package net.ibizsys.central.sysutil;


import com.fasterxml.jackson.core.type.TypeReference;

/**
 * 系统统一状态功能对象
 * @author lionlau
 *
 */
public interface ISysUniStateUtilRuntime extends ISysUtilRuntime{

	/**
	 * 添加主控关系监控
	 * @param strTag
	 */
	void addLeaderLatch(String strTag);
	
	/**
	 * 添加主控关系监控（如果不存在）
	 * @param strTag
	 */
	void addLeaderLatchIf(String strTag);
	
	/**
	 * 移除主控关系监控
	 * @param strTag
	 */
	void removeLeaderLatch(String strTag);
	
	/**
	 * 判断传入路径是否具备主控能力
	 * @param strTag
	 * @return
	 */
	boolean hasLeadership(String strTag);
	
	
	/**
	 * 获取指定属性值
	 * @param strPath
	 * @return
	 */
	String getState(String strPath);
	
	
	/**
	 * 判断指定属性是否存在
	 * @param strPath
	 * @return
	 */
	boolean containsState(String strPath);
	
	/**
	 * 设置指定属性值
	 * @param strPath
	 * @param strValue
	 */
	void setState(String strPath, String strValue);
	
	
	
	/**
	 * 设置指定属性对象值
	 * @param strPath
	 * @param objValue
	 */
	void setState(String strPath, Object objValue);
	
	
	/**
	 * 移除属性值
	 * @param strPath
	 */
	void resetState(String strPath);
	
	
	
	
	/**
	 * 获取指定缓存，按类型返回
	 * @param strPath
	 * @param cls
	 * @return
	 */
	<T> T getState(String strPath, Class<T> cls);
	
	
	/**
	 * 获取指定缓存，按类型返回
	 * @param strPath
	 * @param type
	 * @return
	 */
	<T> T getState(String strPath, TypeReference<T> type);
	
	
	/**
	 * 注册统一状态侦听器
	 * @param iSysUniStateListener
	 */
	void registerStateListener(String strPath, boolean bChild, ISysUniStateListener iSysUniStateListener);
	
	
	/**
	 * 注销统一状态侦听器
	 * @param iSysUniStateListener
	 */
	void unregisterStateListener(String strPath, ISysUniStateListener iSysUniStateListener);
	
	

}
