package net.ibizsys.central.res;

import java.io.File;

import org.springframework.util.StringUtils;

import net.ibizsys.runtime.util.KeyValueUtils;
import net.ibizsys.runtime.util.ZipUtils;

public class SysZipFileResourceRuntime extends SysFileResourceRuntimeBase {

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(SysZipFileResourceRuntime.class);
	

	@Override
	protected void prepareFile() throws Exception {
	
		String content = this.getContent();
		if(!StringUtils.hasLength(content)) {
			throw new Exception("未指定Zip文件路径");
		}
		
		String[] items = content.split("[#]");
		String url = items[0];
		File tempFile = File.createTempFile("resource", ".zip");
		try {
			this.getSystemRuntime().getDefaultWebClient().download(url, tempFile);
		}
		catch (Throwable ex) {
			throw new Exception(String.format("下载文件发生异常，%1$s", ex.getMessage()), ex);
		}
		
		String folderPath = tempFile.getParentFile().getAbsolutePath() + File.separator + KeyValueUtils.genUniqueId();
		File folder = new File(folderPath);
		ZipUtils.unzip(tempFile, folder);
		
		if(items.length == 2 && StringUtils.hasLength(items[1])) {
			folder = new File(folder.getAbsolutePath() + File.separator + items[1]);
		}

		this.setFile(folder);
		
		//super.prepareFile();
	}
	
}
