/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import net.ibizsys.runtime.util.Entity;
import net.ibizsys.runtime.util.IEntity;

public class JsonUtils {
    public static ObjectMapper MAPPER = new ObjectMapper();

    public static ObjectMapper getMapper() {
        return MAPPER;
    }

    public void setMapper(ObjectMapper mapper) {
        MAPPER = mapper != null ? mapper : new ObjectMapper();
    }

    public static ObjectNode createObjectNode() {
        return JsonUtils.getMapper().createObjectNode();
    }

    public static ArrayNode createArrayNode() {
        return JsonUtils.getMapper().createArrayNode();
    }

    public static String toString(Object obj) {
        try {
            return JsonUtils.getMapper().writeValueAsString(obj);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static JsonNode toJsonNode(Object obj) {
        try {
            if (obj instanceof String) {
                return JsonUtils.getMapper().readTree((String)obj);
            }
            return (JsonNode)JsonUtils.getMapper().convertValue(obj, JsonNode.class);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static ArrayNode toArrayNode(Object obj) {
        try {
            if (obj instanceof String) {
                return (ArrayNode)JsonUtils.getMapper().readTree((String)obj);
            }
            return (ArrayNode)JsonUtils.getMapper().convertValue(obj, ArrayNode.class);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static ObjectNode toObjectNode(Object obj) {
        try {
            if (obj instanceof String) {
                return (ObjectNode)JsonUtils.getMapper().readTree((String)obj);
            }
            return (ObjectNode)JsonUtils.getMapper().convertValue(obj, ObjectNode.class);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Map asMap(Object obj) {
        return JsonUtils.as(obj, Map.class);
    }

    public static IEntity asEntity(Object obj) {
        return JsonUtils.as(obj, Entity.class);
    }

    public static List asList(Object obj) {
        return JsonUtils.as(obj, List.class);
    }

    public static <T> T as(Object obj, Class<T> cls) {
        try {
            if (obj instanceof String) {
                return (T)JsonUtils.getMapper().readValue((String)obj, cls);
            }
            return (T)JsonUtils.getMapper().convertValue(obj, cls);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

