/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.util.IActionSessionLog;
import net.ibizsys.runtime.util.JsonUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ActionSessionLog
implements IActionSessionLog {
    private String strDEName = null;
    private String strAction = null;
    private String strInfo = null;
    private String strActionMode = null;
    private String strLogicName = null;
    private long nBeginTime = -1L;
    private long nEndTime = -1L;
    private boolean bError = false;
    private List<ActionSessionLog> actionSessionLogList = null;
    private ActionSessionLog parent = null;
    private IModelRuntime iModelRuntime = null;
    private Throwable cause = null;

    public ActionSessionLog(ActionSessionLog parent) {
        this.parent = parent;
    }

    @Override
    public ActionSessionLog getParent() {
        return this.parent;
    }

    @Override
    public ActionSessionLog getRoot() {
        for (ActionSessionLog curActionSessionLog = this; curActionSessionLog != null; curActionSessionLog = curActionSessionLog.getParent()) {
            if (curActionSessionLog.getParent() != null) {
                continue;
            }
            return curActionSessionLog;
        }
        return null;
    }

    @Override
    public String getDEName() {
        return this.strDEName;
    }

    public void setDEName(String strDEName) {
        this.strDEName = strDEName;
    }

    @Override
    public String getAction() {
        return this.strAction;
    }

    public void setAction(String strAction) {
        this.strAction = strAction;
    }

    public String getActionMode() {
        return this.strActionMode;
    }

    public void setActionMode(String strActionMode) {
        this.strActionMode = strActionMode;
    }

    public String getLogicName() {
        return this.strLogicName;
    }

    public void setLogicName(String strLogicName) {
        this.strLogicName = strLogicName;
    }

    @Override
    public String getInfo() {
        return this.strInfo;
    }

    public void setInfo(String strInfo) {
        this.strInfo = strInfo;
    }

    @Override
    public long getBeginTime() {
        return this.nBeginTime;
    }

    public void setBeginTime(long nBeginTime) {
        this.nBeginTime = nBeginTime;
    }

    @Override
    public long getEndTime() {
        return this.nEndTime;
    }

    public void setEndTime(long nEndTime) {
        this.nEndTime = nEndTime;
    }

    public ActionSessionLog beginSubAction(String strDEName, String strAction) {
        if (this.actionSessionLogList == null) {
            this.actionSessionLogList = new ArrayList<ActionSessionLog>();
        }
        ActionSessionLog actionSessionLog = new ActionSessionLog(this);
        actionSessionLog.setDEName(strDEName);
        actionSessionLog.setAction(strAction);
        actionSessionLog.setBeginTime(System.currentTimeMillis());
        this.actionSessionLogList.add(actionSessionLog);
        return actionSessionLog;
    }

    public ActionSessionLog beginSubAction(IModelRuntime iModelRuntime, String strAction) {
        if (this.actionSessionLogList == null) {
            this.actionSessionLogList = new ArrayList<ActionSessionLog>();
        }
        ActionSessionLog actionSessionLog = new ActionSessionLog(this);
        if (iModelRuntime != null) {
            actionSessionLog.setModelRuntime(iModelRuntime);
            actionSessionLog.setDEName(iModelRuntime.getName());
        }
        actionSessionLog.setAction(strAction);
        actionSessionLog.setBeginTime(System.currentTimeMillis());
        this.actionSessionLogList.add(actionSessionLog);
        return actionSessionLog;
    }

    public ActionSessionLog endAction(String strInfo) {
        return this.endAction(strInfo, false, null);
    }

    public ActionSessionLog endAction(String strInfo, boolean bError) {
        return this.endAction(strInfo, bError, null);
    }

    public ActionSessionLog endAction(String strInfo, boolean bError, Throwable cause) {
        if (this.getEndTime() != -1L) {
            throw new RuntimeException(String.format("\u884c\u4e3a[%1$s][%2$s]\u5df2\u7ed3\u675f", this.getDEName(), this.getAction()));
        }
        this.setInfo(strInfo);
        this.setError(bError);
        this.setCause(cause);
        this.setEndTime(System.currentTimeMillis());
        return this.getParent();
    }

    @Override
    public long getTime() {
        return this.getEndTime() - this.getBeginTime();
    }

    @Override
    public boolean isError() {
        return this.bError;
    }

    public void setError(boolean bError) {
        this.bError = bError;
    }

    @Override
    public IModelRuntime getModelRuntime() {
        return this.iModelRuntime;
    }

    public void setModelRuntime(IModelRuntime iModelRuntime) {
        this.iModelRuntime = iModelRuntime;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb, 0, this.getBeginTime());
        return sb.toString();
    }

    public void toString(StringBuilder sb, int nLevel, long nBeginTime) {
        for (int i = 0; i < nLevel; ++i) {
            sb.append("\t");
        }
        if (nLevel == 0) {
            sb.append(String.format("[%1$s][%2$s]\u8017\u65f6[%3$s]ms", this.getDEName(), this.getAction(), this.getTime()));
        } else {
            sb.append(String.format("[%1$s][%2$s]\u5f00\u59cb[+%3$s]\u7ed3\u675f[+%4$s]\u8017\u65f6[%5$s]ms", this.getDEName(), this.getAction(), this.getBeginTime() - nBeginTime, this.getEndTime() - nBeginTime, this.getTime()));
        }
        if (this.actionSessionLogList != null) {
            ++nLevel;
            for (ActionSessionLog childActionSessionLog : this.actionSessionLogList) {
                sb.append("\r\n");
                childActionSessionLog.toString(sb, nLevel, nBeginTime);
            }
        }
    }

    @Override
    public ObjectNode toObjectNode() {
        return this.toObjectNode(this.getBeginTime());
    }

    public ObjectNode toObjectNode(long nBeginTime) {
        ObjectNode objectNode = JsonUtils.createObjectNode();
        objectNode.put("dename", this.getDEName());
        objectNode.put("action", this.getAction());
        objectNode.put("begin", this.getBeginTime() - nBeginTime);
        objectNode.put("end", this.getEndTime() - nBeginTime);
        objectNode.put("duration", this.getTime());
        if (StringUtils.hasLength((String)this.getInfo())) {
            objectNode.put("info", this.getInfo());
        } else if (this.getCause() != null) {
            objectNode.put("info", this.getCause().getMessage());
        }
        if (this.isError()) {
            objectNode.put("error", true);
        }
        if (StringUtils.hasLength((String)this.getLogicName())) {
            objectNode.put("logicname", this.getLogicName());
        }
        if (StringUtils.hasLength((String)this.getActionMode())) {
            objectNode.put("actionmode", this.getActionMode());
        }
        if (!ObjectUtils.isEmpty(this.actionSessionLogList)) {
            ArrayNode arrayNode = objectNode.putArray("actions");
            for (ActionSessionLog childActionSessionLog : this.actionSessionLogList) {
                ObjectNode childNode = childActionSessionLog.toObjectNode(nBeginTime);
                arrayNode.add((JsonNode)childNode);
            }
        }
        return objectNode;
    }

    @Override
    public String toString(boolean bJsonDetail) {
        if (bJsonDetail) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("[%1$s][%2$s]\u8017\u65f6[%3$s]ms", this.getDEName(), this.getAction(), this.getTime()));
            sb.append("\r\n");
            sb.append(this.toObjectNode().toString());
            return sb.toString();
        }
        return this.toString();
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    public void setCause(Throwable cause) {
        this.cause = cause;
    }
}

