/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.res;

import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntime;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeBase;
import net.ibizsys.runtime.res.SysValueRuleRuntimeBase;
import net.ibizsys.runtime.util.IEntityBase;
import net.ibizsys.runtime.util.IReadOnlyEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public class SysScriptValueRuleRuntime
extends SysValueRuleRuntimeBase {
    private static final Log log = LogFactory.getLog(SysScriptValueRuleRuntime.class);
    private ScriptValueRuleContext scriptValueRuleContext = new ScriptValueRuleContext();
    private Invocable invocable = null;

    @Override
    protected void onInit() throws Exception {
        if (!StringUtils.hasLength((String)this.getPSSysValueRule().getScriptCode())) {
            throw new SystemRuntimeException(this.getSystemRuntimeBase(), String.format("\u7cfb\u7edf\u503c\u89c4\u5219[%1$s]\u6ca1\u6709\u6307\u5b9a\u811a\u672c\u4ee3\u7801", this.getName()));
        }
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("JavaScript");
        String strJSCode = "function main(value,ctx,entity){";
        strJSCode = strJSCode + this.getPSSysValueRule().getScriptCode();
        strJSCode = strJSCode + "}";
        engine.eval(strJSCode);
        this.invocable = (Invocable)((Object)engine);
        super.onInit();
    }

    @Override
    public boolean test(Object objValue, final IEntityBase iEntityBase, IPSDEField iPSDEField, final IDataEntityRuntimeBase iDataEntityRuntimeBase) throws Throwable {
        try {
            this.scriptValueRuleContext.reset();
            if (iDataEntityRuntimeBase != null && iEntityBase != null && iDataEntityRuntimeBase instanceof IDataEntityRuntime) {
                this.scriptValueRuleContext.setEntity(new IReadOnlyEntity(){

                    @Override
                    public Object get(String strName) {
                        IPSDEField iPSDEField2 = iDataEntityRuntimeBase.getPSDEField(strName);
                        if (iPSDEField2 != null) {
                            return ((IDataEntityRuntime)iDataEntityRuntimeBase).getFieldValue(iEntityBase, iPSDEField2);
                        }
                        return null;
                    }

                    @Override
                    public boolean contains(String strName) {
                        IPSDEField iPSDEField2 = iDataEntityRuntimeBase.getPSDEField(strName);
                        if (iPSDEField2 != null) {
                            return ((IDataEntityRuntime)iDataEntityRuntimeBase).containsFieldValue(iEntityBase, iPSDEField2);
                        }
                        return false;
                    }
                });
            }
            if (iPSDEField != null) {
                this.scriptValueRuleContext.setField(iPSDEField.getName().toLowerCase());
            }
            this.scriptValueRuleContext.setValue(objValue);
            Object objRet = this.invocable.invokeFunction("main", objValue, this.scriptValueRuleContext, this.scriptValueRuleContext.getEntity());
            boolean bRet = false;
            if (objRet != null && objRet instanceof Boolean) {
                bRet = (Boolean)objRet;
            }
            this.scriptValueRuleContext.reset();
            return bRet;
        }
        catch (NoSuchMethodException | ScriptException ex) {
            this.scriptValueRuleContext.reset();
            log.error((Object)ex);
            this.getSystemRuntime().log(40000, "SCRIPT", String.format("\u7cfb\u7edf\u503c\u89c4\u5219[%1$s]\u6267\u884c\u53d1\u751f\u5f02\u5e38\uff0c%2%s", this.getName(), ex.getMessage()), ex);
            throw new SystemRuntimeException(this.getSystemRuntimeBase(), String.format("\u7cfb\u7edf\u503c\u89c4\u5219[%1$s]\u6267\u884c\u53d1\u751f\u5f02\u5e38\uff0c%2%s", this.getName(), ex.getMessage()));
        }
    }

    private class ScriptValueRuleContext {
        private ThreadLocal<IReadOnlyEntity> et = new ThreadLocal();
        private ThreadLocal<String> strFieldName = new ThreadLocal();
        private ThreadLocal<Object> value = new ThreadLocal();

        private ScriptValueRuleContext() {
        }

        public void setEntity(IReadOnlyEntity et) {
            this.et.set(et);
        }

        public IReadOnlyEntity getEntity() {
            return this.et.get();
        }

        public void setField(String strFieldName) {
            this.strFieldName.set(strFieldName);
        }

        public String getField() {
            return this.strFieldName.get();
        }

        public boolean isTempMode() {
            return false;
        }

        public Object getValue() {
            return this.value.get();
        }

        public void setValue(Object objValue) {
            this.value.set(objValue);
        }

        public void reset() {
            this.et.set(null);
            this.strFieldName.set(null);
            this.value.set(null);
        }
    }
}

