/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.msg;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.msg.IPSSysMsgTempl;
import net.ibizsys.runtime.ISystemRuntimeBaseContext;
import net.ibizsys.runtime.SystemModelRuntimeBase;
import net.ibizsys.runtime.msg.ISysMsgTemplRuntime;
import net.ibizsys.runtime.util.IEntityBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SysMsgTemplRuntime
extends SystemModelRuntimeBase
implements ISysMsgTemplRuntime {
    private static final Log log = LogFactory.getLog(SysMsgTemplRuntime.class);
    public static final String TEMPL_CONTENT = "CONTENT";
    public static final String TEMPL_SUBJECT = "SUBJECT";
    public static final String TEMPL_IMCONTENT = "IMCONTENT";
    public static final String TEMPL_SMSCONTENT = "SMSCONTENT";
    public static final String TEMPL_WXCONTENT = "WXCONTENT";
    public static final String TEMPL_DDCONTENT = "DDCONTENT";
    private IPSSysMsgTempl iPSSysMsgTempl = null;
    private StringTemplateLoader stringTemplateLoader = new StringTemplateLoader();
    private Configuration config = new Configuration();
    private String strContent = null;
    private String strSubject = null;
    private String strIMContent = null;
    private String strSMSContent = null;
    private String strWXContent = null;
    private String strDDContent = null;

    @Override
    public void init(ISystemRuntimeBaseContext iSystemRuntimeBaseContext, IPSSysMsgTempl iPSSysMsgTempl) throws Exception {
        this.setSystemRuntimeBaseContext(iSystemRuntimeBaseContext);
        this.iPSSysMsgTempl = iPSSysMsgTempl;
        Assert.notNull((Object)this.iPSSysMsgTempl, (String)"\u4f20\u5165\u7cfb\u7edf\u6d88\u606f\u6a21\u677f\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        this.setContent(this.getPSSysMsgTempl().getContent());
        this.setSubject(this.getPSSysMsgTempl().getSubject());
        this.setIMContent(this.getPSSysMsgTempl().getIMContent());
        this.setSMSContent(this.getPSSysMsgTempl().getSMSContent());
        this.setWXContent(this.getPSSysMsgTempl().getWXContent());
        this.setDDContent(this.getPSSysMsgTempl().getDDContent());
        if (StringUtils.hasLength((String)this.getContent())) {
            this.stringTemplateLoader.putTemplate(TEMPL_CONTENT, this.getContent());
        }
        if (StringUtils.hasLength((String)this.getSubject())) {
            this.stringTemplateLoader.putTemplate(TEMPL_SUBJECT, this.getSubject());
        }
        if (StringUtils.hasLength((String)this.getSMSContent())) {
            this.stringTemplateLoader.putTemplate(TEMPL_SMSCONTENT, this.getSMSContent());
        }
        if (StringUtils.hasLength((String)this.getIMContent())) {
            this.stringTemplateLoader.putTemplate(TEMPL_IMCONTENT, this.getIMContent());
        }
        if (StringUtils.hasLength((String)this.getWXContent())) {
            this.stringTemplateLoader.putTemplate(TEMPL_WXCONTENT, this.getWXContent());
        }
        if (StringUtils.hasLength((String)this.getDDContent())) {
            this.stringTemplateLoader.putTemplate(TEMPL_DDCONTENT, this.getDDContent());
        }
        this.config.setTemplateLoader((TemplateLoader)this.stringTemplateLoader);
        this.onInit();
    }

    @Override
    public IPSModelObject getPSModelObject() {
        return this.getPSSysMsgTempl();
    }

    protected String getContent() {
        return this.strContent;
    }

    protected void setContent(String strContent) {
        this.strContent = strContent;
    }

    protected String getSubject() {
        return this.strSubject;
    }

    protected void setSubject(String strSubject) {
        this.strSubject = strSubject;
    }

    protected String getIMContent() {
        return this.strIMContent;
    }

    protected void setIMContent(String strIMContent) {
        this.strIMContent = strIMContent;
    }

    protected String getSMSContent() {
        return this.strSMSContent;
    }

    protected void setSMSContent(String strSMSContent) {
        this.strSMSContent = strSMSContent;
    }

    protected String getWXContent() {
        return this.strWXContent;
    }

    protected void setWXContent(String strWXContent) {
        this.strWXContent = strWXContent;
    }

    protected String getDDContent() {
        return this.strDDContent;
    }

    protected void setDDContent(String strDDContent) {
        this.strDDContent = strDDContent;
    }

    @Override
    public IPSSysMsgTempl getPSSysMsgTempl() {
        return this.iPSSysMsgTempl;
    }

    @Override
    public String getContentType() {
        return this.getPSSysMsgTempl().getContentType();
    }

    @Override
    public String getContent(IEntityBase iEntityBase) {
        if (!StringUtils.hasLength((String)this.getContent())) {
            return null;
        }
        return this.getTemplContent(TEMPL_CONTENT, iEntityBase);
    }

    @Override
    public String getSubject(IEntityBase iEntityBase) {
        if (!StringUtils.hasLength((String)this.getSubject())) {
            return null;
        }
        return this.getTemplContent(TEMPL_SUBJECT, iEntityBase);
    }

    @Override
    public String getSMSContent(IEntityBase iEntityBase) {
        if (!StringUtils.hasLength((String)this.getSMSContent())) {
            return null;
        }
        return this.getTemplContent(TEMPL_SMSCONTENT, iEntityBase);
    }

    @Override
    public String getWXContent(IEntityBase iEntityBase) {
        if (!StringUtils.hasLength((String)this.getWXContent())) {
            return null;
        }
        return this.getTemplContent(TEMPL_WXCONTENT, iEntityBase);
    }

    @Override
    public String getDDContent(IEntityBase iEntityBase) {
        if (!StringUtils.hasLength((String)this.getDDContent())) {
            return null;
        }
        return this.getTemplContent(TEMPL_DDCONTENT, iEntityBase);
    }

    @Override
    public String getIMContent(IEntityBase iEntityBase) {
        if (!StringUtils.hasLength((String)this.getIMContent())) {
            return null;
        }
        return this.getTemplContent(TEMPL_IMCONTENT, iEntityBase);
    }

    protected String getTemplContent(String strType, IEntityBase iEntityBase) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (iEntityBase != null) {
            params.put("data", iEntityBase);
            params.put("entity", iEntityBase);
        }
        params.put("sys", this.getSystemRuntime().getSystemRTScriptContext());
        try {
            Template template = this.config.getTemplate(strType);
            StringWriter sw = new StringWriter();
            template.process(params, (Writer)sw);
            String strContent = sw.toString();
            if (StringUtils.hasLength((String)strContent)) {
                strContent = strContent.toString();
            }
            return strContent;
        }
        catch (Exception ex) {
            log.error((Object)String.format("\u83b7\u53d6\u6a21\u677f\u5185\u5bb9\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), (Throwable)ex);
            return ex.getMessage();
        }
    }

    @Override
    public String getId() {
        return this.getPSSysMsgTempl().getDynaModelFilePath();
    }

    @Override
    public String getName() {
        return this.getPSSysMsgTempl().getName();
    }
}

