/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.dataentity.datasync;

import java.sql.Timestamp;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeBase;
import net.ibizsys.runtime.dataentity.datasync.DEDataSyncRuntimeBase;
import net.ibizsys.runtime.dataentity.datasync.IDEDataSyncOutRuntime;
import net.ibizsys.runtime.res.ISysDataSyncAgentRuntime;
import net.ibizsys.runtime.util.ASFutureActionBase;
import net.ibizsys.runtime.util.ActionSession;
import net.ibizsys.runtime.util.ActionSessionManager;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.IEntityBase;
import net.ibizsys.runtime.util.domain.DataSyncOut;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public class DEDataSyncOutRuntime
extends DEDataSyncRuntimeBase
implements IDEDataSyncOutRuntime {
    private static final Log log = LogFactory.getLog(DEDataSyncOutRuntime.class);
    private ISysDataSyncAgentRuntime iSysDataSyncAgentRuntime = null;
    private boolean bSendImmediately = false;
    private boolean bReadTimeMode = true;

    @Override
    protected void onInit() throws Exception {
        Assert.notNull((Object)this.getPSDEDataSync().getOutPSSysDataSyncAgent(), (String)"\u6ca1\u6709\u6307\u5b9a\u8f93\u51fa\u7684\u6570\u636e\u540c\u6b65\u4ee3\u7406");
        if (this.getPSDEDataSync().getOutputMode() == PSModelEnums.DataSyncOutMode.REALTIME.value) {
            this.setReadTimeMode(true);
        } else {
            this.setReadTimeMode(false);
        }
        this.iSysDataSyncAgentRuntime = this.getDynaInstRuntime() != null ? this.getDynaInstRuntime().getSysDataSyncAgentRuntime(this.getPSDEDataSync().getOutPSSysDataSyncAgent()) : this.getSystemRuntime().getSysDataSyncAgentRuntime(this.getPSDEDataSync().getOutPSSysDataSyncAgent());
        if (this.getSysDataSyncAgentRuntime().isInternalAgent()) {
            this.setSendImmediately(true);
        }
        super.onInit();
    }

    public ISysDataSyncAgentRuntime getSysDataSyncAgentRuntime() {
        return this.iSysDataSyncAgentRuntime;
    }

    @Override
    public boolean isSendImmediately() {
        return this.bSendImmediately;
    }

    protected void setSendImmediately(boolean bSendImmediately) {
        this.bSendImmediately = bSendImmediately;
    }

    @Override
    public boolean isReadTimeMode() {
        return this.bReadTimeMode;
    }

    protected void setReadTimeMode(boolean bReadTimeMode) {
        this.bReadTimeMode = bReadTimeMode;
    }

    @Override
    public void send(int nEvent, Object objData, Object actionData) {
        if ((nEvent & this.getEventType()) == 0) {
            return;
        }
        boolean bImmediately = this.isSendImmediately();
        if (actionData instanceof Boolean) {
            bImmediately = bImmediately;
        }
        try {
            this.onSend(nEvent, objData, bImmediately);
        }
        catch (Throwable ex) {
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), (IModelRuntime)this, String.format("\u53d1\u9001\u540c\u6b65\u4fe1\u606f\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    @Override
    public void sendDirect(int nEvent, Object objData) {
        try {
            this.onSend(nEvent, objData, true);
        }
        catch (Throwable ex) {
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), (IModelRuntime)this, String.format("\u53d1\u9001\u540c\u6b65\u4fe1\u606f\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected void onSend(int nEvent, Object objData, boolean bImmediately) throws Throwable {
        DataSyncOut dataSyncOut = new DataSyncOut();
        dataSyncOut.setEventType(nEvent);
        Object objKey = null;
        Object objSendData = null;
        if (objData instanceof IEntityBase) {
            objKey = this.getDataEntityRuntime().getFieldValue((IEntityBase)objData, this.getDataEntityRuntime().getKeyPSDEField());
            objSendData = this.getDataEntityRuntime().serializeEntity((IEntityBase)objData);
        } else {
            objKey = objData;
        }
        dataSyncOut.setDataKey(DataTypeUtils.getStringValue(objKey, null));
        dataSyncOut.setData(DataTypeUtils.getStringValue(objSendData, null));
        dataSyncOut.setDEId(this.getDataEntityRuntime().getId());
        dataSyncOut.setDEName(this.getDataEntityRuntime().getName());
        dataSyncOut.setCreateDate(new Timestamp(System.currentTimeMillis()));
        this.doSend(dataSyncOut, bImmediately);
    }

    protected void doSend(final DataSyncOut dataSyncOut, boolean bImmediately) throws Throwable {
        if (bImmediately) {
            this.getSysDataSyncAgentRuntime().send(new DataSyncOut[]{dataSyncOut});
        } else {
            final String strActionId = String.format("%1$s|%2$s|%3$s", this.getDataEntityRuntime().getName(), dataSyncOut.getDataKey(), dataSyncOut.getEventType());
            ActionSession actionSession = ActionSessionManager.getCurrentSessionMust();
            actionSession.registerFutureAction(new ASFutureActionBase(){

                @Override
                public String getId() {
                    return strActionId;
                }

                @Override
                public void commit() {
                    DEDataSyncOutRuntime.this.getSysDataSyncAgentRuntime().send(new DataSyncOut[]{dataSyncOut});
                }
            }, true);
        }
    }
}

