/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.testing;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import net.ibizsys.central.ISystemRuntimeContext;
import net.ibizsys.central.SystemModelRuntimeBase;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.testing.ISysTestDataRuntime;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.testing.IPSSysTestData;
import net.ibizsys.model.testing.IPSSysTestDataItem;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.ISystemRuntimeBase;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.util.Entity;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.JsonUtils;
import net.ibizsys.runtime.util.PropertiesUtils;
import net.ibizsys.runtime.util.script.IScriptEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class SysTestDataRuntimeBase
extends SystemModelRuntimeBase
implements ISysTestDataRuntime {
    private static final Log log = LogFactory.getLog(SysTestDataRuntimeBase.class);
    private IPSSysTestData iPSSysTestData = null;
    private IDataEntityRuntime iDataEntityRuntime = null;
    private Invocable invocable = null;
    private Map<String, Object> data = null;
    private String strTestDataType = null;

    @Override
    public void init(ISystemRuntimeContext iSystemRuntimeContext, IPSSysTestData iPSSysTestData) throws Exception {
        this.setSystemRuntimeBaseContext(iSystemRuntimeContext);
        this.iPSSysTestData = iPSSysTestData;
        this.onInit();
    }

    @Override
    protected void onInit() throws Exception {
        this.strTestDataType = this.getPSSysTestData().getTestDataType();
        if (!StringUtils.hasLength((String)this.strTestDataType)) {
            this.strTestDataType = "DATA";
        }
        this.prepareDataMode();
        if ("CUSTOMCODE".equals(this.strTestDataType)) {
            this.prepareCodeMode();
        }
        super.onInit();
    }

    public String getTestDataType() {
        return this.strTestDataType;
    }

    protected void prepareDataMode() throws Exception {
        String strData = this.getPSSysTestData().getData();
        if (!StringUtils.hasLength((String)strData)) {
            return;
        }
        if (!StringUtils.hasLength((String)(strData = strData.toString()))) {
            return;
        }
        if (strData.indexOf("{") == 0) {
            ObjectNode objectNode = JsonUtils.toObjectNode(strData);
            this.data = (Map)JsonUtils.MAPPER.convertValue((Object)objectNode, Map.class);
        } else {
            Properties properties = PropertiesUtils.load(strData);
            if (properties != null) {
                this.data = new LinkedHashMap<String, Object>();
                for (Object objKey : properties.keySet()) {
                    String strName = (String)objKey;
                    this.data.put(strName, PropertiesUtils.getProperty(properties, strName));
                }
            }
        }
    }

    protected void prepareCodeMode() throws Exception {
        String strCustomCode = this.getPSSysTestData().getScriptCode();
        if (!StringUtils.hasLength((String)strCustomCode)) {
            throw new SystemRuntimeException(this.getSystemRuntimeBase(), this, String.format("\u6ca1\u6709\u6307\u5b9a\u811a\u672c\u4ee3\u7801", new Object[0]));
        }
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("JavaScript");
        String strJSCode = "function main(";
        strJSCode = strJSCode + "sys,entity";
        strJSCode = strJSCode + "){";
        strJSCode = strJSCode + strCustomCode;
        strJSCode = strJSCode + "}";
        engine.eval(strJSCode);
        this.invocable = (Invocable)((Object)engine);
    }

    public IPSSysTestData getPSSysTestData() {
        return this.iPSSysTestData;
    }

    @Override
    public IPSModelObject getPSModelObject() {
        return this.getPSSysTestData();
    }

    public IDataEntityRuntime getDataEntityRuntime() {
        if (this.iDataEntityRuntime == null && this.getPSSysTestData().getPSDataEntity() != null) {
            this.iDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(this.getPSSysTestData().getPSDataEntity().getId());
        }
        return this.iDataEntityRuntime;
    }

    protected Map<String, Object> getDataMap() {
        return this.data;
    }

    @Override
    public IEntity getEntity(IEntity iEntity) {
        try {
            if (iEntity == null) {
                IDataEntityRuntime iDataEntityRuntime = this.getDataEntityRuntime();
                iEntity = iDataEntityRuntime != null ? iDataEntityRuntime.createEntity() : new Entity();
            }
            this.fillEntity(iEntity);
            return iEntity;
        }
        catch (Throwable ex) {
            log.error((Object)String.format("\u83b7\u53d6\u6570\u636e\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
            throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), (IModelRuntime)this, String.format("\u83b7\u53d6\u6570\u636e\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected void fillEntity(IEntity iEntity) throws Throwable {
        Map<String, Object> data;
        List psSysTestDataItemList = this.getPSSysTestData().getPSSysTestDataItems();
        if (!ObjectUtils.isEmpty((Object)psSysTestDataItemList)) {
            for (IPSSysTestDataItem iPSSysTestDataItem : psSysTestDataItemList) {
                String string = iPSSysTestDataItem.getValueType();
                if ("VALUE".equals(string)) {
                    iEntity.set(iPSSysTestDataItem.getName(), this.getSystemRuntime().convertValue(iPSSysTestDataItem.getStdDataType(), iPSSysTestDataItem.getValue()));
                    continue;
                }
                if ("NULLVALUE".equals(string)) {
                    iEntity.set(iPSSysTestDataItem.getName(), null);
                    continue;
                }
                log.debug((Object)String.format("\u4e0d\u652f\u6301\u6d4b\u8bd5\u6570\u636e\u9879\u7c7b\u578b[%1$s]", string));
            }
        }
        if ((data = this.getDataMap()) != null) {
            for (Map.Entry entry : data.entrySet()) {
                iEntity.set((String)entry.getKey(), entry.getValue());
            }
        }
        if (this.getTestDataType().equals("CUSTOMCODE")) {
            IScriptEntity iScriptEntity = null;
            IDataEntityRuntime iDataEntityRuntime = this.getDataEntityRuntime();
            iScriptEntity = iDataEntityRuntime != null ? iDataEntityRuntime.createScriptEntity(iEntity) : this.getSystemRuntime().createScriptEntity(iEntity);
            try {
                this.invocable.invokeFunction("main", this.getSystemRuntime().getSystemRTScriptContext(), iScriptEntity);
            }
            catch (NoSuchMethodException | ScriptException ex) {
                log.error((Object)ex);
                this.getSystemRuntime().log(40000, "SCRIPT", String.format("\u6267\u884c\u6d4b\u8bd5\u6570\u636e\u811a\u672c[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), ex);
                throw new SystemRuntimeException(this.getSystemRuntimeBase(), this, String.format("\u6267\u884c\u811a\u672c\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()));
            }
            return;
        }
    }
}

