/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.service;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.ibizsys.central.ISystemRuntimeContext;
import net.ibizsys.central.SystemModelRuntimeBase;
import net.ibizsys.central.service.ISubSysServiceAPIDERuntime;
import net.ibizsys.central.service.ISubSysServiceAPIRTScriptContext;
import net.ibizsys.central.service.ISubSysServiceAPIRuntime;
import net.ibizsys.central.service.ISubSysServiceAPIRuntimeContext;
import net.ibizsys.central.service.ISubSysServiceAPIScriptLogicRuntime;
import net.ibizsys.central.service.SubSysServiceAPIDERuntime;
import net.ibizsys.central.service.SubSysServiceAPIOSSAdapter;
import net.ibizsys.central.service.SubSysServiceAPIRTScriptContext;
import net.ibizsys.central.service.SubSysServiceAPIRuntimeException;
import net.ibizsys.central.service.client.IWebClient;
import net.ibizsys.central.sysutil.IObjectStorageServiceAdapter;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.PSModelUtils;
import net.ibizsys.model.service.IPSSubSysServiceAPI;
import net.ibizsys.model.service.IPSSubSysServiceAPIDE;
import net.ibizsys.model.service.IPSSubSysServiceAPIDEMethod;
import net.ibizsys.model.system.IPSSystemModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SubSysServiceAPIRuntime
extends SystemModelRuntimeBase
implements ISubSysServiceAPIRuntime {
    private static final Log log = LogFactory.getLog(SubSysServiceAPIRuntime.class);
    private IPSSubSysServiceAPI iPSSubSysServiceAPI = null;
    private Map<String, ISubSysServiceAPIDERuntime> deServiceAPIRuntimeMap = null;
    private String strServiceUrl = null;
    private String strServiceType = null;
    private String strServiceParam = null;
    private String strServiceParam2 = null;
    private String strServiceParam3 = null;
    private String strServiceParam4 = null;
    private Map<String, Object> globalHeaderMap = null;
    private Map<String, Object> defaultHeaderMap = null;
    private IWebClient iWebClient = null;
    private String strAccessTokenUrl = null;
    private String strClientId = null;
    private String strClientSecret = null;
    private long nTokenTimeout = 0L;
    private int nDefaultTokenTimeout = 0;
    private String strAuthMode = null;
    private String strAuthParam = null;
    private String strAuthParam2 = null;
    private String strAuthParam3 = null;
    private String strAuthParam4 = null;
    private IObjectStorageServiceAdapter iObjectStorageServiceAdapter = null;
    private ISubSysServiceAPIScriptLogicRuntime authSubSysServiceAPIScriptLogicRuntime = null;
    private ISubSysServiceAPIScriptLogicRuntime methodSubSysServiceAPIScriptLogicRuntime = null;
    private Map<String, ISubSysServiceAPIScriptLogicRuntime> methodSubSysServiceAPIScriptLogicRuntimeMap = new ConcurrentHashMap<String, ISubSysServiceAPIScriptLogicRuntime>();
    private ISubSysServiceAPIRTScriptContext iSubSysServiceAPIRTScriptContext = null;
    private static ISubSysServiceAPIScriptLogicRuntime paramSubSysServiceAPIScriptLogicRuntime = null;
    private ISubSysServiceAPIRuntimeContext iSubSysServiceAPIRuntimeContext = new ISubSysServiceAPIRuntimeContext(){

        @Override
        public ISubSysServiceAPIRuntime getSubSysServiceAPIRuntime() {
            return SubSysServiceAPIRuntime.this.getSelf();
        }

        @Override
        public ISubSysServiceAPIScriptLogicRuntime getMethodSubSysServiceAPIScriptLogicRuntime() {
            return SubSysServiceAPIRuntime.this.getSelf().getMethodSubSysServiceAPIScriptLogicRuntime();
        }

        @Override
        public Object createMethodParamScriptObject() {
            return SubSysServiceAPIRuntime.this.getSelf().createMethodParamScriptObject();
        }

        @Override
        public ISubSysServiceAPIScriptLogicRuntime getMethodSubSysServiceAPIScriptLogicRuntime(String strScriptCode) {
            return SubSysServiceAPIRuntime.this.getSelf().getMethodSubSysServiceAPIScriptLogicRuntime(strScriptCode);
        }
    };

    private static ISubSysServiceAPIScriptLogicRuntime getParamSubSysServiceAPIScriptLogicRuntime() {
        return paramSubSysServiceAPIScriptLogicRuntime;
    }

    private static void setParamSubSysServiceAPIScriptLogicRuntime(ISubSysServiceAPIScriptLogicRuntime paramSubSysServiceAPIScriptLogicRuntime) {
        SubSysServiceAPIRuntime.paramSubSysServiceAPIScriptLogicRuntime = paramSubSysServiceAPIScriptLogicRuntime;
    }

    @Override
    public void init(ISystemRuntimeContext iSystemRuntimeContext, IPSSubSysServiceAPI iPSSubSysServiceAPI) throws Exception {
        Assert.notNull((Object)iSystemRuntimeContext, (String)"\u4f20\u5165\u7cfb\u7edf\u8fd0\u884c\u65f6\u4e0a\u4e0b\u6587\u5bf9\u8c61\u65e0\u6548");
        Assert.notNull((Object)iPSSubSysServiceAPI, (String)"\u4f20\u5165\u5916\u90e8\u670d\u52a1\u63a5\u53e3\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        this.setSystemRuntimeBase(iSystemRuntimeContext.getSystemRuntime());
        this.iPSSubSysServiceAPI = iPSSubSysServiceAPI;
        this.setConfigFolder("subsysserviceapi." + PSModelUtils.calcUniqueTag((IPSSystemModule)this.iPSSubSysServiceAPI.getPSSystemModule(), (String)this.iPSSubSysServiceAPI.getCodeName()));
        this.onInit();
    }

    @Override
    protected void onInit() throws Exception {
        this.setServiceUrl(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".serviceurl", this.getPSSubSysServiceAPI().getServicePath()));
        this.setServiceType(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".servicetype", this.getPSSubSysServiceAPI().getServiceType()));
        this.setServiceParam(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".serviceparam", this.getPSSubSysServiceAPI().getServiceParam()));
        this.setServiceParam2(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".serviceparam2", this.getPSSubSysServiceAPI().getServiceParam2()));
        this.setServiceParam3(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".serviceparam3", this.getPSSubSysServiceAPI().getServiceParam3()));
        this.setServiceParam4(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".serviceparam4", this.getPSSubSysServiceAPI().getServiceParam4()));
        this.setAuthMode(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".authmode", this.getPSSubSysServiceAPI().getAuthMode()));
        this.setAccessTokenUrl(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".accesstokenurl", this.getPSSubSysServiceAPI().getAuthAccessTokenUrl()));
        this.setClientId(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".clientid", this.getPSSubSysServiceAPI().getAuthClientId()));
        this.setClientSecret(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".clientsecret", this.getPSSubSysServiceAPI().getAuthClientSecret()));
        this.setAuthParam(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".authparam", this.getPSSubSysServiceAPI().getAuthParam()));
        this.setAuthParam2(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".authparam2", this.getPSSubSysServiceAPI().getAuthParam2()));
        this.setAuthParam3(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".authparam3", this.getPSSubSysServiceAPI().getAuthParam3()));
        this.setAuthParam4(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".authparam4", this.getPSSubSysServiceAPI().getAuthParam4()));
        int nSecond = this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".tokentimeout", this.getPSSubSysServiceAPI().getAuthTimeout());
        if (nSecond <= 0) {
            nSecond = 3600;
        }
        this.setDefaultTokenTimeout(nSecond * 1000);
        super.onInit();
        this.setHeaders(null);
        List psSubSysServiceAPIDEs = this.getPSSubSysServiceAPI().getAllPSSubSysServiceAPIDEs();
        if (psSubSysServiceAPIDEs != null) {
            for (IPSSubSysServiceAPIDE iPSSubSysServiceAPIDE : psSubSysServiceAPIDEs) {
                this.registerPSSubSysServiceAPIDE(iPSSubSysServiceAPIDE);
            }
        }
        if (SubSysServiceAPIRuntime.getParamSubSysServiceAPIScriptLogicRuntime() == null) {
            ISubSysServiceAPIScriptLogicRuntime iSubSysServiceAPIScriptLogicRuntime = this.getSystemRuntime().createSubSysServiceAPIScriptLogicRuntime("METHODPARAM");
            iSubSysServiceAPIScriptLogicRuntime.init(this.getSystemRuntime(), this, "return {uri:'',param:{},header:{},query:{},body:null};", "METHODPARAM");
            SubSysServiceAPIRuntime.setParamSubSysServiceAPIScriptLogicRuntime(iSubSysServiceAPIScriptLogicRuntime);
        }
        if (this.getMethodScriptLogicRuntime() == null) {
            this.prepareMethodScriptLogicRuntime();
        }
        this.prepareAuthUtil();
        if (this.getObjectStorageServiceAdapter() == null) {
            this.prepareObjectStorageServiceAdapter();
        }
    }

    protected void prepareAuthUtil() throws Exception {
        if (StringUtils.hasLength((String)this.getAuthMode()) && !"NONE".equals(this.getAuthMode())) {
            if (this.getAuthScriptLogicRuntime() == null) {
                this.prepareAuthScriptLogicRuntime();
            }
            this.runAuthTimer(true);
        }
    }

    @Override
    public IPSSubSysServiceAPI getPSSubSysServiceAPI() {
        return this.iPSSubSysServiceAPI;
    }

    @Override
    public IPSModelObject getPSModelObject() {
        return this.getPSSubSysServiceAPI();
    }

    @Override
    public String getId() {
        return this.getPSSubSysServiceAPI().getId();
    }

    @Override
    public String getName() {
        return this.getPSSubSysServiceAPI().getName();
    }

    protected ISubSysServiceAPIRuntimeContext getSubSysServiceAPIRuntimeContext() {
        return this.iSubSysServiceAPIRuntimeContext;
    }

    private SubSysServiceAPIRuntime getSelf() {
        return this;
    }

    @Override
    public String getServiceUrl() {
        return this.strServiceUrl;
    }

    protected void setServiceUrl(String strServiceUrl) {
        this.strServiceUrl = strServiceUrl;
    }

    @Override
    public String getServiceType() {
        return this.strServiceType;
    }

    protected void setServiceType(String strServiceType) {
        this.strServiceType = strServiceType;
    }

    @Override
    public String getServiceParam() {
        return this.strServiceParam;
    }

    protected void setServiceParam(String strServiceParam) {
        this.strServiceParam = strServiceParam;
    }

    @Override
    public String getServiceParam2() {
        return this.strServiceParam2;
    }

    protected void setServiceParam2(String strServiceParam2) {
        this.strServiceParam2 = strServiceParam2;
    }

    @Override
    public String getServiceParam3() {
        return this.strServiceParam3;
    }

    protected void setServiceParam3(String strServiceParam3) {
        this.strServiceParam3 = strServiceParam3;
    }

    @Override
    public String getServiceParam4() {
        return this.strServiceParam4;
    }

    protected void setServiceParam4(String strServiceParam4) {
        this.strServiceParam4 = strServiceParam4;
    }

    @Override
    public ISubSysServiceAPIRTScriptContext getSubSysServiceAPIRTScriptContext() {
        if (this.iSubSysServiceAPIRTScriptContext == null) {
            this.iSubSysServiceAPIRTScriptContext = this.createSubSysServiceAPIRTScriptContext();
        }
        return this.iSubSysServiceAPIRTScriptContext;
    }

    protected ISubSysServiceAPIRTScriptContext createSubSysServiceAPIRTScriptContext() {
        return new SubSysServiceAPIRTScriptContext(this.getSubSysServiceAPIRuntimeContext());
    }

    protected String getMethodScriptCode() {
        return this.getPSSubSysServiceAPI().getMethodScriptCode();
    }

    protected String getAuthScriptCode() {
        return this.getPSSubSysServiceAPI().getAuthScriptCode();
    }

    @Override
    public void setHeaders(Map<String, ?> headers) {
        if (this.defaultHeaderMap == null) {
            Iterator fields;
            ObjectNode objectNode;
            ConcurrentHashMap<String, String> defaultMap = new ConcurrentHashMap<String, String>();
            if (this.getPSSubSysServiceAPI() != null && (objectNode = this.getPSSubSysServiceAPI().getHeaderParams()) != null && (fields = objectNode.fieldNames()) != null) {
                while (fields.hasNext()) {
                    String strName = (String)fields.next();
                    defaultMap.put(strName, objectNode.get(strName).textValue());
                }
            }
            this.defaultHeaderMap = Collections.unmodifiableMap(defaultMap);
        }
        ConcurrentHashMap<String, Object> map = new ConcurrentHashMap<String, Object>();
        map.putAll(this.defaultHeaderMap);
        if (headers != null) {
            map.putAll(headers);
        }
        this.globalHeaderMap = map == null || map.size() == 0 ? null : Collections.unmodifiableMap(map);
    }

    @Override
    public Map<String, ?> getHeaders(boolean bAuthMode) {
        if (bAuthMode) {
            return this.defaultHeaderMap;
        }
        return this.globalHeaderMap;
    }

    @Override
    public Map<String, ?> getHeaders() {
        return this.getHeaders(false);
    }

    @Override
    public IWebClient getWebClient() {
        return this.getWebClient(false);
    }

    protected IWebClient getWebClient(boolean bTryMode) {
        if (this.iWebClient != null || bTryMode) {
            return this.iWebClient;
        }
        this.iWebClient = this.createWebClient();
        return this.iWebClient;
    }

    protected IWebClient createWebClient() {
        IWebClient iWebClient = this.getSystemRuntime().createWebClient(this);
        try {
            iWebClient.init(this);
        }
        catch (Exception ex) {
            throw new SubSysServiceAPIRuntimeException((ISubSysServiceAPIRuntime)this, String.format("\u521d\u59cb\u5316Web\u5ba2\u6237\u7aef\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
        return iWebClient;
    }

    @Override
    public <T> T getServiceClient(Class<?> cls) {
        return this.getWebClient().getProxyClient(cls);
    }

    @Override
    public ISubSysServiceAPIDERuntime getSubSysServiceAPIDERuntime(String strTag, boolean bTryMode) {
        Assert.notNull((Object)strTag, (String)"\u4f20\u5165\u670d\u52a1\u63a5\u53e3\u6807\u8bb0\u65e0\u6548");
        ISubSysServiceAPIDERuntime iSubSysServiceAPIDERuntime = null;
        if (this.deServiceAPIRuntimeMap != null && (iSubSysServiceAPIDERuntime = this.deServiceAPIRuntimeMap.get(strTag)) == null) {
            iSubSysServiceAPIDERuntime = this.deServiceAPIRuntimeMap.get(strTag.toUpperCase());
        }
        if (iSubSysServiceAPIDERuntime == null && !bTryMode) {
            throw new SubSysServiceAPIRuntimeException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61", strTag));
        }
        return iSubSysServiceAPIDERuntime;
    }

    protected ISubSysServiceAPIDERuntime registerPSSubSysServiceAPIDE(IPSSubSysServiceAPIDE iPSSubSysServiceAPIDE) throws Exception {
        String strDETag;
        ISubSysServiceAPIDERuntime iSubSysServiceAPIDERuntime = this.createSubSysServiceAPIDERuntime(iPSSubSysServiceAPIDE);
        if (iSubSysServiceAPIDERuntime == null) {
            return null;
        }
        iSubSysServiceAPIDERuntime.init(this.getSubSysServiceAPIRuntimeContext(), iPSSubSysServiceAPIDE);
        if (this.deServiceAPIRuntimeMap == null) {
            this.deServiceAPIRuntimeMap = new HashMap<String, ISubSysServiceAPIDERuntime>();
        }
        this.deServiceAPIRuntimeMap.put(iPSSubSysServiceAPIDE.getId(), iSubSysServiceAPIDERuntime);
        this.deServiceAPIRuntimeMap.put(iPSSubSysServiceAPIDE.getName().toUpperCase(), iSubSysServiceAPIDERuntime);
        if (StringUtils.hasLength((String)iPSSubSysServiceAPIDE.getDETag()) && !this.deServiceAPIRuntimeMap.containsKey(strDETag = iPSSubSysServiceAPIDE.getDETag().toUpperCase())) {
            this.deServiceAPIRuntimeMap.put(strDETag, iSubSysServiceAPIDERuntime);
        }
        return iSubSysServiceAPIDERuntime;
    }

    protected ISubSysServiceAPIDERuntime createSubSysServiceAPIDERuntime(IPSSubSysServiceAPIDE iPSSubSysServiceAPIDE) throws Exception {
        if (iPSSubSysServiceAPIDE.getPSSysSFPlugin() != null) {
            return this.getSystemRuntime().getRuntimeObject(iPSSubSysServiceAPIDE.getPSSysSFPlugin(), ISubSysServiceAPIDERuntime.class, true);
        }
        return this.createDefaultSubSysServiceAPIDERuntime();
    }

    protected ISubSysServiceAPIDERuntime createDefaultSubSysServiceAPIDERuntime() {
        return new SubSysServiceAPIDERuntime();
    }

    @Override
    public Object invokeDEMethod(String strDataEntityName, String strMethodName, Map<String, Object> context, Object objBody, Map<String, Object> params, Object objTag) throws Throwable {
        ISubSysServiceAPIDERuntime iSubSysServiceAPIDERuntime = this.getSubSysServiceAPIDERuntime(strDataEntityName, false);
        return iSubSysServiceAPIDERuntime.invokeMethod(strMethodName, context, objBody, params, objTag);
    }

    @Override
    public String getAccessTokenUrl() {
        return this.strAccessTokenUrl;
    }

    protected void setAccessTokenUrl(String strAccessTokenUrl) {
        this.strAccessTokenUrl = strAccessTokenUrl;
    }

    @Override
    public String getClientId() {
        return this.strClientId;
    }

    protected void setClientId(String strClientId) {
        this.strClientId = strClientId;
    }

    @Override
    public String getClientSecret() {
        return this.strClientSecret;
    }

    protected void setClientSecret(String strClientSecret) {
        this.strClientSecret = strClientSecret;
    }

    @Override
    public String getAuthMode() {
        return this.strAuthMode;
    }

    protected void setAuthMode(String strAuthMode) {
        this.strAuthMode = strAuthMode;
    }

    @Override
    public String getAuthParam() {
        return this.strAuthParam;
    }

    protected void setAuthParam(String strAuthParam) {
        this.strAuthParam = strAuthParam;
    }

    @Override
    public String getAuthParam2() {
        return this.strAuthParam2;
    }

    protected void setAuthParam2(String strAuthParam2) {
        this.strAuthParam2 = strAuthParam2;
    }

    @Override
    public String getAuthParam3() {
        return this.strAuthParam3;
    }

    protected void setAuthParam3(String strAuthParam3) {
        this.strAuthParam3 = strAuthParam3;
    }

    @Override
    public String getAuthParam4() {
        return this.strAuthParam4;
    }

    protected void setAuthParam4(String strAuthParam4) {
        this.strAuthParam4 = strAuthParam4;
    }

    @Override
    public long getTokenTimeout() {
        return this.nTokenTimeout;
    }

    @Override
    public void setTokenTimeout(long nTokenTimeout) {
        this.nTokenTimeout = nTokenTimeout;
    }

    protected int getDefaultTokenTimeout() {
        return this.nDefaultTokenTimeout;
    }

    protected void setDefaultTokenTimeout(int nDefaultTokenTimeout) {
        this.nDefaultTokenTimeout = nDefaultTokenTimeout;
    }

    protected ISubSysServiceAPIScriptLogicRuntime getAuthSubSysServiceAPIScriptLogicRuntime() {
        return this.authSubSysServiceAPIScriptLogicRuntime;
    }

    protected void setAuthSubSysServiceAPIScriptLogicRuntime(ISubSysServiceAPIScriptLogicRuntime authSubSysServiceAPIScriptLogicRuntime) {
        this.authSubSysServiceAPIScriptLogicRuntime = authSubSysServiceAPIScriptLogicRuntime;
    }

    protected ISubSysServiceAPIScriptLogicRuntime getAuthScriptLogicRuntime() {
        return this.getAuthSubSysServiceAPIScriptLogicRuntime();
    }

    protected void setAuthScriptLogicRuntime(ISubSysServiceAPIScriptLogicRuntime authSubSysServiceAPIScriptLogicRuntime) {
        this.setAuthSubSysServiceAPIScriptLogicRuntime(authSubSysServiceAPIScriptLogicRuntime);
    }

    protected void prepareAuthScriptLogicRuntime() throws Exception {
        if (!StringUtils.hasLength((String)this.getAuthScriptCode())) {
            return;
        }
        ISubSysServiceAPIScriptLogicRuntime iSubSysServiceAPIScriptLogicRuntime = this.getSystemRuntime().createSubSysServiceAPIScriptLogicRuntime("AUTH");
        iSubSysServiceAPIScriptLogicRuntime.init(this.getSystemRuntime(), this, this.getAuthScriptCode(), "AUTH");
        this.setAuthSubSysServiceAPIScriptLogicRuntime(iSubSysServiceAPIScriptLogicRuntime);
    }

    @Override
    public void requestTokenIf(boolean bImmediately) {
        if (this.getTokenTimeout() - System.currentTimeMillis() >= 60000L) {
            return;
        }
        this.requestToken(bImmediately);
    }

    @Override
    public void requestToken() {
        this.requestToken(false);
    }

    @Override
    public void requestToken(boolean bImmediately) {
        if (bImmediately) {
            this.onRequestToken();
        } else {
            this.setTokenTimeout(0L);
        }
    }

    protected void onRequestToken() {
        try {
            long nLastTokenTimeout = this.getTokenTimeout();
            this.doRequestTokenReal();
            if (this.getTokenTimeout() == nLastTokenTimeout) {
                this.setTokenTimeout(System.currentTimeMillis() + (long)this.getDefaultTokenTimeout());
            }
        }
        catch (Throwable ex) {
            log.error((Object)String.format("\u5916\u90e8\u670d\u52a1\u63a5\u53e3[%1$s]\u8ba4\u8bc1\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), ex);
            this.setTokenTimeout(0L);
            throw new SubSysServiceAPIRuntimeException((ISubSysServiceAPIRuntime)this, String.format("\u8ba4\u8bc1\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected void doRequestTokenReal() throws Throwable {
        if (this.getAuthSubSysServiceAPIScriptLogicRuntime() == null) {
            throw new SubSysServiceAPIRuntimeException(this, String.format("\u672a\u5b9a\u4e49\u8ba4\u8bc1\u5904\u7406\u903b\u8f91", new Object[0]));
        }
        this.getAuthSubSysServiceAPIScriptLogicRuntime().execute(null);
    }

    protected void runAuthTimer() {
        this.runAuthTimer(false);
    }

    protected void runAuthTimer(boolean bTimerOnly) {
        if (!bTimerOnly) {
            try {
                this.onAuthTimer();
            }
            catch (Throwable ex) {
                log.error((Object)String.format("\u5916\u90e8\u670d\u52a1\u63a5\u53e3[%1$s]\u8ba4\u8bc1\u5b9a\u65f6\u5668\u5904\u7406\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), ex);
                this.getSystemRuntime().log(40000, "\u5916\u90e8\u670d\u52a1\u63a5\u53e3", String.format("\u5916\u90e8\u670d\u52a1\u63a5\u53e3[%1$s]\u8ba4\u8bc1\u5b9a\u65f6\u5668\u5904\u7406\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), ex);
            }
        }
        this.getSystemRuntime().threadRun(new Runnable(){

            @Override
            public void run() {
                SubSysServiceAPIRuntime.this.runAuthTimer();
            }
        }, System.currentTimeMillis() + 10000L, "AuthTimer_" + this.getPSSubSysServiceAPI().getId());
    }

    protected void onAuthTimer() {
        if (this.getTokenTimeout() - System.currentTimeMillis() >= 60000L) {
            return;
        }
        this.onRequestToken();
    }

    protected ISubSysServiceAPIScriptLogicRuntime getMethodSubSysServiceAPIScriptLogicRuntime() {
        return this.methodSubSysServiceAPIScriptLogicRuntime;
    }

    protected void setMethodSubSysServiceAPIScriptLogicRuntime(ISubSysServiceAPIScriptLogicRuntime methodSubSysServiceAPIScriptLogicRuntime) {
        this.methodSubSysServiceAPIScriptLogicRuntime = methodSubSysServiceAPIScriptLogicRuntime;
    }

    protected ISubSysServiceAPIScriptLogicRuntime getMethodScriptLogicRuntime() {
        return this.methodSubSysServiceAPIScriptLogicRuntime;
    }

    protected void setMethodScriptLogicRuntime(ISubSysServiceAPIScriptLogicRuntime methodSubSysServiceAPIScriptLogicRuntime) {
        this.methodSubSysServiceAPIScriptLogicRuntime = methodSubSysServiceAPIScriptLogicRuntime;
    }

    protected void prepareMethodScriptLogicRuntime() throws Exception {
        if (!StringUtils.hasLength((String)this.getMethodScriptCode())) {
            return;
        }
        ISubSysServiceAPIScriptLogicRuntime iSubSysServiceAPIScriptLogicRuntime = this.getSystemRuntime().createSubSysServiceAPIScriptLogicRuntime("METHOD");
        iSubSysServiceAPIScriptLogicRuntime.init(this.getSystemRuntime(), this, this.getMethodScriptCode(), "METHOD");
        this.setMethodSubSysServiceAPIScriptLogicRuntime(iSubSysServiceAPIScriptLogicRuntime);
    }

    protected Object createMethodParamScriptObject() {
        return SubSysServiceAPIRuntime.getParamSubSysServiceAPIScriptLogicRuntime().execute(null);
    }

    protected ISubSysServiceAPIScriptLogicRuntime getMethodSubSysServiceAPIScriptLogicRuntime(String strScriptCode) {
        ISubSysServiceAPIScriptLogicRuntime iSubSysServiceAPIScriptLogicRuntime = this.methodSubSysServiceAPIScriptLogicRuntimeMap.get(strScriptCode);
        if (iSubSysServiceAPIScriptLogicRuntime == null) {
            try {
                iSubSysServiceAPIScriptLogicRuntime = this.getSystemRuntime().createSubSysServiceAPIScriptLogicRuntime("METHOD");
                iSubSysServiceAPIScriptLogicRuntime.init(this.getSystemRuntime(), this, strScriptCode, "METHOD");
                this.methodSubSysServiceAPIScriptLogicRuntimeMap.put(strScriptCode, iSubSysServiceAPIScriptLogicRuntime);
                return iSubSysServiceAPIScriptLogicRuntime;
            }
            catch (Throwable ex) {
                throw new SubSysServiceAPIRuntimeException((ISubSysServiceAPIRuntime)this, String.format("\u5efa\u7acb\u5916\u90e8\u670d\u52a1\u63a5\u53e3\u8c03\u7528\u65b9\u6cd5\u811a\u672c\u903b\u8f91\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
            }
        }
        return iSubSysServiceAPIScriptLogicRuntime;
    }

    @Override
    public IObjectStorageServiceAdapter getObjectStorageServiceAdapter() {
        return this.iObjectStorageServiceAdapter;
    }

    protected void setObjectStorageServiceAdapter(IObjectStorageServiceAdapter iObjectStorageServiceAdapter) {
        this.iObjectStorageServiceAdapter = iObjectStorageServiceAdapter;
    }

    protected void prepareObjectStorageServiceAdapter() throws Exception {
        ISubSysServiceAPIDERuntime utilSubSysServiceAPIDERuntime = this.getSubSysServiceAPIDERuntime("UTIL", true);
        if (utilSubSysServiceAPIDERuntime == null) {
            return;
        }
        IPSSubSysServiceAPIDEMethod uploadFilePSSubSysServiceAPIDEMethod = utilSubSysServiceAPIDERuntime.getPSSubSysServiceAPIDEMethod("UPLOADFILE", true);
        if (uploadFilePSSubSysServiceAPIDEMethod == null) {
            return;
        }
        IPSSubSysServiceAPIDEMethod downloadFilePSSubSysServiceAPIDEMethod = utilSubSysServiceAPIDERuntime.getPSSubSysServiceAPIDEMethod("DOWNLOADFILE", true);
        if (downloadFilePSSubSysServiceAPIDEMethod == null) {
            return;
        }
        this.setObjectStorageServiceAdapter(new SubSysServiceAPIOSSAdapter(this.getSubSysServiceAPIRuntimeContext()));
    }

    @Override
    public void tokenExpireIn(int nSeconds) {
        if (nSeconds >= 0) {
            this.setTokenTimeout(System.currentTimeMillis() + (long)(nSeconds * 1000));
        }
    }
}

