/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.res;

import java.io.File;
import net.ibizsys.central.res.SysFileResourceRuntimeBase;
import net.ibizsys.runtime.util.KeyValueUtils;
import net.ibizsys.runtime.util.ZipUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public class SysZipFileResourceRuntime
extends SysFileResourceRuntimeBase {
    private static final Log log = LogFactory.getLog(SysZipFileResourceRuntime.class);

    @Override
    protected void prepareFile() throws Exception {
        String content = this.getContent();
        if (!StringUtils.hasLength((String)content)) {
            throw new Exception("\u672a\u6307\u5b9aZip\u6587\u4ef6\u8def\u5f84");
        }
        String[] items = content.split("[#]");
        String url = items[0];
        File tempFile = File.createTempFile("resource", ".zip");
        try {
            this.getSystemRuntime().getDefaultWebClient().download(url, tempFile);
        }
        catch (Throwable ex) {
            throw new Exception(String.format("\u4e0b\u8f7d\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
        String folderPath = tempFile.getParentFile().getAbsolutePath() + File.separator + KeyValueUtils.genUniqueId();
        File folder = new File(folderPath);
        ZipUtils.unzip(tempFile, folder);
        if (items.length == 2 && StringUtils.hasLength((String)items[1])) {
            folder = new File(folder.getAbsolutePath() + File.separator + items[1]);
        }
        this.setFile(folder);
    }
}

