/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.dataentity.print;

import java.io.File;
import java.io.OutputStream;
import java.util.List;
import net.ibizsys.central.IDynaInstRuntime;
import net.ibizsys.central.ISystemRuntime;
import net.ibizsys.central.dataentity.IDataEntityModelRuntime;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.IDynaInstDataEntityRuntime;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.central.util.ISearchContextDTO;
import net.ibizsys.central.util.SearchContextDTO;
import net.ibizsys.model.dataentity.der.IPSDER1N;
import net.ibizsys.model.dataentity.der.IPSDERBase;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.IEntityBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DEPrintRuntime
extends net.ibizsys.runtime.dataentity.print.DEPrintRuntime
implements IDataEntityModelRuntime {
    private static final Log log = LogFactory.getLog(DEPrintRuntime.class);
    private String strReportFilePath = null;

    @Override
    protected void onInit() throws Exception {
        super.onInit();
        if (!StringUtils.hasLength((String)this.getReportFilePath())) {
            this.prepareReportFilePath();
        }
    }

    @Override
    protected String getReportFilePath() {
        return this.strReportFilePath;
    }

    protected void setReportFilePath(String strReportFilePath) {
        this.strReportFilePath = strReportFilePath;
    }

    protected void prepareReportFilePath() throws Exception {
        String strReportFilePath = this.getPSDEPrint().getReportFile();
        if (!StringUtils.hasLength((String)strReportFilePath)) {
            return;
        }
        String strReportFilePath2 = strReportFilePath.toLowerCase();
        if (strReportFilePath2.indexOf("http://") == 0 || strReportFilePath2.indexOf("https://") == 0) {
            File tempFile = File.createTempFile("deprint", this.getDefaultReportFileSuffix());
            try {
                this.getSystemRuntime().getDefaultWebClient().download(strReportFilePath, null, null, null, tempFile, null);
            }
            catch (Throwable ex) {
                throw new Exception(String.format("\u4e0b\u8f7d\u8fdc\u7a0b\u62a5\u8868\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
            }
            this.setReportFilePath(tempFile.getCanonicalPath());
        } else {
            if (!StringUtils.hasLength((String)this.getSystemRuntime().getReportFolder())) {
                if (StringUtils.hasLength((String)this.getReportModel())) {
                    return;
                }
                throw new Exception(String.format("\u7cfb\u7edf\u672a\u5b9a\u4e49\u62a5\u8868\u5b58\u50a8\u6587\u4ef6\u5939", new Object[0]));
            }
            File file = new File(this.getSystemRuntime().getReportFolder() + strReportFilePath);
            if (!file.exists()) {
                if (StringUtils.hasLength((String)this.getReportModel())) {
                    return;
                }
                throw new Exception(String.format("\u6307\u5b9a\u62a5\u8868\u6587\u4ef6\u4e0d\u5b58\u5728", new Object[0]));
            }
            this.setReportFilePath(file.getCanonicalPath());
        }
    }

    @Override
    public IDataEntityRuntime getDataEntityRuntime() {
        return (IDataEntityRuntime)super.getDataEntityRuntime();
    }

    @Override
    public IDynaInstDataEntityRuntime getDynaInstDataEntityRuntime() {
        return (IDynaInstDataEntityRuntime)super.getDynaInstDataEntityRuntime();
    }

    @Override
    public ISystemRuntime getSystemRuntime() {
        return (ISystemRuntime)super.getSystemRuntime();
    }

    @Override
    public IDynaInstRuntime getDynaInstRuntime() {
        return (IDynaInstRuntime)super.getDynaInstRuntime();
    }

    protected String getDefaultReportFileSuffix() {
        return null;
    }

    protected List<? extends IEntity> selectDetails(IEntity iEntity) throws Throwable {
        IPSDEDataSet detailPSDEDataSet;
        if (this.getPSDEPrint().getDetailPSDE() == null) {
            return null;
        }
        Object objValue = this.getDataEntityRuntime().getKeyFieldValue(iEntity);
        if (ObjectUtils.isEmpty((Object)objValue)) {
            return null;
        }
        IDataEntityRuntime childDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(this.getPSDEPrint().getDetailPSDE().getId());
        ISearchContextDTO iSearchContextDTO = childDataEntityRuntime.createSearchContext();
        iSearchContextDTO.set(this.getDataEntityRuntime().getKeyPSDEField().getLowerCaseName(), objValue);
        List psDERBases = this.getDataEntityRuntime().getPSDataEntity().getMajorPSDERs();
        if (!ObjectUtils.isEmpty((Object)psDERBases)) {
            String strMinorDEId = this.getPSDEPrint().getDetailPSDE().getId();
            IPSDER1N filterPSDERBase = null;
            for (IPSDERBase psDERBase : psDERBases) {
                IPSDER1N iPSDER1N;
                if (!"DER1N".equals(psDERBase.getDERType()) || ((iPSDER1N = (IPSDER1N)psDERBase).getMasterRS() & 1) != 1 || !strMinorDEId.equalsIgnoreCase(psDERBase.getMinorPSDataEntity().getId())) continue;
                if (filterPSDERBase == null) {
                    filterPSDERBase = iPSDER1N;
                    continue;
                }
                log.warn((Object)String.format("\u5b9e\u4f53[%1$s]\u5b58\u5728\u591a\u4e2a\u9644\u5c5e\u5b9e\u4f53[%2$s]\u7684\u5173\u7cfb\uff0c\u5ffd\u7565\u8fc7\u6ee4\u5904\u7406", this.getDataEntityRuntime().getName(), this.getPSDEPrint().getDetailPSDE().getName()));
                filterPSDERBase = null;
                break;
            }
            if (filterPSDERBase instanceof IPSDER1N) {
                SearchContextDTO.addSearchFieldCond(iSearchContextDTO, ((IPSDER1N)filterPSDERBase).getPSPickupDEFieldMust().getLowerCaseName(), "EQ", objValue, null);
            }
        }
        if ((detailPSDEDataSet = this.getPSDEPrint().getDetailPSDEDataSet()) == null) {
            detailPSDEDataSet = childDataEntityRuntime.getDefaultPSDEDataSet();
        }
        if (detailPSDEDataSet == null) {
            throw new Exception("\u660e\u7ec6\u6570\u636e\u6570\u636e\u96c6\u65e0\u6548");
        }
        List<IEntityDTO> list = childDataEntityRuntime.selectDataSet(detailPSDEDataSet, iSearchContextDTO);
        if (!ObjectUtils.isEmpty(list)) {
            for (IEntityDTO iEntityDTO : list) {
                childDataEntityRuntime.fillEntityCodeListTexts(iEntityDTO);
            }
        }
        return list;
    }

    @Override
    protected void onOutput(OutputStream outputStream, IEntityBase[] list, String strType) throws Throwable {
        if (list != null) {
            for (IEntityBase iEntityBase : list) {
                if (!(iEntityBase instanceof IEntity)) continue;
                this.getDataEntityRuntime().fillEntityCodeListTexts((IEntity)iEntityBase);
            }
        }
        super.onOutput(outputStream, list, strType);
    }
}

