/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.dataentity.demap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.dataentity.DataEntityModelRuntimeBase;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.demap.IDEMapRuntime;
import net.ibizsys.central.dataentity.service.IDEMethodDTO;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.central.util.ISearchContextDTO;
import net.ibizsys.central.util.SearchGroupCond;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.dataentity.action.IPSDEAction;
import net.ibizsys.model.dataentity.datamap.IPSDEMap;
import net.ibizsys.model.dataentity.datamap.IPSDEMapAction;
import net.ibizsys.model.dataentity.datamap.IPSDEMapDataSet;
import net.ibizsys.model.dataentity.datamap.IPSDEMapField;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.model.dataentity.service.IPSDEMethodDTO;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeBase;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeContext;
import net.ibizsys.runtime.dataentity.action.IDEScriptLogicRuntime;
import net.ibizsys.runtime.util.ISearchCond;
import net.ibizsys.runtime.util.ISearchCustomCond;
import net.ibizsys.runtime.util.ISearchFieldCond;
import net.ibizsys.runtime.util.ISearchGroupCond;
import net.ibizsys.runtime.util.ISearchPredefinedCond;
import net.ibizsys.runtime.util.SearchCustomCond;
import net.ibizsys.runtime.util.SearchFieldCond;
import net.ibizsys.runtime.util.SearchPredefinedCond;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Sort;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class DEMapRuntimeBase
extends DataEntityModelRuntimeBase
implements IDEMapRuntime {
    private static final Log log = LogFactory.getLog(DEMapRuntimeBase.class);
    private IPSDEMap iPSDEMap = null;
    private Map<String, IPSDEMapAction> psDEMapActionMap = null;
    private Map<String, IPSDEMapDataSet> psDEMapDataSetMap = null;
    private Map<String, IPSDEMapField> srcPSDEMapFieldMap = null;
    private Map<String, IPSDEMapField> dstPSDEMapFieldMap = null;
    private IDataEntityRuntime dstDataEntityRuntime = null;

    @Override
    public void init(IDataEntityRuntimeContext iDataEntityRuntimeContext, IPSDEMap iPSDEMap) throws Exception {
        this.setDataEntityRuntimeBase(iDataEntityRuntimeContext.getDataEntityRuntime());
        this.setPSDEMap(iPSDEMap);
        this.onInit();
    }

    @Override
    protected void onInit() throws Exception {
        List psDEMapDataSets;
        List psDEMapActions;
        List psDEMapFields = this.getPSDEMap().getPSDEMapFields();
        if (!ObjectUtils.isEmpty((Object)psDEMapFields)) {
            this.srcPSDEMapFieldMap = new HashMap<String, IPSDEMapField>();
            this.dstPSDEMapFieldMap = new HashMap<String, IPSDEMapField>();
            for (IPSDEMapField iPSDEMapField : psDEMapFields) {
                if (ObjectUtils.isEmpty((Object)iPSDEMapField.getMapType()) || "FIELD".equals(iPSDEMapField.getMapType())) {
                    if (ObjectUtils.isEmpty((Object)iPSDEMapField.getSrcFieldName())) {
                        throw new Exception(String.format("\u5c5e\u6027\u6620\u5c04[%1$s]\u672a\u6307\u5b9a\u6e90\u5c5e\u6027", iPSDEMapField.getName()));
                    }
                    if (ObjectUtils.isEmpty((Object)iPSDEMapField.getDstFieldName())) {
                        throw new Exception(String.format("\u5c5e\u6027\u6620\u5c04[%1$s]\u672a\u6307\u5b9a\u76ee\u6807\u5c5e\u6027", iPSDEMapField.getName()));
                    }
                    this.srcPSDEMapFieldMap.put(iPSDEMapField.getSrcFieldName().toLowerCase(), iPSDEMapField);
                    this.dstPSDEMapFieldMap.put(iPSDEMapField.getDstFieldName().toLowerCase(), iPSDEMapField);
                    continue;
                }
                if ("VALUE".equals(iPSDEMapField.getMapType()) || "EXPRESSION".equals(iPSDEMapField.getMapType())) {
                    if (ObjectUtils.isEmpty((Object)iPSDEMapField.getDstFieldName())) {
                        throw new Exception(String.format("\u5c5e\u6027\u6620\u5c04[%1$s]\u672a\u6307\u5b9a\u76ee\u6807\u5c5e\u6027", iPSDEMapField.getName()));
                    }
                    this.dstPSDEMapFieldMap.put(iPSDEMapField.getDstFieldName().toLowerCase(), iPSDEMapField);
                    continue;
                }
                if ("VALUE_SRC".equals(iPSDEMapField.getMapType()) || "EXPRESSION_SRC".equals(iPSDEMapField.getMapType())) {
                    if (ObjectUtils.isEmpty((Object)iPSDEMapField.getSrcFieldName())) {
                        throw new Exception(String.format("\u5c5e\u6027\u6620\u5c04[%1$s]\u672a\u6307\u5b9a\u6e90\u5c5e\u6027", iPSDEMapField.getName()));
                    }
                    this.srcPSDEMapFieldMap.put(iPSDEMapField.getSrcFieldName().toLowerCase(), iPSDEMapField);
                    continue;
                }
                throw new Exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u5c5e\u6027\u6620\u5c04\u7c7b\u578b[%1$s][%2$s]", iPSDEMapField.getName(), iPSDEMapField.getMapType()));
            }
        }
        if (!ObjectUtils.isEmpty((Object)(psDEMapActions = this.getPSDEMap().getPSDEMapActions()))) {
            this.psDEMapActionMap = new HashMap<String, IPSDEMapAction>();
            for (IPSDEMapAction iPSDEMapAction : psDEMapActions) {
                this.psDEMapActionMap.put(iPSDEMapAction.getSrcPSDEActionMust().getName(), iPSDEMapAction);
                this.psDEMapActionMap.put(iPSDEMapAction.getSrcPSDEActionMust().getName().toLowerCase(), iPSDEMapAction);
            }
        }
        if (!ObjectUtils.isEmpty((Object)(psDEMapDataSets = this.getPSDEMap().getPSDEMapDataSets()))) {
            this.psDEMapDataSetMap = new HashMap<String, IPSDEMapDataSet>();
            for (IPSDEMapDataSet iPSDEMapDataSet : psDEMapDataSets) {
                iPSDEMapDataSet.getDstPSDEDataSetMust();
                this.psDEMapDataSetMap.put(iPSDEMapDataSet.getSrcPSDEDataSetMust().getName(), iPSDEMapDataSet);
                this.psDEMapDataSetMap.put(iPSDEMapDataSet.getSrcPSDEDataSetMust().getName().toLowerCase(), iPSDEMapDataSet);
            }
        }
        super.onInit();
    }

    @Override
    public IPSDEMap getPSDEMap() {
        return this.iPSDEMap;
    }

    protected void setPSDEMap(IPSDEMap iPSDEMap) {
        this.iPSDEMap = iPSDEMap;
    }

    @Override
    public IPSModelObject getPSModelObject() {
        return this.getPSDEMap();
    }

    @Override
    public IDataEntityRuntime getDstDataEntityRuntime() {
        if (this.dstDataEntityRuntime == null) {
            this.dstDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(this.getPSDEMap().getDstPSDEMust().getId());
        }
        return this.dstDataEntityRuntime;
    }

    protected Map<String, IPSDEMapField> getDstPSDEMapFieldMap() {
        return this.dstPSDEMapFieldMap;
    }

    protected Map<String, IPSDEMapField> getSrcPSDEMapFieldMap() {
        return this.srcPSDEMapFieldMap;
    }

    @Override
    public IEntityDTO toEntityDTO(IEntityDTO srcEntityDTO) {
        return this.toEntityDTO(srcEntityDTO, null);
    }

    @Override
    public IEntityDTO toEntityDTO(IEntityDTO srcEntityDTO, IEntityDTO iEntityDTO) {
        try {
            if (ObjectUtils.isEmpty(this.getDstPSDEMapFieldMap())) {
                throw new Exception("\u672a\u5b9a\u4e49\u76ee\u6807\u5b9e\u4f53\u5c5e\u6027\u6620\u5c04\u6a21\u578b");
            }
            if (iEntityDTO == null) {
                iEntityDTO = this.getDstDataEntityRuntime().createEntity();
            }
            for (Map.Entry<String, IPSDEMapField> entry : this.getDstPSDEMapFieldMap().entrySet()) {
                IPSDEMapField iPSDEMapField = entry.getValue();
                if ("FIELD".equals(iPSDEMapField.getMapType())) {
                    iEntityDTO.set(iPSDEMapField.getDstFieldName(), srcEntityDTO.get(iPSDEMapField.getSrcFieldName()));
                    continue;
                }
                if ("VALUE".equals(iPSDEMapField.getMapType())) {
                    iEntityDTO.set(iPSDEMapField.getDstFieldName(), iPSDEMapField.getRawValue());
                    continue;
                }
                if (!"EXPRESSION".equals(iPSDEMapField.getMapType())) continue;
                if (!StringUtils.hasLength((String)iPSDEMapField.getExpression())) {
                    throw new Exception(String.format("\u672a\u5b9a\u4e49\u5c5e\u6027\u6620\u5c04[%1$s]\u8868\u8fbe\u5f0f", iPSDEMapField.getName()));
                }
                IDEScriptLogicRuntime iDEScriptLogicRuntime = this.getDataEntityRuntime().getDEScriptLogicRuntime("DEFEXPRESSION", iPSDEMapField.getExpression());
                iEntityDTO.set(iPSDEMapField.getDstFieldName(), iDEScriptLogicRuntime.execute(new Object[]{srcEntityDTO}));
            }
            return iEntityDTO;
        }
        catch (Throwable ex) {
            log.debug((Object)String.format("\u8f6c\u5316\u5f53\u524d\u5b9e\u4f53\u6570\u636e\u5bf9\u8c61\u5230\u76ee\u6807\u5b9e\u4f53\u6570\u636e\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()));
            throw new DataEntityRuntimeException(this.getDataEntityRuntimeBase(), (IModelRuntime)this, String.format("\u8f6c\u5316\u5f53\u524d\u5b9e\u4f53\u6570\u636e\u5bf9\u8c61\u5230\u76ee\u6807\u5b9e\u4f53\u6570\u636e\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    @Override
    public IEntityDTO fromEntityDTO(IEntityDTO dstEntityDTO) {
        return this.fromEntityDTO(dstEntityDTO, null);
    }

    @Override
    public IEntityDTO fromEntityDTO(IEntityDTO dstEntityDTO, IEntityDTO iEntityDTO) {
        try {
            if (ObjectUtils.isEmpty(this.getSrcPSDEMapFieldMap())) {
                throw new Exception("\u672a\u5b9a\u4e49\u6e90\u5b9e\u4f53\u5c5e\u6027\u6620\u5c04\u6a21\u578b");
            }
            if (iEntityDTO == null) {
                iEntityDTO = this.getDataEntityRuntime().createEntity();
            }
            for (Map.Entry<String, IPSDEMapField> entry : this.getSrcPSDEMapFieldMap().entrySet()) {
                IPSDEMapField iPSDEMapField = entry.getValue();
                if ("FIELD".equals(iPSDEMapField.getMapType())) {
                    iEntityDTO.set(iPSDEMapField.getSrcFieldName(), dstEntityDTO.get(iPSDEMapField.getDstFieldName()));
                    continue;
                }
                if ("VALUE_SRC".equals(iPSDEMapField.getMapType())) {
                    iEntityDTO.set(iPSDEMapField.getSrcFieldName(), iPSDEMapField.getRawValue());
                    continue;
                }
                if (!"EXPRESSION_SRC".equals(iPSDEMapField.getMapType())) continue;
                if (!StringUtils.hasLength((String)iPSDEMapField.getExpression())) {
                    throw new Exception(String.format("\u672a\u5b9a\u4e49\u5c5e\u6027\u6620\u5c04[%1$s]\u8868\u8fbe\u5f0f", iPSDEMapField.getName()));
                }
                IDEScriptLogicRuntime iDEScriptLogicRuntime = this.getDstDataEntityRuntime().getDEScriptLogicRuntime("DEFEXPRESSION", iPSDEMapField.getExpression());
                iEntityDTO.set(iPSDEMapField.getSrcFieldName(), iDEScriptLogicRuntime.execute(new Object[]{dstEntityDTO}));
            }
            return iEntityDTO;
        }
        catch (Throwable ex) {
            log.debug((Object)String.format("\u8f6c\u5316\u76ee\u6807\u5b9e\u4f53\u6570\u636e\u5bf9\u8c61\u5230\u5f53\u524d\u5b9e\u4f53\u6570\u636e\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()));
            throw new DataEntityRuntimeException(this.getDataEntityRuntimeBase(), (IModelRuntime)this, String.format("\u8f6c\u5316\u76ee\u6807\u5b9e\u4f53\u6570\u636e\u5bf9\u8c61\u5230\u5f53\u524d\u5b9e\u4f53\u6570\u636e\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    @Override
    public boolean isEnableAction(String strActionName, IPSDEAction iPSDEAction) {
        return this.isEnableAction(strActionName, iPSDEAction, null);
    }

    @Override
    public boolean isEnableAction(String strActionName, IPSDEAction iPSDEAction, String strMode) {
        IPSDEMapAction iPSDEMapAction = this.getPSDEMapAction(strActionName, iPSDEAction);
        if (iPSDEMapAction != null) {
            if (StringUtils.hasLength((String)strMode) && StringUtils.hasLength((String)iPSDEMapAction.getMapMode())) {
                return strMode.equals(iPSDEMapAction.getMapMode());
            }
            return true;
        }
        return false;
    }

    protected IPSDEMapAction getPSDEMapAction(String strActionName, IPSDEAction iPSDEAction) {
        if (ObjectUtils.isEmpty(this.psDEMapActionMap)) {
            return null;
        }
        if (iPSDEAction != null) {
            return this.psDEMapActionMap.get(iPSDEAction.getName());
        }
        return this.psDEMapActionMap.get(strActionName.toLowerCase());
    }

    @Override
    public boolean isEnableDataSet(String strDataSetName, IPSDEDataSet iPSDEDataSet) {
        return this.isEnableDataSet(strDataSetName, iPSDEDataSet, null);
    }

    @Override
    public boolean isEnableDataSet(String strDataSetName, IPSDEDataSet iPSDEDataSet, String strMode) {
        IPSDEMapDataSet iPSDEMapDataSet = this.getPSDEMapDataSet(strDataSetName, iPSDEDataSet);
        if (iPSDEMapDataSet != null) {
            if (StringUtils.hasLength((String)strMode) && StringUtils.hasLength((String)iPSDEMapDataSet.getMapMode())) {
                return strMode.equals(iPSDEMapDataSet.getMapMode());
            }
            return true;
        }
        return false;
    }

    protected IPSDEMapDataSet getPSDEMapDataSet(String strDataSetName, IPSDEDataSet iPSDEDataSet) {
        if (ObjectUtils.isEmpty(this.psDEMapDataSetMap)) {
            return null;
        }
        if (iPSDEDataSet != null) {
            return this.psDEMapDataSetMap.get(iPSDEDataSet.getName());
        }
        return this.psDEMapDataSetMap.get(strDataSetName.toLowerCase());
    }

    @Override
    public Page fetchDataSet(String strDataSetName, IPSDEDataSet iPSDEDataSet, Object[] args, Object actionData) throws Throwable {
        IPSDEMapDataSet iPSDEMapDataSet = this.getPSDEMapDataSet(strDataSetName, iPSDEDataSet);
        if (iPSDEMapDataSet == null) {
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u6570\u636e\u96c6[%1$s]\u6620\u5c04", iPSDEDataSet != null ? iPSDEDataSet.getName() : strDataSetName));
        }
        try {
            return this.onFetchDataSet(iPSDEMapDataSet, args, actionData);
        }
        catch (Throwable ex) {
            log.debug((Object)String.format("\u83b7\u53d6\u6620\u5c04\u5b9e\u4f53\u7ed3\u679c\u96c6\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()));
            throw new DataEntityRuntimeException(this.getDataEntityRuntimeBase(), (IModelRuntime)this, String.format("\u83b7\u53d6\u6620\u5c04\u5b9e\u4f53\u7ed3\u679c\u96c6\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected Page onFetchDataSet(IPSDEMapDataSet iPSDEMapDataSet, Object[] args, Object actionData) throws Throwable {
        ISearchContextDTO iSearchContextDTO = null;
        if (args != null && args.length > 0 && args[0] instanceof ISearchContextDTO) {
            iSearchContextDTO = (ISearchContextDTO)args[0];
        }
        if (iSearchContextDTO == null) {
            throw new Exception(String.format("\u672a\u6307\u5b9a\u641c\u7d22\u4e0a\u4e0b\u6587\u5bf9\u8c61", new Object[0]));
        }
        ISearchContextDTO dstSearchContextDTO = this.toSearchContextDTO(iSearchContextDTO);
        Object objRet = this.getDstDataEntityRuntime().fetchDataSet(iPSDEMapDataSet.getDstPSDEDataSetMust().getName(), iPSDEMapDataSet.getDstPSDEDataSetMust(), new Object[]{dstSearchContextDTO});
        if (objRet instanceof Page) {
            IPSDEMethodDTO srcPSDEMethodDTO = null;
            if (iPSDEMapDataSet.getSrcPSDEDataSetMust().getPSDEDataSetReturn() != null) {
                srcPSDEMethodDTO = iPSDEMapDataSet.getSrcPSDEDataSetMust().getPSDEDataSetReturn().getPSDEMethodDTO();
            }
            Page retPage = (Page)objRet;
            List retList = retPage.getContent();
            List<IEntityDTO> list = this.getDataEntityRuntime().createEntityList();
            if (!ObjectUtils.isEmpty((Object)retList)) {
                for (Object item : retList) {
                    IDEMethodDTO iDEMethodDTO;
                    if (!(item instanceof IEntityDTO)) {
                        throw new Exception("\u65e0\u6cd5\u8bc6\u522b\u7684\u8fd4\u56de\u7ed3\u679c");
                    }
                    IEntityDTO iEntityDTO = null;
                    if (srcPSDEMethodDTO != null && (iDEMethodDTO = this.getDataEntityRuntime().getDEMethodDTO(srcPSDEMethodDTO, null)) instanceof IEntityDTO) {
                        iEntityDTO = (IEntityDTO)iDEMethodDTO;
                    }
                    iEntityDTO = this.fromEntityDTO((IEntityDTO)item, iEntityDTO);
                    list.add(iEntityDTO);
                }
            }
            return new PageImpl(list, retPage.getPageable(), retPage.getTotalElements());
        }
        throw new Exception("\u65e0\u6cd5\u8bc6\u522b\u7684\u8fd4\u56de\u7ed3\u679c");
    }

    @Override
    public ISearchContextDTO toSearchContextDTO(ISearchContextDTO iSearchContextDTO) {
        try {
            List<ISearchCond> searchConds;
            Iterator orders;
            ISearchContextDTO dstContextDTO = this.getDstDataEntityRuntime().createSearchContext();
            if (iSearchContextDTO.getPageable() != null) {
                dstContextDTO.setPageable(iSearchContextDTO.getPageable().getPageNumber(), iSearchContextDTO.getPageable().getPageSize(), iSearchContextDTO.getPageable().getOffset());
            }
            dstContextDTO.setCount(iSearchContextDTO.isCount());
            if (iSearchContextDTO.getPageSort() != null && iSearchContextDTO.getPageSort() != Sort.unsorted() && (orders = iSearchContextDTO.getPageSort().iterator()) != null) {
                while (orders.hasNext()) {
                    Sort.Order order = (Sort.Order)orders.next();
                    IPSDEMapField iPSDEMapField = this.getSrcPSDEMapField(order.getProperty());
                    if (iPSDEMapField == null || !"FIELD".equals(iPSDEMapField.getMapType())) {
                        log.warn((Object)String.format("\u6e90\u5c5e\u6027[%1$s]\u672a\u6620\u5c04\u76ee\u6807\u5c5e\u6027\uff0c\u5ffd\u7565\u6392\u5e8f\u5904\u7406", order.getProperty()));
                        continue;
                    }
                    if (order.isAscending()) {
                        dstContextDTO.setPageSort(String.format("%1$s,asc", iPSDEMapField.getDstFieldName().toLowerCase()));
                        break;
                    }
                    dstContextDTO.setPageSort(String.format("%1$s,desc", iPSDEMapField.getDstFieldName().toLowerCase()));
                    break;
                }
            }
            if (!ObjectUtils.isEmpty(searchConds = iSearchContextDTO.getSearchConds())) {
                for (ISearchCond iSearchCond : searchConds) {
                    ISearchCond dstSearchCond = this.toSearchCond(iSearchCond);
                    if (dstSearchCond == null) continue;
                    dstContextDTO.getSearchCondsIf().add(dstSearchCond);
                }
            }
            if (!ObjectUtils.isEmpty(iSearchContextDTO.any())) {
                for (Map.Entry entry : iSearchContextDTO.any().entrySet()) {
                    dstContextDTO.set((String)entry.getKey(), entry.getValue());
                }
            }
            return dstContextDTO;
        }
        catch (Throwable ex) {
            log.debug((Object)String.format("\u83b7\u53d6\u641c\u7d22\u4e0a\u4e0b\u6587\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()));
            throw new DataEntityRuntimeException(this.getDataEntityRuntimeBase(), (IModelRuntime)this, String.format("\u83b7\u53d6\u641c\u7d22\u4e0a\u4e0b\u6587\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected ISearchCond toSearchCond(ISearchCond iSearchCond) throws Throwable {
        String strType = iSearchCond.getCondType();
        if ("DEFIELD".equalsIgnoreCase(strType)) {
            ISearchFieldCond iSearchFieldCond = (ISearchFieldCond)iSearchCond;
            IPSDEMapField iPSDEMapField = this.getSrcPSDEMapField(iSearchFieldCond.getFieldName());
            if (iPSDEMapField == null || !"FIELD".equals(iPSDEMapField.getMapType())) {
                log.warn((Object)String.format("\u6e90\u5c5e\u6027[%1$s]\u672a\u6620\u5c04\u76ee\u6807\u5c5e\u6027\uff0c\u5ffd\u7565\u8fc7\u6ee4\u5904\u7406", iSearchFieldCond.getFieldName()));
                return null;
            }
            SearchFieldCond searchFieldCond = new SearchFieldCond();
            searchFieldCond.setCondOp(iSearchFieldCond.getCondOp());
            searchFieldCond.setDataType(iSearchFieldCond.getDataType());
            searchFieldCond.setFieldName(iPSDEMapField.getDstFieldName().toLowerCase());
            searchFieldCond.setName(iSearchFieldCond.getName());
            searchFieldCond.setParamMode(iSearchFieldCond.isParamMode());
            searchFieldCond.setValue(iSearchFieldCond.getValue());
            searchFieldCond.setValueFunc(iSearchFieldCond.getValueFunc());
            return searchFieldCond;
        }
        if ("GROUP".equalsIgnoreCase(strType)) {
            ISearchGroupCond iSearchGroupCond = (ISearchGroupCond)iSearchCond;
            List<ISearchCond> childSearchConds = iSearchGroupCond.getSearchConds();
            if (ObjectUtils.isEmpty(childSearchConds)) {
                return null;
            }
            SearchGroupCond searchGroupCond = new SearchGroupCond();
            searchGroupCond.setCondOp(iSearchGroupCond.getCondOp());
            searchGroupCond.setNotMode(iSearchGroupCond.isNotMode());
            for (ISearchCond childSearchCond : childSearchConds) {
                ISearchCond dstSearchCond = this.toSearchCond(childSearchCond);
                if (dstSearchCond == null) continue;
                searchGroupCond.getSearchCondsIf().add(dstSearchCond);
            }
            if (ObjectUtils.isEmpty(searchGroupCond.getSearchConds())) {
                return null;
            }
            return searchGroupCond;
        }
        if ("CUSTOM".equalsIgnoreCase(strType)) {
            ISearchCustomCond iSearchCustomCond = (ISearchCustomCond)iSearchCond;
            SearchCustomCond searchCustomCond = new SearchCustomCond();
            searchCustomCond.setCustomCond(iSearchCustomCond.getCustomCond());
            return searchCustomCond;
        }
        if ("PREDEFINED".equalsIgnoreCase(strType)) {
            ISearchPredefinedCond iSearchPredefinedCond = (ISearchPredefinedCond)iSearchCond;
            SearchPredefinedCond searchPredefinedCond = new SearchPredefinedCond();
            searchPredefinedCond.setPredefinedCond(iSearchPredefinedCond.getPredefinedCond());
            searchPredefinedCond.setPredefinedType(iSearchPredefinedCond.getPredefinedType());
            return searchPredefinedCond;
        }
        throw new Exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u641c\u7d22\u6761\u4ef6\u7c7b\u578b[%1$s]", strType));
    }

    protected IPSDEMapField getDstPSDEMapField(String strFieldName) {
        if (!ObjectUtils.isEmpty(this.getDstPSDEMapFieldMap())) {
            return this.getDstPSDEMapFieldMap().get(strFieldName.toLowerCase());
        }
        return null;
    }

    protected IPSDEMapField getSrcPSDEMapField(String strFieldName) {
        if (!ObjectUtils.isEmpty(this.getSrcPSDEMapFieldMap())) {
            return this.getSrcPSDEMapFieldMap().get(strFieldName.toLowerCase());
        }
        return null;
    }

    @Override
    public Object executeAction(String strActionName, IPSDEAction iPSDEAction, Object[] args, Object actionData) throws Throwable {
        IPSDEMapAction iPSDEMapAction = this.getPSDEMapAction(strActionName, iPSDEAction);
        if (iPSDEMapAction == null) {
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u884c\u4e3a[%1$s]\u6620\u5c04", iPSDEAction != null ? iPSDEAction.getName() : strActionName));
        }
        try {
            return this.onExecuteAction(iPSDEMapAction, args, actionData);
        }
        catch (Throwable ex) {
            log.debug((Object)String.format("\u6267\u884c\u6620\u5c04\u5b9e\u4f53\u884c\u4e3a\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()));
            throw new DataEntityRuntimeException(this.getDataEntityRuntimeBase(), (IModelRuntime)this, String.format("\u6267\u884c\u6620\u5c04\u5b9e\u4f53\u884c\u4e3a\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Object onExecuteAction(IPSDEMapAction iPSDEMapAction, Object[] args, Object actionData) throws Throwable {
        IEntityDTO srcEntityDTO;
        IPSDEMethodDTO retPSDEMethodDTO;
        IEntityDTO srcEntityDTO2;
        if (args == null) throw new Exception(String.format("\u4f20\u5165\u53c2\u6570\u65e0\u6548", new Object[0]));
        if (args.length == 0) {
            throw new Exception(String.format("\u4f20\u5165\u53c2\u6570\u65e0\u6548", new Object[0]));
        }
        Object[] dstArgs = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            dstArgs[i] = args[i];
        }
        IPSDEMethodDTO dstPSDEMethodDTO = iPSDEMapAction.getDstPSDEActionMust().getPSDEActionInputMust().getPSDEMethodDTO();
        if (args[0] instanceof IEntityDTO) {
            if (dstPSDEMethodDTO == null) {
                throw new Exception(String.format("\u76ee\u6807\u884c\u4e3a[%1$s]\u8f93\u5165\u53c2\u6570\u4e0e\u5f53\u524d\u884c\u4e3a[%2$s]\u6a21\u5f0f\u4e0d\u4e00\u81f4", iPSDEMapAction.getDstPSDEActionMust().getName(), iPSDEMapAction.getSrcPSDEActionMust().getName()));
            }
            IEntityDTO dstEntityDTO = (IEntityDTO)this.getDstDataEntityRuntime().getDEMethodDTO(dstPSDEMethodDTO, null);
            dstEntityDTO = this.toEntityDTO((IEntityDTO)args[0], dstEntityDTO);
            dstArgs[0] = dstEntityDTO;
        } else if (args[0] instanceof List) {
            List srcList = (List)args[0];
            ArrayList<IEntityDTO> dstList = new ArrayList<IEntityDTO>();
            for (Object objItem : srcList) {
                if (objItem instanceof IEntityDTO) {
                    if (dstPSDEMethodDTO == null) {
                        throw new Exception(String.format("\u76ee\u6807\u884c\u4e3a[%1$s]\u8f93\u5165\u53c2\u6570\u4e0e\u5f53\u524d\u884c\u4e3a[%2$s]\u6a21\u5f0f\u4e0d\u4e00\u81f4", iPSDEMapAction.getDstPSDEActionMust().getName(), iPSDEMapAction.getSrcPSDEActionMust().getName()));
                    }
                    IEntityDTO dstEntityDTO = (IEntityDTO)this.getDstDataEntityRuntime().getDEMethodDTO(dstPSDEMethodDTO, null);
                    dstEntityDTO = this.toEntityDTO((IEntityDTO)objItem, dstEntityDTO);
                    dstList.add(dstEntityDTO);
                    continue;
                }
                dstList.add((IEntityDTO)objItem);
            }
            dstArgs[0] = dstList;
        }
        Object objRet = this.getDstDataEntityRuntime().executeAction(iPSDEMapAction.getDstPSDEActionMust().getName(), iPSDEMapAction.getDstPSDEActionMust(), dstArgs);
        if (objRet != null) {
            if (!(objRet instanceof IEntityDTO)) return objRet;
            if (iPSDEMapAction.getSrcPSDEActionMust().getPSDEActionInputMust().isOutput()) {
                if (!(args[0] instanceof IEntityDTO)) throw new Exception(String.format("\u4f20\u5165\u53c2\u6570[0]\u7c7b\u578b\u4e0d\u6b63\u786e", new Object[0]));
                srcEntityDTO2 = (IEntityDTO)args[0];
                srcEntityDTO2.resetAll();
                this.fromEntityDTO((IEntityDTO)objRet, srcEntityDTO2);
                return objRet;
            }
            retPSDEMethodDTO = iPSDEMapAction.getSrcPSDEActionMust().getPSDEActionReturnMust().getPSDEMethodDTO();
            if (retPSDEMethodDTO == null) return objRet;
            srcEntityDTO = (IEntityDTO)this.getDataEntityRuntime().getDEMethodDTO(retPSDEMethodDTO, null);
            this.fromEntityDTO((IEntityDTO)objRet, srcEntityDTO);
            return srcEntityDTO;
        }
        if (!iPSDEMapAction.getDstPSDEActionMust().getPSDEActionInputMust().isOutput()) return objRet;
        if (!(dstArgs[0] instanceof IEntityDTO)) return objRet;
        if (iPSDEMapAction.getSrcPSDEActionMust().getPSDEActionInputMust().isOutput()) {
            if (!(args[0] instanceof IEntityDTO)) throw new Exception(String.format("\u4f20\u5165\u53c2\u6570[0]\u7c7b\u578b\u4e0d\u6b63\u786e", new Object[0]));
            srcEntityDTO2 = (IEntityDTO)args[0];
            srcEntityDTO2.resetAll();
            this.fromEntityDTO((IEntityDTO)dstArgs[0], srcEntityDTO2);
            return objRet;
        }
        retPSDEMethodDTO = iPSDEMapAction.getSrcPSDEActionMust().getPSDEActionReturnMust().getPSDEMethodDTO();
        if (retPSDEMethodDTO == null) return objRet;
        srcEntityDTO = (IEntityDTO)this.getDataEntityRuntime().getDEMethodDTO(retPSDEMethodDTO, null);
        this.fromEntityDTO((IEntityDTO)dstArgs[0], srcEntityDTO);
        return srcEntityDTO;
    }
}

