/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.ba;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.ISystemRuntimeContext;
import net.ibizsys.central.SystemModelRuntimeBase;
import net.ibizsys.central.ba.IBDDataService;
import net.ibizsys.central.ba.ISysBDSchemeRuntime;
import net.ibizsys.central.ba.ISysBDSchemeRuntimeContext;
import net.ibizsys.central.ba.SysBDSchemeRuntimeException;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.util.ISearchContext;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.IPSModelObjectRuntime;
import net.ibizsys.model.PSModelUtils;
import net.ibizsys.model.ba.IPSSysBDScheme;
import net.ibizsys.model.dataentity.ds.IPSDEDataQuery;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.model.system.IPSSysModelGroup;
import net.ibizsys.model.system.IPSSystemModule;
import net.ibizsys.runtime.ISystemRuntimeException;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.JsonUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Page;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SysBDSchemeRuntime
extends SystemModelRuntimeBase
implements ISysBDSchemeRuntime {
    private static final Log log = LogFactory.getLog(SysBDSchemeRuntime.class);
    private IPSSysBDScheme iPSSysBDScheme = null;
    private String strServiceUrl = null;
    private boolean bDefaultMode = false;
    private String strBDType = null;
    private Object objDataSourceTag = null;
    private Map<String, Object> properties = null;
    private String strClientId = null;
    private String strClientSecret = null;
    private String strAuthMode = null;
    private String strAuthParam = null;
    private String strAuthParam2 = null;
    private String strServiceParam = null;
    private String strServiceParam2 = null;
    private String strDBName = null;
    private static ThreadLocal<String> dbNameThreadLocal = new ThreadLocal();
    private ISysBDSchemeRuntimeContext iSysBDSchemeRuntimeContext = new ISysBDSchemeRuntimeContext(){

        @Override
        public ISysBDSchemeRuntime getSysBDSchemeRuntime() {
            return SysBDSchemeRuntime.this.getSelf();
        }
    };

    public static void setCurrentDBName(String strDBName) {
        dbNameThreadLocal.set(strDBName);
    }

    public static String getCurrentDBName() {
        return dbNameThreadLocal.get();
    }

    public static String getConfigFolder(IPSSysBDScheme iPSSysBDScheme) {
        if (iPSSysBDScheme.getPSSysModelGroup() != null) {
            return "sysbdscheme." + PSModelUtils.calcUniqueTag((IPSSysModelGroup)iPSSysBDScheme.getPSSysModelGroup(), (String)iPSSysBDScheme.getCodeName());
        }
        return "sysbdscheme." + PSModelUtils.calcUniqueTag((IPSSystemModule)iPSSysBDScheme.getPSSystemModule(), (String)iPSSysBDScheme.getCodeName());
    }

    public static IPSSysBDScheme getDefaultPSSysBDScheme(ISystemRuntimeContext iSystemRuntimeContext) throws Exception {
        ObjectNode objNode = JsonUtils.createObjectNode();
        objNode.put("name", "\u9ed8\u8ba4\u5927\u6570\u636e\u4f53\u7cfb");
        objNode.put("codeName", "SystemDefault");
        return (IPSSysBDScheme)iSystemRuntimeContext.getPSSystemService().createAndInitPSModelObject((IPSModelObjectRuntime)iSystemRuntimeContext.getPSSystemService().getPSSystem(), IPSSysBDScheme.class, objNode);
    }

    public static IPSSysBDScheme getPSSysBDScheme(ISystemRuntimeContext iSystemRuntimeContext, Map<String, Object> params) throws Exception {
        ObjectNode objNode = JsonUtils.createObjectNode();
        objNode.put("name", DataTypeUtils.getStringValue(params.get("name"), null));
        objNode.put("codeName", DataTypeUtils.getStringValue(params.get("codename"), null));
        objNode.put("servicePath", DataTypeUtils.getStringValue(params.get("serviceurl"), null));
        objNode.put("authMode", DataTypeUtils.getStringValue(params.get("authmode"), null));
        objNode.put("authClientId", DataTypeUtils.getStringValue(params.get("clientid"), null));
        objNode.put("authClientSecret", DataTypeUtils.getStringValue(params.get("clientsecret"), null));
        objNode.put("authParam", DataTypeUtils.getStringValue(params.get("authparam"), null));
        objNode.put("authParam2", DataTypeUtils.getStringValue(params.get("authparam2"), null));
        objNode.put("serviceParam", DataTypeUtils.getStringValue(params.get("serviceparam"), null));
        objNode.put("serviceParam2", DataTypeUtils.getStringValue(params.get("serviceparam2"), null));
        return (IPSSysBDScheme)iSystemRuntimeContext.getPSSystemService().createAndInitPSModelObject((IPSModelObjectRuntime)iSystemRuntimeContext.getPSSystemService().getPSSystem(), IPSSysBDScheme.class, objNode);
    }

    @Override
    public void init(ISystemRuntimeContext iSystemRuntimeContext, IPSSysBDScheme iPSSysBDScheme) throws Exception {
        Assert.notNull((Object)iSystemRuntimeContext, (String)"\u4f20\u5165\u7cfb\u7edf\u8fd0\u884c\u65f6\u4e0a\u4e0b\u6587\u5bf9\u8c61\u65e0\u6548");
        Assert.notNull((Object)iPSSysBDScheme, (String)"\u4f20\u5165\u5927\u6570\u636e\u4f53\u7cfb\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        this.setSystemRuntimeBase(iSystemRuntimeContext.getSystemRuntime());
        this.iPSSysBDScheme = iPSSysBDScheme;
        this.setConfigFolder(SysBDSchemeRuntime.getConfigFolder(iPSSysBDScheme));
        this.onInit();
    }

    @Override
    protected void onInit() throws Exception {
        if (StringUtils.hasLength((String)this.getPSSysBDScheme().getCodeName())) {
            this.setDBName(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".dbname", this.getPSSysBDScheme().getCodeName().toLowerCase()));
        } else {
            this.setDBName(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".dbname", null));
        }
        this.setServiceUrl(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".serviceurl", this.getPSSysBDScheme().getServicePath()));
        this.setDefaultMode(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".defaultmode", this.getPSSysBDScheme().isDefaultMode()));
        this.setAuthMode(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".authmode", this.getPSSysBDScheme().getAuthMode()));
        this.setClientId(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".clientid", this.getPSSysBDScheme().getAuthClientId()));
        this.setClientSecret(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".clientsecret", this.getPSSysBDScheme().getAuthClientSecret()));
        this.setAuthParam(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".authparam", this.getPSSysBDScheme().getAuthParam()));
        this.setAuthParam2(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".authparam2", this.getPSSysBDScheme().getAuthParam2()));
        this.setServiceParam(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".serviceparam", this.getPSSysBDScheme().getServiceParam()));
        this.setServiceParam2(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".serviceparam2", this.getPSSysBDScheme().getServiceParam2()));
        super.onInit();
    }

    protected ISysBDSchemeRuntimeContext getSysBDSchemeRuntimeContext() {
        return this.iSysBDSchemeRuntimeContext;
    }

    private SysBDSchemeRuntime getSelf() {
        return this;
    }

    @Override
    public IPSSysBDScheme getPSSysBDScheme() {
        return this.iPSSysBDScheme;
    }

    @Override
    public String getId() {
        return this.getPSSysBDScheme().getId();
    }

    @Override
    public String getName() {
        return this.getPSSysBDScheme().getName();
    }

    @Override
    public String getBDType() {
        return this.strBDType;
    }

    @Override
    public void setBDType(String strBDType) {
        this.strBDType = strBDType;
    }

    @Override
    public String getServiceUrl() {
        return this.strServiceUrl;
    }

    protected void setServiceUrl(String strServiceUrl) {
        this.strServiceUrl = strServiceUrl;
    }

    @Override
    public String getServiceParam() {
        return this.strServiceParam;
    }

    protected void setServiceParam(String strServiceParam) {
        this.strServiceParam = strServiceParam;
    }

    @Override
    public String getServiceParam2() {
        return this.strServiceParam2;
    }

    protected void setServiceParam2(String strServiceParam2) {
        this.strServiceParam2 = strServiceParam2;
    }

    @Override
    public boolean isDefaultMode() {
        return this.bDefaultMode;
    }

    protected void setDefaultMode(boolean bDefaultMode) {
        this.bDefaultMode = bDefaultMode;
    }

    @Override
    public String getClientId() {
        return this.strClientId;
    }

    protected void setClientId(String strClientId) {
        this.strClientId = strClientId;
    }

    @Override
    public String getClientSecret() {
        return this.strClientSecret;
    }

    protected void setClientSecret(String strClientSecret) {
        this.strClientSecret = strClientSecret;
    }

    @Override
    public String getAuthMode() {
        return this.strAuthMode;
    }

    protected void setAuthMode(String strAuthMode) {
        this.strAuthMode = strAuthMode;
    }

    @Override
    public String getAuthParam() {
        return this.strAuthParam;
    }

    protected void setAuthParam(String strAuthParam) {
        this.strAuthParam = strAuthParam;
    }

    @Override
    public String getAuthParam2() {
        return this.strAuthParam2;
    }

    protected void setAuthParam2(String strAuthParam2) {
        this.strAuthParam2 = strAuthParam2;
    }

    public String getDBName() {
        String strCurrentDBName = SysBDSchemeRuntime.getCurrentDBName();
        if (StringUtils.hasLength((String)strCurrentDBName)) {
            return strCurrentDBName;
        }
        return this.strDBName;
    }

    protected void setDBName(String strDBName) {
        this.strDBName = strDBName;
    }

    @Override
    public IPSModelObject getPSModelObject() {
        return this.getPSSysBDScheme();
    }

    protected IBDDataService getBDDataService() {
        throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, "\u6ca1\u6709\u5b9e\u73b0\u83b7\u53d6\u6570\u636e\u670d\u52a1\u65b9\u6cd5", 20);
    }

    @Override
    public Object insert(String strTableName, List<Map<String, Object>> args, Map<String, Object> extParamMap) throws Throwable {
        throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, "\u6ca1\u6709\u5b9e\u73b0", 20);
    }

    @Override
    public Object update(String strTableName, List<Map<String, Object>> args, Map<String, Object> extParamMap, boolean bAppendMode) throws Throwable {
        throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, "\u6ca1\u6709\u5b9e\u73b0", 20);
    }

    @Override
    public Object delete(String strTableName, List<Map<String, Object>> args, Map<String, Object> extParamMap) throws Throwable {
        throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, "\u6ca1\u6709\u5b9e\u73b0", 20);
    }

    @Override
    public Object insert(String strTableName, Map<String, Object> arg, Map<String, Object> extParamMap) throws Throwable {
        Assert.hasLength((String)strTableName, (String)"\u672a\u4f20\u5165\u6570\u636e\u8868\u6807\u8bc6");
        Assert.notNull(arg, (String)"\u672a\u4f20\u5165\u63d2\u5165\u6570\u636e");
        try {
            return this.onInsert(strTableName, arg, extParamMap);
        }
        catch (Throwable ex) {
            if (ex instanceof ISystemRuntimeException) {
                throw ex;
            }
            throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, String.format("\u65b0\u5efa\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected Object onInsert(String strTableName, Map<String, Object> arg, Map<String, Object> extParamMap) throws Throwable {
        throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, "\u6ca1\u6709\u5b9e\u73b0", 20);
    }

    @Override
    public Object update(String strTableName, Map<String, Object> arg, Map<String, Object> extParamMap, boolean bAppendMode) throws Throwable {
        Assert.hasLength((String)strTableName, (String)"\u672a\u4f20\u5165\u6570\u636e\u8868\u6807\u8bc6");
        try {
            return this.onUpdate(strTableName, arg, extParamMap, bAppendMode);
        }
        catch (Throwable ex) {
            if (ex instanceof ISystemRuntimeException) {
                throw ex;
            }
            throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, String.format("\u66f4\u65b0\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected Object onUpdate(String strTableName, Map<String, Object> arg, Map<String, Object> extParamMap, boolean bAppendMode) throws Throwable {
        throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, "\u6ca1\u6709\u5b9e\u73b0", 20);
    }

    @Override
    public Object delete(String strTableName, Map<String, Object> arg, Map<String, Object> extParamMap) throws Throwable {
        Assert.hasLength((String)strTableName, (String)"\u672a\u4f20\u5165\u6570\u636e\u8868\u6807\u8bc6");
        try {
            return this.onDelete(strTableName, arg, extParamMap);
        }
        catch (Throwable ex) {
            if (ex instanceof ISystemRuntimeException) {
                throw ex;
            }
            throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, String.format("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected Object onDelete(String strTableName, Map<String, Object> arg, Map<String, Object> extParamMap) throws Throwable {
        throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, "\u6ca1\u6709\u5b9e\u73b0", 20);
    }

    @Override
    public List select(String strTableName, Map<String, Object> paramMap, Map<String, Object> extParamMap) throws Throwable {
        throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, "\u6ca1\u6709\u5b9e\u73b0", 20);
    }

    @Override
    public List query(IDataEntityRuntime iDataEntityRuntime, IPSDEDataQuery iPSDEDataQuery, ISearchContext iSearchContext, String[] outputFields, Map<String, Object> extParamMap) throws Throwable {
        try {
            return this.onQuery(iDataEntityRuntime, iPSDEDataQuery, iSearchContext, outputFields, extParamMap);
        }
        catch (Throwable ex) {
            if (ex instanceof ISystemRuntimeException) {
                throw ex;
            }
            throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, String.format("\u6570\u636e\u67e5\u8be2[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSDEDataQuery.getName(), ex.getMessage()), ex);
        }
    }

    protected List onQuery(IDataEntityRuntime iDataEntityRuntime, IPSDEDataQuery iPSDEDataQuery, ISearchContext iSearchContext, String[] outputFields, Map<String, Object> extParamMap) throws Throwable {
        throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, "\u6ca1\u6709\u5b9e\u73b0", 20);
    }

    @Override
    public Page query2(IDataEntityRuntime iDataEntityRuntime, IPSDEDataQuery iPSDEDataQuery, ISearchContext iSearchContext, String[] outputFields, Map<String, Object> extParamMap) throws Throwable {
        try {
            return this.onQuery2(iDataEntityRuntime, iPSDEDataQuery, iSearchContext, outputFields, extParamMap);
        }
        catch (Throwable ex) {
            if (ex instanceof ISystemRuntimeException) {
                throw ex;
            }
            throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, String.format("\u6570\u636e\u67e5\u8be2[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSDEDataQuery.getName(), ex.getMessage()), ex);
        }
    }

    protected Page onQuery2(IDataEntityRuntime iDataEntityRuntime, IPSDEDataQuery iPSDEDataQuery, ISearchContext iSearchContext, String[] outputFields, Map<String, Object> extParamMap) throws Throwable {
        throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, "\u6ca1\u6709\u5b9e\u73b0", 20);
    }

    @Override
    public Page fetchDataSet(IDataEntityRuntime iDataEntityRuntime, IPSDEDataSet iPSDEDataSet, ISearchContext iSearchContext, String[] outputFields, Map<String, Object> extParamMap) throws Throwable {
        try {
            return this.onFetchDataSet(iDataEntityRuntime, iPSDEDataSet, iSearchContext, outputFields, extParamMap);
        }
        catch (Throwable ex) {
            if (ex instanceof ISystemRuntimeException) {
                throw ex;
            }
            throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, String.format("\u83b7\u53d6\u6570\u636e\u96c6[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSDEDataSet.getName(), ex.getMessage()), ex);
        }
    }

    protected Page onFetchDataSet(IDataEntityRuntime iDataEntityRuntime, IPSDEDataSet iPSDEDataSet, ISearchContext iSearchContext, String[] outputFields, Map<String, Object> extParamMap) throws Throwable {
        throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, "\u6ca1\u6709\u5b9e\u73b0", 20);
    }

    @Override
    public Page fetch(String strTableName, ISearchContext iSearchContext, String[] outputFields, Map<String, Object> extParamMap) throws Throwable {
        try {
            return this.onFetch(strTableName, iSearchContext, outputFields, extParamMap);
        }
        catch (Throwable ex) {
            if (ex instanceof ISystemRuntimeException) {
                throw ex;
            }
            throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, String.format("\u83b7\u53d6\u6570\u636e\u96c6[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", strTableName, ex.getMessage()), ex);
        }
    }

    protected Page onFetch(String strTableName, ISearchContext iSearchContext, String[] outputFields, Map<String, Object> extParamMap) throws Throwable {
        throw new SysBDSchemeRuntimeException((ISysBDSchemeRuntime)this, "\u6ca1\u6709\u5b9e\u73b0", 20);
    }

    @Override
    public Object getDataSourceTag() {
        return this.objDataSourceTag;
    }

    @Override
    public void setDataSourceTag(Object objDataSourceTag) {
        this.objDataSourceTag = objDataSourceTag;
    }

    @Override
    public void setDataSourceProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @Override
    public Object getDataSourceProperty(String strKey, Object objDefault) {
        if (this.properties != null && this.properties.containsKey(strKey)) {
            return this.properties.get(strKey);
        }
        return objDefault;
    }

    @Override
    public void shutdown() throws Exception {
        this.onShutdown();
    }

    protected void onShutdown() throws Exception {
    }
}

