package net.ibizsys.central.util.groovy;

import net.ibizsys.central.database.ISysDBSchemeRuntime;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.eai.ISysEAIAgentRuntime;
import net.ibizsys.central.service.ISubSysServiceAPIRuntime;
import net.ibizsys.central.service.client.IWebClient;
import net.ibizsys.central.sysutil.ISysUtilRuntime;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.central.util.ISearchContextDTO;
import net.ibizsys.runtime.codelist.ICodeListRuntime;
import net.ibizsys.runtime.res.ISysSequenceRuntime;
import net.ibizsys.runtime.res.ISysTranslatorRuntime;
import net.ibizsys.runtime.res.ISysDataSyncAgentRuntime;
import net.ibizsys.runtime.res.ISysLogicRuntime;
import net.ibizsys.runtime.security.IUserContext;
import net.ibizsys.runtime.util.IAppContext;
import net.ibizsys.runtime.util.IEntity;

public interface ISystemRTGroovyContext extends net.ibizsys.runtime.util.groovy.ISystemRTGroovyContext{

	final static String MODELTYPE_SYS = "sys";
	
	final static String MODELTYPE_UTIL = "util";
	
	final static String MODELTYPE_WEBCLIENT = "webclient";
	
	final static String MODELTYPE_DATAENTITY = "dataentity";
	
	final static String MODELTYPE_SUBSYSAPI = "subsysapi";
	
	final static String MODELTYPE_API = "api";
	
	final static String MODELTYPE_LOGIC = "logic";
	
	final static String MODELTYPE_PLUGIN = "plugin";
	
	final static String MODELTYPE_CODELIST = "codelist";
	
	final static String MODELTYPE_SEQUENCE = "sequence";
	
	final static String MODELTYPE_TRANSLATOR = "translator";
	
	final static String MODELTYPE_EAIAGENT = "eaiagent";
	
	final static String MODELTYPE_DATASYNCAGENT = "datasyncagent";
	
	
	final static String MODELTYPE_DBSCHEMA = "dbschema";
	
	final static String MODELTYPE_DBSCHEME = "dbscheme";
	
	
	
	/**
	 * 运行参数
	 */
	final static String MODELTYPE_PARAM = "param";
	
	/**
	 * 运行配置
	 */
	final static String MODELTYPE_CONFIG = "config";
	
	
	/**
	 * 获取默认Web客户端对象
	 * @return
	 */
	IWebClient webclient();
	
	
	/**
	 * 获取外部服务接口客户端对象
	 * @param tag
	 * @return
	 */
	IWebClient webclient(String tag);
	
	
	
	
	/**
	 * 获取系统功能组件运行时对象
	 * @param tag
	 * @return
	 */
	ISysUtilRuntime util(String tag);
	
	
	
	/**
	 * 获取实体运行时对象
	 * @param tag
	 * @return
	 */
	IDataEntityRuntime dataentity(String tag);
	
	
	
	
	/**
	 * 获取外部服务接口
	 * @param tag
	 * @return
	 */
	ISubSysServiceAPIRuntime subsysapi(String tag);
	
	
	/**
	 * 获取常规数据对象
	 * @return
	 */
	IEntity entity();
	
	
	/**
	 * 获取实体数据对象
	 * @param tag
	 * @return
	 */
	IEntityDTO entity(String tag);
	
	
	/**
	 * 获取实体查询过滤对象
	 * @param tag
	 * @return
	 */
	ISearchContextDTO filter(String tag);
	
	
	
	/**
	 * 获取系统预置逻辑运行时对象
	 * @param tag
	 * @return
	 */
	ISysLogicRuntime logic(String tag);
	
	
	/**
	 * 获取系统代码表运行时对象
	 * @param tag
	 * @return
	 */
	ICodeListRuntime codelist(String tag);
	
	
	
	/**
	 * 获取系统值序列运行时对象
	 * @param tag
	 * @return
	 */
	ISysSequenceRuntime sequence(String tag);
	
	
	/**
	 * 获取系统值转换器运行时对象
	 * @param tag
	 * @return
	 */
	ISysTranslatorRuntime translator(String tag);
	
	
	
	/**
	 * 获取系统数据同步代理运行时对象
	 * @param tag
	 * @return
	 */
	ISysDataSyncAgentRuntime datasyncagent(String tag);
	
	
	/**
	 * 获取系统应用集成代理运行时对象
	 * @param tag
	 * @return
	 */
	ISysEAIAgentRuntime eaiagent(String tag);
	
	
	
	
	/**
	 * 获取系统数据库体系
	 * @param tag
	 * @return
	 */
	ISysDBSchemeRuntime dbschema(String tag);
	
	
	/**
	 * 获取系统数据库体系
	 * @param tag
	 * @return
	 */
	ISysDBSchemeRuntime dbscheme(String tag);
	
	
	
	/**
	 * 获取系统插件对象
	 * @param tag
	 * @return
	 */
	Object plugin(String tag);
	
	

	/**
	 * 获取系统配置
	 * @param strKey
	 * @param defValue
	 * @return
	 */
	Object config(String strKey, Object defValue);
	
	
	/**
	 * 获取系统参数配置
	 * @param strKey
	 * @param defValue
	 * @return
	 */
	Object param(String strKey, Object defValue);
	
	
	/**
	 * 获取系统配置
	 * @param strKey
	 * @return
	 */
	Object config(String strKey);
	
	
	/**
	 * 获取系统参数配置
	 * @param strKey
	 * @return
	 */
	Object param(String strKey);
	
	
	
	/**
	 * 获取当前用户上下文
	 * @return
	 */
	IUserContext user();
	
	
	
	/**
	 * 获取导航上下文对象
	 * @return
	 */
	IAppContext context();
	
	
//	/**
//	 * 输出系统运行调试信息
//	 * @param sender 发送者
//	 * @param strInfo 一般信息
//	 */
//	void debug(Object... infos);
	
	/**
	 * 输出系统运行一般信息
	 * @param info 一般信息
	 */
	void info(String info);
	
	
	
	/**
	 * 输出系统运行警告信息
	 * @param infos 警告信息
	 */
	void warn(String info);
	
	
	
	/**
	 * 输出系统运行错误信息
	 * @param infos 错误信息
	 */
	void error(String info);
}
