package net.ibizsys.central.res;

import net.ibizsys.central.ISystemRuntimeContext;
import net.ibizsys.central.SystemModelRuntimeBase;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.res.IPSSysResource;


public class SysResourceRuntimeBase extends SystemModelRuntimeBase implements ISysResourceRuntime {

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(SysResourceRuntimeBase.class);
	private IPSSysResource iPSSysResource = null;

	@Override
	public void init(ISystemRuntimeContext iSystemRuntimeContext, IPSSysResource iPSSysResource) throws Exception {
		this.setSystemRuntimeBaseContext(iSystemRuntimeContext);
		this.iPSSysResource = iPSSysResource;

		this.onInit();
	}

	@Override
	public IPSSysResource getPSSysResource() {
		return this.iPSSysResource;
	}

	@Override
	public String getId() {
		return getPSSysResource().getDynaModelFilePath();
	}

	@Override
	public String getName() {
		return getPSSysResource().getName();
	}

	@Override
	public IPSModelObject getPSModelObject() {
		return this.getPSSysResource();
	}

	
	@Override
	public String getContent() {
		return this.getPSSysResource().getContent();
	}

}
