package net.ibizsys.central.res;

import java.io.File;

import net.ibizsys.runtime.SystemRuntimeException;

public abstract class SysFileResourceRuntimeBase extends SysResourceRuntimeBase implements ISysFileResourceRuntime {

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(SysFileResourceRuntimeBase.class);
	
	private File file = null;
	
	
	@Override
	protected void onInit() throws Exception {
		super.onInit();
		
		if(this.getFile(true) == null) {
			this.prepareFile();
			if(this.getFile(true) == null) {
				throw new Exception("文件对象无效");
			}
		}
	}
	
	/**
	 * 准备文件对象
	 * @throws Exception
	 */
	protected void prepareFile() throws Exception {
		
	}
	
	@Override
	public File getFile() {
		return this.getFile(false);
	}

	public File getFile(boolean tryMode) {
		if(this.file != null || tryMode) {
			return this.file;
		}
		throw new SystemRuntimeException(this.getSystemRuntime(), this, String.format("文件对象无效"));
	}
	
	protected void setFile(File file) {
		this.file = file;
	}
	
}
