package net.ibizsys.central.dataentity.logic;

import org.springframework.util.StringUtils;

import net.ibizsys.model.dataentity.logic.IPSDELogicNode;
import net.ibizsys.model.dataentity.logic.IPSDELogicNodeParam;
import net.ibizsys.model.res.IPSSysTranslator;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.res.ISysTranslatorRuntime;

/**
 * 实体逻辑准备参数节点运行时对象
 * @author lionlau
 *
 */
public class DELogicPrepareParamNodeRuntime extends DELogicNodeRuntimeBase{

	@Override
	protected void onExecute(IDELogicRuntimeContext iDELogicRuntimeContext, IDELogicSession iDELogicSession, IPSDELogicNode iPSDELogicNode) throws Throwable {
		java.util.List<IPSDELogicNodeParam> psDELogicNodeParamList = iPSDELogicNode.getPSDELogicNodeParams();
		if(psDELogicNodeParamList == null || psDELogicNodeParamList.size() == 0) {
			//throw new DataEntityRuntimeException(iDELogicRuntimeContext.getDataEntityRuntime(), iDELogicRuntimeContext.getDELogicRuntime(), String.format(arg0, arg1)., strInfo);
			return;
		}
		
		for(IPSDELogicNodeParam iPSDELogicNodeParam : psDELogicNodeParamList) {
			String strParamAction = iPSDELogicNodeParam.getParamAction();
			if(DELogicNodeParamTypes.SETPARAMVALUE.equals(strParamAction)) {
//				IEntity dstEntity = iDELogicSession.getParam(iPSDELogicNodeParam.getDstPSDELogicParamMust().getCodeName());
//				if(StringUtils.isEmpty(iPSDELogicNodeParam.getDstFieldName())) {
//					throw new DataEntityRuntimeException(iDELogicRuntimeContext.getDataEntityRuntime(), iDELogicRuntimeContext.getDELogicRuntime(), String.format("处理节点参数[%1$s]未指定目标属性名称", iPSDELogicNodeParam.getName()));
//				}
//				this.onSetParamValue(iDELogicRuntimeContext, iDELogicSession, dstEntity, iPSDELogicNodeParam);
				onSetParamValue(iDELogicRuntimeContext, iDELogicSession, iPSDELogicNodeParam);
				continue;
			}
			
			if(DELogicNodeParamTypes.RESETPARAM.equals(strParamAction)) {
				//IEntity dstEntity = iDELogicSession.getParam(iPSDELogicNodeParam.getDstPSDELogicParamMust().getCodeName());
				onResetParam(iDELogicRuntimeContext, iDELogicSession, iPSDELogicNodeParam);
				continue;
			}
			
			if(DELogicNodeParamTypes.COPYPARAM.equals(strParamAction)) {
				//IEntity srcEntity = iDELogicSession.getParam(iPSDELogicNodeParam.getSrcPSDELogicParamMust().getCodeName());
				//IEntity dstEntity = iDELogicSession.getParam(iPSDELogicNodeParam.getDstPSDELogicParamMust().getCodeName());
				
				//onCopyParam(iDELogicRuntimeContext, iDELogicSession, srcEntity, dstEntity);
				onCopyParam(iDELogicRuntimeContext, iDELogicSession, iPSDELogicNodeParam);
				continue;
			}
			
			if(DELogicNodeParamTypes.BINDPARAM.equals(strParamAction)) {
				onBindParam(iDELogicRuntimeContext, iDELogicSession, iPSDELogicNodeParam);
				continue;
			}
			
			if(DELogicNodeParamTypes.RENEWPARAM.equals(strParamAction)) {
				onRenewParam(iDELogicRuntimeContext, iDELogicSession, iPSDELogicNodeParam);
				continue;
			}
			
			if(DELogicNodeParamTypes.APPENDPARAM.equals(strParamAction)) {
				onAppendParam(iDELogicRuntimeContext, iDELogicSession, iPSDELogicNodeParam);
				continue;
			}
			
			if(DELogicNodeParamTypes.SORTPARAM.equals(strParamAction)) {
				onSortParam(iDELogicRuntimeContext, iDELogicSession, iPSDELogicNodeParam);
				continue;
			}
		}
	}
	

	
//	protected void onCopyParam(IDELogicRuntimeContext iDELogicRuntimeContext, IDELogicSession iDELogicSession, IEntity srcEntity, IEntity dstEntity) throws Throwable {
//		srcEntity.copyTo(dstEntity);
//	}

//	protected void onResetParam(IDELogicRuntimeContext iDELogicRuntimeContext, IDELogicSession iDELogicSession, IEntity dstEntity) throws Throwable {
//		dstEntity.resetAll();
//	}
	
//	protected void onSetParamValue(IDELogicRuntimeContext iDELogicRuntimeContext, IDELogicSession iDELogicSession, IEntity dstEntity, IPSDELogicNodeParam iPSDELogicNodeParam) throws Throwable {
//		if(!StringUtils.hasLength(iPSDELogicNodeParam.getDstFieldName())) {
//			throw new DataEntityRuntimeException(iDELogicRuntimeContext.getDataEntityRuntime(), iDELogicRuntimeContext.getDELogicRuntime(), String.format("处理节点参数[%1$s]未指定设置目标属性", iPSDELogicNodeParam.getName()));
//		}
//		
//		
//		if(DELogicPrepareParamValueTypes.NONEVALUE.equals(iPSDELogicNodeParam.getSrcValueType())) {			
//			dstEntity.reset(iPSDELogicNodeParam.getDstFieldName().toLowerCase());
//			return ;
//		}
//		
//		Object objValue = this.calcDELogicNodeParamValue(iDELogicRuntimeContext, iDELogicSession, iPSDELogicNodeParam);
//		dstEntity.set(iPSDELogicNodeParam.getDstFieldName().toLowerCase(), objValue);
//		return ;
//	}
	
	protected void onCopyParam(IDELogicRuntimeContext iDELogicRuntimeContext, IDELogicSession iDELogicSession, IPSDELogicNodeParam iPSDELogicNodeParam) throws Throwable {
		IDELogicParamRuntime srcDELogicParamRuntime = iDELogicRuntimeContext.getDELogicRuntime().getDELogicParamRuntime(iPSDELogicNodeParam.getSrcPSDELogicParamMust().getCodeName(), false);
		IDELogicParamRuntime dstDELogicParamRuntime = iDELogicRuntimeContext.getDELogicRuntime().getDELogicParamRuntime(iPSDELogicNodeParam.getDstPSDELogicParamMust().getCodeName(), false);
		srcDELogicParamRuntime.copyTo(iDELogicSession, dstDELogicParamRuntime.getParamObject(iDELogicSession));
	}
	
	
	
	protected void onBindParam(IDELogicRuntimeContext iDELogicRuntimeContext, IDELogicSession iDELogicSession, IPSDELogicNodeParam iPSDELogicNodeParam) throws Throwable {
		IDELogicParamRuntime srcDELogicParamRuntime = iDELogicRuntimeContext.getDELogicRuntime().getDELogicParamRuntime(iPSDELogicNodeParam.getSrcPSDELogicParamMust().getCodeName(), false);
		IDELogicParamRuntime dstDELogicParamRuntime = iDELogicRuntimeContext.getDELogicRuntime().getDELogicParamRuntime(iPSDELogicNodeParam.getDstPSDELogicParamMust().getCodeName(), false);
		String strSrcFieldName = iPSDELogicNodeParam.getSrcFieldName();
		Object objValue = null;
		if(StringUtils.hasLength(strSrcFieldName)){
			objValue = srcDELogicParamRuntime.get(iDELogicSession, strSrcFieldName);
		}
		else {
			objValue = srcDELogicParamRuntime.getParamObject(iDELogicSession);
		}
		IPSSysTranslator iPSSysTranslator = iPSDELogicNodeParam.getPSSysTranslator();
		if(iPSSysTranslator!=null) {
			ISysTranslatorRuntime iSysTranslatorRuntime = iDELogicRuntimeContext.getSystemRuntime().getSysTranslatorRuntime(iPSSysTranslator);
			objValue = iSysTranslatorRuntime.translate(objValue, !iPSDELogicNodeParam.isOutTranslate(), null, null, null);
		}
		dstDELogicParamRuntime.bind(iDELogicSession, objValue);
	}
	
	
	protected void onRenewParam(IDELogicRuntimeContext iDELogicRuntimeContext, IDELogicSession iDELogicSession, IPSDELogicNodeParam iPSDELogicNodeParam) throws Throwable {
		IDELogicParamRuntime dstDELogicParamRuntime = iDELogicRuntimeContext.getDELogicRuntime().getDELogicParamRuntime(iPSDELogicNodeParam.getDstPSDELogicParamMust().getCodeName(), false);
		dstDELogicParamRuntime.renew(iDELogicSession);
	}
	
	protected void onResetParam(IDELogicRuntimeContext iDELogicRuntimeContext, IDELogicSession iDELogicSession, IPSDELogicNodeParam iPSDELogicNodeParam) throws Throwable {
		IDELogicParamRuntime dstDELogicParamRuntime = iDELogicRuntimeContext.getDELogicRuntime().getDELogicParamRuntime(iPSDELogicNodeParam.getDstPSDELogicParamMust().getCodeName(), false);
		dstDELogicParamRuntime.resetAll(iDELogicSession);
	}
	
	
	protected void onSetParamValue(IDELogicRuntimeContext iDELogicRuntimeContext, IDELogicSession iDELogicSession, IPSDELogicNodeParam iPSDELogicNodeParam) throws Throwable {
		IDELogicParamRuntime dstDELogicParamRuntime = iDELogicRuntimeContext.getDELogicRuntime().getDELogicParamRuntime(iPSDELogicNodeParam.getDstPSDELogicParamMust().getCodeName(), false);
		
		if(!StringUtils.hasLength(iPSDELogicNodeParam.getDstFieldName())) {
			throw new DataEntityRuntimeException(iDELogicRuntimeContext.getDataEntityRuntime(), iDELogicRuntimeContext.getDELogicRuntime(), String.format("处理节点参数[%1$s]未指定设置目标属性", iPSDELogicNodeParam.getName()));
		}
		
		
		if(DELogicPrepareParamValueTypes.NONEVALUE.equals(iPSDELogicNodeParam.getSrcValueType())) {			
		//	dstEntity.reset(iPSDELogicNodeParam.getDstFieldName().toLowerCase());
			dstDELogicParamRuntime.reset(iDELogicSession, iPSDELogicNodeParam.getDstFieldName().toLowerCase());
			return ;
		}
		
		Object objValue = this.calcDELogicNodeParamValue(iDELogicRuntimeContext, iDELogicSession, iPSDELogicNodeParam);
		IPSSysTranslator iPSSysTranslator = iPSDELogicNodeParam.getPSSysTranslator();
		if(iPSSysTranslator!=null) {
			ISysTranslatorRuntime iSysTranslatorRuntime = iDELogicRuntimeContext.getSystemRuntime().getSysTranslatorRuntime(iPSSysTranslator);
			objValue = iSysTranslatorRuntime.translate(objValue, !iPSDELogicNodeParam.isOutTranslate(), null, null, null);
		}
		dstDELogicParamRuntime.set(iDELogicSession, iPSDELogicNodeParam.getDstFieldName().toLowerCase(), objValue);
		return ;
	}
	
	protected void onAppendParam(IDELogicRuntimeContext iDELogicRuntimeContext, IDELogicSession iDELogicSession, IPSDELogicNodeParam iPSDELogicNodeParam) throws Throwable {
		IDELogicParamRuntime dstDELogicParamRuntime = iDELogicRuntimeContext.getDELogicRuntime().getDELogicParamRuntime(iPSDELogicNodeParam.getDstPSDELogicParamMust().getCodeName(), false);
		IDELogicParamRuntime srcDELogicParamRuntime = iDELogicRuntimeContext.getDELogicRuntime().getDELogicParamRuntime(iPSDELogicNodeParam.getSrcPSDELogicParamMust().getCodeName(), false);
		String strSrcFieldName = iPSDELogicNodeParam.getSrcFieldName();
		Object objValue = null;
		if(StringUtils.hasLength(strSrcFieldName)){
			objValue =  srcDELogicParamRuntime.get(iDELogicSession, strSrcFieldName);
		}
		else {
			objValue = srcDELogicParamRuntime.getParamObject(iDELogicSession);
		}
		IPSSysTranslator iPSSysTranslator = iPSDELogicNodeParam.getPSSysTranslator();
		if(iPSSysTranslator!=null) {
			ISysTranslatorRuntime iSysTranslatorRuntime = iDELogicRuntimeContext.getSystemRuntime().getSysTranslatorRuntime(iPSSysTranslator);
			objValue = iSysTranslatorRuntime.translate(objValue, !iPSDELogicNodeParam.isOutTranslate(), null, null, null);
		}
		dstDELogicParamRuntime.append(iDELogicSession, iPSDELogicNodeParam.getDstIndex(), objValue, iPSDELogicNodeParam.getSrcIndex(), iPSDELogicNodeParam.getSrcSize());
	}
	
	protected void onSortParam(IDELogicRuntimeContext iDELogicRuntimeContext, IDELogicSession iDELogicSession, IPSDELogicNodeParam iPSDELogicNodeParam) throws Throwable {
		IDELogicParamRuntime dstDELogicParamRuntime = iDELogicRuntimeContext.getDELogicRuntime().getDELogicParamRuntime(iPSDELogicNodeParam.getDstPSDELogicParamMust().getCodeName(), false);
		String strDstFieldName = iPSDELogicNodeParam.getDstFieldName();
		if(!StringUtils.hasLength(iPSDELogicNodeParam.getDstFieldName())) {
			throw new DataEntityRuntimeException(iDELogicRuntimeContext.getDataEntityRuntime(), iDELogicRuntimeContext.getDELogicRuntime(), String.format("处理节点参数[%1$s]未指定设置排序属性", iPSDELogicNodeParam.getName()));
		}
		dstDELogicParamRuntime.sort(iDELogicSession, strDstFieldName, iPSDELogicNodeParam.getDstSortDir());
	}
}
