package net.ibizsys.central.dataentity;

import net.ibizsys.central.IDynaInstRuntime;
import net.ibizsys.central.ISystemRuntime;
import net.ibizsys.runtime.ISystemRuntimeBase;
import net.ibizsys.runtime.ModelRuntimeBase;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeBase;

/**
 * 实体模型运行时实现基类对象
 * @author lionlau
 *
 */
public abstract class DataEntityModelRuntimeBase extends ModelRuntimeBase implements IDataEntityModelRuntime{

	private IDataEntityRuntime iDataEntityRuntime = null;
	private IDynaInstDataEntityRuntime iDynaInstDataEntityRuntime = null;
	
	
	protected void setDataEntityRuntimeBase(IDataEntityRuntimeBase iDataEntityRuntimeBase) {
		if(iDataEntityRuntimeBase == null) {
			this.iDataEntityRuntime = null;
			this.iDynaInstDataEntityRuntime = null;
		}
		else {
			if(iDataEntityRuntimeBase instanceof IDataEntityRuntime) {
				this.iDataEntityRuntime = (IDataEntityRuntime)iDataEntityRuntimeBase;
			}
			else
				if(iDataEntityRuntimeBase instanceof IDynaInstDataEntityRuntime) {
					this.iDynaInstDataEntityRuntime = (IDynaInstDataEntityRuntime)iDataEntityRuntimeBase;
					this.iDataEntityRuntime = this.iDynaInstDataEntityRuntime.getDataEntityRuntime();
				}
		}
	}
	
	@Override
	public IDynaInstDataEntityRuntime getDynaInstDataEntityRuntime() {
		return this.iDynaInstDataEntityRuntime;
	}
	
	@Override
	public IDataEntityRuntime getDataEntityRuntime() {
		return this.iDataEntityRuntime;
	}
	
	
	public IDataEntityRuntimeBase getDataEntityRuntimeBase() {
		return (getDynaInstDataEntityRuntime()!=null)?getDynaInstDataEntityRuntime():getDataEntityRuntime();
	}
	
	
	
	@Override
	public IDynaInstRuntime getDynaInstRuntime() {
		if(getDynaInstDataEntityRuntime() == null) {
			return null;
		}
		return this.getDynaInstDataEntityRuntime().getDynaInstRuntime();
	}
	
	@Override
	public ISystemRuntime getSystemRuntime() {
		if(getDataEntityRuntime() == null) {
			return null;
		}
		return this.getDataEntityRuntime().getSystemRuntime();
	}
	
	
	public ISystemRuntimeBase getSystemRuntimeBase() {
		return (getDynaInstRuntime()!=null)?getDynaInstRuntime():getSystemRuntime();
	}
	
	
}
