/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.res;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.PSModelUtils;
import net.ibizsys.model.res.IPSSysSFPlugin;
import net.ibizsys.model.system.IPSSystemModule;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.ISystemEventListener;
import net.ibizsys.runtime.ISystemRuntimeContext;
import net.ibizsys.runtime.ModelException;
import net.ibizsys.runtime.SystemModelRuntimeBase;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.plugin.IPluginRuntimeInitable;
import net.ibizsys.runtime.res.ISysSFPluginRuntime;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.KeyValueUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class SysSFPluginRuntime
extends SystemModelRuntimeBase
implements ISysSFPluginRuntime {
    private static final Log log = LogFactory.getLog(SysSFPluginRuntime.class);
    private static final Map<String, GroovyClassLoader> groovyClassLoaderMap = new HashMap<String, GroovyClassLoader>();
    private static final Map<String, Map<String, Class<?>>> groovyRTClassMapMap = new HashMap();
    private static final Map<String, Map<String, String>> groovyRTCodeMapMap = new HashMap<String, Map<String, String>>();
    private static final Map<String, Map<String, String>> groovyHotCodeMapMap = new HashMap<String, Map<String, String>>();
    private Map<String, Class<?>> groovyRTClassMap = null;
    private Map<String, String> groovyRTCodeMap = null;
    private Map<String, String> groovyHotCodeMap = null;
    private static Random random = new Random();
    private ISystemRuntimeContext iSystemRuntimeContext = null;
    private IPSSysSFPlugin iPSSysSFPlugin = null;
    private Object runtimeObject = null;
    private String strRTObjectName = null;
    private boolean bRuntimePlugin = false;
    private Class<?> rtObjectClass = null;
    private boolean bGroovyRTObject = false;
    private String strRTObjectCode = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerHotCode(String strSystemId, String strPSSysSFPluginId, String strCode) {
        Map<String, String> groovyHotCodeMap = null;
        Map<String, Map<String, String>> map = groovyHotCodeMapMap;
        synchronized (map) {
            groovyHotCodeMap = groovyHotCodeMapMap.get(strSystemId);
            if (groovyHotCodeMap == null) {
                groovyHotCodeMap = new ConcurrentHashMap<String, String>();
                groovyHotCodeMapMap.put(strSystemId, groovyHotCodeMap);
            }
        }
        groovyHotCodeMap.put(strPSSysSFPluginId, strCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHotCode(String strSystemId, String strPSSysSFPluginId) {
        Map<String, String> groovyHotCodeMap = null;
        Map<String, Map<String, String>> map = groovyHotCodeMapMap;
        synchronized (map) {
            groovyHotCodeMap = groovyHotCodeMapMap.get(strSystemId);
            if (groovyHotCodeMap == null) {
                groovyHotCodeMap = new ConcurrentHashMap<String, String>();
                groovyHotCodeMapMap.put(strSystemId, groovyHotCodeMap);
            }
        }
        return groovyHotCodeMap.get(strPSSysSFPluginId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareSystemParams(String strSystemId) {
        Map<String, Map<String, Object>> map = groovyRTClassMapMap;
        synchronized (map) {
            this.groovyRTClassMap = groovyRTClassMapMap.get(strSystemId);
            if (this.groovyRTClassMap == null) {
                this.groovyRTClassMap = new ConcurrentHashMap();
                groovyRTClassMapMap.put(strSystemId, this.groovyRTClassMap);
            }
        }
        map = groovyRTCodeMapMap;
        synchronized (map) {
            this.groovyRTCodeMap = groovyRTCodeMapMap.get(strSystemId);
            if (this.groovyRTCodeMap == null) {
                this.groovyRTCodeMap = new ConcurrentHashMap<String, String>();
                groovyRTCodeMapMap.put(strSystemId, this.groovyRTCodeMap);
            }
        }
        map = groovyHotCodeMapMap;
        synchronized (map) {
            this.groovyHotCodeMap = groovyHotCodeMapMap.get(strSystemId);
            if (this.groovyHotCodeMap == null) {
                this.groovyHotCodeMap = new ConcurrentHashMap<String, String>();
                groovyHotCodeMapMap.put(strSystemId, this.groovyHotCodeMap);
            }
        }
    }

    @Override
    public void init(ISystemRuntimeContext iSystemRuntimeContext, IPSSysSFPlugin iPSSysSFPlugin) throws Exception {
        block36: {
            Assert.notNull((Object)iSystemRuntimeContext, (String)"\u4f20\u5165\u7cfb\u7edf\u8fd0\u884c\u65f6\u4e0a\u4e0b\u6587\u65e0\u6548");
            Assert.notNull((Object)iPSSysSFPlugin, (String)"\u4f20\u5165\u7cfb\u7edf\u540e\u53f0\u63d2\u4ef6\u65e0\u6548");
            this.iSystemRuntimeContext = iSystemRuntimeContext;
            this.setSystemRuntimeBase(this.getSystemRuntimeContext().getSystemRuntime());
            this.prepareSystemParams(this.getSystemRuntimeContext().getSystemRuntime().getDeploySystemId());
            this.iPSSysSFPlugin = iPSSysSFPlugin;
            this.setRuntimePlugin(this.getPSSysSFPlugin().isRuntimeObject());
            this.setRTObjectName(this.getPSSysSFPlugin().getRTObjectName());
            this.setConfigFolder("syssfplugin." + PSModelUtils.calcUniqueTag((IPSSystemModule)this.iPSSysSFPlugin.getPSSystemModule(), (String)this.iPSSysSFPlugin.getPluginCode()));
            this.onInit();
            if (this.isRuntimePlugin()) {
                if (!StringUtils.hasLength((String)this.getRTObjectName())) {
                    throw new ModelException((IPSModelObject)this.getPSSysSFPlugin(), String.format("\u7cfb\u7edf\u540e\u53f0\u63d2\u4ef6[%1$s]\u8bbe\u7f6e\u4e3a\u8fd0\u884c\u65f6\u7ec4\u4ef6\u4f46\u672a\u6307\u5b9a\u7ec4\u4ef6\u540d\u79f0", this.getName()));
                }
                try {
                    if (this.getRTObjectName().indexOf("GROOVY") == 0) {
                        this.setGroovyRTObject(true);
                        if (this.getRTObjectName().length() > "GROOVY".length() + 1) {
                            this.setRTObjectName(this.getRTObjectName().substring("GROOVY".length() + 1));
                        } else {
                            this.setRTObjectName(null);
                        }
                    }
                    String strTemplCode = this.getRTObjectCode();
                    if (!this.isGroovyRTObject()) {
                        try {
                            this.rtObjectClass = Class.forName(this.getRTObjectName());
                            if (StringUtils.hasLength((String)strTemplCode)) {
                                String strCodeTag = null;
                                if (StringUtils.hasLength((String)this.rtObjectClass.getCanonicalName())) {
                                    strCodeTag = this.groovyRTCodeMap.get(this.rtObjectClass.getCanonicalName());
                                }
                                if (!StringUtils.hasLength(strCodeTag)) {
                                    log.warn((Object)String.format("\u7cfb\u7edf\u540e\u53f0\u63d2\u4ef6[%1$s]\u4f7f\u7528\u5185\u7f6e\u7ec4\u4ef6[%2$s]\uff0c\u5ffd\u7565\u52a8\u6001\u4ee3\u7801", this.getName(), this.getRTObjectName()));
                                } else {
                                    String strTag = KeyValueUtils.genUniqueId(strTemplCode);
                                    if (!strCodeTag.equals(strTag)) {
                                        log.warn((Object)String.format("\u7cfb\u7edf\u540e\u53f0\u63d2\u4ef6[%1$s]\u7ec4\u4ef6[%2$s]\u4ee3\u7801\u53d8\u5316\uff0c\u91cd\u65b0\u7f16\u8bd1", this.getName(), this.getRTObjectName()));
                                        this.rtObjectClass = null;
                                    }
                                }
                            }
                        }
                        catch (Exception ex) {
                            if (!StringUtils.hasLength((String)strTemplCode)) {
                                throw ex;
                            }
                            log.warn((Object)String.format("\u7cfb\u7edf\u540e\u53f0\u63d2\u4ef6[%1$s]\u4f7f\u7528\u52a8\u6001\u4ee3\u7801\u6784\u5efa\u7ec4\u4ef6[%2$s]", this.getName(), this.getRTObjectName()));
                        }
                    }
                    if (this.rtObjectClass != null) break block36;
                    if (!StringUtils.hasLength((String)strTemplCode)) {
                        throw new ModelException((IPSModelObject)this.getPSSysSFPlugin(), String.format("\u7cfb\u7edf\u540e\u53f0\u63d2\u4ef6[%1$s]\u672a\u6307\u5b9aGroovy\u4ee3\u7801", this.getName()));
                    }
                    String strTag = KeyValueUtils.genUniqueId(strTemplCode);
                    this.rtObjectClass = this.groovyRTClassMap.get(strTag);
                    if (!this.getPSSysSFPlugin().isLazyMode()) {
                        if (this.rtObjectClass == null) {
                            try {
                                if (strTemplCode.indexOf("package ") == -1) {
                                    String strAutoPackage = String.format("package net.ibizsys.runtime.plugin.groovy.a%1$s\r\n", random.nextInt(99999999));
                                    strTemplCode = strAutoPackage + strTemplCode;
                                }
                                try (GroovyClassLoader groovyClassLoader = new GroovyClassLoader();){
                                    this.rtObjectClass = groovyClassLoader.parseClass(strTemplCode);
                                }
                                this.groovyRTClassMap.put(strTag, this.rtObjectClass);
                                if (StringUtils.hasLength((String)this.rtObjectClass.getCanonicalName())) {
                                    this.groovyRTCodeMap.put(this.rtObjectClass.getCanonicalName(), strTag);
                                }
                            }
                            catch (Exception ex) {
                                log.error((Object)ex);
                                throw new ModelException((IPSModelObject)this.getPSSysSFPlugin(), String.format("\u7cfb\u7edf\u540e\u53f0\u63d2\u4ef6[%1$s]\u6307\u5b9a\u7ec4\u4ef6[%2$s]\u7f16\u8bd1\u53d1\u751f\u5f02\u5e38\uff0c%3$s", this.getName(), this.getRTObjectName(), ex.getMessage()));
                            }
                        }
                        this.setRTObjectCode(strTemplCode);
                        this.setGroovyRTObject(true);
                        break block36;
                    }
                    this.setGroovyRTObject(true);
                }
                catch (Exception ex) {
                    if (ex instanceof ModelException) {
                        throw ex;
                    }
                    throw new ModelException((IPSModelObject)this.getPSSysSFPlugin(), String.format("\u7cfb\u7edf\u540e\u53f0\u63d2\u4ef6[%1$s]\u6307\u5b9a\u7ec4\u4ef6\u65e0\u6548[%2$s]", this.getName(), this.getRTObjectName()));
                }
            }
        }
    }

    protected ISystemRuntimeContext getSystemRuntimeContext() {
        return this.iSystemRuntimeContext;
    }

    @Override
    public IPSSysSFPlugin getPSSysSFPlugin() {
        return this.iPSSysSFPlugin;
    }

    @Override
    public IPSModelObject getPSModelObject() {
        return this.getPSSysSFPlugin();
    }

    @Override
    public boolean isRuntimePlugin() {
        return this.bRuntimePlugin;
    }

    protected void setRuntimePlugin(boolean bRuntimePlugin) {
        this.bRuntimePlugin = bRuntimePlugin;
    }

    @Override
    public String getRTObjectName() {
        return this.strRTObjectName;
    }

    protected void setRTObjectName(String strRTObjectName) {
        this.strRTObjectName = strRTObjectName;
    }

    @Override
    public <T> T getRuntimeObject(Class<T> cls, boolean bNewInstance) throws Exception {
        if (!this.isRuntimePlugin()) {
            throw new SystemRuntimeException(this.getSystemRuntime(), String.format("\u7cfb\u7edf\u540e\u53f0\u63d2\u4ef6[%1$s]\u4e0d\u63d0\u4f9b\u8fd0\u884c\u65f6\u7ec4\u4ef6", this.getName()));
        }
        Class<?> rtObjectClass = this.getRTObjectClass();
        if (!cls.isAssignableFrom(rtObjectClass)) {
            throw new SystemRuntimeException(this.getSystemRuntime(), String.format("\u7cfb\u7edf\u540e\u53f0\u63d2\u4ef6[%1$s]\u4e0d\u652f\u6301\u6307\u5b9a\u7c7b\u578b[%2$s]", this.getName(), cls.getCanonicalName()));
        }
        if (bNewInstance) {
            Object objItem = rtObjectClass.newInstance();
            if (objItem instanceof IPluginRuntimeInitable) {
                ((IPluginRuntimeInitable)objItem).init(this.getSystemRuntimeContext(), this.getPSSysSFPlugin());
            }
            this.autowareGroovyObject(objItem);
            return (T)objItem;
        }
        if (this.runtimeObject == null) {
            Object objItem = rtObjectClass.newInstance();
            if (objItem instanceof IPluginRuntimeInitable) {
                ((IPluginRuntimeInitable)objItem).init(this.getSystemRuntimeContext(), this.getPSSysSFPlugin());
            }
            this.autowareGroovyObject(objItem);
            this.runtimeObject = objItem;
        }
        return (T)this.runtimeObject;
    }

    @Override
    public Object getRuntimeObject(boolean bNewInstance) throws Exception {
        if (!this.isRuntimePlugin()) {
            throw new SystemRuntimeException(this.getSystemRuntime(), String.format("\u7cfb\u7edf\u540e\u53f0\u63d2\u4ef6[%1$s]\u4e0d\u63d0\u4f9b\u8fd0\u884c\u65f6\u7ec4\u4ef6", this.getName()));
        }
        Class<?> rtObjectClass = this.getRTObjectClass();
        if (bNewInstance) {
            Object objItem = rtObjectClass.newInstance();
            if (objItem instanceof IPluginRuntimeInitable) {
                ((IPluginRuntimeInitable)objItem).init(this.getSystemRuntimeContext(), this.getPSSysSFPlugin());
            }
            this.autowareGroovyObject(objItem);
            return objItem;
        }
        if (this.runtimeObject == null) {
            Object objItem = rtObjectClass.newInstance();
            if (objItem instanceof IPluginRuntimeInitable) {
                ((IPluginRuntimeInitable)objItem).init(this.getSystemRuntimeContext(), this.getPSSysSFPlugin());
            }
            this.autowareGroovyObject(objItem);
            this.runtimeObject = objItem;
        }
        return this.runtimeObject;
    }

    protected void autowareGroovyObject(Object object) throws Exception {
        if (object instanceof GroovyObject) {
            GroovyObject groovyObject = (GroovyObject)object;
            this.autowareGroovyObject(groovyObject);
        }
    }

    protected void autowareGroovyObject(final GroovyObject groovyObject) throws Exception {
        if (this.getSystemRuntime().isLoaded()) {
            this.doAutowareGroovyObject(groovyObject);
        } else {
            ISystemEventListener systemEventListener = new ISystemEventListener(){

                @Override
                public void receiveEvent(String event, Object[] params) {
                    SysSFPluginRuntime.this.getSystemRuntime().unregisterSystemEventListener(this);
                    try {
                        SysSFPluginRuntime.this.doAutowareGroovyObject(groovyObject);
                    }
                    catch (Exception ex) {
                        log.error((Object)ex);
                    }
                }

                @Override
                public Executor getExecutor() {
                    return null;
                }
            };
            this.getSystemRuntime().registerSystemEventListener(systemEventListener, new String[]{"LOAD"});
        }
    }

    protected void doAutowareGroovyObject(GroovyObject groovyObject) throws Exception {
        try {
            this.autowire(groovyObject);
        }
        catch (Throwable ex) {
            throw new Exception(String.format("\u88c5\u914dGroovy\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected void autowire(Object object) {
        Object[] fields = object.getClass().getDeclaredFields();
        if (ObjectUtils.isEmpty((Object[])fields)) {
            return;
        }
        try {
            for (Object field : fields) {
                Object value;
                Qualifier qualifier = ((Field)field).getAnnotation(Qualifier.class);
                if (qualifier == null || (value = this.calcModelRuntime(object, (Field)field, qualifier)) == null) continue;
                if (!((AccessibleObject)field).isAccessible()) {
                    ((Field)field).setAccessible(true);
                }
                if (value instanceof IModelRuntime) {
                    ((Field)field).set(object, value);
                    continue;
                }
                ((Field)field).set(object, this.getRealValue(((Field)field).getGenericType().getClass(), value));
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    protected Object calcModelRuntime(Object object, Field field, Qualifier qualifier) {
        String name;
        if (qualifier != null && StringUtils.hasLength((String)(name = qualifier.value()))) {
            String[] items = name.split("[:]");
            if (items.length == 1) {
                if (field.getGenericType().getClass().getName().equals("java.lang.Class")) {
                    return this.getSystemRuntime().getSystemRTGroovyContext().getModelRuntime(items[0], field.getName());
                }
                return this.getSystemRuntime().getSystemRTGroovyContext().getModelRuntime(field.getGenericType().getClass(), items[0]);
            }
            return this.getSystemRuntime().getSystemRTGroovyContext().getModelRuntime(items[0], items[1]);
        }
        return null;
    }

    @Override
    public String getId() {
        return this.getPSSysSFPlugin().getId();
    }

    @Override
    public String getName() {
        return this.getPSSysSFPlugin().getName();
    }

    @Override
    public boolean isGroovyRTObject() {
        return this.bGroovyRTObject;
    }

    protected void setGroovyRTObject(boolean bGroovyRTObject) {
        this.bGroovyRTObject = bGroovyRTObject;
    }

    @Override
    public String getRTObjectCode() {
        if (StringUtils.hasLength((String)this.strRTObjectCode)) {
            return this.strRTObjectCode;
        }
        String strHotCode = SysSFPluginRuntime.getHotCode(this.getSystemRuntime().getDeploySystemId(), this.getPSSysSFPlugin().getId());
        if (StringUtils.hasLength((String)strHotCode)) {
            return strHotCode;
        }
        return this.getPSSysSFPlugin().getTemplCode();
    }

    protected void setRTObjectCode(String strRTObjectCode) {
        this.strRTObjectCode = strRTObjectCode;
    }

    private Class<?> getRTObjectClass() throws Exception {
        if (this.rtObjectClass == null) {
            String strTemplCode = this.getRTObjectCode();
            String strTag = KeyValueUtils.genUniqueId(strTemplCode);
            this.rtObjectClass = this.groovyRTClassMap.get(strTag);
            if (this.rtObjectClass == null) {
                try {
                    if (strTemplCode.indexOf("package ") == -1) {
                        String strAutoPackage = String.format("package net.ibizsys.runtime.plugin.groovy.a%1$s\r\n", random.nextInt(99999999));
                        strTemplCode = strAutoPackage + strTemplCode;
                    }
                    try (GroovyClassLoader groovyClassLoader = new GroovyClassLoader();){
                        this.rtObjectClass = groovyClassLoader.parseClass(strTemplCode);
                    }
                    this.groovyRTClassMap.put(strTag, this.rtObjectClass);
                    if (StringUtils.hasLength((String)this.rtObjectClass.getCanonicalName())) {
                        this.groovyRTCodeMap.put(this.rtObjectClass.getCanonicalName(), strTag);
                    }
                }
                catch (Exception ex) {
                    log.error((Object)ex);
                    throw new ModelException((IPSModelObject)this.getPSSysSFPlugin(), String.format("\u7cfb\u7edf\u540e\u53f0\u63d2\u4ef6[%1$s]\u6307\u5b9a\u7ec4\u4ef6[%2$s]\u7f16\u8bd1\u53d1\u751f\u5f02\u5e38\uff0c%3$s", this.getName(), this.getRTObjectName(), ex.getMessage()));
                }
            }
            this.setRTObjectCode(strTemplCode);
            this.setGroovyRTObject(true);
        }
        return this.rtObjectClass;
    }

    public static Object createObject(String strObjectName) throws Exception {
        Assert.notNull((Object)strObjectName, (String)"\u672a\u4f20\u5165\u7ec4\u4ef6\u540d\u79f0");
        Class<?> cls = Class.forName(strObjectName);
        return cls.newInstance();
    }

    protected Object getRealValue(Class<?> type, Object objValue) throws Exception {
        if (type.equals(String.class)) {
            return objValue.toString();
        }
        if (type.equals(BigInteger.class)) {
            return DataTypeUtils.getBigIntegerValue(objValue, null);
        }
        if (type.equals(BigDecimal.class)) {
            return DataTypeUtils.getBigDecimalValue(objValue, null);
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return DataTypeUtils.getIntegerValue(objValue, null);
        }
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return DataTypeUtils.getLongValue(objValue, null);
        }
        if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            return DataTypeUtils.getDoubleValue(objValue, null);
        }
        if (type.isAssignableFrom(Timestamp.class)) {
            return DataTypeUtils.getDateTimeValue(objValue, null);
        }
        if (type.equals(Boolean.TYPE) || type.isAssignableFrom(Boolean.class)) {
            String strValue = objValue.toString();
            return strValue.equalsIgnoreCase("1") || strValue.equalsIgnoreCase("true");
        }
        return objValue;
    }
}

