/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.res;

import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntime;
import net.ibizsys.runtime.res.SysTranslatorRuntimeBase;
import net.ibizsys.runtime.util.IEntityBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class SysRSAEncryptTranslatorRuntime
extends SysTranslatorRuntimeBase {
    private static final Log log = LogFactory.getLog(SysRSAEncryptTranslatorRuntime.class);
    private PrivateKey privateKey = null;
    private PublicKey publicKey = null;

    @Override
    protected void onInit() throws Exception {
        super.onInit();
        if (this.getPublicKey(true) == null) {
            this.preparePublicKey();
            if (this.getPublicKey(true) == null) {
                throw new Exception("\u516c\u94a5\u65e0\u6548");
            }
        }
        if (this.getPrivateKey(true) == null) {
            this.preparePrivateKey();
            if (this.getPrivateKey(true) == null) {
                throw new Exception("\u79c1\u94a5\u65e0\u6548");
            }
        }
    }

    protected PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    protected PrivateKey getPrivateKey(boolean bTryMode) {
        if (this.privateKey != null || bTryMode) {
            return this.privateKey;
        }
        throw new SystemRuntimeException(this.getSystemRuntimeBase(), this, String.format("\u672a\u6307\u5b9a\u79c1\u94a5", new Object[0]));
    }

    protected void preparePrivateKey() throws Exception {
        String strPrivateKey = this.getSystemRuntime().getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".privatekey", null);
        if (!StringUtils.hasLength((String)strPrivateKey)) {
            throw new Exception("\u672a\u6307\u5b9a\u79c1\u94a5\u914d\u7f6e");
        }
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(strPrivateKey));
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey privateKey = keyFactory.generatePrivate(pkcs8EncodedKeySpec);
        this.setPrivateKey(privateKey);
    }

    protected void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    protected PublicKey getPublicKey() {
        return this.getPublicKey(false);
    }

    protected PublicKey getPublicKey(boolean bTryMode) {
        if (this.publicKey != null || bTryMode) {
            return this.publicKey;
        }
        throw new SystemRuntimeException(this.getSystemRuntimeBase(), this, String.format("\u672a\u6307\u5b9a\u516c\u94a5", new Object[0]));
    }

    protected void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    protected void preparePublicKey() throws Exception {
        String strPublicKey = this.getSystemRuntime().getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".publickey", null);
        if (!StringUtils.hasLength((String)strPublicKey)) {
            throw new Exception("\u672a\u6307\u5b9a\u516c\u94a5\u914d\u7f6e");
        }
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(strPublicKey));
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey privateKey = keyFactory.generatePublic(pkcs8EncodedKeySpec);
        this.setPublicKey(privateKey);
    }

    public static String encrypt(String plainText, PublicKey publicKey) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWITHSHA-512ANDMGF1PADDING");
        cipher.init(1, publicKey);
        byte[] cipherText = cipher.doFinal(plainText.getBytes());
        return Base64.getEncoder().encodeToString(cipherText);
    }

    public static String decrypt(String cipherText, PrivateKey privateKey) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWITHSHA-512ANDMGF1PADDING");
        cipher.init(2, privateKey);
        byte[] decryptedTextArray = cipher.doFinal(Base64.getDecoder().decode(cipherText));
        return new String(decryptedTextArray);
    }

    public static String encrypt(String plainText, PrivateKey privateKey) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWITHSHA-512ANDMGF1PADDING");
        cipher.init(1, privateKey);
        byte[] cipherText = cipher.doFinal(plainText.getBytes());
        return Base64.getEncoder().encodeToString(cipherText);
    }

    public static String decrypt(String cipherText, PublicKey publicKey) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWITHSHA-512ANDMGF1PADDING");
        cipher.init(2, publicKey);
        byte[] decryptedTextArray = cipher.doFinal(Base64.getDecoder().decode(cipherText));
        return new String(decryptedTextArray);
    }

    @Override
    public Object translate(Object objValue, boolean bIn, IEntityBase iEntityBase, IPSDEField iPSDEField, IDataEntityRuntime entityDataEntityRuntime) throws Throwable {
        if (bIn) {
            if (ObjectUtils.isEmpty((Object)objValue)) {
                return null;
            }
            String strContent = null;
            strContent = objValue instanceof String ? (String)objValue : objValue.toString();
            return SysRSAEncryptTranslatorRuntime.encrypt(strContent, this.getPrivateKey());
        }
        if (ObjectUtils.isEmpty((Object)objValue)) {
            return null;
        }
        String strContent = null;
        strContent = objValue instanceof String ? (String)objValue : objValue.toString();
        strContent = SysRSAEncryptTranslatorRuntime.decrypt(strContent, this.getPublicKey());
        if (iPSDEField != null) {
            return this.getSystemRuntime().convertValue(iPSDEField.getStdDataType(), strContent);
        }
        return strContent;
    }
}

