/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.res;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.runtime.dataentity.IDataEntityRuntime;
import net.ibizsys.runtime.res.SysTranslatorRuntimeBase;
import net.ibizsys.runtime.util.IEntityBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class SysEncryptTranslatorRuntime
extends SysTranslatorRuntimeBase {
    private static final Log log = LogFactory.getLog(SysEncryptTranslatorRuntime.class);
    final Base64.Decoder decoder = Base64.getDecoder();
    final Base64.Encoder encoder = Base64.getEncoder();
    private static final String ENCRYPTTYPE = "AES";
    private static final String ENCODING = "UTF-8";
    private String strKey = "__ibiz__encrpty__";
    private static SysEncryptTranslatorRuntime instance = new SysEncryptTranslatorRuntime();
    private static Cipher encryptCipher;
    private static Cipher decryptChipher;

    public SysEncryptTranslatorRuntime() {
        if (encryptCipher == null) {
            try {
                encryptCipher = Cipher.getInstance(ENCRYPTTYPE);
                decryptChipher = Cipher.getInstance(ENCRYPTTYPE);
                encryptCipher.init(1, SysEncryptTranslatorRuntime.generateAESKey(this.strKey, ENCODING));
                decryptChipher.init(2, SysEncryptTranslatorRuntime.generateAESKey(this.strKey, ENCODING));
            }
            catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
                log.error((Object)e);
                encryptCipher = null;
                throw new RuntimeException(e);
            }
            catch (InvalidKeyException e) {
                encryptCipher = null;
                log.error((Object)e);
                throw new RuntimeException(e);
            }
        }
    }

    public String aesEncrypt(String encryptString) {
        try {
            return new String(this.encoder.encode(encryptCipher.doFinal(encryptString.getBytes(ENCODING))), ENCODING);
        }
        catch (BadPaddingException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException(e);
        }
    }

    public String aesDecrypt(String decryptString) {
        try {
            return new String(decryptChipher.doFinal(this.decoder.decode(decryptString.getBytes())));
        }
        catch (BadPaddingException nsae) {
            throw new RuntimeException(nsae);
        }
        catch (IllegalBlockSizeException ike) {
            throw new RuntimeException(ike);
        }
    }

    public static SecretKeySpec generateAESKey(String key, String encoding) {
        try {
            byte[] finalKey = new byte[16];
            int i = 0;
            for (byte b : key.getBytes(encoding)) {
                int n = i++ % 16;
                finalKey[n] = (byte)(finalKey[n] ^ b);
            }
            return new SecretKeySpec(finalKey, ENCRYPTTYPE);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static SysEncryptTranslatorRuntime getInstance() {
        return instance;
    }

    @Override
    public Object translate(Object objValue, boolean bIn, IEntityBase iEntityBase, IPSDEField iPSDEField, IDataEntityRuntime entityDataEntityRuntime) throws Throwable {
        if (bIn) {
            if (ObjectUtils.isEmpty((Object)objValue)) {
                return null;
            }
            String strContent = null;
            strContent = objValue instanceof String ? (String)objValue : objValue.toString();
            return SysEncryptTranslatorRuntime.getInstance().aesEncrypt(strContent);
        }
        if (ObjectUtils.isEmpty((Object)objValue)) {
            return null;
        }
        String strContent = null;
        strContent = objValue instanceof String ? (String)objValue : objValue.toString();
        strContent = SysEncryptTranslatorRuntime.getInstance().aesDecrypt(strContent);
        if (iPSDEField != null) {
            return this.getSystemRuntime().convertValue(iPSDEField.getStdDataType(), strContent);
        }
        return strContent;
    }
}

