/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.dataentity.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.model.codelist.IPSCodeList;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.action.IPSDEAction;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.defield.IPSLinkDEField;
import net.ibizsys.model.dataentity.der.IPSDER1N;
import net.ibizsys.runtime.IDynaInstRuntime;
import net.ibizsys.runtime.ISystemRuntimeBase;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.codelist.ICodeListRuntime;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntime;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeBase;
import net.ibizsys.runtime.dataentity.util.DEUtilRuntimeBase;
import net.ibizsys.runtime.dataentity.util.IDEDataAuditUtilRuntime;
import net.ibizsys.runtime.util.ActionSession;
import net.ibizsys.runtime.util.ActionSessionManager;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.DateUtils;
import net.ibizsys.runtime.util.IEntityBase;
import net.ibizsys.runtime.util.JsonUtils;
import net.ibizsys.runtime.util.domain.DataAudit;
import net.ibizsys.runtime.util.domain.DataAuditDetail;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DEDataAuditUtilRuntime
extends DEUtilRuntimeBase
implements IDEDataAuditUtilRuntime {
    private static final Log log = LogFactory.getLog(DEDataAuditUtilRuntime.class);
    private static Map<String, String> IgnoreAuditDEFPredefinedTypeMap = new HashMap<String, String>();
    private static String[] DataAuditFields = new String[]{"auditinfo", "audittype", "ipaddress", "ipaddress", "objectid", "objecttype", "oppersonid", "oppersonname", "sessionid"};
    private IDataEntityRuntime dataAuditDataEntityRuntime = null;

    @Override
    protected void onInit() throws Exception {
        super.onInit();
    }

    @Override
    public void auditAction(Object curData, IEntityBase lastEntityBase, String strActionName, IPSDEAction iPSDEAction, IPSDataEntity iPSDataEntity, IDataEntityRuntime iDataEntityRuntime, IDynaInstRuntime iDynaInstRuntime, Object actionData) {
        List<DataAuditDetail> dataAudtiDetails;
        Assert.notNull((Object)iDataEntityRuntime, (String)"\u4f20\u5165\u5b9e\u4f53\u8fd0\u884c\u65f6\u5bf9\u8c61\u65e0\u6548");
        if (iDataEntityRuntime.getDataAuditMode() == 0) {
            log.warn((Object)String.format("\u5b9e\u4f53[%1$s]\u6ca1\u6709\u542f\u7528\u6570\u636e\u5ba1\u8ba1\u6a21\u5f0f\uff0c\u5ffd\u7565\u5ba1\u8ba1\u4f5c\u4e1a", iPSDataEntity.getName()));
            return;
        }
        ActionSession actionSession = ActionSessionManager.getCurrentSessionMust();
        Object objKey = null;
        IEntityBase curEntityBase = null;
        if (curData instanceof IEntityBase) {
            curEntityBase = (IEntityBase)curData;
            objKey = iDataEntityRuntime.getFieldValue(curEntityBase, iDataEntityRuntime.getKeyPSDEField());
        } else {
            objKey = curData;
        }
        String strAction = strActionName;
        String strActionLogicName = null;
        if (iPSDEAction != null) {
            strActionLogicName = iPSDEAction.getLogicName();
        }
        if (!StringUtils.hasLength(strActionLogicName)) {
            strActionLogicName = strAction;
        }
        DataAudit dataAudit = new DataAudit();
        dataAudit.setOpPersonId(actionSession.getUserContext().getUserid());
        dataAudit.setOpPersonName(actionSession.getUserContext().getUsername());
        dataAudit.setIPAddress(actionSession.getUserContext().getRemoteaddress());
        dataAudit.setObjectType(iDataEntityRuntime.getName());
        dataAudit.setObjectId(DataTypeUtils.getStringValue(objKey, null));
        dataAudit.setAuditType(strAction);
        String strInfo = String.format("%1$s %2$s %3$s", DateUtils.getCurTimeString(), actionSession.getUserContext().getUsername(), strActionLogicName);
        dataAudit.setDataAuditName(strInfo);
        if (iDataEntityRuntime.getDataAuditMode() == 2 && curEntityBase != null && (dataAudtiDetails = DEDataAuditUtilRuntime.getDataAuditDetails(curEntityBase, lastEntityBase, iPSDataEntity, iDataEntityRuntime, iDynaInstRuntime)) != null) {
            dataAudit.setDataauditdetails(dataAudtiDetails);
            ArrayNode arrayNode = JsonUtils.createArrayNode();
            for (DataAuditDetail dataAuditDetail : dataAudtiDetails) {
                try {
                    JsonNode jsonNode = JsonUtils.MAPPER.readTree(JsonUtils.MAPPER.writeValueAsString((Object)dataAuditDetail));
                    arrayNode.add(jsonNode);
                }
                catch (JsonProcessingException ex) {
                    throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, String.format("\u5b9e\u4f53[%1$s]\u5e8f\u5217\u5316\u5ba1\u8ba1\u8bb0\u5f55\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iDataEntityRuntime.getName(), ex.getMessage()), ex);
                }
                catch (IOException ex) {
                    throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, String.format("\u5b9e\u4f53[%1$s]\u5e8f\u5217\u5316\u5ba1\u8ba1\u8bb0\u5f55\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iDataEntityRuntime.getName(), ex.getMessage()), ex);
                }
            }
            dataAudit.setAuditInfo(arrayNode.toString());
        }
        this.logDataAudit(dataAudit, curEntityBase, lastEntityBase, iPSDataEntity, iDataEntityRuntime, iDynaInstRuntime);
    }

    protected void logDataAudit(DataAudit dataAudit, IEntityBase curEntityBase, IEntityBase lastEntityBase, IPSDataEntity iPSDataEntity, IDataEntityRuntime iDataEntityRuntime, IDynaInstRuntime iDynaInstRuntime) {
        IDataEntityRuntime dataAuditDataEntityRuntime = this.getDataAuditDataEntityRuntime();
        IEntityBase dataAuditEntity = dataAuditDataEntityRuntime.createEntity();
        IPSDEField iPSDEField = dataAuditDataEntityRuntime.getPSDEField("dataauditname");
        if (iPSDEField == null) {
            iPSDEField = dataAuditDataEntityRuntime.getMajorPSDEField();
        }
        if (iPSDEField != null) {
            dataAuditDataEntityRuntime.setFieldValue(dataAuditEntity, iPSDEField, dataAudit.getDataAuditName());
        }
        for (String strField : DataAuditFields) {
            iPSDEField = dataAuditDataEntityRuntime.getPSDEField(strField);
            if (iPSDEField == null) continue;
            dataAuditDataEntityRuntime.setFieldValue(dataAuditEntity, iPSDEField, dataAudit.get(strField));
        }
        try {
            dataAuditDataEntityRuntime.create(dataAuditEntity);
        }
        catch (Throwable ex) {
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, String.format("\u5b9e\u4f53[%1$s]\u65e5\u5fd7\u5ba1\u8ba1\u4fe1\u606f\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iDataEntityRuntime.getName(), ex.getMessage()), ex);
        }
    }

    public static List<DataAuditDetail> getDataAuditDetails(IEntityBase curEntityBase, IEntityBase lastEntityBase, IPSDataEntity iPSDataEntity, IDataEntityRuntime iDataEntityRuntime, IDynaInstRuntime iDynaInstRuntime) {
        List psDEFields;
        ArrayList<DataAuditDetail> list = new ArrayList<DataAuditDetail>();
        try {
            psDEFields = iDataEntityRuntime.getPSDataEntity().getAllPSDEFields();
        }
        catch (Exception ex) {
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, String.format("\u5b9e\u4f53[%1$s]\u83b7\u53d6\u5c5e\u6027\u96c6\u5408\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iDataEntityRuntime.getName(), ex.getMessage()), 21, (Throwable)ex);
        }
        for (IPSDEField iPSDEField : psDEFields) {
            IPSLinkDEField iPSLinkDEField;
            if (!iPSDEField.isEnableAudit() || iPSDEField.isKeyDEField() || iPSDEField.isUniTagField() || StringUtils.hasLength((String)iPSDEField.getPredefinedType()) && IgnoreAuditDEFPredefinedTypeMap.containsKey(iPSDEField.getPredefinedType()) || !iDataEntityRuntime.containsFieldValue(curEntityBase, iPSDEField) || lastEntityBase != null && !iDataEntityRuntime.containsFieldValue(lastEntityBase, iPSDEField)) continue;
            Object objNewValue = iDataEntityRuntime.getFieldValue(curEntityBase, iPSDEField);
            Object objOldValue = null;
            if (lastEntityBase != null) {
                objOldValue = iDataEntityRuntime.getFieldValue(lastEntityBase, iPSDEField);
            }
            if (objNewValue == null && objOldValue == null || objNewValue != null && objOldValue != null && iDataEntityRuntime.getSystemRuntime().compareValue(objNewValue, objOldValue, iPSDEField.getStdDataType()) == 0L) continue;
            DataAuditDetail dataAuditDetail = new DataAuditDetail();
            dataAuditDetail.setDataAuditDetailName(iPSDEField.getName());
            if (objNewValue != null) {
                if (objNewValue instanceof String) {
                    dataAuditDetail.setNewValue((String)objNewValue);
                } else {
                    dataAuditDetail.setNewValue(objNewValue.toString());
                }
            }
            if (objOldValue != null) {
                if (objOldValue instanceof String) {
                    dataAuditDetail.setOldValue((String)objOldValue);
                } else {
                    dataAuditDetail.setOldValue(objOldValue.toString());
                }
            }
            list.add(dataAuditDetail);
            IPSCodeList iPSCodeList = null;
            try {
                iPSCodeList = iPSDEField.getPSCodeList();
            }
            catch (Exception ex) {
                throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, String.format("\u5b9e\u4f53[%1$s]\u5c5e\u6027[%2$s]\u83b7\u53d6\u4ee3\u7801\u8868\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%3$s", iDataEntityRuntime.getName(), iPSDEField.getName(), ex.getMessage()), 21);
            }
            ICodeListRuntime iCodeListRuntime = null;
            if (iPSCodeList != null) {
                iCodeListRuntime = iDynaInstRuntime != null ? iDynaInstRuntime.getCodeListRuntime(iPSCodeList) : iDataEntityRuntime.getSystemRuntime().getCodeListRuntime(iPSCodeList);
                if (objNewValue != null) {
                    try {
                        dataAuditDetail.setNewText(iCodeListRuntime.getText(objNewValue));
                    }
                    catch (Throwable ex) {
                        throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, String.format("\u5b9e\u4f53[%1$s]\u5c5e\u6027[%2$s]\u8ba1\u7b97\u4ee3\u7801\u503c\u6587\u672c\u53d1\u751f\u5f02\u5e38\uff0c%3$s", iDataEntityRuntime.getName(), iPSDEField.getName(), ex.getMessage()), 21, ex);
                    }
                }
                if (objOldValue == null) continue;
                try {
                    dataAuditDetail.setOldText(iCodeListRuntime.getText(objOldValue));
                }
                catch (Throwable ex) {
                    dataAuditDetail.setOldText(String.valueOf(objOldValue));
                    log.error((Object)ex);
                }
                continue;
            }
            IPSLinkDEField pickupTextPSDEField = null;
            if ("PICKUP".equals(iPSDEField.getDataType())) {
                iPSLinkDEField = (IPSLinkDEField)iPSDEField;
                try {
                    pickupTextPSDEField = ((IPSDER1N)iPSLinkDEField.getPSDER()).getPSPickupTextDEField();
                }
                catch (Exception ex) {
                    throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, String.format("\u5b9e\u4f53[%1$s]\u5c5e\u6027[%2$s]\u83b7\u53d6\u5916\u952e\u503c\u6587\u672c\u5c5e\u6027\u53d1\u751f\u5f02\u5e38\uff0c%3$s", iDataEntityRuntime.getName(), iPSDEField.getName(), ex.getMessage()), 21, (Throwable)ex);
                }
            }
            if (iPSDEField.isInheritDEField()) {
                iPSLinkDEField = (IPSLinkDEField)iPSDEField;
                try {
                    IPSDEField relatedPSDEField = iPSLinkDEField.getRelatedPSDEField();
                    if ("PICKUP".equals(relatedPSDEField.getDataType()) && (pickupTextPSDEField = ((IPSDER1N)(iPSLinkDEField = (IPSLinkDEField)relatedPSDEField).getPSDER()).getPSPickupTextDEField()) != null) {
                        pickupTextPSDEField = iDataEntityRuntime.getPSDEField(pickupTextPSDEField.getName());
                    }
                }
                catch (Exception ex) {
                    throw new DataEntityRuntimeException((IDataEntityRuntimeBase)iDataEntityRuntime, String.format("\u5b9e\u4f53[%1$s]\u5c5e\u6027[%2$s]\u83b7\u53d6\u5916\u952e\u503c\u6587\u672c\u5c5e\u6027\u53d1\u751f\u5f02\u5e38\uff0c%3$s", iDataEntityRuntime.getName(), iPSDEField.getName(), ex.getMessage()), 21, (Throwable)ex);
                }
            }
            if (pickupTextPSDEField == null) continue;
            Object newText = iDataEntityRuntime.getFieldValue(curEntityBase, (IPSDEField)pickupTextPSDEField);
            Object oldText = null;
            if (lastEntityBase != null) {
                oldText = iDataEntityRuntime.getFieldValue(lastEntityBase, (IPSDEField)pickupTextPSDEField);
            }
            if (newText instanceof String) {
                dataAuditDetail.setNewText((String)newText);
            } else if (newText != null) {
                dataAuditDetail.setNewText(newText.toString());
            }
            if (oldText instanceof String) {
                dataAuditDetail.setOldText((String)oldText);
                continue;
            }
            if (oldText == null) continue;
            dataAuditDetail.setOldText(oldText.toString());
        }
        if (list.size() == 0) {
            return null;
        }
        return list;
    }

    protected IDataEntityRuntime getDataAuditDataEntityRuntime() {
        if (this.dataAuditDataEntityRuntime == null) {
            IPSDataEntity dataAuditPSDataEntity = this.getDataAuditPSDataEntity();
            Assert.notNull((Object)dataAuditPSDataEntity, (String)"\u6570\u636e\u5ba1\u8ba1\u8bb0\u5f55\u5b9e\u4f53\u65e0\u6548");
            try {
                this.dataAuditDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(dataAuditPSDataEntity.getDynaModelFilePath());
            }
            catch (Exception ex) {
                throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), String.format("\u83b7\u53d6\u6307\u5b9a\u5b9e\u4f53[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%2$s", dataAuditPSDataEntity.getName(), ex.getMessage()), ex);
            }
        }
        return this.dataAuditDataEntityRuntime;
    }

    protected IPSDataEntity getDataAuditPSDataEntity() {
        IPSDataEntity iPSDataEntity = null;
        if (this.getPSDEUtil() != null) {
            try {
                iPSDataEntity = this.getPSDEUtil().getUtilPSDE();
                if (iPSDataEntity == null) {
                    throw new Exception("\u6ca1\u6709\u6307\u5b9a");
                }
            }
            catch (Exception ex) {
                throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), String.format("\u5b9e\u4f53\u529f\u80fd[%1$s]\u83b7\u53d6\u5ba1\u8ba1\u8bb0\u5f55\u5b9e\u4f53\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), 21, (Throwable)ex);
            }
        }
        if (this.getPSSysUtil() != null) {
            try {
                iPSDataEntity = this.getPSSysUtil().getUtilPSDE();
                if (iPSDataEntity == null) {
                    throw new Exception("\u6ca1\u6709\u6307\u5b9a");
                }
            }
            catch (Exception ex) {
                throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), String.format("\u7cfb\u7edf\u529f\u80fd[%1$s]\u83b7\u53d6\u5ba1\u8ba1\u8bb0\u5f55\u5b9e\u4f53\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), 21, (Throwable)ex);
            }
        }
        return iPSDataEntity;
    }

    static {
        IgnoreAuditDEFPredefinedTypeMap.put("LOGICVALID", "");
        IgnoreAuditDEFPredefinedTypeMap.put("CREATEMAN", "");
        IgnoreAuditDEFPredefinedTypeMap.put("CREATEMANNAME", "");
        IgnoreAuditDEFPredefinedTypeMap.put("CREATEDATE", "");
        IgnoreAuditDEFPredefinedTypeMap.put("UPDATEMAN", "");
        IgnoreAuditDEFPredefinedTypeMap.put("UPDATEMANNAME", "");
        IgnoreAuditDEFPredefinedTypeMap.put("UPDATEDATE", "");
    }
}

