/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.dataentity.action;

import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.dataentity.action.IPSDEAction;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.runtime.ModelRuntimeBase;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntime;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeBase;
import net.ibizsys.runtime.dataentity.action.IDEScriptLogicRuntime;
import net.ibizsys.runtime.util.IEntityBase;
import net.ibizsys.runtime.util.script.IScriptEntity;
import net.ibizsys.runtime.util.script.ISystemRTScriptContext;
import net.ibizsys.runtime.util.script.ScriptUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public class DEScriptLogicRuntime
extends ModelRuntimeBase
implements IDEScriptLogicRuntime {
    private static final Log log = LogFactory.getLog(DEScriptLogicRuntime.class);
    private String strScript = null;
    private String strLogicMode = null;
    private IDataEntityRuntime iDataEntityRuntime = null;
    private ISystemRTScriptContext iSystemRTScriptContext = null;
    private Invocable invocable = null;
    private String strScriptEngine = null;

    @Override
    public void init(ISystemRTScriptContext iSystemRTScriptContext, IDataEntityRuntime iDataEntityRuntime, String strLogicMode, String strScript) throws Exception {
        this.iDataEntityRuntime = iDataEntityRuntime;
        this.strLogicMode = strLogicMode;
        this.strScript = strScript;
        this.strScriptEngine = iSystemRTScriptContext.getSystemRuntime().getScriptEngine(strScript);
        this.iSystemRTScriptContext = iSystemRTScriptContext;
        this.onInit();
    }

    @Override
    public IPSModelObject getPSModelObject() {
        return null;
    }

    public String getScriptEngine() {
        return this.strScriptEngine;
    }

    @Override
    protected void onInit() throws Exception {
        if (!StringUtils.hasLength((String)this.strScript)) {
            throw new DataEntityRuntimeException(this.iDataEntityRuntime, String.format("\u6ca1\u6709\u6307\u5b9a\u811a\u672c\u4ee3\u7801", new Object[0]));
        }
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName(this.getScriptEngine());
        if ("Groovy".equals(this.getScriptEngine())) {
            String strJSCode = "def main(";
            strJSCode = "DEFCHECK".equals(this.getLogicMode()) || "DEFDEFAULT".equals(this.getLogicMode()) ? strJSCode + "sys,entity,actionmode,field,action" : strJSCode + "sys,entity";
            strJSCode = strJSCode + "){";
            strJSCode = "DEFEXPRESSION".equals(this.getLogicMode()) ? strJSCode + this.strScript : strJSCode + this.strScript;
            strJSCode = strJSCode + "}";
            engine.eval(strJSCode);
        } else {
            String strJSCode = "function main(";
            strJSCode = "DEFCHECK".equals(this.getLogicMode()) || "DEFDEFAULT".equals(this.getLogicMode()) ? strJSCode + "sys,entity,actionmode,field,action" : strJSCode + "sys,entity";
            strJSCode = strJSCode + "){";
            strJSCode = "DEFEXPRESSION".equals(this.getLogicMode()) ? strJSCode + "return " + this.strScript + ";" : strJSCode + this.strScript;
            strJSCode = strJSCode + "}";
            engine.eval(strJSCode);
        }
        this.invocable = (Invocable)((Object)engine);
        super.onInit();
    }

    @Override
    public Object execute(Object[] args) {
        IEntityBase iEntityBase = null;
        if (args.length > 0 && args[0] instanceof IEntityBase) {
            iEntityBase = (IEntityBase)args[0];
        } else if (args.length > 1 && args[1] instanceof IEntityBase) {
            iEntityBase = (IEntityBase)args[1];
        }
        if (iEntityBase == null) {
            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.iDataEntityRuntime, String.format("\u4f20\u5165\u53c2\u6570\u65e0\u6548", new Object[0]), 5);
        }
        try {
            Object objRet;
            if ("Groovy".equals(this.getScriptEngine())) {
                Object objRet2;
                if ("DEFCHECK".equals(this.getLogicMode()) || "DEFDEFAULT".equals(this.getLogicMode())) {
                    String strActionMode = this.getArg(args, 1, String.class);
                    IPSDEField iDEField = this.getArg(args, 2, IPSDEField.class);
                    IPSDEAction iPSDEAction = this.getArg(args, 3, IPSDEAction.class);
                    objRet2 = this.invocable.invokeFunction("main", this.iSystemRTScriptContext.getSystemRuntime(), iEntityBase, strActionMode, iDEField, iPSDEAction);
                } else {
                    objRet2 = this.invocable.invokeFunction("main", this.iSystemRTScriptContext.getSystemRuntime(), iEntityBase);
                }
                return objRet2;
            }
            IScriptEntity iScriptEntity = this.iDataEntityRuntime.createScriptEntity(iEntityBase);
            if ("DEFCHECK".equals(this.getLogicMode()) || "DEFDEFAULT".equals(this.getLogicMode())) {
                String strActionMode = this.getArg(args, 1, String.class);
                IPSDEField iDEField = this.getArg(args, 2, IPSDEField.class);
                IPSDEAction iPSDEAction = this.getArg(args, 3, IPSDEAction.class);
                objRet = this.invocable.invokeFunction("main", this.iSystemRTScriptContext, iScriptEntity, strActionMode, iDEField, iPSDEAction);
            } else {
                objRet = this.invocable.invokeFunction("main", this.iSystemRTScriptContext, iScriptEntity);
            }
            return ScriptUtils.getReal(objRet);
        }
        catch (NoSuchMethodException | ScriptException ex) {
            log.error((Object)ex);
            this.iDataEntityRuntime.getSystemRuntime().log(40000, "SCRIPT", String.format("\u6267\u884c\u5b9e\u4f53\u811a\u672c[%1$s][%2$s]\u53d1\u751f\u5f02\u5e38\uff0c%3$s", this.iDataEntityRuntime.getName(), this.getName(), ex.getMessage()), ex);
            throw new DataEntityRuntimeException(this.iDataEntityRuntime, String.format("\u6267\u884c\u5b9e\u4f53\u811a\u672c[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()));
        }
    }

    @Override
    public String getId() {
        return String.format("%1$s", this.strScript.hashCode());
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getLogicMode() {
        return this.strLogicMode;
    }

    protected <T> T getArg(Object[] args, int nPos, Class<T> cls) {
        if (args.length > nPos && args[nPos] != null && cls.isAssignableFrom(args[nPos].getClass())) {
            return (T)args[nPos];
        }
        return null;
    }
}

