/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.codelist;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import net.ibizsys.model.IPSModelObjectRuntime;
import net.ibizsys.model.codelist.IPSCodeItem;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.runtime.codelist.CodeListRuntimeBase;
import net.ibizsys.runtime.dataentity.IDataEntityRuntime;
import net.ibizsys.runtime.util.IEntityBase;
import net.ibizsys.runtime.util.ISearchContextBase;
import net.ibizsys.runtime.util.JsonUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.util.StringUtils;

public class DynamicCodeListRuntime
extends CodeListRuntimeBase {
    private List<IPSCodeItem> psCodeItemList = null;

    @Override
    protected void onInit() throws Exception {
        super.onInit();
    }

    @Override
    public List<IPSCodeItem> getPSCodeItems() {
        List<IPSCodeItem> psCodeItemList = this.psCodeItemList;
        if (psCodeItemList == null) {
            psCodeItemList = new ArrayList<IPSCodeItem>();
            IPSDataEntity iPSDataEntity = this.getPSCodeList().getPSDataEntityMust();
            IDataEntityRuntime iDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(iPSDataEntity.getId());
            IPSDEDataSet iPSDEDataSet = this.getPSCodeList().getPSDEDataSet();
            if (iPSDEDataSet == null) {
                iPSDEDataSet = iPSDataEntity.getDefaultPSDEDataSetMust();
            }
            ISearchContextBase iSearchContextBase = iDataEntityRuntime.createSearchContext();
            if (StringUtils.hasLength((String)this.getPSCodeList().getCustomCond())) {
                iDataEntityRuntime.setSearchCustomCondition(iSearchContextBase, this.getPSCodeList().getCustomCond());
            }
            Sort sort = Sort.unsorted();
            if (this.getPSCodeList().getMinorSortPSDEField() != null) {
                ArrayList<Sort.Order> list = new ArrayList<Sort.Order>();
                if ("DESC".equalsIgnoreCase(this.getPSCodeList().getMinorSortDir())) {
                    list.add(Sort.Order.desc((String)this.getPSCodeList().getMinorSortPSDEField().getLowerCaseName()));
                } else {
                    list.add(Sort.Order.asc((String)this.getPSCodeList().getMinorSortPSDEField().getLowerCaseName()));
                }
                sort = Sort.by(list);
            }
            iDataEntityRuntime.setSearchPaging(iSearchContextBase, 0, 1000, sort);
            iDataEntityRuntime.setSearchMode(iSearchContextBase, true, false);
            Page<? extends IEntityBase> page = iDataEntityRuntime.searchDataSet(iPSDEDataSet, iSearchContextBase);
            if (page != null && page.getContent() != null) {
                for (IEntityBase item : page.getContent()) {
                    Object objValue = null;
                    Object objText = null;
                    objValue = this.getPSCodeList().getValuePSDEField() != null ? iDataEntityRuntime.getFieldValue(item, this.getPSCodeList().getValuePSDEField()) : iDataEntityRuntime.getFieldValue(item, iDataEntityRuntime.getKeyPSDEField());
                    if (this.getPSCodeList().getTextPSDEField() != null) {
                        objText = iDataEntityRuntime.getFieldValue(item, this.getPSCodeList().getTextPSDEField());
                    } else if (iDataEntityRuntime.getMajorPSDEField() != null) {
                        objText = iDataEntityRuntime.getFieldValue(item, iDataEntityRuntime.getMajorPSDEField());
                    }
                    if (objText == null) {
                        objText = objValue;
                    }
                    ObjectNode objNode = JsonUtils.createObjectNode();
                    objNode.put("id", String.valueOf(objValue));
                    objNode.put("name", String.valueOf(objText));
                    objNode.put("value", String.valueOf(objValue));
                    objNode.put("text", String.valueOf(objText));
                    IPSCodeItem iPSCodeItem = (IPSCodeItem)this.getSystemRuntimeBaseContext().getPSSystemService().createAndInitPSModelObject((IPSModelObjectRuntime)this.getPSCodeList(), IPSCodeItem.class, objNode);
                    psCodeItemList.add(iPSCodeItem);
                }
            }
        }
        if (this.psCodeItemList == null) {
            this.psCodeItemList = psCodeItemList;
        }
        return psCodeItemList;
    }

    @Override
    public void reset() {
        this.psCodeItemList = null;
        super.reset();
    }
}

