/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.backend;

import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.action.IPSDEAction;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.backend.SysBackendTaskRuntimeBase;
import net.ibizsys.runtime.dataentity.IDataEntityRuntime;
import net.ibizsys.runtime.util.IEntityBase;
import net.ibizsys.runtime.util.ISearchContextBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.data.domain.Page;

public abstract class SysDEActionBackendTaskRuntimeBase
extends SysBackendTaskRuntimeBase {
    private static final Log log = LogFactory.getLog(SysDEActionBackendTaskRuntimeBase.class);
    private IPSDataEntity iPSDataEntity = null;
    private IPSDEAction iPSDEAction = null;
    private IPSDEDataSet iPSDEDataSet = null;

    @Override
    protected void onInit() throws Exception {
        this.iPSDataEntity = this.getPSSysBackService().getPSDataEntity();
        this.iPSDEAction = this.getPSSysBackService().getPSDEAction();
        this.iPSDEDataSet = this.getPSSysBackService().getPSDEDataSet();
        if (this.iPSDataEntity == null) {
            throw new SystemRuntimeException(this.getSystemRuntime(), String.format("\u540e\u53f0\u4f5c\u4e1a[%1$s]\u6ca1\u6709\u6307\u5b9a\u8c03\u7528\u5b9e\u4f53\u5bf9\u8c61", this.getName()));
        }
        if (this.iPSDEAction == null) {
            throw new SystemRuntimeException(this.getSystemRuntime(), String.format("\u540e\u53f0\u4f5c\u4e1a[%1$s]\u6ca1\u6709\u6307\u5b9a\u8c03\u7528\u5b9e\u4f53\u884c\u4e3a", this.getName()));
        }
        super.onInit();
    }

    @Override
    protected Object onExecute(String strDynaInstId, String strParam, ProceedingJoinPoint joinPoint) throws Throwable {
        IDataEntityRuntime iDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(this.iPSDataEntity.getId());
        if (this.iPSDEDataSet != null) {
            ISearchContextBase iSearchContextBase = iDataEntityRuntime.createSearchContext();
            Page<? extends IEntityBase> page = iDataEntityRuntime.searchDataSet(this.iPSDEDataSet, iSearchContextBase);
            if (page != null && page.getNumberOfElements() > 0) {
                for (IEntityBase iEntityBase : page.getContent()) {
                    iDataEntityRuntime.executeAction(this.iPSDEAction.getName(), this.iPSDEAction, new Object[]{iEntityBase});
                }
            }
        } else {
            IEntityBase iEntityBase = iDataEntityRuntime.createEntity();
            iDataEntityRuntime.executeAction(this.iPSDEAction.getName(), this.iPSDEAction, new Object[]{iEntityBase});
        }
        if (joinPoint != null) {
            return joinPoint.proceed();
        }
        return null;
    }
}

