/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.runtime.backend;

import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.backservice.IPSSysBackService;
import net.ibizsys.runtime.IDynaInstRuntime;
import net.ibizsys.runtime.ISystemRuntimeBase;
import net.ibizsys.runtime.ISystemRuntimeContext;
import net.ibizsys.runtime.SystemModelRuntimeBase;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.backend.ISysBackendTaskRuntime;
import net.ibizsys.runtime.security.IUserContext;
import net.ibizsys.runtime.util.ActionSessionManager;
import net.ibizsys.runtime.util.KeyValueUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;

public abstract class SysBackendTaskRuntimeBase
extends SystemModelRuntimeBase
implements ISysBackendTaskRuntime {
    private static final Log log = LogFactory.getLog(SysBackendTaskRuntimeBase.class);
    private IPSSysBackService iPSSysBackService = null;

    @Override
    public void init(ISystemRuntimeContext iSystemRuntimeContext, IPSSysBackService iPSSysBackService) throws Exception {
        this.iPSSysBackService = iPSSysBackService;
        this.setSystemRuntimeBaseContext(iSystemRuntimeContext);
        this.onInit();
    }

    @Override
    public final IPSSysBackService getPSSysBackService() {
        if (this.iPSSysBackService == null) {
            return this.internalGetPSSysBackService();
        }
        return this.iPSSysBackService;
    }

    protected synchronized IPSSysBackService internalGetPSSysBackService() {
        if (this.iPSSysBackService == null) {
            IPSSysBackService iPSSysBackService;
            this.iPSSysBackService = iPSSysBackService = this.getSystemRuntime().getPSSystem().getPSSysBackService((Object)this.getId(), false);
            try {
                this.onInit();
            }
            catch (Exception ex) {
                this.iPSSysBackService = null;
                throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), String.format("\u521d\u59cb\u5316\u7cfb\u7edf\u540e\u53f0\u4efb\u52a1[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), ex);
            }
        }
        return this.iPSSysBackService;
    }

    @Override
    public String getId() {
        return this.getPSSysBackService().getId();
    }

    @Override
    public String getName() {
        return this.getPSSysBackService().getName();
    }

    public Object aroundHandler(ProceedingJoinPoint joinPoint) throws Throwable {
        String strDynaInstId = null;
        String strParam = null;
        if (joinPoint.getArgs() != null) {
            Object objArg;
            if (joinPoint.getArgs().length >= 1 && (objArg = joinPoint.getArgs()[0]) instanceof String) {
                strDynaInstId = (String)objArg;
            }
            if (joinPoint.getArgs().length >= 2 && (objArg = joinPoint.getArgs()[1]) instanceof String) {
                strParam = (String)objArg;
            }
        }
        return this.execute(strDynaInstId, strParam, joinPoint);
    }

    protected Object execute(String strDynaInstId, String strParam, ProceedingJoinPoint joinPoint) throws Throwable {
        boolean bOpenActionSession;
        boolean bl = bOpenActionSession = ActionSessionManager.getCurrentSession() == null;
        if (bOpenActionSession) {
            ActionSessionManager.openSession().setName(this.getName());
            ActionSessionManager.getCurrentSession().setUserContext(this.getUserContext());
        }
        try {
            IDynaInstRuntime lastDynaInstRuntime = ActionSessionManager.getCurrentSession().getDynaInstRuntime();
            IDynaInstRuntime lastChildDynaInstRuntime = ActionSessionManager.getCurrentSession().getChildDynaInstRuntime();
            String strLastSessionId = ActionSessionManager.getCurrentSession().getSessionId();
            ActionSessionManager.getCurrentSession().setDefaultDynaInstId(strDynaInstId);
            ActionSessionManager.getCurrentSession().setSessionId(KeyValueUtils.genGuidEx());
            Object objRet = this.onExecute(strDynaInstId, strParam, joinPoint);
            ActionSessionManager.getCurrentSession().setSessionId(strLastSessionId);
            ActionSessionManager.getCurrentSession().setDynaInstRuntime(lastDynaInstRuntime);
            ActionSessionManager.getCurrentSession().setChildDynaInstRuntime(lastChildDynaInstRuntime);
            if (bOpenActionSession) {
                ActionSessionManager.closeSession(true);
            }
            return objRet;
        }
        catch (Throwable ex) {
            ActionSessionManager.getCurrentSession().setDynaInstRuntime(null);
            ActionSessionManager.getCurrentSession().setChildDynaInstRuntime(null);
            if (bOpenActionSession) {
                ActionSessionManager.closeSession(false);
            }
            throw ex;
        }
    }

    protected Object onExecute(String strDynaInstId, String strParam, ProceedingJoinPoint joinPoint) throws Throwable {
        return joinPoint.proceed();
    }

    protected IUserContext getUserContext() {
        throw new SystemRuntimeException((ISystemRuntimeBase)this.getSystemRuntime(), "\u6ca1\u6709\u5b9e\u73b0", 20);
    }

    @Override
    public IPSModelObject getPSModelObject() {
        return this.getPSSysBackService();
    }
}

