/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.ISystemRuntimeContext;
import net.ibizsys.central.SystemModelRuntimeBase;
import net.ibizsys.central.dataentity.service.DEServiceAPIRSRuntime;
import net.ibizsys.central.dataentity.service.DEServiceAPIRuntime;
import net.ibizsys.central.dataentity.service.IDEServiceAPIRSRuntime;
import net.ibizsys.central.dataentity.service.IDEServiceAPIRuntime;
import net.ibizsys.central.service.ISysServiceAPIRuntime;
import net.ibizsys.central.service.ISysServiceAPIRuntimeContext;
import net.ibizsys.central.service.SysServiceAPIRuntimeException;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.dataentity.service.IPSDEServiceAPI;
import net.ibizsys.model.dataentity.service.IPSDEServiceAPIRS;
import net.ibizsys.model.service.IPSSysServiceAPI;
import net.ibizsys.runtime.util.domain.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SysServiceAPIRuntime
extends SystemModelRuntimeBase
implements ISysServiceAPIRuntime {
    private static final Log log = LogFactory.getLog(SysServiceAPIRuntime.class);
    private IPSSysServiceAPI iPSSysServiceAPI = null;
    private Map<String, IDEServiceAPIRuntime> deServiceAPIRuntimeMap = null;
    private Map<String, IDEServiceAPIRSRuntime> deServiceAPIRSRuntimeMap = null;
    private ISysServiceAPIRuntimeContext iSysServiceAPIRuntimeContext = new ISysServiceAPIRuntimeContext(){

        @Override
        public ISysServiceAPIRuntime getSysServiceAPIRuntime() {
            return SysServiceAPIRuntime.this.getSelf();
        }
    };

    @Override
    public void init(ISystemRuntimeContext iSystemRuntimeContext, IPSSysServiceAPI iPSSysServiceAPI) throws Exception {
        this.setSystemRuntimeBaseContext(iSystemRuntimeContext);
        this.iPSSysServiceAPI = iPSSysServiceAPI;
        Assert.notNull((Object)this.iPSSysServiceAPI, (String)"\u4f20\u5165\u7cfb\u7edf\u670d\u52a1\u63a5\u53e3\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        this.onInit();
    }

    @Override
    protected void onInit() throws Exception {
        List psDEServiceAPIRSs;
        super.onInit();
        List psDEServiceAPIs = this.getPSSysServiceAPI().getPSDEServiceAPIs();
        if (psDEServiceAPIs != null) {
            for (IPSDEServiceAPI iPSDEServiceAPI : psDEServiceAPIs) {
                this.registerPSDEServiceAPI(iPSDEServiceAPI);
            }
        }
        if ((psDEServiceAPIRSs = this.getPSSysServiceAPI().getPSDEServiceAPIRSs()) != null) {
            for (IPSDEServiceAPIRS iPSDEServiceAPIRS : psDEServiceAPIRSs) {
                this.registerPSDEServiceAPIRS(iPSDEServiceAPIRS);
            }
        }
    }

    @Override
    public IPSSysServiceAPI getPSSysServiceAPI() {
        return this.iPSSysServiceAPI;
    }

    @Override
    public IPSModelObject getPSModelObject() {
        return this.getPSSysServiceAPI();
    }

    @Override
    public int getAPILevel() {
        return this.getPSSysServiceAPI().getAPILevel();
    }

    @Override
    public String getId() {
        return this.getPSSysServiceAPI().getId();
    }

    @Override
    public String getName() {
        return this.getPSSysServiceAPI().getName();
    }

    protected ISysServiceAPIRuntimeContext getSysServiceAPIRuntimeContext() {
        return this.iSysServiceAPIRuntimeContext;
    }

    @Override
    protected ISystemRuntimeContext getSystemRuntimeContext() {
        return (ISystemRuntimeContext)super.getSystemRuntimeBaseContext();
    }

    private ISysServiceAPIRuntime getSelf() {
        return this;
    }

    @Override
    public IDEServiceAPIRuntime getDEServiceAPIRuntime(String strTag, boolean bTryMode) {
        Assert.notNull((Object)strTag, (String)"\u4f20\u5165\u670d\u52a1\u63a5\u53e3\u6807\u8bb0\u65e0\u6548");
        IDEServiceAPIRuntime iDEServiceAPIRuntime = null;
        if (this.deServiceAPIRuntimeMap != null && (iDEServiceAPIRuntime = this.deServiceAPIRuntimeMap.get(strTag)) == null) {
            iDEServiceAPIRuntime = this.deServiceAPIRuntimeMap.get(strTag.toUpperCase());
        }
        if (iDEServiceAPIRuntime != null || bTryMode) {
            return iDEServiceAPIRuntime;
        }
        throw new SysServiceAPIRuntimeException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61", strTag));
    }

    protected IDEServiceAPIRuntime registerPSDEServiceAPI(IPSDEServiceAPI iPSDEServiceAPI) {
        IDEServiceAPIRuntime iDEServiceAPIRuntime = this.createDEServiceAPIRuntime(iPSDEServiceAPI);
        if (iDEServiceAPIRuntime == null) {
            return null;
        }
        try {
            iDEServiceAPIRuntime.init(this.getSysServiceAPIRuntimeContext(), iPSDEServiceAPI);
        }
        catch (Exception ex) {
            throw new SysServiceAPIRuntimeException((ISysServiceAPIRuntime)this, String.format("\u521d\u59cb\u5316\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSDEServiceAPI.getName(), ex.getMessage()), ex);
        }
        if (this.deServiceAPIRuntimeMap == null) {
            this.deServiceAPIRuntimeMap = new HashMap<String, IDEServiceAPIRuntime>();
        }
        this.deServiceAPIRuntimeMap.put(iPSDEServiceAPI.getName().toUpperCase(), iDEServiceAPIRuntime);
        this.deServiceAPIRuntimeMap.put(iPSDEServiceAPI.getId(), iDEServiceAPIRuntime);
        if (StringUtils.hasLength((String)iPSDEServiceAPI.getCodeName()) && !this.deServiceAPIRuntimeMap.containsKey(iPSDEServiceAPI.getCodeName().toUpperCase())) {
            this.deServiceAPIRuntimeMap.put(iPSDEServiceAPI.getCodeName().toUpperCase(), iDEServiceAPIRuntime);
        }
        return iDEServiceAPIRuntime;
    }

    protected IDEServiceAPIRuntime createDEServiceAPIRuntime(IPSDEServiceAPI iPSDEServiceAPI) {
        IDEServiceAPIRuntime iDEServiceAPIRuntime = this.getSystemRuntime().getRuntimeObject(iPSDEServiceAPI.getPSSysSFPlugin(), IDEServiceAPIRuntime.class, true);
        if (iDEServiceAPIRuntime != null) {
            return iDEServiceAPIRuntime;
        }
        return this.createDefaultDEServiceAPIRuntime();
    }

    protected IDEServiceAPIRuntime createDefaultDEServiceAPIRuntime() {
        return new DEServiceAPIRuntime();
    }

    @Override
    public IDEServiceAPIRSRuntime getDEServiceAPIRSRuntime(String strTag, boolean bTryMode) {
        Assert.notNull((Object)strTag, (String)"\u4f20\u5165\u670d\u52a1\u63a5\u53e3\u5173\u7cfb\u6807\u8bb0\u65e0\u6548");
        IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime = null;
        if (this.deServiceAPIRSRuntimeMap != null && (iDEServiceAPIRSRuntime = this.deServiceAPIRSRuntimeMap.get(strTag)) == null) {
            iDEServiceAPIRSRuntime = this.deServiceAPIRSRuntimeMap.get(strTag.toUpperCase());
        }
        if (iDEServiceAPIRSRuntime != null || bTryMode) {
            return iDEServiceAPIRSRuntime;
        }
        throw new SysServiceAPIRuntimeException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3\u5173\u7cfb[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61", strTag));
    }

    protected IDEServiceAPIRSRuntime registerPSDEServiceAPIRS(IPSDEServiceAPIRS iPSDEServiceAPIRS) {
        IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime = this.createDEServiceAPIRSRuntime(iPSDEServiceAPIRS);
        if (iDEServiceAPIRSRuntime == null) {
            return null;
        }
        try {
            iDEServiceAPIRSRuntime.init(this.getSysServiceAPIRuntimeContext(), iPSDEServiceAPIRS);
        }
        catch (Exception ex) {
            throw new SysServiceAPIRuntimeException((ISysServiceAPIRuntime)this, String.format("\u521d\u59cb\u5316\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3\u5173\u7cfb[%1$s]\u8fd0\u884c\u65f6\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSDEServiceAPIRS.getName(), ex.getMessage()), ex);
        }
        if (this.deServiceAPIRSRuntimeMap == null) {
            this.deServiceAPIRSRuntimeMap = new HashMap<String, IDEServiceAPIRSRuntime>();
        }
        this.deServiceAPIRSRuntimeMap.put(String.format("%1$s|%2$s", iPSDEServiceAPIRS.getMajorPSDEServiceAPIMust().getName(), iPSDEServiceAPIRS.getMinorPSDEServiceAPIMust().getName()).toUpperCase(), iDEServiceAPIRSRuntime);
        if (StringUtils.hasLength((String)iPSDEServiceAPIRS.getCodeName())) {
            this.deServiceAPIRSRuntimeMap.put(String.format("%1$s|%2$s", iPSDEServiceAPIRS.getMajorPSDEServiceAPIMust().getName(), iPSDEServiceAPIRS.getCodeName()).toUpperCase(), iDEServiceAPIRSRuntime);
        }
        this.deServiceAPIRSRuntimeMap.put(iPSDEServiceAPIRS.getId(), iDEServiceAPIRSRuntime);
        return iDEServiceAPIRSRuntime;
    }

    protected IDEServiceAPIRSRuntime createDEServiceAPIRSRuntime(IPSDEServiceAPIRS iPSDEServiceAPIRS) {
        return this.createDefaultDEServiceAPIRSRuntime();
    }

    protected IDEServiceAPIRSRuntime createDefaultDEServiceAPIRSRuntime() {
        return new DEServiceAPIRSRuntime();
    }

    @Override
    public Object invokeDEMethod(String strScope, String strDataEntityName, String strMethodName, Object objBody, String strKey, Object objTag) throws Throwable {
        return this.invokeDEMethod(strScope, null, null, strDataEntityName, strMethodName, objBody, strKey, objTag);
    }

    @Override
    public Object invokeDEMethod(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strMethodName, Object objBody, String strKey, Object objTag) throws Throwable {
        IDEServiceAPIRuntime iDEServiceAPIRuntime;
        String strMinorDEServiceAPIName;
        IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime = null;
        if (StringUtils.hasLength((String)strParentDEName) && !(strMinorDEServiceAPIName = (iDEServiceAPIRSRuntime = this.getDEServiceAPIRSRuntime(String.format("%1$s|%2$s", strParentDEName, strDataEntityName).toUpperCase(), false)).getMinorDEServiceAPIRuntime().getName()).equalsIgnoreCase(strDataEntityName)) {
            log.debug((Object)String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3\u6807\u8bc6\u8c03\u6574[%1$s] => [%2$s]", strDataEntityName, strMinorDEServiceAPIName));
            strDataEntityName = strMinorDEServiceAPIName;
        }
        if ((iDEServiceAPIRuntime = this.getDEServiceAPIRuntime(strDataEntityName, false)).getAPIMode() == 9) {
            throw new SysServiceAPIRuntimeException(this, String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3[%1$s]\u6a21\u5f0f\u4e3a[\u5d4c\u5957\u6210\u5458]\u4e0d\u5bf9\u5916\u63d0\u4f9b\u670d\u52a1", iDEServiceAPIRuntime.getName()));
        }
        if (iDEServiceAPIRSRuntime == null && iDEServiceAPIRuntime.getAPIMode() == 0) {
            throw new SysServiceAPIRuntimeException(this, String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3[%1$s]\u6a21\u5f0f\u4e3a[\u4ece\u63a5\u53e3]\u5fc5\u987b\u540c\u65f6\u6307\u5b9a\u4e3b\u63a5\u53e3", iDEServiceAPIRuntime.getName()));
        }
        return iDEServiceAPIRuntime.invokeMethod(strScope, iDEServiceAPIRSRuntime, strParentKey, strMethodName, objBody, strKey, objTag);
    }

    @Override
    public Object invokeDEImportData(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strImportTag, Object objBody, Object objTag) throws Throwable {
        IDEServiceAPIRuntime iDEServiceAPIRuntime;
        String strMinorDEServiceAPIName;
        IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime = null;
        if (StringUtils.hasLength((String)strParentDEName) && !(strMinorDEServiceAPIName = (iDEServiceAPIRSRuntime = this.getDEServiceAPIRSRuntime(String.format("%1$s|%2$s", strParentDEName, strDataEntityName).toUpperCase(), false)).getMinorDEServiceAPIRuntime().getName()).equalsIgnoreCase(strDataEntityName)) {
            log.debug((Object)String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3\u6807\u8bc6\u8c03\u6574[%1$s] => [%2$s]", strDataEntityName, strMinorDEServiceAPIName));
            strDataEntityName = strMinorDEServiceAPIName;
        }
        if ((iDEServiceAPIRuntime = this.getDEServiceAPIRuntime(strDataEntityName, false)).getAPIMode() == 9) {
            throw new SysServiceAPIRuntimeException(this, String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3[%1$s]\u6a21\u5f0f\u4e3a[\u5d4c\u5957\u6210\u5458]\u4e0d\u5bf9\u5916\u63d0\u4f9b\u670d\u52a1", iDEServiceAPIRuntime.getName()));
        }
        if (iDEServiceAPIRSRuntime == null && iDEServiceAPIRuntime.getAPIMode() == 0) {
            throw new SysServiceAPIRuntimeException(this, String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3[%1$s]\u6a21\u5f0f\u4e3a[\u4ece\u63a5\u53e3]\u5fc5\u987b\u540c\u65f6\u6307\u5b9a\u4e3b\u63a5\u53e3", iDEServiceAPIRuntime.getName()));
        }
        return iDEServiceAPIRuntime.importData(strScope, iDEServiceAPIRSRuntime, strParentKey, strImportTag, objBody, objTag);
    }

    @Override
    public Object invokeDEImportData2(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strImportTag, Object objBody, Object objTag) throws Throwable {
        IDEServiceAPIRuntime iDEServiceAPIRuntime;
        String strMinorDEServiceAPIName;
        IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime = null;
        if (StringUtils.hasLength((String)strParentDEName) && !(strMinorDEServiceAPIName = (iDEServiceAPIRSRuntime = this.getDEServiceAPIRSRuntime(String.format("%1$s|%2$s", strParentDEName, strDataEntityName).toUpperCase(), false)).getMinorDEServiceAPIRuntime().getName()).equalsIgnoreCase(strDataEntityName)) {
            log.debug((Object)String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3\u6807\u8bc6\u8c03\u6574[%1$s] => [%2$s]", strDataEntityName, strMinorDEServiceAPIName));
            strDataEntityName = strMinorDEServiceAPIName;
        }
        if ((iDEServiceAPIRuntime = this.getDEServiceAPIRuntime(strDataEntityName, false)).getAPIMode() == 9) {
            throw new SysServiceAPIRuntimeException(this, String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3[%1$s]\u6a21\u5f0f\u4e3a[\u5d4c\u5957\u6210\u5458]\u4e0d\u5bf9\u5916\u63d0\u4f9b\u670d\u52a1", iDEServiceAPIRuntime.getName()));
        }
        if (iDEServiceAPIRSRuntime == null && iDEServiceAPIRuntime.getAPIMode() == 0) {
            throw new SysServiceAPIRuntimeException(this, String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3[%1$s]\u6a21\u5f0f\u4e3a[\u4ece\u63a5\u53e3]\u5fc5\u987b\u540c\u65f6\u6307\u5b9a\u4e3b\u63a5\u53e3", iDEServiceAPIRuntime.getName()));
        }
        return iDEServiceAPIRuntime.importData2(strScope, iDEServiceAPIRSRuntime, strParentKey, strImportTag, objBody, objTag);
    }

    @Override
    public Object invokeDEAsyncImportData(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strImportTag, Object objBody, Object objTag) throws Throwable {
        IDEServiceAPIRuntime iDEServiceAPIRuntime;
        String strMinorDEServiceAPIName;
        IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime = null;
        if (StringUtils.hasLength((String)strParentDEName) && !(strMinorDEServiceAPIName = (iDEServiceAPIRSRuntime = this.getDEServiceAPIRSRuntime(String.format("%1$s|%2$s", strParentDEName, strDataEntityName).toUpperCase(), false)).getMinorDEServiceAPIRuntime().getName()).equalsIgnoreCase(strDataEntityName)) {
            log.debug((Object)String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3\u6807\u8bc6\u8c03\u6574[%1$s] => [%2$s]", strDataEntityName, strMinorDEServiceAPIName));
            strDataEntityName = strMinorDEServiceAPIName;
        }
        if ((iDEServiceAPIRuntime = this.getDEServiceAPIRuntime(strDataEntityName, false)).getAPIMode() == 9) {
            throw new SysServiceAPIRuntimeException(this, String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3[%1$s]\u6a21\u5f0f\u4e3a[\u5d4c\u5957\u6210\u5458]\u4e0d\u5bf9\u5916\u63d0\u4f9b\u670d\u52a1", iDEServiceAPIRuntime.getName()));
        }
        if (iDEServiceAPIRSRuntime == null && iDEServiceAPIRuntime.getAPIMode() == 0) {
            throw new SysServiceAPIRuntimeException(this, String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3[%1$s]\u6a21\u5f0f\u4e3a[\u4ece\u63a5\u53e3]\u5fc5\u987b\u540c\u65f6\u6307\u5b9a\u4e3b\u63a5\u53e3", iDEServiceAPIRuntime.getName()));
        }
        return iDEServiceAPIRuntime.asyncImportData(strScope, iDEServiceAPIRSRuntime, strParentKey, strImportTag, objBody, objTag);
    }

    @Override
    public Object invokeDEAsyncImportData2(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strImportTag, Object objBody, Object objTag) throws Throwable {
        IDEServiceAPIRuntime iDEServiceAPIRuntime;
        String strMinorDEServiceAPIName;
        IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime = null;
        if (StringUtils.hasLength((String)strParentDEName) && !(strMinorDEServiceAPIName = (iDEServiceAPIRSRuntime = this.getDEServiceAPIRSRuntime(String.format("%1$s|%2$s", strParentDEName, strDataEntityName).toUpperCase(), false)).getMinorDEServiceAPIRuntime().getName()).equalsIgnoreCase(strDataEntityName)) {
            log.debug((Object)String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3\u6807\u8bc6\u8c03\u6574[%1$s] => [%2$s]", strDataEntityName, strMinorDEServiceAPIName));
            strDataEntityName = strMinorDEServiceAPIName;
        }
        if ((iDEServiceAPIRuntime = this.getDEServiceAPIRuntime(strDataEntityName, false)).getAPIMode() == 9) {
            throw new SysServiceAPIRuntimeException(this, String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3[%1$s]\u6a21\u5f0f\u4e3a[\u5d4c\u5957\u6210\u5458]\u4e0d\u5bf9\u5916\u63d0\u4f9b\u670d\u52a1", iDEServiceAPIRuntime.getName()));
        }
        if (iDEServiceAPIRSRuntime == null && iDEServiceAPIRuntime.getAPIMode() == 0) {
            throw new SysServiceAPIRuntimeException(this, String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3[%1$s]\u6a21\u5f0f\u4e3a[\u4ece\u63a5\u53e3]\u5fc5\u987b\u540c\u65f6\u6307\u5b9a\u4e3b\u63a5\u53e3", iDEServiceAPIRuntime.getName()));
        }
        return iDEServiceAPIRuntime.asyncImportData2(strScope, iDEServiceAPIRSRuntime, strParentKey, strImportTag, objBody, objTag);
    }

    @Override
    public Object invokeDEGetImportTemplate(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strImportTag, Object objTag) throws Throwable {
        IDEServiceAPIRuntime iDEServiceAPIRuntime;
        String strMinorDEServiceAPIName;
        IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime = null;
        if (StringUtils.hasLength((String)strParentDEName) && !(strMinorDEServiceAPIName = (iDEServiceAPIRSRuntime = this.getDEServiceAPIRSRuntime(String.format("%1$s|%2$s", strParentDEName, strDataEntityName).toUpperCase(), false)).getMinorDEServiceAPIRuntime().getName()).equalsIgnoreCase(strDataEntityName)) {
            log.debug((Object)String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3\u6807\u8bc6\u8c03\u6574[%1$s] => [%2$s]", strDataEntityName, strMinorDEServiceAPIName));
            strDataEntityName = strMinorDEServiceAPIName;
        }
        if ((iDEServiceAPIRuntime = this.getDEServiceAPIRuntime(strDataEntityName, false)).getAPIMode() == 9) {
            throw new SysServiceAPIRuntimeException(this, String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3[%1$s]\u6a21\u5f0f\u4e3a[\u5d4c\u5957\u6210\u5458]\u4e0d\u5bf9\u5916\u63d0\u4f9b\u670d\u52a1", iDEServiceAPIRuntime.getName()));
        }
        if (iDEServiceAPIRSRuntime == null && iDEServiceAPIRuntime.getAPIMode() == 0) {
            throw new SysServiceAPIRuntimeException(this, String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3[%1$s]\u6a21\u5f0f\u4e3a[\u4ece\u63a5\u53e3]\u5fc5\u987b\u540c\u65f6\u6307\u5b9a\u4e3b\u63a5\u53e3", iDEServiceAPIRuntime.getName()));
        }
        return iDEServiceAPIRuntime.getImportTemplate(strScope, iDEServiceAPIRSRuntime, strParentKey, strImportTag, objTag);
    }

    @Override
    public Object invokeDEExportData(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strExportTag, Object objBody, Object objTag) throws Throwable {
        IDEServiceAPIRuntime iDEServiceAPIRuntime;
        String strMinorDEServiceAPIName;
        IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime = null;
        if (StringUtils.hasLength((String)strParentDEName) && !(strMinorDEServiceAPIName = (iDEServiceAPIRSRuntime = this.getDEServiceAPIRSRuntime(String.format("%1$s|%2$s", strParentDEName, strDataEntityName).toUpperCase(), false)).getMinorDEServiceAPIRuntime().getName()).equalsIgnoreCase(strDataEntityName)) {
            log.debug((Object)String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3\u6807\u8bc6\u8c03\u6574[%1$s] => [%2$s]", strDataEntityName, strMinorDEServiceAPIName));
            strDataEntityName = strMinorDEServiceAPIName;
        }
        if ((iDEServiceAPIRuntime = this.getDEServiceAPIRuntime(strDataEntityName, false)).getAPIMode() == 9) {
            throw new SysServiceAPIRuntimeException(this, String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3[%1$s]\u6a21\u5f0f\u4e3a[\u5d4c\u5957\u6210\u5458]\u4e0d\u5bf9\u5916\u63d0\u4f9b\u670d\u52a1", iDEServiceAPIRuntime.getName()));
        }
        if (iDEServiceAPIRSRuntime == null && iDEServiceAPIRuntime.getAPIMode() == 0) {
            throw new SysServiceAPIRuntimeException(this, String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3[%1$s]\u6a21\u5f0f\u4e3a[\u4ece\u63a5\u53e3]\u5fc5\u987b\u540c\u65f6\u6307\u5b9a\u4e3b\u63a5\u53e3", iDEServiceAPIRuntime.getName()));
        }
        return iDEServiceAPIRuntime.exportData(strScope, iDEServiceAPIRSRuntime, strParentKey, strExportTag, objBody, objTag);
    }

    @Override
    public Object invokeDEExportData(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strExportTag, String strMethodName, Object objBody, String strKey, Object objTag) throws Throwable {
        IDEServiceAPIRuntime iDEServiceAPIRuntime;
        String strMinorDEServiceAPIName;
        IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime = null;
        if (StringUtils.hasLength((String)strParentDEName) && !(strMinorDEServiceAPIName = (iDEServiceAPIRSRuntime = this.getDEServiceAPIRSRuntime(String.format("%1$s|%2$s", strParentDEName, strDataEntityName).toUpperCase(), false)).getMinorDEServiceAPIRuntime().getName()).equalsIgnoreCase(strDataEntityName)) {
            log.debug((Object)String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3\u6807\u8bc6\u8c03\u6574[%1$s] => [%2$s]", strDataEntityName, strMinorDEServiceAPIName));
            strDataEntityName = strMinorDEServiceAPIName;
        }
        if ((iDEServiceAPIRuntime = this.getDEServiceAPIRuntime(strDataEntityName, false)).getAPIMode() == 9) {
            throw new SysServiceAPIRuntimeException(this, String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3[%1$s]\u6a21\u5f0f\u4e3a[\u5d4c\u5957\u6210\u5458]\u4e0d\u5bf9\u5916\u63d0\u4f9b\u670d\u52a1", iDEServiceAPIRuntime.getName()));
        }
        if (iDEServiceAPIRSRuntime == null && iDEServiceAPIRuntime.getAPIMode() == 0) {
            throw new SysServiceAPIRuntimeException(this, String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3[%1$s]\u6a21\u5f0f\u4e3a[\u4ece\u63a5\u53e3]\u5fc5\u987b\u540c\u65f6\u6307\u5b9a\u4e3b\u63a5\u53e3", iDEServiceAPIRuntime.getName()));
        }
        return iDEServiceAPIRuntime.exportData(strScope, iDEServiceAPIRSRuntime, strParentKey, strExportTag, strMethodName, objBody, strKey, objTag);
    }

    @Override
    public Object invokeDEAsyncExportData(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strExportTag, String strMethodName, Object objBody, String strKey, Object objTag) throws Throwable {
        IDEServiceAPIRuntime iDEServiceAPIRuntime;
        String strMinorDEServiceAPIName;
        IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime = null;
        if (StringUtils.hasLength((String)strParentDEName) && !(strMinorDEServiceAPIName = (iDEServiceAPIRSRuntime = this.getDEServiceAPIRSRuntime(String.format("%1$s|%2$s", strParentDEName, strDataEntityName).toUpperCase(), false)).getMinorDEServiceAPIRuntime().getName()).equalsIgnoreCase(strDataEntityName)) {
            log.debug((Object)String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3\u6807\u8bc6\u8c03\u6574[%1$s] => [%2$s]", strDataEntityName, strMinorDEServiceAPIName));
            strDataEntityName = strMinorDEServiceAPIName;
        }
        if ((iDEServiceAPIRuntime = this.getDEServiceAPIRuntime(strDataEntityName, false)).getAPIMode() == 9) {
            throw new SysServiceAPIRuntimeException(this, String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3[%1$s]\u6a21\u5f0f\u4e3a[\u5d4c\u5957\u6210\u5458]\u4e0d\u5bf9\u5916\u63d0\u4f9b\u670d\u52a1", iDEServiceAPIRuntime.getName()));
        }
        if (iDEServiceAPIRSRuntime == null && iDEServiceAPIRuntime.getAPIMode() == 0) {
            throw new SysServiceAPIRuntimeException(this, String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3[%1$s]\u6a21\u5f0f\u4e3a[\u4ece\u63a5\u53e3]\u5fc5\u987b\u540c\u65f6\u6307\u5b9a\u4e3b\u63a5\u53e3", iDEServiceAPIRuntime.getName()));
        }
        return iDEServiceAPIRuntime.asyncExportData(strScope, iDEServiceAPIRSRuntime, strParentKey, strExportTag, strMethodName, objBody, strKey, objTag);
    }

    @Override
    public Object invokeDEPrintData(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strPrintTag, String strPrintType, Object objBody, String strKey, Object objTag) throws Throwable {
        IDEServiceAPIRuntime iDEServiceAPIRuntime;
        String strMinorDEServiceAPIName;
        IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime = null;
        if (StringUtils.hasLength((String)strParentDEName) && !(strMinorDEServiceAPIName = (iDEServiceAPIRSRuntime = this.getDEServiceAPIRSRuntime(String.format("%1$s|%2$s", strParentDEName, strDataEntityName).toUpperCase(), false)).getMinorDEServiceAPIRuntime().getName()).equalsIgnoreCase(strDataEntityName)) {
            log.debug((Object)String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3\u6807\u8bc6\u8c03\u6574[%1$s] => [%2$s]", strDataEntityName, strMinorDEServiceAPIName));
            strDataEntityName = strMinorDEServiceAPIName;
        }
        if ((iDEServiceAPIRuntime = this.getDEServiceAPIRuntime(strDataEntityName, false)).getAPIMode() == 9) {
            throw new SysServiceAPIRuntimeException(this, String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3[%1$s]\u6a21\u5f0f\u4e3a[\u5d4c\u5957\u6210\u5458]\u4e0d\u5bf9\u5916\u63d0\u4f9b\u670d\u52a1", iDEServiceAPIRuntime.getName()));
        }
        if (iDEServiceAPIRSRuntime == null && iDEServiceAPIRuntime.getAPIMode() == 0) {
            throw new SysServiceAPIRuntimeException(this, String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3[%1$s]\u6a21\u5f0f\u4e3a[\u4ece\u63a5\u53e3]\u5fc5\u987b\u540c\u65f6\u6307\u5b9a\u4e3b\u63a5\u53e3", iDEServiceAPIRuntime.getName()));
        }
        return iDEServiceAPIRuntime.printData(strScope, iDEServiceAPIRSRuntime, strParentKey, strPrintTag, strPrintType, objBody, strKey, objTag);
    }

    @Override
    public Object invokeDEWFStart(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strWFTag, Object objBody, String strKey, Object objTag) throws Throwable {
        IDEServiceAPIRuntime iDEServiceAPIRuntime;
        String strMinorDEServiceAPIName;
        IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime = null;
        if (StringUtils.hasLength((String)strParentDEName) && !(strMinorDEServiceAPIName = (iDEServiceAPIRSRuntime = this.getDEServiceAPIRSRuntime(String.format("%1$s|%2$s", strParentDEName, strDataEntityName).toUpperCase(), false)).getMinorDEServiceAPIRuntime().getName()).equalsIgnoreCase(strDataEntityName)) {
            log.debug((Object)String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3\u6807\u8bc6\u8c03\u6574[%1$s] => [%2$s]", strDataEntityName, strMinorDEServiceAPIName));
            strDataEntityName = strMinorDEServiceAPIName;
        }
        if ((iDEServiceAPIRuntime = this.getDEServiceAPIRuntime(strDataEntityName, false)).getAPIMode() == 9) {
            throw new SysServiceAPIRuntimeException(this, String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3[%1$s]\u6a21\u5f0f\u4e3a[\u5d4c\u5957\u6210\u5458]\u4e0d\u5bf9\u5916\u63d0\u4f9b\u670d\u52a1", iDEServiceAPIRuntime.getName()));
        }
        if (iDEServiceAPIRSRuntime == null && iDEServiceAPIRuntime.getAPIMode() == 0) {
            throw new SysServiceAPIRuntimeException(this, String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3[%1$s]\u6a21\u5f0f\u4e3a[\u4ece\u63a5\u53e3]\u5fc5\u987b\u540c\u65f6\u6307\u5b9a\u4e3b\u63a5\u53e3", iDEServiceAPIRuntime.getName()));
        }
        return iDEServiceAPIRuntime.wfStart(strScope, iDEServiceAPIRSRuntime, strParentKey, strWFTag, objBody, strKey, objTag);
    }

    @Override
    public Object invokeDEWFCancel(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strWFTag, Object objBody, String strKey, Object objTag) throws Throwable {
        IDEServiceAPIRuntime iDEServiceAPIRuntime;
        String strMinorDEServiceAPIName;
        IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime = null;
        if (StringUtils.hasLength((String)strParentDEName) && !(strMinorDEServiceAPIName = (iDEServiceAPIRSRuntime = this.getDEServiceAPIRSRuntime(String.format("%1$s|%2$s", strParentDEName, strDataEntityName).toUpperCase(), false)).getMinorDEServiceAPIRuntime().getName()).equalsIgnoreCase(strDataEntityName)) {
            log.debug((Object)String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3\u6807\u8bc6\u8c03\u6574[%1$s] => [%2$s]", strDataEntityName, strMinorDEServiceAPIName));
            strDataEntityName = strMinorDEServiceAPIName;
        }
        if ((iDEServiceAPIRuntime = this.getDEServiceAPIRuntime(strDataEntityName, false)).getAPIMode() == 9) {
            throw new SysServiceAPIRuntimeException(this, String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3[%1$s]\u6a21\u5f0f\u4e3a[\u5d4c\u5957\u6210\u5458]\u4e0d\u5bf9\u5916\u63d0\u4f9b\u670d\u52a1", iDEServiceAPIRuntime.getName()));
        }
        if (iDEServiceAPIRSRuntime == null && iDEServiceAPIRuntime.getAPIMode() == 0) {
            throw new SysServiceAPIRuntimeException(this, String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3[%1$s]\u6a21\u5f0f\u4e3a[\u4ece\u63a5\u53e3]\u5fc5\u987b\u540c\u65f6\u6307\u5b9a\u4e3b\u63a5\u53e3", iDEServiceAPIRuntime.getName()));
        }
        return iDEServiceAPIRuntime.wfCancel(strScope, iDEServiceAPIRSRuntime, strParentKey, strWFTag, objBody, strKey, objTag);
    }

    @Override
    public Object invokeDEDownloadFile(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strKey, String strStorageField, File file, Object objBody, Object objTag) throws Throwable {
        String strMinorDEServiceAPIName;
        IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime = null;
        if (StringUtils.hasLength((String)strParentDEName) && !(strMinorDEServiceAPIName = (iDEServiceAPIRSRuntime = this.getDEServiceAPIRSRuntime(String.format("%1$s|%2$s", strParentDEName, strDataEntityName).toUpperCase(), false)).getMinorDEServiceAPIRuntime().getName()).equalsIgnoreCase(strDataEntityName)) {
            log.debug((Object)String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3\u6807\u8bc6\u8c03\u6574[%1$s] => [%2$s]", strDataEntityName, strMinorDEServiceAPIName));
            strDataEntityName = strMinorDEServiceAPIName;
        }
        IDEServiceAPIRuntime iDEServiceAPIRuntime = this.getDEServiceAPIRuntime(strDataEntityName, false);
        if (iDEServiceAPIRSRuntime == null && iDEServiceAPIRuntime.getAPIMode() == 0) {
            throw new SysServiceAPIRuntimeException(this, String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3[%1$s]\u6a21\u5f0f\u4e3a[\u4ece\u63a5\u53e3]\u5fc5\u987b\u540c\u65f6\u6307\u5b9a\u4e3b\u63a5\u53e3", iDEServiceAPIRuntime.getName()));
        }
        return iDEServiceAPIRuntime.downloadFile(strScope, iDEServiceAPIRSRuntime, strParentKey, strKey, strStorageField, file, objBody, objTag);
    }

    @Override
    public Object invokeDEUploadFile(String strScope, String strParentDEName, String strParentKey, String strDataEntityName, String strKey, String strStorageField, File file, Object objBody, Object objTag) throws Throwable {
        String strMinorDEServiceAPIName;
        IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime = null;
        if (StringUtils.hasLength((String)strParentDEName) && !(strMinorDEServiceAPIName = (iDEServiceAPIRSRuntime = this.getDEServiceAPIRSRuntime(String.format("%1$s|%2$s", strParentDEName, strDataEntityName).toUpperCase(), false)).getMinorDEServiceAPIRuntime().getName()).equalsIgnoreCase(strDataEntityName)) {
            log.debug((Object)String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3\u6807\u8bc6\u8c03\u6574[%1$s] => [%2$s]", strDataEntityName, strMinorDEServiceAPIName));
            strDataEntityName = strMinorDEServiceAPIName;
        }
        IDEServiceAPIRuntime iDEServiceAPIRuntime = this.getDEServiceAPIRuntime(strDataEntityName, false);
        if (iDEServiceAPIRSRuntime == null && iDEServiceAPIRuntime.getAPIMode() == 0) {
            throw new SysServiceAPIRuntimeException(this, String.format("\u5b9e\u4f53\u670d\u52a1\u63a5\u53e3[%1$s]\u6a21\u5f0f\u4e3a[\u4ece\u63a5\u53e3]\u5fc5\u987b\u540c\u65f6\u6307\u5b9a\u4e3b\u63a5\u53e3", iDEServiceAPIRuntime.getName()));
        }
        return iDEServiceAPIRuntime.uploadFile(strScope, iDEServiceAPIRSRuntime, strParentKey, strKey, strStorageField, file, objBody, objTag);
    }
}

