/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.service;

import java.util.HashMap;
import net.ibizsys.central.ISystemRuntime;
import net.ibizsys.central.service.ISubSysServiceAPIDERuntime;
import net.ibizsys.central.service.ISubSysServiceAPIRuntime;
import net.ibizsys.central.service.ISubSysServiceAPIRuntimeContext;
import net.ibizsys.central.service.SubSysServiceAPIRuntimeException;
import net.ibizsys.central.sysutil.IObjectStorageServiceAdapter;
import net.ibizsys.model.service.IPSSubSysServiceAPIDEMethod;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.domain.File;
import org.springframework.util.StringUtils;

public class SubSysServiceAPIOSSAdapter
implements IObjectStorageServiceAdapter {
    private ISubSysServiceAPIRuntimeContext iSubSysServiceAPIRuntimeContext = null;
    private ISubSysServiceAPIDERuntime utilSubSysServiceAPIDERuntime = null;
    private IPSSubSysServiceAPIDEMethod uploadPSSubSysServiceAPIDEMethod = null;
    private IPSSubSysServiceAPIDEMethod downloadPSSubSysServiceAPIDEMethod = null;

    public SubSysServiceAPIOSSAdapter(ISubSysServiceAPIRuntimeContext iSubSysServiceAPIRuntimeContext) {
        this.iSubSysServiceAPIRuntimeContext = iSubSysServiceAPIRuntimeContext;
        this.utilSubSysServiceAPIDERuntime = this.getSubSysServiceAPIRuntime().getSubSysServiceAPIDERuntime("UTIL", false);
        this.uploadPSSubSysServiceAPIDEMethod = this.getUtilSubSysServiceAPIDERuntime().getPSSubSysServiceAPIDEMethod("UPLOADFILE", false);
        this.downloadPSSubSysServiceAPIDEMethod = this.getUtilSubSysServiceAPIDERuntime().getPSSubSysServiceAPIDEMethod("DOWNLOADFILE", false);
    }

    protected ISubSysServiceAPIRuntimeContext getSubSysServiceAPIRuntimeContext() {
        return this.iSubSysServiceAPIRuntimeContext;
    }

    protected ISubSysServiceAPIRuntime getSubSysServiceAPIRuntime() {
        return this.getSubSysServiceAPIRuntimeContext().getSubSysServiceAPIRuntime();
    }

    protected ISystemRuntime getSystemRuntime() {
        return this.getSubSysServiceAPIRuntime().getSystemRuntime();
    }

    protected ISubSysServiceAPIDERuntime getUtilSubSysServiceAPIDERuntime() {
        return this.utilSubSysServiceAPIDERuntime;
    }

    protected IPSSubSysServiceAPIDEMethod getUploadPSSubSysServiceAPIDEMethod() {
        return this.uploadPSSubSysServiceAPIDEMethod;
    }

    protected IPSSubSysServiceAPIDEMethod getDownloadPSSubSysServiceAPIDEMethod() {
        return this.downloadPSSubSysServiceAPIDEMethod;
    }

    @Override
    public File saveFile(File file, String strCat, Object objFile, Object objTag) {
        try {
            return this.onSaveFile(file, strCat, objFile, objTag);
        }
        catch (Throwable ex) {
            throw new SubSysServiceAPIRuntimeException(this.getSubSysServiceAPIRuntime(), String.format("\u4e0a\u4f20\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected File onSaveFile(File file, String strCat, Object objFile, Object objTag) throws Throwable {
        String strOSSId;
        HashMap<String, Object> context = new HashMap<String, Object>();
        if (StringUtils.hasLength((String)strCat)) {
            context.put("cat", strCat);
        } else {
            context.put("cat", "default");
        }
        Object objRet = this.getUtilSubSysServiceAPIDERuntime().invokeMethod(this.getUploadPSSubSysServiceAPIDEMethod(), context, objFile, null, objTag);
        if (!(objRet instanceof IEntity)) {
            throw new Exception("\u8fd4\u56de\u7ed3\u679c\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
        IEntity iEntity = (IEntity)objRet;
        if (file == null) {
            file = new File();
        }
        if (!StringUtils.hasLength((String)(strOSSId = DataTypeUtils.getStringValue(iEntity.get("id"), null)))) {
            throw new Exception("\u8fd4\u56de\u7ed3\u679c\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
        file.setOSSId(strOSSId);
        if (!StringUtils.hasLength((String)file.getFileId())) {
            file.setFileId(strOSSId);
        }
        file.setFolder(DataTypeUtils.getStringValue(iEntity.get("folder"), null));
        return file;
    }

    @Override
    public File getFile(String strId, String strCat, Object objFile, Object objTag) {
        try {
            return this.onGetFile(strId, strCat, objFile, objTag);
        }
        catch (Throwable ex) {
            throw new SubSysServiceAPIRuntimeException(this.getSubSysServiceAPIRuntime(), String.format("\u4e0b\u8f7d\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected File onGetFile(String strId, String strCat, Object objFile, Object objTag) throws Throwable {
        HashMap<String, Object> context = new HashMap<String, Object>();
        if (StringUtils.hasLength((String)this.getDownloadPSSubSysServiceAPIDEMethod().getRequestField())) {
            context.put(this.getDownloadPSSubSysServiceAPIDEMethod().getRequestField(), strId);
        } else {
            context.put("id", strId);
        }
        if (StringUtils.hasLength((String)strCat)) {
            context.put("cat", strCat);
        } else {
            context.put("cat", "default");
        }
        Object objRet = this.getUtilSubSysServiceAPIDERuntime().invokeMethod(this.getDownloadPSSubSysServiceAPIDEMethod(), context, objFile, null, objTag);
        if (!(objRet instanceof IEntity)) {
            throw new Exception("\u8fd4\u56de\u7ed3\u679c\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
        IEntity iEntity = (IEntity)objRet;
        File file = new File();
        iEntity.copyTo(file);
        file.setOSSId(strId);
        file.setFileId(strId);
        return file;
    }
}

