/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.eai;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.ibizsys.central.ISystemRuntime;
import net.ibizsys.central.ISystemRuntimeSetting;
import net.ibizsys.central.eai.ISysEAIAgentRuntime;
import net.ibizsys.central.eai.ISysEAIMsgListener;
import net.ibizsys.model.PSModelUtils;
import net.ibizsys.model.res.IPSSysDataSyncAgent;
import net.ibizsys.model.system.IPSSystemModule;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.ISystemRuntimeBaseContext;
import net.ibizsys.runtime.ISystemRuntimeException;
import net.ibizsys.runtime.SystemRuntimeException;
import net.ibizsys.runtime.dataentity.datasync.IDEDataSyncInRuntime;
import net.ibizsys.runtime.res.SysDataSyncAgentRuntimeBase;
import net.ibizsys.runtime.security.IUserContext;
import net.ibizsys.runtime.security.UserContext;
import net.ibizsys.runtime.util.ActionSessionManager;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.JsonUtils;
import net.ibizsys.runtime.util.domain.DataSyncIn;
import net.ibizsys.runtime.util.domain.DataSyncOut;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class SysEAIAgentRuntimeBase
extends SysDataSyncAgentRuntimeBase
implements ISysEAIAgentRuntime {
    private static final Log log = LogFactory.getLog(SysEAIAgentRuntimeBase.class);
    public static final String PARAM_TRANSACTED = "TRANSACTED";
    private String strServiceUrl = null;
    private String strClientId = null;
    private String strClientSecret = null;
    private String strAuthMode = null;
    private String strAuthParam = null;
    private String strAuthParam2 = null;
    private String strServiceParam = null;
    private String strServiceParam2 = null;
    private List<String> topics = null;
    private String strDefaultTopic = null;
    private String strGroupId = null;
    private boolean bTransacted = false;
    private String strAgentType = null;
    private List<ISysEAIMsgListener> sysEAIMsgListenerList = null;

    public static String getConfigFolder(IPSSysDataSyncAgent iPSSysDataSyncAgent) {
        return "syseaiagent." + PSModelUtils.calcUniqueTag((IPSSystemModule)iPSSysDataSyncAgent.getPSSystemModule(), (String)iPSSysDataSyncAgent.getCodeName());
    }

    @Override
    public void init(ISystemRuntimeBaseContext iSystemRuntimeBaseContext, IPSSysDataSyncAgent iPSSysDataSyncAgent) throws Exception {
        Assert.notNull((Object)iPSSysDataSyncAgent, (String)"\u672a\u4f20\u5165\u7cfb\u7edf\u6570\u636e\u540c\u6b65\u4ee3\u7406\u8fd0\u884c\u65f6\u5bf9\u8c61");
        this.setConfigFolder("syseaiagent." + PSModelUtils.calcUniqueTag((IPSSystemModule)iPSSysDataSyncAgent.getPSSystemModule(), (String)iPSSysDataSyncAgent.getCodeName()));
        super.init(iSystemRuntimeBaseContext, iPSSysDataSyncAgent);
    }

    @Override
    protected void onInit() throws Exception {
        this.setServiceUrl(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".serviceurl", this.getPSSysDataSyncAgent().getServicePath()));
        this.setClientId(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".clientid", this.getPSSysDataSyncAgent().getAuthClientId()));
        this.setClientSecret(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".clientsecret", this.getPSSysDataSyncAgent().getAuthClientSecret()));
        this.setAuthMode(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".authmode", this.getPSSysDataSyncAgent().getAuthMode()));
        this.setAuthParam(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".authparam", this.getPSSysDataSyncAgent().getAuthParam()));
        this.setAuthParam2(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".authparam2", this.getPSSysDataSyncAgent().getAuthParam2()));
        this.setServiceParam(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".serviceparam", this.getPSSysDataSyncAgent().getServiceParam()));
        this.setServiceParam2(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".serviceparam2", this.getPSSysDataSyncAgent().getServiceParam2()));
        this.setAgentType(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".agenttype", this.getPSSysDataSyncAgent().getAgentType()));
        String strTopic = this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".topic", this.getPSSysDataSyncAgent().getTopic());
        if (!StringUtils.hasLength((String)strTopic) && StringUtils.hasLength((String)this.getPSSysDataSyncAgent().getCodeName())) {
            strTopic = this.getPSSysDataSyncAgent().getCodeName().toLowerCase();
        }
        if (StringUtils.hasLength((String)strTopic)) {
            String[] topics = strTopic.split("[;]");
            this.setTopics(Arrays.asList(topics));
            this.setDefaultTopic(topics[0]);
        }
        this.setTransacted(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".transacted", DataTypeUtils.getBooleanValue(this.getAgentParam(PARAM_TRANSACTED, null), false)));
        this.setGroupId(this.getSystemRuntimeSetting().getParam(this.getConfigFolder() + ".groupid", this.getPSSysDataSyncAgent().getGroupId()));
        if (!StringUtils.hasLength((String)this.getGroupId())) {
            this.setGroupId(this.getSystemRuntime().getDeploySystemId());
        }
        super.onInit();
    }

    @Override
    public ISystemRuntime getSystemRuntime() {
        return (ISystemRuntime)super.getSystemRuntime();
    }

    @Override
    public ISystemRuntimeSetting getSystemRuntimeSetting() {
        if (this.getSystemRuntime() != null) {
            return this.getSystemRuntime().getSystemRuntimeSetting();
        }
        return null;
    }

    @Override
    public void send(String strTopic, String strData) {
        try {
            this.onSend(strTopic, strData);
        }
        catch (Throwable ex) {
            if (ex instanceof ISystemRuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new SystemRuntimeException(this.getSystemRuntimeBase(), (IModelRuntime)this, String.format("\u53d1\u9001\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected void onSend(String strTopic, String strData) throws Throwable {
        throw new Exception("\u6ca1\u6709\u5b9e\u73b0");
    }

    @Override
    public String getServiceUrl() {
        return this.strServiceUrl;
    }

    protected void setServiceUrl(String strServiceUrl) {
        this.strServiceUrl = strServiceUrl;
    }

    @Override
    public String getServiceParam() {
        return this.strServiceParam;
    }

    protected void setServiceParam(String strServiceParam) {
        this.strServiceParam = strServiceParam;
    }

    @Override
    public String getServiceParam2() {
        return this.strServiceParam2;
    }

    protected void setServiceParam2(String strServiceParam2) {
        this.strServiceParam2 = strServiceParam2;
    }

    @Override
    public String getClientId() {
        return this.strClientId;
    }

    protected void setClientId(String strClientId) {
        this.strClientId = strClientId;
    }

    @Override
    public String getClientSecret() {
        return this.strClientSecret;
    }

    protected void setClientSecret(String strClientSecret) {
        this.strClientSecret = strClientSecret;
    }

    @Override
    public String getAuthMode() {
        return this.strAuthMode;
    }

    protected void setAuthMode(String strAuthMode) {
        this.strAuthMode = strAuthMode;
    }

    @Override
    public List<String> getTopics() {
        return this.topics;
    }

    protected void setTopics(List<String> topics) {
        this.topics = topics;
    }

    @Override
    public String getDefaultTopic() {
        return this.strDefaultTopic;
    }

    protected void setDefaultTopic(String strDefaultTopic) {
        this.strDefaultTopic = strDefaultTopic;
    }

    @Override
    public String getAuthParam() {
        return this.strAuthParam;
    }

    protected void setAuthParam(String strAuthParam) {
        this.strAuthParam = strAuthParam;
    }

    @Override
    public String getAuthParam2() {
        return this.strAuthParam2;
    }

    protected void setAuthParam2(String strAuthParam2) {
        this.strAuthParam2 = strAuthParam2;
    }

    @Override
    public String getGroupId() {
        return this.strGroupId;
    }

    protected void setGroupId(String strGroupId) {
        this.strGroupId = strGroupId;
    }

    public boolean isTransacted() {
        return this.bTransacted;
    }

    public void setTransacted(boolean bTransacted) {
        this.bTransacted = bTransacted;
    }

    protected void setAgentType(String strAgentType) {
        this.strAgentType = strAgentType;
    }

    @Override
    public String getAgentType() {
        return this.strAgentType;
    }

    @Override
    protected void onSend(String strSendData, DataSyncOut[] dataSyncOuts) throws Throwable {
        this.send(null, strSendData);
    }

    @Override
    public void recv(String strTopic, String strData) {
        try {
            this.onRecv(strTopic, strData);
        }
        catch (Throwable ex) {
            if (ex instanceof ISystemRuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new SystemRuntimeException(this.getSystemRuntimeBase(), (IModelRuntime)this, String.format("\u5904\u7406\u63a5\u6536\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected void onRecv(String strTopic, String strData) throws Throwable {
        this.onRecv(strTopic, strData, null);
    }

    protected void onRecv(String strTopic, String strData, Map<String, Object> map) throws Throwable {
        List<IDEDataSyncInRuntime> deDataSyncInRuntimeList;
        List<ISysEAIMsgListener> list;
        boolean bResetUserContext = false;
        IUserContext iUserContext = ActionSessionManager.getUserContext();
        if (iUserContext == null) {
            iUserContext = this.getSystemRuntime().createDefaultUserContext();
            UserContext.setCurrent(iUserContext);
            bResetUserContext = true;
        }
        if ((list = this.getSysEAIMsgListenerList()) != null) {
            for (ISysEAIMsgListener iSysEAIMsgListener : list) {
                try {
                    iSysEAIMsgListener.recv(strTopic, strData);
                }
                catch (Throwable ex) {
                    log.error((Object)String.format("\u7cfb\u7edf\u5e94\u7528\u96c6\u6210\u4ee3\u7406[%1$s]\u5904\u7406\u63a5\u6536\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), ex);
                    this.getSystemRuntime().log(40000, "\u6570\u636e\u540c\u6b65", String.format("\u7cfb\u7edf\u5e94\u7528\u96c6\u6210\u4ee3\u7406[%1$s]\u5904\u7406\u63a5\u6536\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), null);
                }
            }
        }
        if (!ObjectUtils.isEmpty(deDataSyncInRuntimeList = this.getDEDataSyncInRuntimeList())) {
            try {
                if (!this.isRawDataMode()) {
                    String strRealData;
                    Object objAgent;
                    if (map == null) {
                        map = this.getRecvDataMap(strData);
                    }
                    String strSyncAgent = (objAgent = map.get("agent")) == null ? null : objAgent.toString();
                    Object objData = map.get("data");
                    if (objData instanceof String && StringUtils.hasLength((String)(strRealData = (String)objData))) {
                        List<DataSyncIn> dataSyncInList = null;
                        if (strRealData.indexOf("[") == 0) {
                            dataSyncInList = (List)JsonUtils.MAPPER.readValue(strRealData, (TypeReference)new TypeReference<List<DataSyncIn>>(){});
                        } else {
                            dataSyncInList = new ArrayList();
                            DataSyncIn dataSyncIn = (DataSyncIn)JsonUtils.MAPPER.readValue(strRealData, DataSyncIn.class);
                            dataSyncInList.add(dataSyncIn);
                        }
                        if (StringUtils.hasLength((String)strSyncAgent)) {
                            for (DataSyncIn dataSyncIn : dataSyncInList) {
                                dataSyncIn.setSyncAgent(strSyncAgent);
                            }
                        }
                        DataSyncIn[] dataSyncIns = dataSyncInList.toArray(new DataSyncIn[dataSyncInList.size()]);
                        this.recv(dataSyncIns);
                    }
                } else {
                    DataSyncIn dataSyncIn = new DataSyncIn();
                    dataSyncIn.setData(strData);
                    dataSyncIn.setEventType(1);
                    this.recv(new DataSyncIn[]{dataSyncIn});
                }
            }
            catch (Throwable ex) {
                log.error((Object)String.format("\u7cfb\u7edf\u5e94\u7528\u96c6\u6210\u4ee3\u7406[%1$s]\u5904\u7406\u63a5\u6536\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), ex);
                this.getSystemRuntime().log(40000, "\u6570\u636e\u540c\u6b65", String.format("\u7cfb\u7edf\u5e94\u7528\u96c6\u6210\u4ee3\u7406[%1$s]\u5904\u7406\u63a5\u6536\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), null);
            }
        }
        if (bResetUserContext) {
            UserContext.setCurrent(null);
        }
    }

    protected Map<String, Object> getRecvDataMap(String strData) throws Throwable {
        return (Map)JsonUtils.MAPPER.readValue(strData, Map.class);
    }

    @Override
    public synchronized void registerSysEAIMsgListener(ISysEAIMsgListener iSysEAIMsgListener) {
        if (!"IN".equals(this.getPSSysDataSyncAgent().getSyncDir()) && !"INOUT".equals(this.getPSSysDataSyncAgent().getSyncDir())) {
            throw new SystemRuntimeException(this.getSystemRuntimeBase(), this, String.format("\u7cfb\u7edf\u6570\u636e\u540c\u6b65\u4ee3\u7406[%1$s]\u4e0d\u662f\u8f93\u5165\u4ee3\u7406", this.getPSSysDataSyncAgent().getName()));
        }
        List<ISysEAIMsgListener> list = this.getSysEAIMsgListenerList();
        ArrayList<ISysEAIMsgListener> newList = new ArrayList<ISysEAIMsgListener>();
        if (list != null) {
            newList.addAll(list);
        }
        newList.add(iSysEAIMsgListener);
        this.setSysEAIMsgListenerList(newList);
    }

    @Override
    public synchronized void unregisterSysEAIMsgListener(ISysEAIMsgListener iSysEAIMsgListener) {
        List<ISysEAIMsgListener> list = this.getSysEAIMsgListenerList();
        if (list == null) {
            return;
        }
        ArrayList<ISysEAIMsgListener> newList = new ArrayList<ISysEAIMsgListener>();
        newList.addAll(list);
        newList.remove(iSysEAIMsgListener);
        if (newList.size() == 0) {
            this.setSysEAIMsgListenerList(null);
        } else {
            this.setSysEAIMsgListenerList(newList);
        }
    }

    protected List<ISysEAIMsgListener> getSysEAIMsgListenerList() {
        return this.sysEAIMsgListenerList;
    }

    protected void setSysEAIMsgListenerList(List<ISysEAIMsgListener> sysEAIMsgListenerList) {
        this.sysEAIMsgListenerList = sysEAIMsgListenerList;
    }

    @Override
    public void shutdown() throws Exception {
        this.onShutdown();
    }

    protected void onShutdown() throws Exception {
    }
}

