/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central.dataentity.dataimport;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.ibizsys.central.dataentity.DataEntityModelRuntimeBase;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.dataimport.IDEDataImportRuntime;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.central.util.ISearchContextDTO;
import net.ibizsys.central.util.SearchContextDTO;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.codelist.IPSCodeItem;
import net.ibizsys.model.dataentity.dataimport.IPSDEDataImport;
import net.ibizsys.model.dataentity.dataimport.IPSDEDataImportItem;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.defield.IPSLinkDEField;
import net.ibizsys.model.dataentity.der.IPSDER1N;
import net.ibizsys.model.dataentity.der.IPSDERBase;
import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.codelist.ICodeListRuntime;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeBase;
import net.ibizsys.runtime.dataentity.IDataEntityRuntimeBaseContext;
import net.ibizsys.runtime.security.IUserContext;
import net.ibizsys.runtime.security.UserContext;
import net.ibizsys.runtime.util.EntityError;
import net.ibizsys.runtime.util.IEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DEDataImportRuntime
extends DataEntityModelRuntimeBase
implements IDEDataImportRuntime {
    private static final Log log = LogFactory.getLog(DEDataImportRuntime.class);
    private IDataEntityRuntimeBaseContext iDataEntityRuntimeBaseContext = null;
    private IPSDEDataImport iPSDEDataImport = null;

    @Override
    public void init(IDataEntityRuntimeBaseContext iDataEntityRuntimeBaseContext, IPSDEDataImport iPSDEDataImport) throws Exception {
        this.iDataEntityRuntimeBaseContext = iDataEntityRuntimeBaseContext;
        this.iPSDEDataImport = iPSDEDataImport;
        this.setDataEntityRuntimeBase(this.iDataEntityRuntimeBaseContext.getDataEntityRuntime());
        this.onInit();
    }

    @Override
    public IPSDEDataImport getPSDEDataImport() {
        return this.iPSDEDataImport;
    }

    @Override
    public IPSModelObject getPSModelObject() {
        return this.getPSDEDataImport();
    }

    protected IUserContext getUserContext() {
        return UserContext.getCurrent();
    }

    @Override
    public Map<Integer, EntityError> importData(IEntity baseEntity, List<Map<String, Object>> list, boolean bTestPriv) throws Throwable {
        return this.importData(baseEntity, list, bTestPriv, null, null);
    }

    @Override
    public Map<Integer, EntityError> importFile(IEntity baseEntity, File file, boolean bTestPriv, IDataEntityRuntime parentDataEntityRuntime, String strParentKey) throws Throwable {
        try (FileInputStream inputStream = new FileInputStream(file);){
            Map<Integer, EntityError> map = this.importStream(baseEntity, (InputStream)inputStream, bTestPriv, parentDataEntityRuntime, strParentKey);
            return map;
        }
    }

    @Override
    public Map<Integer, EntityError> importStream(IEntity baseEntity, InputStream inputStream, boolean bTestPriv, IDataEntityRuntime parentDataEntityRuntime, String strParentKey) throws Throwable {
        throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), (IModelRuntime)this, null, 20);
    }

    @Override
    public Map<Integer, EntityError> importData(IEntity baseEntity, List<Map<String, Object>> list, boolean bTestPriv, IDataEntityRuntime parentDataEntityRuntime, String strParentKey) throws Throwable {
        int i;
        IPSDEField iPSDEField;
        if (ObjectUtils.isEmpty(list)) {
            throw new DataEntityRuntimeException(this.getDataEntityRuntimeBase(), this, "\u6ca1\u6709\u4f20\u5165\u5bfc\u5165\u6570\u636e");
        }
        TreeMap<Integer, EntityError> entityErrorMap = new TreeMap<Integer, EntityError>();
        boolean bIgnoreError = this.isIgnoreError();
        Map<String, IPSDEDataImportItem> psDEDataImportItemMap = this.getPSDEDataImportItems();
        if (psDEDataImportItemMap == null || psDEDataImportItemMap.size() == 0) {
            throw new DataEntityRuntimeException(this.getDataEntityRuntimeBase(), this, String.format("\u6ca1\u6709\u5b9a\u4e49\u4efb\u4f55\u5bfc\u5165\u9879", new Object[0]));
        }
        HashMap<String, ICodeListRuntime> codeListRuntimeMap = new HashMap<String, ICodeListRuntime>();
        HashMap<String, IPSDERBase> psDERBaseMap = new HashMap<String, IPSDERBase>();
        HashMap<String, IPSLinkDEField> relatedPSDEFieldMap = new HashMap<String, IPSLinkDEField>();
        HashMap<String, IPSDEField> psDEFieldMap = new HashMap<String, IPSDEField>();
        HashMap<String, IPSDEField> uniquePSDEFieldMap = new HashMap<String, IPSDEField>();
        for (Map.Entry<String, IPSDEDataImportItem> entry : psDEDataImportItemMap.entrySet()) {
            IPSDERBase iPSDERBase;
            psDEFieldMap.put(entry.getValue().getPSDEFieldMust().getLowerCaseName(), entry.getValue().getPSDEFieldMust());
            if (!entry.getValue().isUniqueItem()) continue;
            iPSDEField = entry.getValue().getPSDEFieldMust();
            if (("PICKUPDATA".equals(iPSDEField.getDataType()) || "PICKUPTEXT".equals(iPSDEField.getDataType())) && (iPSDERBase = ((IPSLinkDEField)iPSDEField).getPSDERMust()) instanceof IPSDER1N) {
                iPSDEField = ((IPSDER1N)iPSDERBase).getPSPickupDEFieldMust();
            }
            uniquePSDEFieldMap.put(iPSDEField.getLowerCaseName(), iPSDEField);
        }
        for (Map.Entry<String, IPSDEDataImportItem> entry : psDEDataImportItemMap.entrySet()) {
            if (entry.getValue().getPSCodeList() == null) continue;
            ICodeListRuntime iCodeListRuntime = this.getSystemRuntimeBase().getCodeListRuntime(entry.getValue().getPSCodeList());
            codeListRuntimeMap.put(entry.getKey(), iCodeListRuntime);
        }
        block6: for (Map.Entry<String, IPSDEDataImportItem> entry : psDEDataImportItemMap.entrySet()) {
            iPSDEField = entry.getValue().getPSDEFieldMust();
            if (!(iPSDEField instanceof IPSLinkDEField)) continue;
            IPSLinkDEField iPSLinkDEField = (IPSLinkDEField)iPSDEField;
            IPSDERBase iPSDERBase = null;
            if ("INHERIT".equals(iPSLinkDEField.getDataType())) {
                IPSDEField relatedPSDEField = iPSLinkDEField.getRelatedPSDEFieldMust();
                while (relatedPSDEField != null && relatedPSDEField instanceof IPSLinkDEField) {
                    if ("INHERIT".endsWith(relatedPSDEField.getDataType())) {
                        relatedPSDEField = ((IPSLinkDEField)relatedPSDEField).getRelatedPSDEFieldMust();
                        continue;
                    }
                    iPSDERBase = ((IPSLinkDEField)relatedPSDEField).getPSDERMust();
                    psDERBaseMap.put(entry.getKey(), iPSDERBase);
                    relatedPSDEFieldMap.put(entry.getKey(), (IPSLinkDEField)relatedPSDEField);
                    continue block6;
                }
                continue;
            }
            iPSDERBase = iPSLinkDEField.getPSDERMust();
            psDERBaseMap.put(entry.getKey(), iPSDERBase);
            relatedPSDEFieldMap.put(entry.getKey(), iPSLinkDEField);
        }
        HashMap<String, Object> fieldValueCacheMap = new HashMap<String, Object>();
        HashMap<Integer, IEntityDTO> entityMap = new HashMap<Integer, IEntityDTO>();
        for (i = 0; i < list.size(); ++i) {
            boolean bError = false;
            IEntityDTO iEntity = this.getDataEntityRuntime().createEntity();
            Map<String, Object> map = list.get(i);
            block9: for (Map.Entry<String, Object> entry : map.entrySet()) {
                Object objRealValue;
                if (ObjectUtils.isEmpty((Object)entry.getValue())) continue;
                String string = entry.getKey();
                if (StringUtils.isEmpty((Object)string)) {
                    if (bIgnoreError) {
                        bError = true;
                        EntityError entityError = new EntityError();
                        entityError.setErrorInfo(String.format("\u6ca1\u6709\u6307\u5b9a\u5bfc\u5165\u6807\u8bb0", new Object[0]));
                        entityErrorMap.put(i, entityError);
                        break;
                    }
                    throw new DataEntityRuntimeException(this.getDataEntityRuntimeBase(), this, String.format("\u5bfc\u5165\u6570\u636e[%1$s]\u6ca1\u6709\u5bfc\u5165\u6807\u8bb0", i));
                }
                String string2 = string.toUpperCase();
                IPSDEDataImportItem iPSDEDataImportItem = psDEDataImportItemMap.get(string2);
                if (iPSDEDataImportItem == null) {
                    if (bIgnoreError) {
                        bError = true;
                        EntityError entityError = new EntityError();
                        entityError.setErrorInfo(String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u6807\u8bb0[%1$s]\u5bf9\u5e94\u7684\u5bfc\u5165\u9879", string2));
                        entityErrorMap.put(i, entityError);
                        break;
                    }
                    throw new DataEntityRuntimeException(this.getDataEntityRuntimeBase(), this, String.format("\u5bfc\u5165\u6570\u636e[%1$s]\u6307\u5b9a\u6807\u8bb0[%2$s]\u65e0\u6cd5\u8bc6\u522b", i, string2));
                }
                IPSDEField iPSDEField2 = iPSDEDataImportItem.getPSDEFieldMust();
                String strContent = String.valueOf(entry.getValue());
                ICodeListRuntime iCodeListRuntime = (ICodeListRuntime)codeListRuntimeMap.get(string2);
                if (iCodeListRuntime != null) {
                    String strCacheTag = String.format("%1$s|%2$s", iPSDEField2.getLowerCaseName(), strContent);
                    if (fieldValueCacheMap.containsKey(strCacheTag)) {
                        objRealValue = fieldValueCacheMap.get(strCacheTag);
                        this.getDataEntityRuntime().setFieldValue(iEntity, iPSDEField2, objRealValue);
                        continue;
                    }
                    String strDataType = iPSDEField2.getDataType();
                    if ("NMCODELIST".equals(strDataType) || "SMCODELIST".equals(strDataType)) {
                        boolean bNumberMode = "NMCODELIST".equals(strDataType);
                        int nRealValue = 0;
                        String strRealValue = "";
                        Object strNewContent = strContent;
                        strNewContent = ((String)strNewContent).replace("|", ";");
                        strNewContent = ((String)strNewContent).replace(",", ";");
                        strNewContent = ((String)strNewContent).replace("\uff0c", ";");
                        strNewContent = ((String)strNewContent).replace("\u3001", ";");
                        String[] stringArray = ((String)strNewContent).split("[;]");
                        boolean bValueMode = false;
                        for (int l = 0; l < stringArray.length; ++l) {
                            String strText = stringArray[l];
                            IPSCodeItem iPSCodeItem = iCodeListRuntime.getPSCodeItemByText(strText, this.getUserContext(), true);
                            if (iPSCodeItem == null) {
                                bValueMode = true;
                                continue block9;
                            }
                            if (bNumberMode) {
                                nRealValue |= Integer.parseInt(iPSCodeItem.getValue());
                            } else {
                                if (!StringUtils.isEmpty((Object)strRealValue)) {
                                    strRealValue = strRealValue + iCodeListRuntime.getValueSeparator();
                                }
                                strRealValue = strRealValue + iPSCodeItem.getValue();
                            }
                            if (bValueMode) {
                                if (bNumberMode) {
                                    nRealValue = Integer.parseInt(String.valueOf(entry.getValue()));
                                    this.getDataEntityRuntime().setFieldValue(iEntity, iPSDEField2, nRealValue);
                                    fieldValueCacheMap.put(strCacheTag, nRealValue);
                                    continue;
                                }
                                strRealValue = ((String)strNewContent).replace(";", iCodeListRuntime.getValueSeparator());
                                this.getDataEntityRuntime().setFieldValue(iEntity, iPSDEField2, strRealValue);
                                fieldValueCacheMap.put(strCacheTag, strRealValue);
                                continue;
                            }
                            if (bNumberMode) {
                                this.getDataEntityRuntime().setFieldValue(iEntity, iPSDEField2, nRealValue);
                                fieldValueCacheMap.put(strCacheTag, nRealValue);
                                continue;
                            }
                            iEntity.set(iPSDEField2.getLowerCaseName(), (Object)strRealValue);
                            this.getDataEntityRuntime().setFieldValue(iEntity, iPSDEField2, strRealValue);
                            fieldValueCacheMap.put(strCacheTag, strRealValue);
                        }
                        continue;
                    }
                    IPSCodeItem iPSCodeItem = iCodeListRuntime.getPSCodeItemByText(strContent, this.getUserContext(), true);
                    if (iPSCodeItem == null) {
                        iPSCodeItem = iCodeListRuntime.getPSCodeItem(strContent, true);
                        if (iPSCodeItem != null || strContent.equalsIgnoreCase(iCodeListRuntime.getEmptyText())) continue;
                        if (bIgnoreError) {
                            bError = true;
                            EntityError entityError = new EntityError();
                            entityError.setErrorInfo(String.format("\u9879[%1$s]\u503c[%2$s]\u65e0\u6cd5\u88ab\u4ee3\u7801\u8868[%3$s]\u8bc6\u522b", string2, strContent, iCodeListRuntime.getName()));
                            entityErrorMap.put(i, entityError);
                            break;
                        }
                        throw new DataEntityRuntimeException(this.getDataEntityRuntimeBase(), this, String.format("\u5bfc\u5165\u6570\u636e[%1$s]\u9879[%2$s]\u503c[%3$s]\u65e0\u6cd5\u88ab\u4ee3\u7801\u8868[%4$s]\u8bc6\u522b", i, string2, strContent, iCodeListRuntime.getName()));
                    }
                    Object objRealValue2 = this.getDataEntityRuntime().convertValue(iPSDEField2.getStdDataType(), iPSCodeItem.getValue());
                    this.getDataEntityRuntime().setFieldValue(iEntity, iPSDEField2, objRealValue2);
                    fieldValueCacheMap.put(strCacheTag, objRealValue2);
                    continue;
                }
                IPSDERBase iPSDERBase = (IPSDERBase)psDERBaseMap.get(string2);
                if (iPSDERBase != null) {
                    IPSLinkDEField iPSLinkPSDEField = (IPSLinkDEField)relatedPSDEFieldMap.get(string2);
                    if ("PICKUP".equals(iPSLinkPSDEField.getDataType())) {
                        this.getDataEntityRuntime().setFieldValue(iEntity, iPSDEField2, this.getDataEntityRuntime().convertValue(iPSDEField2.getStdDataType(), strContent));
                        continue;
                    }
                    if (!"PICKUPTEXT".equals(iPSLinkPSDEField.getDataType()) && (!this.isEnablePickupDataField() || !"PICKUPDATA".equals(iPSLinkPSDEField.getDataType())) || !(iPSDERBase instanceof IPSDER1N)) continue;
                    IPSDER1N iPSDER1N = (IPSDER1N)iPSDERBase;
                    if (this.isFillPickupTextField()) {
                        this.getDataEntityRuntime().setFieldValue(iEntity, iPSDEField2, this.getDataEntityRuntime().convertValue(iPSDEField2.getStdDataType(), strContent));
                    }
                    if (psDEFieldMap.containsKey(iPSDER1N.getPSPickupDEFieldMust().getLowerCaseName())) continue;
                    IDataEntityRuntime majorDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(iPSDER1N.getMajorPSDataEntityMust().getId());
                    ISearchContextDTO iSearchContextDTO = majorDataEntityRuntime.createSearchContext();
                    SearchContextDTO.addSearchFieldCond(iSearchContextDTO, iPSLinkPSDEField.getRelatedPSDEFieldMust().getLowerCaseName(), "EQ", strContent, null);
                    for (Map.Entry entry2 : psDERBaseMap.entrySet()) {
                        Object conten2;
                        IPSLinkDEField iPSLinkPSDEField2;
                        if (((String)entry2.getKey()).equals(string2) || !((IPSDERBase)entry2.getValue()).getId().equals(iPSDERBase.getId()) || (iPSLinkPSDEField2 = (IPSLinkDEField)relatedPSDEFieldMap.get(entry2.getKey())) == null || (conten2 = map.get(entry2.getKey())) == null) continue;
                        String strContent2 = String.valueOf(conten2);
                        SearchContextDTO.addSearchFieldCond(iSearchContextDTO, iPSLinkPSDEField2.getRelatedPSDEFieldMust().getLowerCaseName(), "EQ", strContent2, null);
                    }
                    String strCacheTag = iPSDER1N.getPSPickupDEFieldMust().getLowerCaseName() + ";";
                    Assert.notNull(iSearchContextDTO.any(), (String)"\u641c\u7d22\u8fc7\u6ee4\u5668\u76f4\u63a5\u53d8\u91cf\u5bf9\u8c61\u65e0\u6548");
                    for (Map.Entry<String, Object> entry23 : iSearchContextDTO.any().entrySet()) {
                        strCacheTag = strCacheTag + String.format("%1$s|%2$s;", entry23.getKey(), entry23.getValue());
                    }
                    if (fieldValueCacheMap.containsKey(strCacheTag)) {
                        Object v = fieldValueCacheMap.get(strCacheTag);
                        this.getDataEntityRuntime().setFieldValue(iEntity, (IPSDEField)iPSDER1N.getPSPickupDEFieldMust(), v);
                        continue;
                    }
                    majorDataEntityRuntime.setSearchPaging(iSearchContextDTO, 0, 2);
                    List<IEntityDTO> list2 = majorDataEntityRuntime.select(iSearchContextDTO);
                    if (list2 == null || list2.size() != 1) {
                        if (bIgnoreError) {
                            bError = true;
                            EntityError entityError = new EntityError();
                            entityError.setErrorInfo(String.format("\u9879[%1$s]\u503c[%2$s]\u65e0\u6cd5\u88ab\u5b9e\u4f53[%3$s]\u8bc6\u522b", string2, strContent, majorDataEntityRuntime.getPSDataEntity().getLogicName()));
                            entityErrorMap.put(i, entityError);
                            break;
                        }
                        throw new DataEntityRuntimeException(this.getDataEntityRuntimeBase(), this, String.format("\u5bfc\u5165\u6570\u636e[%1$s]\u9879[%2$s]\u503c[%3$s]\u65e0\u6cd5\u88ab\u5b9e\u4f53[%4$s]\u8bc6\u522b", i, string2, strContent, majorDataEntityRuntime.getPSDataEntity().getLogicName()));
                    }
                    Object objRealValue4 = majorDataEntityRuntime.getFieldValue(list2.get(0), majorDataEntityRuntime.getKeyPSDEField());
                    this.getDataEntityRuntime().setFieldValue(iEntity, (IPSDEField)iPSDER1N.getPSPickupDEFieldMust(), objRealValue4);
                    fieldValueCacheMap.put(strCacheTag, objRealValue4);
                    continue;
                }
                try {
                    objRealValue = this.getDataEntityRuntime().convertValue(iPSDEField2.getStdDataType(), strContent);
                }
                catch (Exception e) {
                    if (bIgnoreError) {
                        bError = true;
                        EntityError entityError = new EntityError();
                        entityError.setErrorInfo(String.format("\u9879[%1$s]\u503c[%2$s]\u4e0d\u7b26\u5408\u683c\u5f0f\u8981\u6c42", string2, strContent));
                        entityErrorMap.put(i, entityError);
                        break;
                    }
                    throw new DataEntityRuntimeException(this.getDataEntityRuntimeBase(), this, String.format("\u9879[%1$s]\u503c[%2$s]\u4e0d\u7b26\u5408\u683c\u5f0f\u8981\u6c42", string2, strContent));
                }
                this.getDataEntityRuntime().setFieldValue(iEntity, iPSDEField2, objRealValue);
            }
            if (bError) continue;
            entityMap.put(i, iEntity);
        }
        for (i = 0; i < list.size(); ++i) {
            IEntity iEntity = (IEntity)entityMap.get(i);
            if (iEntity == null) continue;
            if (baseEntity != null) {
                baseEntity.copyTo(iEntity);
            }
            boolean bCreate = true;
            if (uniquePSDEFieldMap.size() > 0) {
                boolean bSearch = true;
                ISearchContextDTO iSearchContextDTO = this.getDataEntityRuntime().createSearchContext();
                for (Map.Entry entry : uniquePSDEFieldMap.entrySet()) {
                    Object objValue = iEntity.get(((IPSDEField)entry.getValue()).getLowerCaseName());
                    if (ObjectUtils.isEmpty((Object)objValue)) {
                        bSearch = false;
                        break;
                    }
                    SearchContextDTO.addSearchFieldCond(iSearchContextDTO, ((IPSDEField)entry.getValue()).getLowerCaseName(), "EQ", objValue, null);
                }
                if (bSearch) {
                    this.getDataEntityRuntime().setSearchPaging(iSearchContextDTO, 0, 2);
                    List<IEntityDTO> entityList = this.getDataEntityRuntime().selectSimple(iSearchContextDTO);
                    if (entityList != null) {
                        if (entityList.size() > 1) {
                            if (bIgnoreError) {
                                EntityError entityError = new EntityError();
                                entityError.setErrorInfo(String.format("\u5bfc\u5165\u6570\u636e[%1$s]\u8bc6\u522b\u6807\u8bb0\u65e0\u6cd5\u786e\u5b9a\u552f\u4e00\u6570\u636e", i));
                                entityErrorMap.put(i, entityError);
                                continue;
                            }
                            throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), this, String.format("\u5bfc\u5165\u6570\u636e[%1$s]\u8bc6\u522b\u6807\u8bb0\u65e0\u6cd5\u786e\u5b9a\u552f\u4e00\u6570\u636e", i));
                        }
                        if (entityList.size() == 1) {
                            bCreate = false;
                            this.getDataEntityRuntime().setFieldValue(iEntity, this.getDataEntityRuntime().getKeyPSDEField(), this.getDataEntityRuntime().getFieldValue(entityList.get(0), this.getDataEntityRuntime().getKeyPSDEField()));
                        }
                    }
                }
            }
            try {
                if (bTestPriv) {
                    if (bCreate) {
                        this.getDataEntityRuntime().getDataEntityAccessManager().testDataAccessAction(this.getUserContext(), parentDataEntityRuntime, strParentKey, null, (IEntityDTO)iEntity, this.getPSDEDataImport().getCreateDataAccessAction());
                    } else {
                        this.getDataEntityRuntime().getDataEntityAccessManager().testDataAccessAction(this.getUserContext(), parentDataEntityRuntime, strParentKey, this.getDataEntityRuntime().getFieldValue(iEntity, this.getDataEntityRuntime().getKeyPSDEField()), (IEntityDTO)iEntity, this.getPSDEDataImport().getUpdateDataAccessAction());
                    }
                }
                if (bCreate) {
                    if (this.getPSDEDataImport().getCreatePSDEAction() != null) {
                        this.getDataEntityRuntime().executeAction(this.getPSDEDataImport().getCreatePSDEAction().getName(), this.getPSDEDataImport().getCreatePSDEAction(), new Object[]{iEntity});
                        continue;
                    }
                    this.getDataEntityRuntime().create(iEntity);
                    continue;
                }
                if (this.getPSDEDataImport().getUpdatePSDEAction() != null) {
                    this.getDataEntityRuntime().executeAction(this.getPSDEDataImport().getUpdatePSDEAction().getName(), this.getPSDEDataImport().getUpdatePSDEAction(), new Object[]{iEntity});
                    continue;
                }
                this.getDataEntityRuntime().update(iEntity);
                continue;
            }
            catch (Throwable ex) {
                if (bIgnoreError) {
                    EntityError entityError = new EntityError();
                    entityError.setErrorInfo(String.format("\u5bfc\u5165\u6570\u636e[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", i, ex.getMessage()));
                    entityErrorMap.put(i, entityError);
                    continue;
                }
                throw new DataEntityRuntimeException((IDataEntityRuntimeBase)this.getDataEntityRuntime(), (IModelRuntime)this, String.format("\u5bfc\u5165\u6570\u636e[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", i, ex.getMessage()), ex);
            }
        }
        if (entityErrorMap.size() == 0) {
            return null;
        }
        return entityErrorMap;
    }

    protected Map<String, IPSDEDataImportItem> getPSDEDataImportItems() throws Throwable {
        IUserContext iUserContext = this.getUserContext();
        HashMap<String, IPSDEDataImportItem> psDEDataImportItemMap = new HashMap<String, IPSDEDataImportItem>();
        List psDEDataImportItems = this.getPSDEDataImport().getPSDEDataImportItems();
        if (psDEDataImportItems != null) {
            for (IPSDEDataImportItem iPSDEDataImportItem : psDEDataImportItems) {
                String strImportTag = null;
                strImportTag = iPSDEDataImportItem.getCapPSLanguageRes() != null ? iUserContext.getLocalization(iPSDEDataImportItem.getCapPSLanguageRes().getLanResTag(), iPSDEDataImportItem.getCaption()) : iPSDEDataImportItem.getCaption();
                if (psDEDataImportItemMap.containsKey(strImportTag = strImportTag.toUpperCase())) {
                    throw new DataEntityRuntimeException(this.getDataEntityRuntimeBase(), this, String.format("\u51fa\u73b0\u91cd\u590d\u7684\u5bfc\u5165\u6807\u8bc6[%1$s]", strImportTag));
                }
                if (iPSDEDataImportItem.getPSDEField() == null) {
                    throw new DataEntityRuntimeException(this.getDataEntityRuntimeBase(), this, String.format("\u5bfc\u5165\u9879[%1$s]\u6ca1\u6709\u6307\u5b9a\u5c5e\u6027", strImportTag));
                }
                psDEDataImportItemMap.put(strImportTag, iPSDEDataImportItem);
            }
        }
        return psDEDataImportItemMap;
    }

    public boolean isEnablePickupDataField() {
        return true;
    }

    public boolean isFillPickupTextField() {
        return false;
    }

    public boolean isIgnoreError() {
        return this.getPSDEDataImport().isIgnoreError();
    }

    @Override
    public Map<Integer, EntityError> importData(IEntity baseEntity, List<Map<String, Object>> list, boolean bTestPriv, net.ibizsys.runtime.dataentity.IDataEntityRuntime parentDataEntityRuntime, String strParentKey) throws Throwable {
        return this.importData(baseEntity, list, bTestPriv, (IDataEntityRuntime)parentDataEntityRuntime, strParentKey);
    }

    @Override
    public Map<Integer, EntityError> importFile(IEntity baseEntity, File file, boolean bTestPriv, net.ibizsys.runtime.dataentity.IDataEntityRuntime parentDataEntityRuntime, String strParentKey) throws Throwable {
        return this.importFile(baseEntity, file, bTestPriv, (IDataEntityRuntime)parentDataEntityRuntime, strParentKey);
    }

    @Override
    public Map<Integer, EntityError> importStream(IEntity baseEntity, InputStream inputStream, boolean bTestPriv, net.ibizsys.runtime.dataentity.IDataEntityRuntime parentDataEntityRuntime, String strParentKey) throws Throwable {
        return this.importStream(baseEntity, inputStream, bTestPriv, (IDataEntityRuntime)parentDataEntityRuntime, strParentKey);
    }

    @Override
    public void getImportTemplate(String strImportTag, OutputStream outputStream, boolean bTestPriv, IDataEntityRuntime parentDataEntityRuntime, String strParentKey) throws Throwable {
        throw new Exception("\u6ca1\u6709\u5b9e\u73b0");
    }
}

