/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.central;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.ibizsys.central.ISystemLogListener;
import net.ibizsys.central.ISystemLogListenerProxy;
import net.ibizsys.central.SimpleSystemLogAdapter;
import net.ibizsys.central.ba.ISysBDSchemeRuntime;
import net.ibizsys.runtime.security.IUserContext;
import net.ibizsys.runtime.util.ActionSessionManager;
import net.ibizsys.runtime.util.domain.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultSystemLogAdapter
extends SimpleSystemLogAdapter
implements ISystemLogListenerProxy {
    private static final org.apache.commons.logging.Log logger = LogFactory.getLog(DefaultSystemLogAdapter.class);
    public static final String RTLOG_TABLENAME = "_rt_log";
    public static final String RTAUDITLOG_TABLENAME = "_rt_auditlog";
    public static final String RTEVENTLOG_TABLENAME = "_rt_eventlog";
    public static final String RTPOLOG_TABLENAME = "_rt_polog";
    private List<ISystemLogListener> systemLogListenerList = null;
    private ConcurrentLinkedQueue<Log> logList = new ConcurrentLinkedQueue();
    private boolean bLogThreadRun = false;
    private boolean bEnableBDSchemeLog = false;

    @Override
    protected void onInit() throws Exception {
        super.onInit();
        this.startLogThread();
    }

    protected void startLogThread() {
        this.setLogThreadRun(true);
        new Thread(new Runnable(){

            @Override
            public void run() {
                DefaultSystemLogAdapter.this.runLogThread();
            }
        }).start();
    }

    @Override
    public synchronized void registerSystemLogListener(ISystemLogListener iSystemLogListener) {
        List<ISystemLogListener> list = this.getSystemLogListenerList();
        ArrayList<ISystemLogListener> newList = new ArrayList<ISystemLogListener>();
        if (list != null) {
            newList.addAll(list);
        }
        newList.add(iSystemLogListener);
        this.setSystemLogListenerList(newList);
    }

    @Override
    public synchronized void unregisterSystemLogListener(ISystemLogListener iSystemLogListener) {
        List<ISystemLogListener> list = this.getSystemLogListenerList();
        if (list == null) {
            return;
        }
        ArrayList<ISystemLogListener> newList = new ArrayList<ISystemLogListener>();
        newList.addAll(list);
        newList.remove(iSystemLogListener);
        if (newList.size() == 0) {
            this.setSystemLogListenerList(null);
        } else {
            this.setSystemLogListenerList(newList);
        }
    }

    protected List<ISystemLogListener> getSystemLogListenerList() {
        return this.systemLogListenerList;
    }

    protected void setSystemLogListenerList(List<ISystemLogListener> systemLogListenerList) {
        this.systemLogListenerList = systemLogListenerList;
    }

    protected ISysBDSchemeRuntime getSysBDSchemeRuntime() {
        return this.getSystemRuntimeContext().getSystemRuntime().getDefaultSysBDSchemeRuntime();
    }

    @Override
    public void log(int nLogLevel, String strCat, String strInfo, Object objData) {
        super.log(nLogLevel, strCat, strInfo, objData);
        Log log = new Log();
        log.setLogType("NORMAL");
        log.setLogTime(new Timestamp(System.currentTimeMillis()));
        log.setLogLevel(nLogLevel);
        log.setLogCat(strCat);
        log.setInfo(strInfo);
        this.appendLogList(log, objData);
    }

    @Override
    public void logAudit(int nLogLevel, String strCat, String strInfo, String strPersonId, String strAddress, Object objData) {
        super.logAudit(nLogLevel, strCat, strInfo, strPersonId, strAddress, objData);
        Log log = new Log();
        log.setLogType("AUDIT");
        log.setLogTime(new Timestamp(System.currentTimeMillis()));
        log.setLogLevel(nLogLevel);
        log.setLogCat(strCat);
        log.setInfo(strInfo);
        log.setUserId(strPersonId);
        log.setRemoteAddress(strAddress);
        IUserContext iUserContext = ActionSessionManager.getUserContext();
        if (iUserContext != null) {
            log.setTenant(iUserContext.getTenant());
            log.setOrgId(iUserContext.getOrgid());
            log.setDeptId(iUserContext.getDeptid());
        }
        this.appendLogList(log, objData);
    }

    @Override
    public void logEvent(int nLogLevel, String strCat, String strInfo, Object objData) {
        super.logEvent(nLogLevel, strCat, strInfo, objData);
        Log log = new Log();
        log.setLogType("EVENT");
        log.setLogTime(new Timestamp(System.currentTimeMillis()));
        log.setLogLevel(nLogLevel);
        log.setLogCat(strCat);
        log.setInfo(strInfo);
        this.appendLogList(log, objData);
    }

    @Override
    public void logPO(int nLogLevel, String strCat, String strInfo, String strDEName, String strAction, long nTime, Object objData) {
        super.logPO(nLogLevel, strCat, strInfo, strDEName, strAction, nTime, objData);
        Log log = new Log();
        log.setLogType("PO");
        log.setLogTime(new Timestamp(System.currentTimeMillis()));
        log.setLogLevel(nLogLevel);
        log.setLogCat(strCat);
        log.setInfo(strInfo);
        log.setActionOwner(strDEName);
        log.setAction(strAction);
        log.setActionDuration((int)nTime);
        this.appendLogList(log, objData);
    }

    protected void appendLogList(Log log, Object objData) {
        if (this.isLogThreadRun()) {
            this.logList.add(log);
        }
    }

    protected boolean isLogThreadRun() {
        return this.bLogThreadRun;
    }

    protected void setLogThreadRun(boolean bLogThreadRun) {
        this.bLogThreadRun = bLogThreadRun;
    }

    protected void runLogThread() {
        while (this.isLogThreadRun()) {
            Log log = this.logList.poll();
            if (log != null) {
                this.onThreadLog(log);
                continue;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                this.setLogThreadRun(false);
                logger.error((Object)e);
                break;
            }
        }
    }

    protected void onThreadLog(Log log) {
        List<ISystemLogListener> list;
        ISysBDSchemeRuntime iSysBDSchemeRuntime;
        if (this.isEnableBDSchemeLog() && (iSysBDSchemeRuntime = this.getSysBDSchemeRuntime()) != null) {
            try {
                if (log.any() != null) {
                    String strLogType = log.getLogType();
                    if ("AUDIT".equals(strLogType)) {
                        iSysBDSchemeRuntime.insert(RTAUDITLOG_TABLENAME, log.any(), null);
                    } else if ("EVENT".equals(strLogType)) {
                        iSysBDSchemeRuntime.insert(RTEVENTLOG_TABLENAME, log.any(), null);
                    } else if ("PO".equals(strLogType)) {
                        iSysBDSchemeRuntime.insert(RTPOLOG_TABLENAME, log.any(), null);
                    } else {
                        iSysBDSchemeRuntime.insert(RTLOG_TABLENAME, log.any(), null);
                    }
                }
            }
            catch (Throwable ex) {
                logger.debug((Object)String.format("\u5b58\u50a8\u5927\u6570\u636e\u65e5\u5fd7\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
            }
        }
        if ((list = this.getSystemLogListenerList()) != null) {
            for (ISystemLogListener iSystemLogListener : list) {
                try {
                    iSystemLogListener.log(log);
                }
                catch (Throwable ex) {
                    logger.debug((Object)String.format("\u65e5\u5fd7\u4fa6\u542c\u5bf9\u8c61\u65e5\u5fd7\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
                }
            }
        }
    }

    public void setEnableBDSchemeLog(boolean bEnableBDSchemeLog) {
        this.bEnableBDSchemeLog = bEnableBDSchemeLog;
    }

    public boolean isEnableBDSchemeLog() {
        return this.bEnableBDSchemeLog;
    }
}

