package net.ibizsys.runtime.util;

import org.springframework.data.domain.Sort;

/**
 * 搜索上下文对象接口
 * @author lionlau
 *
 */
public interface ISearchContext extends ISearchContextBase{

	/**
	 * 起始页码
	 */
	final static int STARTPAGE = 0;
	
	
	/**
	 * 默认页大小
	 */
	final static int DEFAULTPAGESIZE = 1000;
	
	/**
	 * 获取分页排序信息
	 * @return
	 */
	Sort getPageSort();
	
	
	/**
	 * 设置分页排序信息
	 */
	void setPageSort(Sort sort);
}
