package net.ibizsys.runtime.res;

import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.PSModelUtils;
import net.ibizsys.model.res.IPSSysTranslator;
import net.ibizsys.runtime.ISystemRuntimeBaseContext;
import net.ibizsys.runtime.SystemModelRuntimeBase;

/**
 * 系统值转换器运行时基类
 * 
 * @author lionlau
 *
 */
public abstract class SysTranslatorRuntimeBase extends SystemModelRuntimeBase implements ISysTranslatorRuntime {

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(SysTranslatorRuntimeBase.class);
	private IPSSysTranslator iPSSysTranslator = null;

	@Override
	public void init(ISystemRuntimeBaseContext iSystemRuntimeBaseContext, IPSSysTranslator iPSSysTranslator) throws Exception {
		this.setSystemRuntimeBaseContext(iSystemRuntimeBaseContext);
		this.iPSSysTranslator = iPSSysTranslator;
		
		this.setConfigFolder("systranslator." + PSModelUtils.calcUniqueTag(this.iPSSysTranslator.getPSSystemModule(), this.iPSSysTranslator.getCodeName()));
		
		this.onInit();
	}

	@Override
	public IPSSysTranslator getPSSysTranslator() {
		return this.iPSSysTranslator;
	}

	@Override
	public String getId() {
		return getPSSysTranslator().getDynaModelFilePath();
	}

	@Override
	public String getName() {
		return getPSSysTranslator().getName();
	}

	@Override
	public IPSModelObject getPSModelObject() {
		return this.getPSSysTranslator();
	}

}
