package net.ibizsys.central.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.util.Assert;

import com.fasterxml.jackson.annotation.JsonIgnore;

import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.service.IDEMethodDTO;
import net.ibizsys.central.dataentity.service.IDEMethodDTORuntime;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.service.IPSDEMethodDTOField;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.service.DEMethodDTOFieldTypes;
import net.ibizsys.runtime.dataentity.service.DEMethodDTOTypes;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.DataTypes;
import net.ibizsys.runtime.util.EntityBase;
import net.ibizsys.runtime.util.IEntity;

@SuppressWarnings("serial")
public class EntityDTO extends EntityBase implements IEntityDTO {

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(EntityDTO.class);
	
	@JsonIgnore
	private transient IDEMethodDTORuntime iDEMethodDTORuntime = null;
	
	@JsonIgnore
	private boolean bActionInputDTO = false;

	@JsonIgnore
	private boolean bEnableAny = false;
	
	@Override
	public void init(IDEMethodDTORuntime iDEMethodDTORuntime, Object dtoData, boolean bDTOData, boolean bIn) throws Exception {
		this.iDEMethodDTORuntime = iDEMethodDTORuntime;
		if(this.getDEMethodDTORuntime() == null) {
			throw new Exception("传入实体方法DTO运行时对象无效");
		}
		bEnableAny = this.getDEMethodDTORuntime().isEnableAny();
		if(DEMethodDTOTypes.DEACTIONINPUT.equals(this.getDEMethodDTORuntime().getPSDEMethodDTO().getType())) {
			bActionInputDTO = true;
		}
		reload(dtoData, bDTOData, bIn);
		onInit();
	}
	

	@Override
	public void init(IDEMethodDTORuntime iDEMethodDTORuntime, Object dtoData, boolean bDTOData) throws Exception {
		init(iDEMethodDTORuntime, dtoData, bDTOData, false);
	}

	protected void onInit() throws Exception {

	}
	
	@Override
	@JsonIgnore
	public void setDEMethodDTORuntime(IDEMethodDTORuntime iDEMethodDTORuntime) {
		this.iDEMethodDTORuntime = iDEMethodDTORuntime;
		this.bEnableAny = false;
		this.bActionInputDTO = false;
		if(this.getDEMethodDTORuntime() != null) {
			bEnableAny = this.getDEMethodDTORuntime().isEnableAny();
			if(DEMethodDTOTypes.DEACTIONINPUT.equals(this.getDEMethodDTORuntime().getPSDEMethodDTO().getType())) {
				bActionInputDTO = true;
			}
		}
	}

	@JsonIgnore
	private boolean isActionInputDTO() {
		return this.bActionInputDTO;
	}
	
	
	@Override
	@JsonIgnore
	public IDEMethodDTORuntime getDEMethodDTORuntime() {
		return this.iDEMethodDTORuntime;
	}

	@Override
	@JsonIgnore
	public void reload(Object objData, boolean bDTOData) throws Exception{
		reload(objData, bDTOData, false);
	}

	@Override
	@JsonIgnore
	public void reload(Object objData, boolean bDTOData, boolean bIn) throws Exception{
		if(objData == null) {
			this.setAny(null);
			return;
		}
		if(bDTOData) {
			//DTO 数据为直接缓存
			if (objData instanceof IEntityDTO) {
				//需要判断DTO是否一致
				IEntityDTO srcEntityDTO = (IEntityDTO)objData;
				if(srcEntityDTO.getDEMethodDTORuntime()!=null && this.getDEMethodDTORuntime() !=null && this.getDEMethodDTORuntime().getId().equals(srcEntityDTO.getDEMethodDTORuntime().getId())) {
					this.setAny(((IEntityDTO) objData).any(), true);
				}
				else {
					//不一致，使用复制方式
					this.setAny(null);
					if(getDEMethodDTORuntime()!=null) {
						List<IPSDEMethodDTOField> psDEMethodDTOFieldList = getDEMethodDTORuntime().getPSDEMethodDTO().getPSDEMethodDTOFields();
						if(psDEMethodDTOFieldList != null) {
							for(IPSDEMethodDTOField iPSDEMethodDTOField : psDEMethodDTOFieldList) {
								
								Object objValue = null;
								IPSDEField iPSDEField = iPSDEMethodDTOField.getPSDEField();
								if(iPSDEField != null){
									if(srcEntityDTO.contains(iPSDEField.getLowerCaseName())) {
										objValue = srcEntityDTO.get(iPSDEField.getLowerCaseName());
									}
									else {
										continue;
									}	
								}
								else {
									if(srcEntityDTO.contains(iPSDEMethodDTOField.getLowerCaseName())) {
										objValue = srcEntityDTO.get(iPSDEMethodDTOField.getLowerCaseName());
									}
									else {
										continue;
									}
								}
								
								//进行值转化
								if(objValue != null) {
									if(DEMethodDTOFieldTypes.SIMPLE.equals(iPSDEMethodDTOField.getType())
												||DEMethodDTOFieldTypes.SIMPLES.equals(iPSDEMethodDTOField.getType())) {
										int nStdDataType = iPSDEMethodDTOField.getStdDataType();
										if(nStdDataType != DataTypes.UNKNOWN){
											try {
												if(DEMethodDTOFieldTypes.SIMPLE.equals(iPSDEMethodDTOField.getType())) {
													objValue = this.getDEMethodDTORuntime().getSystemRuntime().convertValue(nStdDataType, objValue);
												}
												else {
													objValue = this.getDEMethodDTORuntime().getSystemRuntime().convertListValue(nStdDataType, objValue);
												}
												
											} catch (Exception ex) {
												throw new DataEntityRuntimeException(this.getDEMethodDTORuntime().getDataEntityRuntime() ,String.format("转化数据[%1$s]至[%2$s]发生异常，%3$s", objValue, DataTypeUtils.getTypeName(nStdDataType), ex.getMessage())	,ex);
											}
										}
									}
									
								}
								
								
								super.set(iPSDEMethodDTOField.getLowerCaseName(), objValue);
							}
						}
						
						//复制非DTO属性
						if(srcEntityDTO.any()!=null) {
							for(java.util.Map.Entry<String ,Object> entry:srcEntityDTO.any().entrySet()) {
								String strName = entry.getKey().toLowerCase();
								if(!super.contains(strName)) {
									super.set(strName, entry.getValue());
								}
							}
						}
					}
					else {
						this.setAny(((IEntityDTO) objData).any(), true);
					}
				}
			}
			else {
				Map<String,Object> srcmap = null;
				if (objData instanceof Map) {
					srcmap = (Map<String,Object>)objData;
				}
				else
					if (objData instanceof IEntity) {
						srcmap = ((IEntity)objData).any();
					}
					else {
						throw new Exception("无法识别的数据对象");
					}
				
				Map<String, Object> map = this.createAny();
				map.putAll(srcmap);
				
				
				//对成员数据进行转化
				if(getDEMethodDTORuntime() != null) {
					List<IPSDEMethodDTOField> psDEMethodDTOFieldList = getDEMethodDTORuntime().getPSDEMethodDTO().getPSDEMethodDTOFields();
					if(psDEMethodDTOFieldList != null) {
						for(IPSDEMethodDTOField iPSDEMethodDTOField : psDEMethodDTOFieldList) {
							Object dtoData = map.get(iPSDEMethodDTOField.getLowerCaseName());
							if(DEMethodDTOFieldTypes.DTO.equals(iPSDEMethodDTOField.getType())
									||DEMethodDTOFieldTypes.DTOS.equals(iPSDEMethodDTOField.getType())) {
								if(dtoData != null) {
									IDataEntityRuntime refDataEntityRuntime = this.getDEMethodDTORuntime().getSystemRuntime().getDataEntityRuntime(iPSDEMethodDTOField.getRefPSDataEntityMust().getId());
									if(DEMethodDTOFieldTypes.DTOS.equals(iPSDEMethodDTOField.getType())) {
										//列表模式
										if(!(dtoData instanceof List)) {
											throw new DataEntityRuntimeException(this.getDEMethodDTORuntime().getDataEntityRuntime(), this.getDEMethodDTORuntime(), String.format("属性[%1$s]传入数据类型不正确", iPSDEMethodDTOField.getName()));
										}
										List list = (List)dtoData;
										List dtoList=  new ArrayList();
										for(Object item : list) {
											IDEMethodDTO iDEMethodDTO = refDataEntityRuntime.getDEMethodDTO(iPSDEMethodDTOField.getRefPSDEMethodDTOMust(), item);
											dtoList.add(iDEMethodDTO);
											
										}
										map.put(iPSDEMethodDTOField.getLowerCaseName(), dtoList);
									}
									else {
										IDEMethodDTO iDEMethodDTO = refDataEntityRuntime.getDEMethodDTO(iPSDEMethodDTOField.getRefPSDEMethodDTOMust(), dtoData);
										map.put(iPSDEMethodDTOField.getLowerCaseName(), iDEMethodDTO);
									}
								}
								continue;
							}
							else 
								if(DEMethodDTOFieldTypes.SIMPLE.equals(iPSDEMethodDTOField.getType())
										||DEMethodDTOFieldTypes.SIMPLES.equals(iPSDEMethodDTOField.getType())) {
									//进行值转化
									if(dtoData != null) {
										int nStdDataType = iPSDEMethodDTOField.getStdDataType();
										if(nStdDataType != DataTypes.UNKNOWN){
											try {
												if(DEMethodDTOFieldTypes.SIMPLE.equals(iPSDEMethodDTOField.getType())) {
													dtoData = this.getDEMethodDTORuntime().getSystemRuntime().convertValue(nStdDataType, dtoData);
												}
												else {
													dtoData = this.getDEMethodDTORuntime().getSystemRuntime().convertListValue(nStdDataType, dtoData);
												}
											} catch (Exception ex) {
												throw new DataEntityRuntimeException(this.getDEMethodDTORuntime().getDataEntityRuntime() ,String.format("转化数据[%1$s]至[%2$s]发生异常，%3$s", dtoData, DataTypeUtils.getTypeName(nStdDataType), ex.getMessage())	,ex);
											}
											map.put(iPSDEMethodDTOField.getLowerCaseName(), dtoData);
										}
									}
									continue;
								}
								else {
									throw new DataEntityRuntimeException(this.getDEMethodDTORuntime().getDataEntityRuntime() ,String.format("无法识别的DTO属性类型[%1$s]", iPSDEMethodDTOField.getType()));
								}
						}
					}
				}
				
				this.setAny(map);
			}
			
		}
		else {
			this.setAny(null);
			//需要进行转化
			Map<String,Object> srcmap = null;
			if (objData instanceof Map) {
				srcmap = (Map<String,Object>)objData;
			}
			else
				if (objData instanceof IEntity) {
					srcmap = ((IEntity)objData).any();
				}
				else {
					throw new Exception("无法识别的数据对象");
				}
			
			Map<String, Object> map = this.createAny();
			map.putAll(srcmap);
			
			if (map!=null) {
				if(getDEMethodDTORuntime()!=null) {
					List<IPSDEMethodDTOField> psDEMethodDTOFieldList = getDEMethodDTORuntime().getPSDEMethodDTO().getPSDEMethodDTOFields();
					if(psDEMethodDTOFieldList != null) {
						for(IPSDEMethodDTOField iPSDEMethodDTOField : psDEMethodDTOFieldList) {
							Object objValue = null;
							IPSDEField iPSDEField = iPSDEMethodDTOField.getPSDEField();
							if(iPSDEField != null){
								if(map.containsKey(iPSDEField.getLowerCaseName())) {
									objValue = map.remove(iPSDEField.getLowerCaseName());
								}
								else
									if(map.containsKey(iPSDEField.getName())) {
										objValue = map.remove(iPSDEField.getName());
									}
									else {
										continue;
									}
							}
							else {
								if(map.containsKey(iPSDEMethodDTOField.getLowerCaseName())) {
									objValue = map.remove(iPSDEMethodDTOField.getLowerCaseName());
								}
								else {
									continue;
								}
							}
							
							//进行值转化
							if(objValue != null) {
								if(DEMethodDTOFieldTypes.SIMPLE.equals(iPSDEMethodDTOField.getType())
										||DEMethodDTOFieldTypes.SIMPLES.equals(iPSDEMethodDTOField.getType())) {
									int nStdDataType = iPSDEMethodDTOField.getStdDataType();
									if(nStdDataType != DataTypes.UNKNOWN){
										try {
											if(DEMethodDTOFieldTypes.SIMPLE.equals(iPSDEMethodDTOField.getType())) {
												objValue = this.getDEMethodDTORuntime().getSystemRuntime().convertValue(nStdDataType, objValue);
											}
											else {
												objValue = this.getDEMethodDTORuntime().getSystemRuntime().convertListValue(nStdDataType, objValue);
											}
										} catch (Exception ex) {
											throw new DataEntityRuntimeException(this.getDEMethodDTORuntime().getDataEntityRuntime() ,String.format("转化数据[%1$s]至[%2$s]发生异常，%3$s", objValue, DataTypeUtils.getTypeName(nStdDataType), ex.getMessage())	,ex);
										}
									}
								}
							}
							
							super.set(iPSDEMethodDTOField.getLowerCaseName(), objValue);
						}
					}
					
					//复制非DTO属性
					for(java.util.Map.Entry<String ,Object> entry:map.entrySet()) {
						String strName = entry.getKey().toLowerCase();
						if(!super.contains(strName)) {
							super.set(strName, entry.getValue());
						}
					}
				}
				else {
					this.setAny(map);
				}
				
			}
			
		}
		
		if(bIn) {
			this.resetReadOnlyFields();
		}
	}
	
	

	@Override
	public Object get(String strName) {
		
		Assert.hasLength(strName, "传入属性名无效");
		
		if(this.getDEMethodDTORuntime() != null) {
			if(isActionInputDTO()) {
				IPSDEMethodDTOField iPSDEMethodDTOField = this.getDEMethodDTORuntime().getPSDEMethodDTOField(strName, true);
				if(iPSDEMethodDTOField == null) {
					if(this.isEnableAny()) {
						return super.get(strName.toLowerCase());
					}
					return null;
				}
				return super.get(iPSDEMethodDTOField.getLowerCaseName());
			}
			else{
				IPSDEMethodDTOField iPSDEMethodDTOField = this.getDEMethodDTORuntime().getPSDEMethodDTOFieldByDEField(strName, true);
				if(iPSDEMethodDTOField == null) {
					if(this.isEnableAny()) {
						return super.get(strName.toLowerCase());
					}
					return null;
				}
				return super.get(iPSDEMethodDTOField.getLowerCaseName());
			}
		}
		else {
			return super.get(strName);
		}
	}

	@Override
	public void set(String strName, Object objValue) {
		
		Assert.hasLength(strName, "传入属性名无效");
		
		if(this.getDEMethodDTORuntime() != null) {
			if(isActionInputDTO()) {
				IPSDEMethodDTOField iPSDEMethodDTOField = this.getDEMethodDTORuntime().getPSDEMethodDTOField(strName, true);
				if(iPSDEMethodDTOField == null) {
					if(this.isEnableAny()) {
						super.set(strName.toLowerCase(), objValue);
					}
					else {
						log.warn(String.format("DTO对象[%1$s]不支持属性[%2$s]，无法设置值", this.getDEMethodDTORuntime().getId(), strName));
					}
				}
				else {
					//进行值转化
					if(objValue != null) {
						if(DEMethodDTOFieldTypes.SIMPLE.equals(iPSDEMethodDTOField.getType())
								||DEMethodDTOFieldTypes.SIMPLES.equals(iPSDEMethodDTOField.getType())) {
							int nStdDataType = iPSDEMethodDTOField.getStdDataType();
							if(nStdDataType != DataTypes.UNKNOWN){
								try {
									if(DEMethodDTOFieldTypes.SIMPLE.equals(iPSDEMethodDTOField.getType())) {
										objValue = this.getDEMethodDTORuntime().getSystemRuntime().convertValue(nStdDataType, objValue);
									}
									else {
										objValue = this.getDEMethodDTORuntime().getSystemRuntime().convertListValue(nStdDataType, objValue);
									}
								} catch (Exception ex) {
									throw new DataEntityRuntimeException(this.getDEMethodDTORuntime().getDataEntityRuntime() ,String.format("转化数据[%1$s]至[%2$s]发生异常，%3$s", objValue, DataTypeUtils.getTypeName(nStdDataType), ex.getMessage())	,ex);
								}
							}
						}
					}
					super.set(iPSDEMethodDTOField.getLowerCaseName(), objValue);
				}
			}
			else{
				IPSDEMethodDTOField iPSDEMethodDTOField = this.getDEMethodDTORuntime().getPSDEMethodDTOFieldByDEField(strName, true);
				if(iPSDEMethodDTOField == null) {
					if(this.isEnableAny()) {
						super.set(strName.toLowerCase(), objValue);
					}
					else {
						log.warn(String.format("DTO对象[%1$s]不支持属性[%2$s]，无法设置值", this.getDEMethodDTORuntime().getId(), strName));
					}
				}
				else {
					if(objValue != null) {
						if(DEMethodDTOFieldTypes.SIMPLE.equals(iPSDEMethodDTOField.getType())
								||DEMethodDTOFieldTypes.SIMPLES.equals(iPSDEMethodDTOField.getType())) {
							int nStdDataType = iPSDEMethodDTOField.getStdDataType();
							if(nStdDataType != DataTypes.UNKNOWN){
								try {
									if(DEMethodDTOFieldTypes.SIMPLE.equals(iPSDEMethodDTOField.getType())) {
										objValue = this.getDEMethodDTORuntime().getSystemRuntime().convertValue(nStdDataType, objValue);
									}
									else {
										objValue = this.getDEMethodDTORuntime().getSystemRuntime().convertListValue(nStdDataType, objValue);
									}
								} catch (Exception ex) {
									throw new DataEntityRuntimeException(this.getDEMethodDTORuntime().getDataEntityRuntime() ,String.format("转化数据[%1$s]至[%2$s]发生异常，%3$s", objValue, DataTypeUtils.getTypeName(nStdDataType), ex.getMessage())	,ex);
								}
							}
						}
					}
					super.set(iPSDEMethodDTOField.getLowerCaseName(), objValue);
				}
					
			}
		}
		else {
			super.set(strName, objValue);
			return;
		}
	}

	@Override
	public boolean contains(String strName) {
		
		Assert.hasLength(strName, "传入属性名无效");
		
		if(this.getDEMethodDTORuntime() != null) {
			if(isActionInputDTO()) {
				IPSDEMethodDTOField iPSDEMethodDTOField = this.getDEMethodDTORuntime().getPSDEMethodDTOField(strName, true);
				if(iPSDEMethodDTOField == null) {
					if(this.isEnableAny()) {
						return super.contains(strName.toLowerCase());
					}
					return false;
				}
				return super.contains(iPSDEMethodDTOField.getLowerCaseName());
			}
			else {
				IPSDEMethodDTOField iPSDEMethodDTOField = this.getDEMethodDTORuntime().getPSDEMethodDTOFieldByDEField(strName, true);
				if(iPSDEMethodDTOField == null) {
					if(this.isEnableAny()) {
						return super.contains(strName.toLowerCase());
					}
					return false;
				}
				return super.contains(iPSDEMethodDTOField.getLowerCaseName());
			}
		}
		else {
			return super.contains(strName);
		}
		
		
	}

	@Override
	public void reset(String strName) {
		
		Assert.hasLength(strName, "传入属性名无效");
		
		if(this.getDEMethodDTORuntime() != null) {
			if(isActionInputDTO()) {
				IPSDEMethodDTOField iPSDEMethodDTOField = this.getDEMethodDTORuntime().getPSDEMethodDTOField(strName, true);
				if(iPSDEMethodDTOField == null) {
					if(this.isEnableAny()) {
						super.reset(strName.toLowerCase());
					}
					else {
						log.warn(String.format("DTO对象[%1$s]不支持属性[%2$s]，无法重置值", this.getDEMethodDTORuntime().getId(), strName));
					}
				}
				else
					super.reset(iPSDEMethodDTOField.getLowerCaseName());
			}
			else {
				IPSDEMethodDTOField iPSDEMethodDTOField = this.getDEMethodDTORuntime().getPSDEMethodDTOFieldByDEField(strName, true);
				if(iPSDEMethodDTOField == null) {
					if(this.isEnableAny()) {
						super.reset(strName.toLowerCase());
					}
					else {
						log.warn(String.format("DTO对象[%1$s]不支持属性[%2$s]，无法重置值", this.getDEMethodDTORuntime().getId(), strName));
					}
				}
				else
					super.reset(iPSDEMethodDTOField.getLowerCaseName());
			}
		}
		else {
			super.reset(strName);
		}
		
		
	}
	
	@Override
	@JsonIgnore
	public void resetReadOnlyFields() {
		if(getDEMethodDTORuntime()!=null) {
			List<IPSDEMethodDTOField> psDEMethodDTOFieldList = getDEMethodDTORuntime().getPSDEMethodDTO().getPSDEMethodDTOFields();
			if(psDEMethodDTOFieldList != null) {
				for(IPSDEMethodDTOField iPSDEMethodDTOField : psDEMethodDTOFieldList) {
					if(iPSDEMethodDTOField.isReadOnly()) {
						super.reset(iPSDEMethodDTOField.getLowerCaseName());
					}
				}
			}
		}
	}
	

	@Override
	@JsonIgnore
	protected boolean isLowerCaseName() {
		if(this.getDEMethodDTORuntime() == null) {
			return super.isLowerCaseName();
		}
		return false;
	}

	//@Override
	@JsonIgnore
	private boolean isEnableAny() {
		
		return this.bEnableAny;
	}

	//@Override
	@JsonIgnore
	private void setEnableAny(boolean bEnableAny) {
		this.bEnableAny = bEnableAny;
	}

	@Override
	public void copyTo(IEntity iEntity) {
		copyTo(iEntity, false);
	}
	
	
	@Override
	public void copyTo(IEntity iEntity, boolean bDTOData) {
		Assert.notNull(iEntity, "传入目标对象无效");
		if(!bDTOData && getDEMethodDTORuntime() != null) {
			Map<String, Object> any = this.any();
			if(any == null || any.size() == 0) {
				return ;
			}
			
			Map<String, Object> map = new HashMap<String, Object>();
			map.putAll(any);
			
			List<IPSDEMethodDTOField> psDEMethodDTOFieldList = getDEMethodDTORuntime().getPSDEMethodDTO().getPSDEMethodDTOFields();
			if(psDEMethodDTOFieldList != null) {
				for(IPSDEMethodDTOField iPSDEMethodDTOField : psDEMethodDTOFieldList) {
					String strFieldName = iPSDEMethodDTOField.getLowerCaseName();
					if(!map.containsKey(strFieldName)) {
						continue;
					}
					
					Object objValue = map.remove(strFieldName);
					if(iPSDEMethodDTOField.getPSDEField() != null) {
						iEntity.set(iPSDEMethodDTOField.getPSDEField().getLowerCaseName(), objValue);
					}
					else {
						iEntity.set(strFieldName, objValue);
					}
				}
			}
			
			for(java.util.Map.Entry<String, Object> entry : map.entrySet()) {
				iEntity.set(entry.getKey(), entry.getValue());
			}
		}
		else {
			super.copyTo(iEntity);
		}
	}
	
	@Override
	public void copyTo(Map<String, Object> destMap) {
		this.copyTo(destMap, false);
	}
	
	@Override
	public void copyTo(Map<String, Object> destMap, boolean bDTOData) {
		Assert.notNull(destMap, "传入目标对象无效");
		if(!bDTOData && getDEMethodDTORuntime() != null) {
			Map<String, Object> any = this.any();
			if(any == null || any.size() == 0) {
				return ;
			}
			
			Map<String, Object> map = new HashMap<String, Object>();
			map.putAll(any);
			
			List<IPSDEMethodDTOField> psDEMethodDTOFieldList = getDEMethodDTORuntime().getPSDEMethodDTO().getPSDEMethodDTOFields();
			if(psDEMethodDTOFieldList != null) {
				for(IPSDEMethodDTOField iPSDEMethodDTOField : psDEMethodDTOFieldList) {
					String strFieldName = iPSDEMethodDTOField.getLowerCaseName();
					if(!map.containsKey(strFieldName)) {
						continue;
					}
					
					Object objValue = map.remove(strFieldName);
					if(iPSDEMethodDTOField.getPSDEField() != null) {
						destMap.put(iPSDEMethodDTOField.getPSDEField().getLowerCaseName(), objValue);
					}
					else {
						destMap.put(strFieldName, objValue);
					}
				}
			}
			
			for(java.util.Map.Entry<String, Object> entry : map.entrySet()) {
				destMap.put(entry.getKey(), entry.getValue());
			}
		}
		else {
			Map<String, Object> any = this.any();
			if(any == null || any.size() == 0) {
				return ;
			}
			destMap.putAll(any);
		}
	}
	
	
//	@Override
//	public void copyTo(Object destObject) {
//		Assert.notNull(destObject, "传入目标对象无效");
//		if(destObject instanceof IEntity) {
//			this.copyTo((IEntity)destObject);
//			return;
//		}
//		
//		if(destObject instanceof Map) {
//			this.copyTo((Map)destObject);
//			return;
//		}
//		
//	
//		BeanCopier.create(this.getClass(), destObject.getClass(), false).copy(this, destObject, null);
//	}
	
	
	
	@Override
	public void set(String strName, String strValue) {
		
		Assert.hasLength(strName, "传入属性名无效");
		
//		if(this.getDEMethodDTORuntime() != null) {
//			IPSDEMethodDTOField iPSDEMethodDTOField = null;
//			if(isActionInputDTO()) {
//				iPSDEMethodDTOField = this.getDEMethodDTORuntime().getPSDEMethodDTOField(strName, true);
//			}
//			else{
//				 iPSDEMethodDTOField = this.getDEMethodDTORuntime().getPSDEMethodDTOFieldByDEField(strName, true);
//			}
//			if(iPSDEMethodDTOField != null) {
//				int nStdDataType = iPSDEMethodDTOField.getStdDataType();
//				if(nStdDataType != DataTypes.UNKNOWN && !DataTypeUtils.isStringDataType(nStdDataType)) {
//					Object objValue = null;
//					try {
//						objValue = this.getDEMethodDTORuntime().getSystemRuntime().convertValue(nStdDataType, strValue);
//					} catch (Exception ex) {
//						throw new DataEntityRuntimeException(this.getDEMethodDTORuntime().getDataEntityRuntime()
//								,String.format("转化数据[%1$s]至[%2$s]发生异常，%3$s", strValue, DataTypeUtils.getTypeName(nStdDataType), ex.getMessage())
//								,ex);
//					}
//					set(strName, objValue);
//					return ;
//				}
//			}
//			
//		}
		set(strName, (Object)strValue);
	}
	
	protected void _set(String strName, Object objValue) {
		super.set(strName, objValue);
	}
	
	protected Object _get(String strName) {
		return super.get(strName);
	}
	
	protected boolean _contains(String strName) {
		return super.contains(strName);
	}
	
	protected void _reset(String strName) {
		super.reset(strName);
	}


	@Override
	public IEntityDTO put(String strName, Object objValue) {
		this.set(strName, objValue);
		return this;
	}

	@Override
	public IEntityDTO put(String strName, String strValue) {
		this.set(strName, strValue);
		return this;
	}

	@Override
	public Timestamp getTimestamp(String strName, Timestamp def) {
		try {
			return DataTypeUtils.getDateTimeValue(this.get(strName), def);
		}
		catch (Exception ex) {
			throw new RuntimeException(ex);
		}
	}


	@Override
	public BigDecimal getBigDecimal(String strName, BigDecimal fDefault) {
		try {
			return DataTypeUtils.getBigDecimalValue(this.get(strName), fDefault);
		}
		catch (Exception ex) {
			throw new RuntimeException(ex);
		}
	}


	@Override
	public BigInteger getBigInteger(String strName, BigInteger nDefault) {
		try {
			return DataTypeUtils.getBigIntegerValue(this.get(strName), nDefault);
		}
		catch (Exception ex) {
			throw new RuntimeException(ex);
		}
	}


	@Override
	public Boolean getBoolean(String strName, Boolean def) {
		try {
			return DataTypeUtils.getBooleanValue(this.get(strName), def);
		}
		catch (Exception ex) {
			throw new RuntimeException(ex);
		}
	}


	@Override
	public Double getDouble(String strName, Double def) {
		try {
			return DataTypeUtils.getDoubleValue(this.get(strName), def);
		}
		catch (Exception ex) {
			throw new RuntimeException(ex);
		}
	}


	@Override
	public Float getFloat(String strName, Float def) {
		try {
			return DataTypeUtils.getFloatValue(this.get(strName), def);
		}
		catch (Exception ex) {
			throw new RuntimeException(ex);
		}
	}


	@Override
	public Integer getInteger(String strName, Integer def) {
		try {
			return DataTypeUtils.getIntegerValue(this.get(strName), def);
		}
		catch (Exception ex) {
			throw new RuntimeException(ex);
		}
	}
	
	@Override
	public Long getLong(String strName, Long def) {
		try {
			return DataTypeUtils.getLongValue(this.get(strName), def);
		}
		catch (Exception ex) {
			throw new RuntimeException(ex);
		}
	}
	
	


	@Override
	public String getString(String strName, String strDefault) {
		try {
			return DataTypeUtils.getStringValue(this.get(strName), strDefault);
		}
		catch (Exception ex) {
			throw new RuntimeException(ex);
		}
	}}
