package net.ibizsys.central.service;

import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.ISystemRuntimeBase;
import net.ibizsys.runtime.util.Errors;

/**
 * 系统服务接口运行时异常
 * @author lionlau
 *
 */
public class SysServiceAPIRuntimeException extends RuntimeException implements ISysServiceAPIRuntimeException{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private ISysServiceAPIRuntime iSysServiceAPIRuntimeBase = null;
	private int nErrorCode = Errors.INTERNALERROR;
	private IModelRuntime iModelRuntime = null;
	
	public SysServiceAPIRuntimeException(ISysServiceAPIRuntime iSysServiceAPIRuntimeBase, String strInfo) {
		super(strInfo);
		this.iSysServiceAPIRuntimeBase = iSysServiceAPIRuntimeBase;
	}
	
	public SysServiceAPIRuntimeException(ISysServiceAPIRuntime iSysServiceAPIRuntimeBase, String strInfo, int nErrorCode) {
		super(strInfo);
		this.nErrorCode = nErrorCode;
		this.iSysServiceAPIRuntimeBase = iSysServiceAPIRuntimeBase;
	}
	
	public SysServiceAPIRuntimeException(ISysServiceAPIRuntime iSysServiceAPIRuntimeBase, String strInfo,Throwable throwable) {
		super(strInfo, throwable);
		this.iSysServiceAPIRuntimeBase = iSysServiceAPIRuntimeBase;
	}
	
	public SysServiceAPIRuntimeException(ISysServiceAPIRuntime iSysServiceAPIRuntimeBase, String strInfo, int nErrorCode, Throwable throwable) {
		super(strInfo, throwable);
		this.nErrorCode = nErrorCode;
		this.iSysServiceAPIRuntimeBase = iSysServiceAPIRuntimeBase;
	}
	
	public SysServiceAPIRuntimeException(ISysServiceAPIRuntime iSysServiceAPIRuntimeBase, IModelRuntime iModelRuntime, String strInfo) {
		super(strInfo);
		this.iSysServiceAPIRuntimeBase = iSysServiceAPIRuntimeBase;
		this.iModelRuntime = iModelRuntime;
	}
	
	public SysServiceAPIRuntimeException(ISysServiceAPIRuntime iSysServiceAPIRuntimeBase, IModelRuntime iModelRuntime, String strInfo, int nErrorCode) {
		super(strInfo);
		this.nErrorCode = nErrorCode;
		this.iSysServiceAPIRuntimeBase = iSysServiceAPIRuntimeBase;
		this.iModelRuntime = iModelRuntime;
	}
	
	public SysServiceAPIRuntimeException(ISysServiceAPIRuntime iSysServiceAPIRuntimeBase, IModelRuntime iModelRuntime, String strInfo,Throwable throwable) {
		super(strInfo, throwable);
		this.iSysServiceAPIRuntimeBase = iSysServiceAPIRuntimeBase;
		this.iModelRuntime = iModelRuntime;
	}
	
	public SysServiceAPIRuntimeException(ISysServiceAPIRuntime iSysServiceAPIRuntimeBase, IModelRuntime iModelRuntime, String strInfo, int nErrorCode, Throwable throwable) {
		super(strInfo, throwable);
		this.nErrorCode = nErrorCode;
		this.iSysServiceAPIRuntimeBase = iSysServiceAPIRuntimeBase;
		this.iModelRuntime = iModelRuntime;
	}
	
	
	/**
	 * 获取系统服务接口对象
	 * @return
	 */
	@Override
	public ISysServiceAPIRuntime getSysServiceAPIRuntime() {
		return this.iSysServiceAPIRuntimeBase;
	}
	
	
	
	/**
	 * 获取错误代码
	 * 
	 * @return the nErrorCode
	 */
	public int getErrorCode() {
		return nErrorCode;
	}

	@Override
	public ISystemRuntimeBase getSystemRuntime() {
		if(getSysServiceAPIRuntime()!=null) {
			return this.getSysServiceAPIRuntime().getSystemRuntime();
		}
		return null;
	}


	
	@Override
	public IModelRuntime getModelRuntime() {
		if(this.iModelRuntime == null) {
			return this.getSysServiceAPIRuntime();
		}
		return this.iModelRuntime;
	}
}
