package net.ibizsys.central.dataentity.service;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.data.domain.Pageable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

import net.ibizsys.central.dataentity.DataEntityModelRuntimeBase;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.IDynaInstDataEntityRuntime;
import net.ibizsys.central.dataentity.dataimport.IDEDataImportRuntime;
import net.ibizsys.central.service.ISysServiceAPIRuntime;
import net.ibizsys.central.service.ISysServiceAPIRuntimeContext;
import net.ibizsys.central.service.SysServiceAPILevels;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.central.util.ISearchContextDTO;
import net.ibizsys.central.util.SearchContextDTO;
import net.ibizsys.central.util.domain.ImportDataResult;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.dataentity.action.IPSDEAction;
import net.ibizsys.model.dataentity.action.IPSDEActionInput;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.der.IPSDER1N;
import net.ibizsys.model.dataentity.der.IPSDERBase;
import net.ibizsys.model.dataentity.der.IPSDERCustom;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.model.dataentity.ds.IPSDEDataSetInput;
import net.ibizsys.model.dataentity.service.IPSDEServiceAPI;
import net.ibizsys.model.dataentity.service.IPSDEServiceAPIMethod;
import net.ibizsys.runtime.ModelException;
import net.ibizsys.runtime.dataentity.DETypes;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.action.DEActionModes;
import net.ibizsys.runtime.dataentity.dataexport.IDEDataExportRuntime;
import net.ibizsys.runtime.dataentity.der.DERSubTypes;
import net.ibizsys.runtime.dataentity.der.DERTypes;
import net.ibizsys.runtime.dataentity.print.IDEPrintRuntime;
import net.ibizsys.runtime.dataentity.service.DEMethodInputTypes;
import net.ibizsys.runtime.dataentity.service.DEMethodReturnTypes;
import net.ibizsys.runtime.security.DataAccessActions;
import net.ibizsys.runtime.security.UserContext;
import net.ibizsys.runtime.util.AppContext;
import net.ibizsys.runtime.util.Conditions;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.EntityError;
import net.ibizsys.runtime.util.Errors;
import net.ibizsys.runtime.util.IAppContext;
import net.ibizsys.runtime.util.INamedAction;
import net.ibizsys.runtime.util.domain.File;

/**
 * 实体服务接口运行时对象接口
 * 
 * @author lionlau
 *
 */
public class DEServiceAPIRuntime extends DataEntityModelRuntimeBase implements IDEServiceAPIRuntime {

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(DEServiceAPIRuntime.class);

	private ISysServiceAPIRuntimeContext iSysServiceAPIRuntimeContext = null;
	private IPSDEServiceAPI iPSDEServiceAPI = null;
	private IDataEntityRuntime iDataEntityRuntime = null;
	private Map<String, IPSDEServiceAPIMethod> psDEServiceAPIMethodMap = new HashMap<String, IPSDEServiceAPIMethod>();

	@Override
	public void init(ISysServiceAPIRuntimeContext iSysServiceAPIRuntimeContext, IPSDEServiceAPI iPSDEServiceAPI) throws Exception {
		Assert.notNull(iSysServiceAPIRuntimeContext, "传入系统服务接口运行时上下文对象无效");
		Assert.notNull(iPSDEServiceAPI, "传入实体服务接口模型对象无效");

		this.iSysServiceAPIRuntimeContext = iSysServiceAPIRuntimeContext;
		// 获取对应的实体运行时对象
		Object objDataEntityRuntime = iSysServiceAPIRuntimeContext.getSysServiceAPIRuntime().getSystemRuntime().getDataEntityRuntime(iPSDEServiceAPI.getPSDataEntityMust().getId());
		if (!(objDataEntityRuntime instanceof IDataEntityRuntime)) {
			throw new DEServiceAPIRuntimeException(this, String.format("实体[%1$s]运行时对象不正确", iPSDEServiceAPI.getPSDataEntityMust().getId()));
		}
		iDataEntityRuntime = (IDataEntityRuntime) objDataEntityRuntime;
		this.setDataEntityRuntimeBase(iDataEntityRuntime);

		this.iPSDEServiceAPI = iPSDEServiceAPI;

		this.onInit();
	}

	@Override
	protected void onInit() throws Exception {

		java.util.List<IPSDEServiceAPIMethod> psDEServcieAPIMethodList = this.getPSDEServiceAPI().getPSDEServiceAPIMethods();
		if (psDEServcieAPIMethodList != null) {
			for (IPSDEServiceAPIMethod iPSDEServiceAPIMethod : psDEServcieAPIMethodList) {
				if (StringUtils.hasLength(iPSDEServiceAPIMethod.getCodeName()) && !iPSDEServiceAPIMethod.isNoServiceCodeName()) {
					psDEServiceAPIMethodMap.put(iPSDEServiceAPIMethod.getCodeName(), iPSDEServiceAPIMethod);
					psDEServiceAPIMethodMap.put(iPSDEServiceAPIMethod.getCodeName().toUpperCase(), iPSDEServiceAPIMethod);
					psDEServiceAPIMethodMap.put(iPSDEServiceAPIMethod.getCodeName().toLowerCase(), iPSDEServiceAPIMethod);
				} else {
					if (iPSDEServiceAPIMethod.getPSDEAction() != null) {
						psDEServiceAPIMethodMap.put(iPSDEServiceAPIMethod.getPSDEAction().getCodeName(), iPSDEServiceAPIMethod);
						psDEServiceAPIMethodMap.put(iPSDEServiceAPIMethod.getPSDEAction().getCodeName().toUpperCase(), iPSDEServiceAPIMethod);
						psDEServiceAPIMethodMap.put(iPSDEServiceAPIMethod.getPSDEAction().getCodeName().toLowerCase(), iPSDEServiceAPIMethod);
					}
				}
			}
		}

		super.onInit();
	}

	@Override
	public ISysServiceAPIRuntime getSysServiceAPIRuntime() {
		return this.getSysServiceAPIRuntimeContext().getSysServiceAPIRuntime();
	}

	@Override
	public IPSDEServiceAPI getPSDEServiceAPI() {
		return this.iPSDEServiceAPI;
	}

	@Override
	public IPSModelObject getPSModelObject() {
		return this.getPSDEServiceAPI();
	}

	protected ISysServiceAPIRuntimeContext getSysServiceAPIRuntimeContext() {
		return this.iSysServiceAPIRuntimeContext;
	}

	@Override
	public IDataEntityRuntime getDataEntityRuntime() {
		return this.iDataEntityRuntime;
	}

	@Override
	public IPSDEServiceAPIMethod getPSDEServiceAPIMethod(String strMethodCodeName, boolean bTryMode) {
		IPSDEServiceAPIMethod iPSDEServiceAPIMethod = psDEServiceAPIMethodMap.get(strMethodCodeName);
		if (iPSDEServiceAPIMethod != null || bTryMode) {
			return iPSDEServiceAPIMethod;
		}

		throw new DEServiceAPIRuntimeException(this, String.format("不存在指定服务方法[%1$s]", strMethodCodeName));
	}

	@Override
	public Object invokeMethod(String strScope, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, String strMethodName, Object objBody, String strKey, Object objTag) throws Throwable {
		// 需要判断接口是否提供指定方法
		IPSDEServiceAPIMethod iPSDEServiceAPIMethod = null;
		if (iDEServiceAPIRSRuntime != null) {
			iPSDEServiceAPIMethod = iDEServiceAPIRSRuntime.getPSDEServiceAPIMethod(strMethodName, false);
		} else {
			iPSDEServiceAPIMethod = getPSDEServiceAPIMethod(strMethodName, false);
		}

		if (iPSDEServiceAPIMethod.getPSDEAction() != null) {
			return this.executeAction(strScope, iDEServiceAPIRSRuntime, strParentKey, iPSDEServiceAPIMethod, objBody, strKey, objTag);
		}

		if (iPSDEServiceAPIMethod.getPSDEDataSet() != null) {
			// Object[] args = getDataSetArgs(iPSDEServiceAPIMethod,
			// iDEServiceAPIRSRuntime, strParentKey, objBody);
			// return
			// this.getDataEntityRuntime().fetchDataSet(iPSDEServiceAPIMethod.getPSDEDataSet().getName(),
			// iPSDEServiceAPIMethod.getPSDEDataSet(), args);
			return this.fetchDataSet(strScope, iDEServiceAPIRSRuntime, strParentKey, iPSDEServiceAPIMethod, objBody, strKey, objTag);
		}

		// 暂时直接调用实体方法
		// return this.getDataEntityRuntime().invokeMethod(strMethodName,
		// objBody, objTag);
		throw new DEServiceAPIRuntimeException(this, String.format("无法识别服务方法[%1$s]", strMethodName));
	}

	protected Object fetchDataSet(String strScope, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, IPSDEServiceAPIMethod iPSDEServiceAPIMethod, Object objBody, String strKey, Object objTag) throws Throwable {

		return this.onFetchDataSet(strScope, iDEServiceAPIRSRuntime, strParentKey, iPSDEServiceAPIMethod, objBody, strKey, objTag);
	}

	protected Object onFetchDataSet(String strScope, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, IPSDEServiceAPIMethod iPSDEServiceAPIMethod, Object objBody, String strKey, Object objTag) throws Throwable {

		
		Object[] args = getDataSetArgs(iPSDEServiceAPIMethod, iDEServiceAPIRSRuntime, strParentKey, objBody);

		ISearchContextDTO iSearchContextDTO = null;
		if (args.length > 0 && args[0] instanceof ISearchContextDTO) {
			iSearchContextDTO = (ISearchContextDTO) args[0];
			
		}

		// 判断数据访问
		if (!this.getDataEntityRuntime().getDataEntityAccessManager().testDataAccessAction(UserContext.getCurrent(), ((iDEServiceAPIRSRuntime == null) ? null : iDEServiceAPIRSRuntime.getMajorDEServiceAPIRuntime().getDataEntityRuntime()), strParentKey, iSearchContextDTO, iPSDEServiceAPIMethod.getDataAccessAction())) {
			if (!StringUtils.hasLength(iPSDEServiceAPIMethod.getDataAccessAction())) {
				throw new DEServiceAPIRuntimeException(this, String.format("数据集[%1$s]未定义访问操作标识", iPSDEServiceAPIMethod.getPSDEDataSet().getName()), Errors.ACCESSDENY);
			}
			throw new DEServiceAPIRuntimeException(this, String.format("%1$s不具备操作能力[%2$s]", this.getLogicName(), iPSDEServiceAPIMethod.getDataAccessAction()), Errors.ACCESSDENY);
		}

		if (iDEServiceAPIRSRuntime != null) {
			IAppContext iAppContext = UserContext.getCurrentMust().getAppContext();
			if (iAppContext == null) {
				iAppContext = new AppContext();
				UserContext.getCurrentMust().setAppContext(iAppContext);
			}
			iAppContext.set(iDEServiceAPIRSRuntime.getMajorDEServiceAPIRuntime().getName(), strParentKey);
		}

		return this.getDataEntityRuntime().fetchDataSet(iPSDEServiceAPIMethod.getPSDEDataSet().getName(), iPSDEServiceAPIMethod.getPSDEDataSet(), args);
	}

	protected Object executeAction(String strScope, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, IPSDEServiceAPIMethod iPSDEServiceAPIMethod, Object objBody, String strKey, Object objTag) throws Throwable {

		return this.onExecuteAction(strScope, iDEServiceAPIRSRuntime, strParentKey, iPSDEServiceAPIMethod, objBody, strKey, objTag);
	}

	protected Object onExecuteAction(String strScope, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, IPSDEServiceAPIMethod iPSDEServiceAPIMethod, Object objBody, String strKey, Object objTag) throws Throwable {

		Object[] args = getActionArgs(iPSDEServiceAPIMethod, iDEServiceAPIRSRuntime, strParentKey, objBody, strKey);
		if (args[0] instanceof List) {
			List list = (List) args[0];
			for (Object item : list) {
				if (item instanceof IEntityDTO) {
					// 判断数据访问
					if (!this.getDataEntityRuntime().getDataEntityAccessManager().testDataAccessAction(UserContext.getCurrent(), ((iDEServiceAPIRSRuntime == null) ? null : iDEServiceAPIRSRuntime.getMajorDEServiceAPIRuntime().getDataEntityRuntime()), strParentKey, null, (IEntityDTO) item, iPSDEServiceAPIMethod.getDataAccessAction())) {

						if (!StringUtils.hasLength(iPSDEServiceAPIMethod.getDataAccessAction())) {
							throw new DEServiceAPIRuntimeException(this, String.format("行为[%1$s]未定义访问操作标识", iPSDEServiceAPIMethod.getPSDEAction().getName()), Errors.ACCESSDENY);
						}

						if (StringUtils.hasLength(strKey)) {
							throw new DEServiceAPIRuntimeException(this, String.format("%1$s[%2$s]不具备操作能力[%3$s]", this.getLogicName(), strKey, iPSDEServiceAPIMethod.getDataAccessAction()), Errors.ACCESSDENY);
						}

						throw new DEServiceAPIRuntimeException(this, String.format("%1$s不具备操作能力[%2$s]", this.getLogicName(), iPSDEServiceAPIMethod.getDataAccessAction()), Errors.ACCESSDENY);
					}
				} else {
					// 判断数据访问
					if (!this.getDataEntityRuntime().getDataEntityAccessManager().testDataAccessAction(UserContext.getCurrent(), ((iDEServiceAPIRSRuntime == null) ? null : iDEServiceAPIRSRuntime.getMajorDEServiceAPIRuntime().getDataEntityRuntime()), strParentKey, item, null, iPSDEServiceAPIMethod.getDataAccessAction())) {

						if (!StringUtils.hasLength(iPSDEServiceAPIMethod.getDataAccessAction())) {
							throw new DEServiceAPIRuntimeException(this, String.format("行为[%1$s]未定义访问操作标识", iPSDEServiceAPIMethod.getPSDEAction().getName()), Errors.ACCESSDENY);
						}

						// throw new DEServiceAPIRuntimeException(this,
						// String.format("数据[%1$s]不具备操作能力[%2$s]", strKey,
						// iPSDEServiceAPIMethod.getDataAccessAction()),
						// Errors.ACCESSDENY);

						if (StringUtils.hasLength(strKey)) {
							throw new DEServiceAPIRuntimeException(this, String.format("%1$s[%2$s]不具备操作能力[%3$s]", this.getLogicName(), strKey, iPSDEServiceAPIMethod.getDataAccessAction()), Errors.ACCESSDENY);
						}

						throw new DEServiceAPIRuntimeException(this, String.format("%1$s不具备操作能力[%2$s]", this.getLogicName(), iPSDEServiceAPIMethod.getDataAccessAction()), Errors.ACCESSDENY);

					}
				}
			}

			if (iDEServiceAPIRSRuntime != null) {
				IAppContext iAppContext = UserContext.getCurrentMust().getAppContext();
				if (iAppContext == null) {
					iAppContext = new AppContext();
					UserContext.getCurrentMust().setAppContext(iAppContext);
				}
				iAppContext.set(iDEServiceAPIRSRuntime.getMajorDEServiceAPIRuntime().getName(), strParentKey);
			}

			// 判断行为是否支持为批操作行为
			if (iPSDEServiceAPIMethod.getPSDEAction().isBatchAction()) {
				// 直接传入
				Object objRet = this.getDataEntityRuntime().executeAction(iPSDEServiceAPIMethod.getPSDEAction().getName(), iPSDEServiceAPIMethod.getPSDEAction(), args);
				if (iPSDEServiceAPIMethod.getPSDEAction().getPSDEActionInput().isOutput()) {
					return args[0];
				}
				return objRet;
			} else {
				List retList = null;
				if (!DEMethodReturnTypes.VOID.equals(iPSDEServiceAPIMethod.getPSDEAction().getPSDEActionReturnMust().getType()) || iPSDEServiceAPIMethod.getPSDEAction().getPSDEActionInput().isOutput()) {
					retList = new ArrayList();
				}

				boolean bIgnoreExists = false;
				if (this.getDataEntityRuntime().getDEType() == DETypes.RELATED && DEActionModes.CREATE.equals(iPSDEServiceAPIMethod.getPSDEAction().getActionMode()) && this.getDataEntityRuntime().getUnionKeyValuePSDEFields() != null) {
					bIgnoreExists = true;
				}

				// 转为逐项调用
				for (Object item : list) {
					if (bIgnoreExists && item instanceof IEntityDTO) {
						boolean bSelect = true;
						ISearchContextDTO iSearchContextDTO = this.getDataEntityRuntime().createSearchContext();
						for (IPSDEField iPSDEField : this.getDataEntityRuntime().getUnionKeyValuePSDEFields()) {
							Object objValue = this.getDataEntityRuntime().getFieldValue((IEntityDTO) item, iPSDEField);
							if (!iPSDEField.isAllowEmpty() && objValue == null) {
								bSelect = false;
								break;
							}
							SearchContextDTO.addSearchFieldCond(iSearchContextDTO, iPSDEField.getLowerCaseName(), Conditions.EQ, objValue, null);
						}
						if (bSelect) {
							if (this.getDataEntityRuntime().existsData(iSearchContextDTO)) {
								continue;
							}
						}
					}
					Object objRet = this.getDataEntityRuntime().executeAction(iPSDEServiceAPIMethod.getPSDEAction().getName(), iPSDEServiceAPIMethod.getPSDEAction(), new Object[] { item });
					if (iPSDEServiceAPIMethod.getPSDEAction().getPSDEActionInput().isOutput()) {
						if (retList != null) {
							retList.add(args[0]);
						}
					} else {
						if (retList != null) {
							retList.add(objRet);
						}
					}
				}
				return retList;
			}
		} else {
			IEntityDTO iEntityDTO = null;
			if (args.length > 0 && args[0] instanceof IEntityDTO) {
				iEntityDTO = (IEntityDTO) args[0];
			}

			// 判断数据访问
			if (!this.getDataEntityRuntime().getDataEntityAccessManager().testDataAccessAction(UserContext.getCurrent(), ((iDEServiceAPIRSRuntime == null) ? null : iDEServiceAPIRSRuntime.getMajorDEServiceAPIRuntime().getDataEntityRuntime()), strParentKey, strKey, iEntityDTO, iPSDEServiceAPIMethod.getDataAccessAction())) {

				if (!StringUtils.hasLength(iPSDEServiceAPIMethod.getDataAccessAction())) {
					throw new DEServiceAPIRuntimeException(this, String.format("行为[%1$s]未定义访问操作标识", iPSDEServiceAPIMethod.getPSDEAction().getName()), Errors.ACCESSDENY);
				}

				// throw new DEServiceAPIRuntimeException(this,
				// String.format("数据[%1$s]不具备操作能力[%2$s]", strKey,
				// iPSDEServiceAPIMethod.getDataAccessAction()),
				// Errors.ACCESSDENY);

				if (StringUtils.hasLength(strKey)) {
					throw new DEServiceAPIRuntimeException(this, String.format("%1$s[%2$s]不具备操作能力[%3$s]", this.getLogicName(), strKey, iPSDEServiceAPIMethod.getDataAccessAction()), Errors.ACCESSDENY);
				}

				throw new DEServiceAPIRuntimeException(this, String.format("%1$s不具备操作能力[%2$s]", this.getLogicName(), iPSDEServiceAPIMethod.getDataAccessAction()), Errors.ACCESSDENY);

			}

			if (iDEServiceAPIRSRuntime != null) {
				IAppContext iAppContext = UserContext.getCurrentMust().getAppContext();
				if (iAppContext == null) {
					iAppContext = new AppContext();
					UserContext.getCurrentMust().setAppContext(iAppContext);
				}
				iAppContext.set(iDEServiceAPIRSRuntime.getMajorDEServiceAPIRuntime().getName(), strParentKey);
			}

			Object objRet = this.getDataEntityRuntime().executeAction(iPSDEServiceAPIMethod.getPSDEAction().getName(), iPSDEServiceAPIMethod.getPSDEAction(), args);
			if (iPSDEServiceAPIMethod.getPSDEAction().getPSDEActionInput().isOutput()) {
				return args[0];
			}
			return objRet;
		}
	}

	protected Object[] getActionArgs(IPSDEServiceAPIMethod iPSDEServiceAPIMethod, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, Object objBody, String strKey) throws Throwable {
		IPSDEAction iPSDEAction = iPSDEServiceAPIMethod.getPSDEActionMust();
		IPSDEActionInput iPSDEActionInput = iPSDEAction.getPSDEActionInput();
		if (iPSDEActionInput == null) {
			throw new ModelException(iPSDEAction, String.format("实体行为[%1$s]没有指定输入对象", iPSDEAction.getName()));
		}
		if (DEMethodInputTypes.KEYFIELD.equals(iPSDEActionInput.getType()) || DEMethodInputTypes.KEYFIELDS.equals(iPSDEActionInput.getType())) {
			if (ObjectUtils.isEmpty(strKey)) {
				throw new Exception("没有指定输入参数");
			}
			String[] items = strKey.trim().replace(",", ";").split("[;]");
			if (DEMethodInputTypes.KEYFIELD.equals(iPSDEActionInput.getType())) {
				if (items.length == 1) {
					Object objValue = this.getSystemRuntime().convertValue(this.getDataEntityRuntime().getKeyPSDEField().getStdDataType(), (String) strKey);
					return new Object[] { objValue };
				} else {
					List list = new ArrayList();
					for (int i = 0; i < items.length; i++) {
						Object objValue = this.getSystemRuntime().convertValue(this.getDataEntityRuntime().getKeyPSDEField().getStdDataType(), items[i]);
						list.add(objValue);
					}
					return new Object[] { list };
				}
			}

			if (DEMethodInputTypes.KEYFIELDS.equals(iPSDEActionInput.getType())) {
				List list = new ArrayList();
				for (int i = 0; i < items.length; i++) {
					Object objValue = this.getSystemRuntime().convertValue(this.getDataEntityRuntime().getKeyPSDEField().getStdDataType(), items[i]);
					list.add(objValue);
				}
				return new Object[] { list };
			}
		}

		if (DEMethodInputTypes.DTO.equals(iPSDEActionInput.getType()) || DEMethodInputTypes.DTOS.equals(iPSDEActionInput.getType())) {
			if (objBody == null) {
				throw new Exception("没有指定输入参数");
			}

			if (objBody instanceof List) {
				// 构建列表
				List dtoList = new ArrayList();
				List list = (List) objBody;
				for (Object item : list) {
					IEntityDTO iEntityDTO = (IEntityDTO) this.getDataEntityRuntime().getDEMethodDTO(iPSDEActionInput.getPSDEMethodDTOMust(), item);
					iEntityDTO.resetReadOnlyFields();
					this.removeInvalidUserInput(iPSDEServiceAPIMethod, iDEServiceAPIRSRuntime, iEntityDTO);
					// if (StringUtils.hasLength(strKey)) {
					// Object objValue =
					// this.getSystemRuntime().convertValue(this.getDataEntityRuntime().getKeyPSDEField().getStdDataType(),
					// (String) strKey);
					// iEntityDTO.set(this.getDataEntityRuntime().getKeyPSDEField().getLowerCaseName(),
					// objValue);
					// }

					if (iDEServiceAPIRSRuntime != null && StringUtils.hasLength(strParentKey)) {
						IPSDEField parentIdPSDEField = iDEServiceAPIRSRuntime.getPSDEServiceAPIRS().getParentIdPSDEField();
						if (parentIdPSDEField != null) {
							Object objValue = this.getSystemRuntime().convertValue(parentIdPSDEField.getStdDataType(), strParentKey);
							iEntityDTO.set(parentIdPSDEField.getLowerCaseName(), objValue);
						}

					}
					dtoList.add(iEntityDTO);

				}
				return new Object[] { dtoList };
			} else {
				IEntityDTO iEntityDTO = (IEntityDTO) this.getDataEntityRuntime().getDEMethodDTO(iPSDEActionInput.getPSDEMethodDTOMust(), objBody);
				iEntityDTO.resetReadOnlyFields();
				this.removeInvalidUserInput(iPSDEServiceAPIMethod, iDEServiceAPIRSRuntime, iEntityDTO);

				if (StringUtils.hasLength(strKey)) {
					Object objValue = this.getSystemRuntime().convertValue(this.getDataEntityRuntime().getKeyPSDEField().getStdDataType(), (String) strKey);
					iEntityDTO.set(this.getDataEntityRuntime().getKeyPSDEField().getLowerCaseName(), objValue);
				}

				if (iDEServiceAPIRSRuntime != null && StringUtils.hasLength(strParentKey)) {
					IPSDEField parentIdPSDEField = iDEServiceAPIRSRuntime.getPSDEServiceAPIRS().getParentIdPSDEField();
					if (parentIdPSDEField != null) {
						Object objValue = this.getSystemRuntime().convertValue(parentIdPSDEField.getStdDataType(), strParentKey);
						iEntityDTO.set(parentIdPSDEField.getLowerCaseName(), objValue);
					}

				}

				return new Object[] { iEntityDTO };
			}

			// if (DEMethodInputTypes.DTO.equals(iPSDEActionInput.getType())) {
			//
			// IEntityDTO iEntityDTO = (IEntityDTO)
			// this.getDataEntityRuntime().getDEMethodDTO(iPSDEActionInput.getPSDEMethodDTOMust(),
			// objBody);
			// iEntityDTO.resetReadOnlyFields();
			// if (StringUtils.hasLength(strKey)) {
			// Object objValue =
			// this.getSystemRuntime().convertValue(this.getDataEntityRuntime().getKeyPSDEField().getStdDataType(),
			// (String) strKey);
			// iEntityDTO.set(this.getDataEntityRuntime().getKeyPSDEField().getLowerCaseName(),
			// objValue);
			// }
			//
			// if (iDEServiceAPIRSRuntime != null &&
			// StringUtils.hasLength(strParentKey)) {
			// IPSDEField parentIdPSDEField =
			// iDEServiceAPIRSRuntime.getPSDEServiceAPIRS().getParentIdPSDEField();
			// if (parentIdPSDEField != null) {
			// Object objValue =
			// this.getSystemRuntime().convertValue(parentIdPSDEField.getStdDataType(),
			// strParentKey);
			// iEntityDTO.set(parentIdPSDEField.getLowerCaseName(), objValue);
			// }
			//
			// }
			//
			// return new Object[] { iEntityDTO };
			// }
		}

		throw new DataEntityRuntimeException(this.getDataEntityRuntime(), String.format("无法识别的实体行为输入类型[%1$s][%2$s]", iPSDEAction.getName(), iPSDEActionInput.getType()));
	}

	protected void removeInvalidUserInput(IPSDEServiceAPIMethod iPSDEServiceAPIMethod, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, IEntityDTO iEntityDTO) {

		if (this.getSysServiceAPIRuntime().getAPILevel() == SysServiceAPILevels.CORE) {
			return;
		}

		IPSDEAction iPSDEAction = iPSDEServiceAPIMethod.getPSDEAction();
		if (iPSDEAction != null) {
			this.getDataEntityRuntime().removeInvalidUserInput(iPSDEAction, iEntityDTO);
		}
	}

	protected Object[] getDataSetArgs(IPSDEServiceAPIMethod iPSDEServiceAPIMethod, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, Object objBody) throws Exception {
		IPSDEDataSet iPSDEDataSet = iPSDEServiceAPIMethod.getPSDEDataSetMust();
		IPSDEDataSetInput iPSDEDataSetInput = iPSDEDataSet.getPSDEDataSetInput();
		if (iPSDEDataSetInput == null) {
			throw new ModelException(iPSDEDataSet, String.format("实体数据集[%1$s]没有指定输入对象", iPSDEDataSet.getName()));
		}
		if (DEMethodInputTypes.DTO.equals(iPSDEDataSetInput.getType())) {

			// 判断传入参数是否已经处理（外部已经进行过滤加载）
			if (objBody instanceof ISearchContextDTO) {
				return new Object[] { objBody };
			}

			ISearchContextDTO iSearchContextDTO = (ISearchContextDTO) this.getDataEntityRuntime().getDEMethodDTO(iPSDEDataSetInput.getPSDEFilterDTOMust(), objBody);
			if (iDEServiceAPIRSRuntime != null && StringUtils.hasLength(strParentKey)) {
				// 送入过滤条件
				if (DEServiceAPIMethodParentKeyModes.DEFAULT.equals(iPSDEServiceAPIMethod.getParentKeyMode())) {
					IPSDEField parentIdPSDEField = iDEServiceAPIRSRuntime.getPSDEServiceAPIRS().getParentIdPSDEField();
					if (parentIdPSDEField != null) {
						Object objParentKey = DataTypeUtils.parse(parentIdPSDEField.getStdDataType(), strParentKey);
						SearchContextDTO.addSearchFieldCondIf(iSearchContextDTO, parentIdPSDEField.getLowerCaseName(), Conditions.EQ, objParentKey, null);
					}
				}
			} else {
				// 兼容处理旧版本模式，考虑到外部宋体实体标识可能为服务实体代码标识，所以在接口处进行处理
				Object parentDEName = iSearchContextDTO.get(ISearchContextDTO.PARAM_PARENTDENAME);
				Object parentKey = iSearchContextDTO.get(ISearchContextDTO.PARAM_PARENTKEY);
				if (!ObjectUtils.isEmpty(parentDEName) && !ObjectUtils.isEmpty(parentKey)) {
					List<IPSDERBase> psDERBaseList = this.getDataEntityRuntime().getPSDataEntity().getMinorPSDERs();
					if (!ObjectUtils.isEmpty(psDERBaseList)) {

						String strParentDEName = parentDEName.toString();
						IDEServiceAPIRuntime iDEServiceAPIRuntime = this.getSysServiceAPIRuntime().getDEServiceAPIRuntime(strParentDEName, true);
						if (iDEServiceAPIRuntime != null) {
							strParentDEName = iDEServiceAPIRuntime.getDataEntityRuntime().getName();
						}

						IPSDERBase filterPSDERBase = null;
						for (IPSDERBase iPSDERBase : psDERBaseList) {
							if (DERTypes.DER1N.equals(iPSDERBase.getDERType())) {
								if (iPSDERBase.getMajorPSDataEntityMust().getName().equalsIgnoreCase(strParentDEName)) {
									if (filterPSDERBase == null) {
										filterPSDERBase = iPSDERBase;
									} else {
										// 存在多个实体，置空
										log.warn(String.format("实体[%1$s]存在多个父实体[%2$s]的关系，忽略过滤处理", this.getDataEntityRuntime().getName(), iPSDERBase.getMajorPSDataEntityMust().getName()));
										filterPSDERBase = null;
										break;
									}
								}
								continue;
							}

							if (DERTypes.DERCUSTOM.equals(iPSDERBase.getDERType())) {
								IPSDERCustom iPSDERCustom = (IPSDERCustom) iPSDERBase;
								if (!DERSubTypes.DER1N.equals(iPSDERCustom.getDERSubType())) {
									continue;
								}

								if (iPSDERCustom.getPickupPSDEField() == null) {
									continue;
								}

								if (iPSDERBase.getMajorPSDataEntityMust().getName().equalsIgnoreCase(strParentDEName)) {
									if (filterPSDERBase == null) {
										filterPSDERBase = iPSDERBase;
									} else {
										// 存在多个实体，置空
										log.warn(String.format("实体[%1$s]存在多个父实体[%2$s]的关系，忽略过滤处理", this.getDataEntityRuntime().getName(), iPSDERBase.getMajorPSDataEntityMust().getName()));
										filterPSDERBase = null;
										break;
									}
								}
								continue;
							}

							// if(DERTypes.DERCUSTOM.equals(iPSDERBase.getDERType()))
							// {
							// if(DERSubTypes.DER1N.equals(((IPSDERCustom)iPSDERBase).getDERSubType()))
							// {
							// if(iPSDERBase.getMajorPSDataEntityMust().getName().equalsIgnoreCase(strParentDEName))
							// {
							// if(filterPSDERBase == null) {
							// filterPSDERBase = iPSDERBase;
							// }
							// else{
							// //存在多个实体，置空
							// filterPSDERBase = null;
							// break;
							// }
							// }
							// continue;
							// }
							continue;
						}

						if (filterPSDERBase instanceof IPSDER1N) {
							if (parentKey instanceof String) {
								parentKey = DataTypeUtils.parse(((IPSDER1N) filterPSDERBase).getPSPickupDEFieldMust().getStdDataType(), (String) parentKey);
							}
							SearchContextDTO.addSearchFieldCondIf(iSearchContextDTO, ((IPSDER1N) filterPSDERBase).getPSPickupDEFieldMust().getLowerCaseName(), Conditions.EQ, parentKey, null);
						} else if (filterPSDERBase instanceof IPSDERCustom) {
							if (parentKey instanceof String) {
								parentKey = DataTypeUtils.parse(((IPSDERCustom) filterPSDERBase).getPickupPSDEFieldMust().getStdDataType(), (String) parentKey);
							}
							SearchContextDTO.addSearchFieldCondIf(iSearchContextDTO, ((IPSDERCustom) filterPSDERBase).getPickupPSDEFieldMust().getLowerCaseName(), Conditions.EQ, parentKey, null);
						}
					}
				}
			}
			return new Object[] { iSearchContextDTO };
		}

		throw new DataEntityRuntimeException(this.getDataEntityRuntime(), String.format("无法识别的实体数据集输入类型[%1$s][%2$s]", iPSDEDataSet.getName(), iPSDEDataSetInput.getType()));
	}

	@Override
	public int getAPIMode() {
		return this.getPSDEServiceAPI().getAPIMode();
	}

	@Override
	public String getLogicName() {
		String strLogicName = this.getPSDEServiceAPI().getLogicName();
		if (!StringUtils.hasLength(strLogicName)) {
			return this.getDataEntityRuntime().getLogicName();
		}
		return strLogicName;
	}

	@Override
	public Object importData(String strScope, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, String strImportTag, Object objBody, Object objTag) throws Throwable {
		return this.onImportData(strScope, iDEServiceAPIRSRuntime, strParentKey, strImportTag, objBody, objTag);
	}

	protected Object onImportData(String strScope, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, String strImportTag, Object objBody, Object objTag) throws Throwable {

		// 判断数据访问
		if (!this.getDataEntityRuntime().getDataEntityAccessManager().testDataAccessAction(UserContext.getCurrent(), ((iDEServiceAPIRSRuntime == null) ? null : iDEServiceAPIRSRuntime.getMajorDEServiceAPIRuntime().getDataEntityRuntime()), strParentKey, null, null, DataAccessActions.CREATE)) {
			throw new DEServiceAPIRuntimeException(this, String.format("%1$s不具备操作能力[%2$s]", this.getLogicName(), DataAccessActions.CREATE), Errors.ACCESSDENY);
		}

		MultipartFile file = null;
		if (objBody instanceof MultipartFile) {
			file = (MultipartFile) objBody;
		}
		Map<Integer, EntityError> errorMap = null;
		IEntityDTO iEntityDTO = this.getDataEntityRuntime().createEntity();
		// 设置导入文件名
		if (!ObjectUtils.isEmpty(file.getOriginalFilename())) {
			iEntityDTO.set(IDEDataImportRuntime.FIELD_IMPORTFILENAME, file.getOriginalFilename());
		}
		// 填充parentKey
		if (iDEServiceAPIRSRuntime != null && StringUtils.hasLength(strParentKey)) {
			IPSDEField parentIdPSDEField = iDEServiceAPIRSRuntime.getPSDEServiceAPIRS().getParentIdPSDEField();
			if (parentIdPSDEField != null) {
				Object objValue = this.getSystemRuntime().convertValue(parentIdPSDEField.getStdDataType(), strParentKey);
				iEntityDTO.set(parentIdPSDEField.getLowerCaseName(), objValue);
				// errorMap = iDEDataImportRuntime.importStream(iEntityDTO,
				// file.getInputStream(), true,
				// iDEServiceAPIRSRuntime.getMajorDEServiceAPIRuntime().getDataEntityRuntime(),
				// String.valueOf(objValue));
				errorMap = this.getDataEntityRuntime().importData(strImportTag, iEntityDTO, file.getInputStream(), true, iDEServiceAPIRSRuntime.getMajorDEServiceAPIRuntime().getDataEntityRuntime(), String.valueOf(objValue));
			} else {
				throw new DEServiceAPIRuntimeException(this, "解析导入Excel发生异常：缺少关系属性");
			}
		} else {
			// errorMap = iDEDataImportRuntime.importStream(iEntityDTO,
			// file.getInputStream(), true, null, null);
			errorMap = this.getDataEntityRuntime().importData(strImportTag, iEntityDTO, file.getInputStream(), true, null, null);
		}

		return errorMap;
	}

	@Override
	public Object importData2(String strScope, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, String strImportTag, Object objBody, Object objTag) throws Throwable {
		return this.onImportData2(strScope, iDEServiceAPIRSRuntime, strParentKey, strImportTag, objBody, objTag);
	}

	protected Object onImportData2(String strScope, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, String strImportTag, Object objBody, Object objTag) throws Throwable {

		// 判断数据访问
		if (!this.getDataEntityRuntime().getDataEntityAccessManager().testDataAccessAction(UserContext.getCurrent(), ((iDEServiceAPIRSRuntime == null) ? null : iDEServiceAPIRSRuntime.getMajorDEServiceAPIRuntime().getDataEntityRuntime()), strParentKey, null, null, DataAccessActions.CREATE)) {
			throw new DEServiceAPIRuntimeException(this, String.format("%1$s不具备操作能力[%2$s]", this.getLogicName(), DataAccessActions.CREATE), Errors.ACCESSDENY);
		}

		MultipartFile file = null;
		if (objBody instanceof MultipartFile) {
			file = (MultipartFile) objBody;
		}
		ImportDataResult objRet = null;
		IEntityDTO iEntityDTO = this.getDataEntityRuntime().createEntity();
		// 设置导入文件名
		if (!ObjectUtils.isEmpty(file.getOriginalFilename())) {
			iEntityDTO.set(IDEDataImportRuntime.FIELD_IMPORTFILENAME, file.getOriginalFilename());
		}
		// 填充parentKey
		if (iDEServiceAPIRSRuntime != null && StringUtils.hasLength(strParentKey)) {
			IPSDEField parentIdPSDEField = iDEServiceAPIRSRuntime.getPSDEServiceAPIRS().getParentIdPSDEField();
			if (parentIdPSDEField != null) {
				Object objValue = this.getSystemRuntime().convertValue(parentIdPSDEField.getStdDataType(), strParentKey);
				iEntityDTO.set(parentIdPSDEField.getLowerCaseName(), objValue);
				objRet = this.getDataEntityRuntime().importData2(strImportTag, iEntityDTO, file.getInputStream(), true, iDEServiceAPIRSRuntime.getMajorDEServiceAPIRuntime().getDataEntityRuntime(), String.valueOf(objValue));
			} else {
				throw new DEServiceAPIRuntimeException(this, "解析导入Excel发生异常：缺少关系属性");
			}
		} else {
			objRet = this.getDataEntityRuntime().importData2(strImportTag, iEntityDTO, file.getInputStream(), true, null, null);
		}

		return objRet;
	}
	
	@Override
	public Object asyncImportData(String strScope, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, String strImportTag, Object objBody, Object objTag) throws Throwable {
		return this.onAsyncImportData(strScope, iDEServiceAPIRSRuntime, strParentKey, strImportTag, objBody, objTag);
	}

	protected Object onAsyncImportData(String strScope, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, String strImportTag, Object objBody, Object objTag) throws Throwable {

		// 判断数据访问
		if (!this.getDataEntityRuntime().getDataEntityAccessManager().testDataAccessAction(UserContext.getCurrent(), ((iDEServiceAPIRSRuntime == null) ? null : iDEServiceAPIRSRuntime.getMajorDEServiceAPIRuntime().getDataEntityRuntime()), strParentKey, null, null, DataAccessActions.CREATE)) {
			throw new DEServiceAPIRuntimeException(this, String.format("%1$s不具备操作能力[%2$s]", this.getLogicName(), DataAccessActions.CREATE), Errors.ACCESSDENY);
		}

		MultipartFile file = null;
		if (objBody instanceof MultipartFile) {
			file = (MultipartFile) objBody;
		}
		else {
			throw new DEServiceAPIRuntimeException(this, "未传入导入数据文件");
		}
		
		IEntityDTO iEntityDTO = this.getDataEntityRuntime().createEntity();
		// 设置导入文件名
		if (!ObjectUtils.isEmpty(file.getOriginalFilename())) {
			iEntityDTO.set(IDEDataImportRuntime.FIELD_IMPORTFILENAME, file.getOriginalFilename());
		}
		
		Object objValue = null;
		if (iDEServiceAPIRSRuntime != null && StringUtils.hasLength(strParentKey)) {
			IPSDEField parentIdPSDEField = iDEServiceAPIRSRuntime.getPSDEServiceAPIRS().getParentIdPSDEField();
			if (parentIdPSDEField != null) {
				objValue = this.getSystemRuntime().convertValue(parentIdPSDEField.getStdDataType(), strParentKey);
				iEntityDTO.set(parentIdPSDEField.getLowerCaseName(), objValue);
			}
			else {
				throw new DEServiceAPIRuntimeException(this, "解析导入Excel发生异常：缺少关系属性");
			}
		}

		String strValue = (objValue == null)?null:String.valueOf(objValue);
		InputStream inputStream = file.getInputStream();
		
		Map<String, Object> actionTagMap = new HashMap<String, Object>();
		actionTagMap.put("actionparam", getDataEntityRuntime().getName());
		actionTagMap.put("actionparam2", strImportTag);
		
		//actionTagMap.put("", value);
		
		return this.getSystemRuntime().asyncExecute(new INamedAction() {
			@Override
			public Object execute(Object[] args) throws Throwable {
				if (iDEServiceAPIRSRuntime != null && StringUtils.hasLength(strParentKey)) {
					return getDataEntityRuntime().importData(strImportTag, iEntityDTO, inputStream, true, iDEServiceAPIRSRuntime.getMajorDEServiceAPIRuntime().getDataEntityRuntime(), strValue);
				} else {
					return getDataEntityRuntime().importData(strImportTag, iEntityDTO, inputStream, true, null, null);
				}
			}

			@Override
			public String getName() {
				return String.format("[%1$s]数据导入作业[%2$s]", getDataEntityRuntime().getLogicName(), strImportTag);
			}
		}, null, actionTagMap);
	}

	@Override
	public Object asyncImportData2(String strScope, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, String strImportTag, Object objBody, Object objTag) throws Throwable {
		return this.onAsyncImportData2(strScope, iDEServiceAPIRSRuntime, strParentKey, strImportTag, objBody, objTag);
	}

	protected Object onAsyncImportData2(String strScope, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, String strImportTag, Object objBody, Object objTag) throws Throwable {

		// 判断数据访问
		if (!this.getDataEntityRuntime().getDataEntityAccessManager().testDataAccessAction(UserContext.getCurrent(), ((iDEServiceAPIRSRuntime == null) ? null : iDEServiceAPIRSRuntime.getMajorDEServiceAPIRuntime().getDataEntityRuntime()), strParentKey, null, null, DataAccessActions.CREATE)) {
			throw new DEServiceAPIRuntimeException(this, String.format("%1$s不具备操作能力[%2$s]", this.getLogicName(), DataAccessActions.CREATE), Errors.ACCESSDENY);
		}

		MultipartFile file = null;
		if (objBody instanceof MultipartFile) {
			file = (MultipartFile) objBody;
		}
		else {
			throw new DEServiceAPIRuntimeException(this, "未传入导入数据文件");
		}
		
		IEntityDTO iEntityDTO = this.getDataEntityRuntime().createEntity();
		// 设置导入文件名
		if (!ObjectUtils.isEmpty(file.getOriginalFilename())) {
			iEntityDTO.set(IDEDataImportRuntime.FIELD_IMPORTFILENAME, file.getOriginalFilename());
		}
		
		Object objValue = null;
		if (iDEServiceAPIRSRuntime != null && StringUtils.hasLength(strParentKey)) {
			IPSDEField parentIdPSDEField = iDEServiceAPIRSRuntime.getPSDEServiceAPIRS().getParentIdPSDEField();
			if (parentIdPSDEField != null) {
				objValue = this.getSystemRuntime().convertValue(parentIdPSDEField.getStdDataType(), strParentKey);
				iEntityDTO.set(parentIdPSDEField.getLowerCaseName(), objValue);
			}
			else {
				throw new DEServiceAPIRuntimeException(this, "解析导入Excel发生异常：缺少关系属性");
			}
		}

		String strValue = (objValue == null)?null:String.valueOf(objValue);
		InputStream inputStream = file.getInputStream();
		
		Map<String, Object> actionTagMap = new HashMap<String, Object>();
		actionTagMap.put("actionparam", getDataEntityRuntime().getName());
		actionTagMap.put("actionparam2", strImportTag);
		
		return this.getSystemRuntime().asyncExecute(new INamedAction() {
			@Override
			public Object execute(Object[] args) throws Throwable {
				if (iDEServiceAPIRSRuntime != null && StringUtils.hasLength(strParentKey)) {
					return getDataEntityRuntime().importData2(strImportTag, iEntityDTO, inputStream, true, iDEServiceAPIRSRuntime.getMajorDEServiceAPIRuntime().getDataEntityRuntime(), strValue);
				} else {
					return getDataEntityRuntime().importData2(strImportTag, iEntityDTO, inputStream, true, null, null);
				}
			}

			@Override
			public String getName() {
				return String.format("[%1$s]数据导入作业[%2$s]", getDataEntityRuntime().getLogicName(), strImportTag);
			}
		}, null, actionTagMap);
	}
	
	
	@Override
	public Object getImportTemplate(String strScope, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, String strImportTag, Object objTag) throws Throwable {
		return this.onGetImportTemplate(strScope, iDEServiceAPIRSRuntime, strParentKey, strImportTag, objTag);
	}

	protected Object onGetImportTemplate(String strScope, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, String strImportTag, Object objTag) throws Throwable {

		// 判断数据访问
		if (!this.getDataEntityRuntime().getDataEntityAccessManager().testDataAccessAction(UserContext.getCurrent(), ((iDEServiceAPIRSRuntime == null) ? null : iDEServiceAPIRSRuntime.getMajorDEServiceAPIRuntime().getDataEntityRuntime()), strParentKey, null, null, DataAccessActions.CREATE)) {
			throw new DEServiceAPIRuntimeException(this, String.format("%1$s不具备操作能力[%2$s]", this.getLogicName(), DataAccessActions.CREATE), Errors.ACCESSDENY);
		}

		OutputStream outputStream = null;
		if (objTag instanceof OutputStream) {
			outputStream = (OutputStream) objTag;
		}

		if (outputStream == null) {
			throw new DEServiceAPIRuntimeException(this, String.format("导出模板未传入输出流对象"));
		}

		this.getDataEntityRuntime().getImportTemplate(strImportTag, outputStream, false, iDEServiceAPIRSRuntime != null ? iDEServiceAPIRSRuntime.getMajorDEServiceAPIRuntime().getDataEntityRuntime() : null, strParentKey);
		return null;
	}

	@Override
	public Object exportData(String strScope, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, String strExportTag, Object objBody, Object objTag) throws Throwable {
		throw new DEServiceAPIRuntimeException(this, "没有实现");
	}

	@Override
	public Object exportData(String strScope, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, String strExportTag, String strMethodName, Object objBody, String strKey, Object objTag) throws Throwable {
		return onExportData(strScope, iDEServiceAPIRSRuntime, strParentKey, strExportTag, strMethodName, objBody, strKey, objTag);
	}

	protected Object onExportData(String strScope, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, String strExportTag, String strMethodName, Object objBody, String strKey, Object objTag) throws Throwable {

		OutputStream outputStream = null;
		if (objTag instanceof OutputStream) {
			outputStream = (OutputStream) objTag;
		}

		if (outputStream == null) {
			throw new DEServiceAPIRuntimeException(this, String.format("导出数据未传入输出流对象"));
		}
		
		
		IDEDataExportRuntime iDEDataExportRuntime = this.getDataEntityRuntime().getDEDataExportRuntime(strExportTag);

		// 需要判断接口是否提供指定方法
		IPSDEServiceAPIMethod iPSDEServiceAPIMethod = null;
		if (iDEServiceAPIRSRuntime != null) {
			iPSDEServiceAPIMethod = iDEServiceAPIRSRuntime.getPSDEServiceAPIMethod(strMethodName, false);
		} else {
			iPSDEServiceAPIMethod = getPSDEServiceAPIMethod(strMethodName, false);
		}
		
		if (iPSDEServiceAPIMethod.getPSDEDataSet() != null) {
			
			Object size = null;
			if(objBody instanceof Map) {
				size = ((Map)objBody).get(ISearchContextDTO.PARAM_SIZE);
			}
			
			Object[] args = getDataSetArgs(iPSDEServiceAPIMethod, iDEServiceAPIRSRuntime, strParentKey, objBody);
			
			if (args.length > 0 && args[0] instanceof ISearchContextDTO) {
				ISearchContextDTO iSearchContextDTO = (ISearchContextDTO) args[0];
				// 强行调整导出的最大数量
				int nMaxSize = iDEDataExportRuntime.getMaxRowCount();
				Pageable pageable = iSearchContextDTO.getPageable();
				if (pageable != null) {
					if (size == null) {
						// 直接使用最大值
						iSearchContextDTO.setPageable(pageable.getPageNumber(), nMaxSize, pageable.getOffset());
					} else {
						int nSize = Integer.parseInt(size.toString());
						if (nSize <= 0 || nSize > pageable.getPageSize()) {
							if (nSize <= 0 || nSize > nMaxSize) {
								nSize = nMaxSize;
							}
							iSearchContextDTO.setPageable(pageable.getPageNumber(), nMaxSize, pageable.getOffset());
						}
					}
				} else {
					iSearchContextDTO.limit(nMaxSize);
				}
				
				//将已经处理的过滤对象设置到Body对象
				objBody = iSearchContextDTO;
			}
		}

		// 进行实际方法执行
		Object objRet = this.invokeMethod(strScope, iDEServiceAPIRSRuntime, strParentKey, strMethodName, objBody, strKey, null);
		

		this.getDataEntityRuntime().exportData(strExportTag, objRet, outputStream);
		return null;
	}
	
	@Override
	public Object asyncExportData(String strScope, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, String strExportTag, String strMethodName, Object objBody, String strKey, Object objTag) throws Throwable {
		return onAsyncExportData(strScope, iDEServiceAPIRSRuntime, strParentKey, strExportTag, strMethodName, objBody, strKey, objTag);
	}

	protected Object onAsyncExportData(String strScope, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, String strExportTag, String strMethodName, Object objBody, String strKey, Object objTag) throws Throwable {

		OutputStream outputStream = null;
		if (objTag instanceof OutputStream) {
			outputStream = (OutputStream) objTag;
		}

		if (outputStream == null) {
			throw new DEServiceAPIRuntimeException(this, String.format("导出数据未传入输出流对象"));
		}
		
		
		IDEDataExportRuntime iDEDataExportRuntime = this.getDataEntityRuntime().getDEDataExportRuntime(strExportTag);

		// 需要判断接口是否提供指定方法
		IPSDEServiceAPIMethod iPSDEServiceAPIMethod = null;
		if (iDEServiceAPIRSRuntime != null) {
			iPSDEServiceAPIMethod = iDEServiceAPIRSRuntime.getPSDEServiceAPIMethod(strMethodName, false);
		} else {
			iPSDEServiceAPIMethod = getPSDEServiceAPIMethod(strMethodName, false);
		}
		
		if (iPSDEServiceAPIMethod.getPSDEDataSet() != null) {
			
			Object size = null;
			if(objBody instanceof Map) {
				size = ((Map)objBody).get(ISearchContextDTO.PARAM_SIZE);
			}
			
			Object[] args = getDataSetArgs(iPSDEServiceAPIMethod, iDEServiceAPIRSRuntime, strParentKey, objBody);
			
			if (args.length > 0 && args[0] instanceof ISearchContextDTO) {
				ISearchContextDTO iSearchContextDTO = (ISearchContextDTO) args[0];
				// 强行调整导出的最大数量
				int nMaxSize = iDEDataExportRuntime.getMaxRowCount();
				Pageable pageable = iSearchContextDTO.getPageable();
				if (pageable != null) {
					if (size == null) {
						// 直接使用最大值
						iSearchContextDTO.setPageable(pageable.getPageNumber(), nMaxSize, pageable.getOffset());
					} else {
						int nSize = Integer.parseInt(size.toString());
						if (nSize <= 0 || nSize > pageable.getPageSize()) {
							if (nSize <= 0 || nSize > nMaxSize) {
								nSize = nMaxSize;
							}
							iSearchContextDTO.setPageable(pageable.getPageNumber(), nMaxSize, pageable.getOffset());
						}
					}
				} else {
					iSearchContextDTO.limit(nMaxSize);
				}
				
				//将已经处理的过滤对象设置到Body对象
				objBody = iSearchContextDTO;
			}
		}

		// 进行实际方法执行
		Object objRet = this.invokeMethod(strScope, iDEServiceAPIRSRuntime, strParentKey, strMethodName, objBody, strKey, null);
		

		this.getDataEntityRuntime().exportData(strExportTag, objRet, outputStream);
		return null;
	}
	

	@Override
	public Object printData(String strScope, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, String strPrintTag, String strPrintType, Object objBody, String strKey, Object objTag) throws Throwable {
		return this.onPrintData(strScope, iDEServiceAPIRSRuntime, strParentKey, strPrintTag, strPrintType, objBody, strKey, objTag);
	}

	protected Object onPrintData(String strScope, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, String strPrintTag, String strPrintType, Object objBody, String strKey, Object objTag) throws Throwable {

		if (ObjectUtils.isEmpty(strKey)) {
			throw new Exception("没有指定输入参数");
		}

		IDEPrintRuntime iDEPrintRuntime = null;
		IDynaInstDataEntityRuntime iDynaInstDataEntityRuntime = this.getDataEntityRuntime().getDynaInstDataEntityRuntime(null, false);
		if (iDynaInstDataEntityRuntime != null) {
			iDEPrintRuntime = iDynaInstDataEntityRuntime.getDEPrintRuntime(strPrintTag);
		} else {
			iDEPrintRuntime = this.getDataEntityRuntime().getDEPrintRuntime(strPrintTag);
		}

		String[] items = strKey.trim().split("[;]");
		List<Object> list = new ArrayList<Object>();
		for (int i = 0; i < items.length; i++) {
			Object objValue = this.getSystemRuntime().convertValue(this.getDataEntityRuntime().getKeyPSDEField().getStdDataType(), items[i]);
			list.add(objValue);
		}

		Object[] keys = list.toArray(new Object[list.size()]);
		for (int i = 0; i < keys.length; i++) {
			// 判断数据访问
			if (!this.getDataEntityRuntime().getDataEntityAccessManager().testDataAccessAction(UserContext.getCurrent(), ((iDEServiceAPIRSRuntime == null) ? null : iDEServiceAPIRSRuntime.getMajorDEServiceAPIRuntime().getDataEntityRuntime()), strParentKey, keys[i], null, iDEPrintRuntime.getPSDEPrint().getDataAccessAction())) {

				if (!StringUtils.hasLength(iDEPrintRuntime.getPSDEPrint().getDataAccessAction())) {
					throw new DEServiceAPIRuntimeException(this, String.format("打印[%1$s]未定义访问操作标识", iDEPrintRuntime.getPSDEPrint().getName()), Errors.ACCESSDENY);
				}

				throw new DEServiceAPIRuntimeException(this, String.format("%1$s[%2$s]不具备操作能力[%3$s]", this.getLogicName(), keys[i], iDEPrintRuntime.getPSDEPrint().getDataAccessAction()), Errors.ACCESSDENY);

			}
		}

		OutputStream outputStream = null;
		if (objTag instanceof OutputStream) {
			outputStream = (OutputStream) objTag;
		}

		if (outputStream == null) {
			throw new DEServiceAPIRuntimeException(this, String.format("打印数据未传入输出流对象"));
		}

		this.getDataEntityRuntime().outputPrint(strPrintTag, outputStream, keys, strPrintType, false);
		return null;
	}

	@Override
	public Object wfStart(String strScope, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, String strWFTag, Object objBody, String strKey, Object objTag) throws Throwable {
		return this.onWFStart(strScope, iDEServiceAPIRSRuntime, strParentKey, strWFTag, objBody, strKey, objTag);
	}

	protected Object onWFStart(String strScope, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, String strWFTag, Object objBody, String strKey, Object objTag) throws Throwable {
		throw new DEServiceAPIRuntimeException(this, "没有实现", Errors.NOTIMPL);
	}

	@Override
	public Object wfCancel(String strScope, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, String strWFTag, Object objBody, String strKey, Object objTag) throws Throwable {
		return this.onWFCancel(strScope, iDEServiceAPIRSRuntime, strParentKey, strWFTag, objBody, strKey, objTag);
	}

	protected Object onWFCancel(String strScope, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, String strWFTag, Object objBody, String strKey, Object objTag) throws Throwable {
		throw new DEServiceAPIRuntimeException(this, "没有实现", Errors.NOTIMPL);
	}

	@Override
	public Object uploadFile(String strScope, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, String strKey, String strStorageField, File file, Object objBody, Object objTag) throws Throwable {
		return this.onUploadFile(strScope, iDEServiceAPIRSRuntime, strParentKey, strKey, strStorageField, file, objBody, objTag);
	}

	protected Object onUploadFile(String strScope, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, String strKey, String strStorageField, File file, Object objBody, Object objTag) throws Throwable {
		throw new DEServiceAPIRuntimeException(this, "没有实现", Errors.NOTIMPL);
	}

	@Override
	public Object downloadFile(String strScope, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, String strKey, String strStorageField, File file, Object objBody, Object objTag) throws Throwable {
		return this.onDownloadFile(strScope, iDEServiceAPIRSRuntime, strParentKey, strKey, strStorageField, file, objBody, objTag);
	}

	protected Object onDownloadFile(String strScope, IDEServiceAPIRSRuntime iDEServiceAPIRSRuntime, String strParentKey, String strKey, String strStorageField, File file, Object objBody, Object objTag) throws Throwable {
		throw new DEServiceAPIRuntimeException(this, "没有实现", Errors.NOTIMPL);
	}
}
