package net.ibizsys.central.dataentity.print;

import java.io.File;
import java.io.OutputStream;
import java.util.List;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import net.ibizsys.central.IDynaInstRuntime;
import net.ibizsys.central.ISystemRuntime;
import net.ibizsys.central.dataentity.IDataEntityModelRuntime;
import net.ibizsys.central.dataentity.IDataEntityRuntime;
import net.ibizsys.central.dataentity.IDynaInstDataEntityRuntime;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.central.util.ISearchContextDTO;
import net.ibizsys.central.util.SearchContextDTO;
import net.ibizsys.model.dataentity.der.IPSDER1N;
import net.ibizsys.model.dataentity.der.IPSDERBase;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.runtime.dataentity.der.DER1NMasterRSTypes;
import net.ibizsys.runtime.dataentity.der.DERTypes;
import net.ibizsys.runtime.util.Conditions;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.IEntityBase;

public class DEPrintRuntime extends net.ibizsys.runtime.dataentity.print.DEPrintRuntime implements IDataEntityModelRuntime {

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(DEPrintRuntime.class);
	
	private String strReportFilePath = null;
	
	@Override
	protected void onInit() throws Exception {
		
		super.onInit();
		
		//准备本地报表文件
		if(!StringUtils.hasLength(getReportFilePath())) {
			prepareReportFilePath();
		}
	}
	
	@Override
	protected String getReportFilePath() {
		return this.strReportFilePath;
	}
	
	protected void setReportFilePath(String strReportFilePath) {
		this.strReportFilePath = strReportFilePath;
	}
	
	protected void prepareReportFilePath() throws Exception{
		String strReportFilePath = this.getPSDEPrint().getReportFile();
		if(!StringUtils.hasLength(strReportFilePath)) {
			return;
		}
		
		//判断文件路径类型
		String strReportFilePath2 = strReportFilePath.toLowerCase();
		if((strReportFilePath2.indexOf("http://") == 0)
				|| (strReportFilePath2.indexOf("https://") == 0)) {
			//进行文件下载
			File tempFile = File.createTempFile("deprint", getDefaultReportFileSuffix());
			try {
				this.getSystemRuntime().getDefaultWebClient().download(strReportFilePath, null, null, null, tempFile, null);
			}
			catch (Throwable ex) {
				throw new Exception(String.format("下载远程报表文件发生异常，%1$s", ex.getMessage()), ex);
			}
			this.setReportFilePath(tempFile.getCanonicalPath());
		}
		else {
			if(!StringUtils.hasLength(this.getSystemRuntime().getReportFolder())) {
				if(StringUtils.hasLength(this.getReportModel())) {
					return;
				}
				throw new Exception(String.format("系统未定义报表存储文件夹"));
			}
			File file = new File(this.getSystemRuntime().getReportFolder() + strReportFilePath);
			if(!file.exists()) {
				if(StringUtils.hasLength(this.getReportModel())) {
					return;
				}
				throw new Exception(String.format("指定报表文件不存在"));
			}
			this.setReportFilePath(file.getCanonicalPath());
		}
	}
	
	
	
	
	@Override
	public IDataEntityRuntime getDataEntityRuntime() {
		return (IDataEntityRuntime)super.getDataEntityRuntime();
	}
	
	@Override
	public IDynaInstDataEntityRuntime getDynaInstDataEntityRuntime() {
		return (IDynaInstDataEntityRuntime)super.getDynaInstDataEntityRuntime();
	}
	
	
	@Override
	public ISystemRuntime getSystemRuntime() {
		return (ISystemRuntime)super.getSystemRuntime();
	}
	
	
	
	@Override
	public IDynaInstRuntime getDynaInstRuntime() {
		return (IDynaInstRuntime)super.getDynaInstRuntime();
	}
	
	/**
	 * 获取默认报表文件后缀
	 * @return
	 */
	protected String getDefaultReportFileSuffix() {
		return null;
	}
	
	protected List<? extends IEntity> selectDetails(IEntity iEntity) throws Throwable{
		if(this.getPSDEPrint().getDetailPSDE() == null ) {
			return null;
		}
		
		Object objValue = this.getDataEntityRuntime().getKeyFieldValue(iEntity);
		if (ObjectUtils.isEmpty(objValue)) {
			return null;
		}

		IDataEntityRuntime childDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(this.getPSDEPrint().getDetailPSDE().getId());
		ISearchContextDTO iSearchContextDTO = childDataEntityRuntime.createSearchContext();
		
		//将当前实体作为上下文数据变量放入
		iSearchContextDTO.set(this.getDataEntityRuntime().getKeyPSDEField().getLowerCaseName(), objValue);
		
		//尝试放入关系数据过滤条件
		java.util.List<IPSDERBase> psDERBases = this.getDataEntityRuntime().getPSDataEntity().getMajorPSDERs();
		if (!ObjectUtils.isEmpty(psDERBases)) {
			
			String strMinorDEId = this.getPSDEPrint().getDetailPSDE().getId();
			// 判断存在关联关系的关系实体
			IPSDERBase filterPSDERBase = null;
			for (IPSDERBase psDERBase : psDERBases) {
				if (DERTypes.DER1N.equals(psDERBase.getDERType())) {
					IPSDER1N iPSDER1N = (IPSDER1N) psDERBase;
					if ((iPSDER1N.getMasterRS() & DER1NMasterRSTypes.RELATED) == DER1NMasterRSTypes.RELATED) {
						if (strMinorDEId.equalsIgnoreCase(psDERBase.getMinorPSDataEntity().getId())) {
							if(filterPSDERBase == null) {
								filterPSDERBase = iPSDER1N;
							}
							else {
								log.warn(String.format("实体[%1$s]存在多个附属实体[%2$s]的关系，忽略过滤处理", this.getDataEntityRuntime().getName(),  this.getPSDEPrint().getDetailPSDE().getName()));
								filterPSDERBase = null;
								break;
							}
						}
					}
				} else {
					continue;
				}
			}
			
			if (filterPSDERBase instanceof IPSDER1N) {
				SearchContextDTO.addSearchFieldCond(iSearchContextDTO, ((IPSDER1N) filterPSDERBase).getPSPickupDEFieldMust().getLowerCaseName(), Conditions.EQ, objValue, null);
			}
		}

		IPSDEDataSet detailPSDEDataSet = this.getPSDEPrint().getDetailPSDEDataSet();
		if(detailPSDEDataSet == null) {
			detailPSDEDataSet = childDataEntityRuntime.getDefaultPSDEDataSet();
		}
					
		if(detailPSDEDataSet == null) {
			throw new Exception("明细数据数据集无效");
		}
		
		List<IEntityDTO> list = childDataEntityRuntime.selectDataSet(detailPSDEDataSet, iSearchContextDTO);
		if (!ObjectUtils.isEmpty(list)) {
			for(IEntityDTO iEntityDTO : list) {
				childDataEntityRuntime.fillEntityCodeListTexts(iEntityDTO);
			}
		}
		
		return list;
	}
	
	
	@Override
	protected void onOutput(OutputStream outputStream, IEntityBase[] list, String strType) throws Throwable {
		if(list != null) {
			for(IEntityBase iEntityBase : list) {
				if(iEntityBase instanceof IEntity) {
					this.getDataEntityRuntime().fillEntityCodeListTexts((IEntity)iEntityBase);
				}
					
			}
		}
		super.onOutput(outputStream, list, strType);
	}
}
