package net.ibizsys.central.dataentity.logic;

import java.util.List;

import net.ibizsys.central.database.ISysDBSchemeRuntime;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.model.dataentity.logic.IPSDELogicNode;
import net.ibizsys.model.dataentity.logic.IPSDERawSqlCallLogic;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.util.IEntity;

/**
 * 实体SQL查询并循环调用节点运行时对象
 * @author lionlau
 *
 */
public class DELogicRawSqlCallNodeRuntime extends DELogicRawSqlCallNodeRuntimeBase{

	@Override
	protected void onExecute(IDELogicRuntimeContext iDELogicRuntimeContext, IDELogicSession iDELogicSession, IPSDELogicNode iPSDELogicNode) throws Throwable {
	
		if(!(iPSDELogicNode instanceof IPSDERawSqlCallLogic)) {
			throw new DataEntityRuntimeException(iDELogicRuntimeContext.getDataEntityRuntime(), iDELogicRuntimeContext.getDELogicRuntime(), String.format("处理节点[%1$s]模型类型不正确", iPSDELogicNode.getName()));
		}
		
		IPSDERawSqlCallLogic iPSDERawSqlCallLogic = (IPSDERawSqlCallLogic)iPSDELogicNode;
		
		
//		ISysDBSchemeRuntime iSysDBSchemeRuntime = iDELogicRuntimeContext.getDataEntityRuntime().getSysDBSchemeRuntime();
//		if(iSysDBSchemeRuntime == null) {
//			throw new DataEntityRuntimeException(iDELogicRuntimeContext.getDataEntityRuntime(), iDELogicRuntimeContext.getDELogicRuntime(), String.format("实体[%1$s]运行时未提供SQL支持", iDELogicRuntimeContext.getDataEntityRuntime().getName()));
//		}
		
		ISysDBSchemeRuntime iSysDBSchemeRuntime = null;
		if(iPSDERawSqlCallLogic.getPSSysDBScheme() != null) {
			iSysDBSchemeRuntime = iDELogicRuntimeContext.getDataEntityRuntime().getSystemRuntime().getSysDBSchemeRuntime(iPSDERawSqlCallLogic.getPSSysDBScheme());
		}
		else {
			iSysDBSchemeRuntime = iDELogicRuntimeContext.getDataEntityRuntime().getSysDBSchemeRuntime();
		}
		
		
		List<Object> paramList = this.getSqlParamList(iDELogicRuntimeContext, iDELogicSession, iPSDELogicNode);
		
		if(iPSDERawSqlCallLogic.isFillDstLogicParam()) {
			List list = iSysDBSchemeRuntime.executeSelectSQL(iPSDERawSqlCallLogic.getSql(), paramList);
			if(list!=null && list.size()>0) {
				IEntity dstEntity = iDELogicSession.getParam(iPSDERawSqlCallLogic.getDstPSDELogicParamMust().getCodeName());
				if(!iPSDERawSqlCallLogic.isIgnoreResetDstLogicParam()) {
					dstEntity.resetAll();
				}
				IEntityDTO iEntityDTO = iDELogicRuntimeContext.getDataEntityRuntime().createEntity();
				iEntityDTO.reload(list.get(0), false);
				iEntityDTO.copyTo(dstEntity);
			}
		}
		else {
			iSysDBSchemeRuntime.executeSQL(iPSDERawSqlCallLogic.getSql(), paramList);
		}
		
	}
	
}
