package net.ibizsys.central.dataentity.logic;


import java.util.Map;

import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.IEntityBase;

public class DELogicEntityParamRuntime extends DELogicParamRuntimeBase {

	@Override
	public Object getScriptObject(IDELogicSession iDELogicSession) throws Throwable {
		Object objParam = getParamObject(iDELogicSession);
		if(objParam instanceof IEntityBase) {
			if(this.getDataEntityRuntime()!=null) {
				return this.getDataEntityRuntime().createScriptEntity((IEntityBase)objParam);
			}
		}
		return super.getScriptObject(iDELogicSession);
	}
	
	
	@Override
	public Object getParamObject(IDELogicSession iDELogicSession) throws Throwable {
		Object object = iDELogicSession.getParamObject(this.getCodeName(), true);
		if (object != null) {
			// 检查类型是否正确
			if (!(object instanceof IEntity)) {
				throw new DataEntityRuntimeException(this.getDELogicRuntimeContext().getDataEntityRuntime(), getDELogicRuntimeContext().getDELogicRuntime(), String.format("逻辑参数[%1$s]不是数据对象类型", getCodeName()));
			}
			return object;
		}
		// 新建
		if (this.getDataEntityRuntime() == null) {
			object = this.getDELogicRuntimeContext().getSystemRuntime().createEntity(null, !this.getPSDELogicParam().isOriginEntity());
		} else {
			object = this.getDataEntityRuntime().createEntity();
		}
		iDELogicSession.setParamObject(this.getCodeName(), object);
		return object;
	}

	@Override
	public void bind(IDELogicSession iDELogicSession, Object paramObject) throws Throwable {
		IEntity srcEntity = null;
		if (paramObject != null) {
			if(paramObject instanceof IEntity) {
				srcEntity = (IEntity)paramObject;
			}
			else{
				try {
					Map map = this.getSystemRuntime().deserialize(paramObject, Map.class);
					srcEntity = this.getSystemRuntime().createEntity(map, !this.getPSDELogicParam().isOriginEntity());
				}
				catch(Throwable ex) {
					throw new DataEntityRuntimeException(this.getDELogicRuntimeContext().getDataEntityRuntime(), getDELogicRuntimeContext().getDELogicRuntime(), String.format("逻辑参数[%1$s]无法绑定非数据对象类型参数", getCodeName()), ex);
				}
			}
		}
		super.bind(iDELogicSession, srcEntity);
	}
	
}
