package net.ibizsys.central.dataentity.logic;

import org.springframework.util.StringUtils;

import net.ibizsys.model.dataentity.logic.IPSDEBindParamLogic;
import net.ibizsys.model.dataentity.logic.IPSDELogicNode;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;

/**
 * 实体绑定逻辑参数节点运行时对象
 * @author lionlau
 *
 */
public class DELogicBindParamNodeRuntime extends DELogicNodeRuntimeBase{

	@Override
	protected void onExecute(IDELogicRuntimeContext iDELogicRuntimeContext, IDELogicSession iDELogicSession, IPSDELogicNode iPSDELogicNode) throws Throwable {
	
		if(!(iPSDELogicNode instanceof IPSDEBindParamLogic)) {
			throw new DataEntityRuntimeException(iDELogicRuntimeContext.getDataEntityRuntime(), iDELogicRuntimeContext.getDELogicRuntime(), String.format("处理节点[%1$s]模型类型不正确", iPSDELogicNode.getName()));
		}
		
		IPSDEBindParamLogic iPSDEBindParamLogic = (IPSDEBindParamLogic)iPSDELogicNode;
		IDELogicParamRuntime srcDELogicParamRuntime = iDELogicRuntimeContext.getDELogicRuntime().getDELogicParamRuntime(iPSDEBindParamLogic.getSrcPSDELogicParamMust().getCodeName(), false);
		IDELogicParamRuntime dstDELogicParamRuntime = iDELogicRuntimeContext.getDELogicRuntime().getDELogicParamRuntime(iPSDEBindParamLogic.getDstPSDELogicParamMust().getCodeName(), false);
		String strSrcFieldName = iPSDEBindParamLogic.getSrcFieldName();
		if(StringUtils.hasLength(strSrcFieldName)){
			dstDELogicParamRuntime.bind(iDELogicSession, srcDELogicParamRuntime.get(iDELogicSession, strSrcFieldName));
		}
		else {
			dstDELogicParamRuntime.bind(iDELogicSession, srcDELogicParamRuntime.getParamObject(iDELogicSession));
		}
		iDELogicSession.setLastReturn(null);
	}
	
}
