package net.ibizsys.central.dataentity.logic;

import org.springframework.util.StringUtils;

import net.ibizsys.model.dataentity.logic.IPSDEAppendParamLogic;
import net.ibizsys.model.dataentity.logic.IPSDELogicNode;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;

/**
 * 实体附加列表逻辑参数节点运行时对象
 * @author lionlau
 *
 */
public class DELogicAppendParamNodeRuntime extends DELogicNodeRuntimeBase{

	@Override
	protected void onExecute(IDELogicRuntimeContext iDELogicRuntimeContext, IDELogicSession iDELogicSession, IPSDELogicNode iPSDELogicNode) throws Throwable {
	
		if(!(iPSDELogicNode instanceof IPSDEAppendParamLogic)) {
			throw new DataEntityRuntimeException(iDELogicRuntimeContext.getDataEntityRuntime(), iDELogicRuntimeContext.getDELogicRuntime(), String.format("处理节点[%1$s]模型类型不正确", iPSDELogicNode.getName()));
		}
		
		IPSDEAppendParamLogic iPSDEAppendParamLogic = (IPSDEAppendParamLogic)iPSDELogicNode;
		IDELogicParamRuntime dstDELogicParamRuntime = iDELogicRuntimeContext.getDELogicRuntime().getDELogicParamRuntime(iPSDEAppendParamLogic.getDstPSDELogicParamMust().getCodeName(), false);
		IDELogicParamRuntime srcDELogicParamRuntime = iDELogicRuntimeContext.getDELogicRuntime().getDELogicParamRuntime(iPSDEAppendParamLogic.getSrcPSDELogicParamMust().getCodeName(), false);
		String strSrcFieldName = iPSDEAppendParamLogic.getSrcFieldName();
		Object objParam = null;
		if(StringUtils.hasLength(strSrcFieldName)){
			objParam =  srcDELogicParamRuntime.get(iDELogicSession, strSrcFieldName);
		}
		else {
			objParam = srcDELogicParamRuntime.getParamObject(iDELogicSession);
		}
		dstDELogicParamRuntime.append(iDELogicSession, iPSDEAppendParamLogic.getDstIndex(), objParam, iPSDEAppendParamLogic.getSrcIndex(), iPSDEAppendParamLogic.getSrcSize());
		iDELogicSession.setLastReturn(null);
	}
	
}
