package net.ibizsys.central.dataentity;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import net.ibizsys.central.ISystemPersistentAdapter;
import net.ibizsys.central.ISystemRuntimeContext;
import net.ibizsys.central.ba.ISysBDSchemeRuntime;
import net.ibizsys.central.database.ISysDBSchemeRuntime;
import net.ibizsys.central.database.ISysDBTableRuntime;
import net.ibizsys.central.dataentity.action.DEActionInputDTORuntime;
import net.ibizsys.central.dataentity.action.DEActionPluginRuntimeBase;
import net.ibizsys.central.dataentity.action.IDEActionInputDTORuntime;
import net.ibizsys.central.dataentity.dataexport.DEDataExportRuntime;
import net.ibizsys.central.dataentity.dataimport.DEDataImportRuntime;
import net.ibizsys.central.dataentity.dataimport.IDEDataImportRuntime2;
import net.ibizsys.central.dataentity.demap.IDEMapRuntime;
import net.ibizsys.central.dataentity.der.DERAggDataRuntime;
import net.ibizsys.central.dataentity.der.IDERRuntime;
import net.ibizsys.central.dataentity.ds.DECodeListDataSetRuntime;
import net.ibizsys.central.dataentity.ds.DEDataQueryCodeRuntime;
import net.ibizsys.central.dataentity.ds.DEDataSetPluginRuntimeBase;
import net.ibizsys.central.dataentity.ds.DEFilterDTORuntime;
import net.ibizsys.central.dataentity.ds.DELogicDataSetRuntime;
import net.ibizsys.central.dataentity.ds.IDEDataQueryCodeRuntime;
import net.ibizsys.central.dataentity.ds.IDEFilterDTORuntime;
import net.ibizsys.central.dataentity.logic.DELogicRuntime;
import net.ibizsys.central.dataentity.security.IDataEntityAccessManager;
import net.ibizsys.central.dataentity.service.DEMethodDTORuntime;
import net.ibizsys.central.dataentity.service.IDEMethodDTO;
import net.ibizsys.central.dataentity.service.IDEMethodDTORuntime;
import net.ibizsys.central.dataentity.service.IDEService;
import net.ibizsys.central.dataentity.service.IDEServiceInitable;
import net.ibizsys.central.dataentity.testing.IDETestCaseRuntime;
import net.ibizsys.central.dataentity.wf.DEWFRuntime;
import net.ibizsys.central.dataentity.wf.IDEWFRuntime;
import net.ibizsys.central.service.ISubSysServiceAPIDERuntime;
import net.ibizsys.central.service.ISubSysServiceAPIRuntime;
import net.ibizsys.central.system.ISystemModuleRuntime;
import net.ibizsys.central.system.ISystemModuleUtilRuntime;
import net.ibizsys.central.testing.ISysTestCaseRuntime;
import net.ibizsys.central.util.EntityDTO;
import net.ibizsys.central.util.IEntityDTO;
import net.ibizsys.central.util.ISearchContext;
import net.ibizsys.central.util.ISearchContextDTO;
import net.ibizsys.central.util.SearchContextDTO;
import net.ibizsys.central.util.annotation.DEAction;
import net.ibizsys.central.util.annotation.DEDataSet;
import net.ibizsys.central.util.domain.ImportDataResult;
import net.ibizsys.central.util.script.ScriptEntity;
import net.ibizsys.central.util.script.ScriptSearchContext;
import net.ibizsys.model.PSModelEnums.DEDataQueryViewLevel;
import net.ibizsys.model.PSModelEnums.DEDataSetGroupMode;
import net.ibizsys.model.codelist.IPSCodeList;
import net.ibizsys.model.database.IPSDEDBConfig;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.action.IPSDEAction;
import net.ibizsys.model.dataentity.action.IPSDEActionInput;
import net.ibizsys.model.dataentity.action.IPSDEActionInputDTO;
import net.ibizsys.model.dataentity.action.IPSDEActionLogic;
import net.ibizsys.model.dataentity.action.IPSDEActionParam;
import net.ibizsys.model.dataentity.action.IPSDELogicAction;
import net.ibizsys.model.dataentity.action.IPSDEScriptAction;
import net.ibizsys.model.dataentity.action.IPSDESelectByKeyAction;
import net.ibizsys.model.dataentity.dataexport.IPSDEDataExport;
import net.ibizsys.model.dataentity.dataimport.IPSDEDataImport;
import net.ibizsys.model.dataentity.datamap.IPSDEMap;
import net.ibizsys.model.dataentity.defield.IPSDEFGroup;
import net.ibizsys.model.dataentity.defield.IPSDEFGroupDetail;
import net.ibizsys.model.dataentity.defield.IPSDEFSearchMode;
import net.ibizsys.model.dataentity.defield.IPSDEField;
import net.ibizsys.model.dataentity.defield.valuerule.IPSDEFVRQueryCountCondition;
import net.ibizsys.model.dataentity.defield.valuerule.IPSDEFVRValueRangeCondition;
import net.ibizsys.model.dataentity.defield.valuerule.IPSDEFVRValueRecursionCondition;
import net.ibizsys.model.dataentity.der.IPSDER1N;
import net.ibizsys.model.dataentity.der.IPSDER1NDEFieldMap;
import net.ibizsys.model.dataentity.der.IPSDERBase;
import net.ibizsys.model.dataentity.der.IPSDERCustom;
import net.ibizsys.model.dataentity.ds.IPSDEDataQuery;
import net.ibizsys.model.dataentity.ds.IPSDEDataQueryCode;
import net.ibizsys.model.dataentity.ds.IPSDEDataQueryCodeExp;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.model.dataentity.ds.IPSDEDataSetInput;
import net.ibizsys.model.dataentity.ds.IPSDEFilterDTO;
import net.ibizsys.model.dataentity.logic.IPSDELogic;
import net.ibizsys.model.dataentity.notify.IPSDENotify;
import net.ibizsys.model.dataentity.service.IPSDEMethodDTO;
import net.ibizsys.model.dataentity.service.IPSDEMethodDTOField;
import net.ibizsys.model.dataentity.wf.IPSDEWF;
import net.ibizsys.model.service.IPSSubSysServiceAPIDEMethod;
import net.ibizsys.model.testing.IPSSysTestCase;
import net.ibizsys.model.wf.IPSWFDE;
import net.ibizsys.model.wf.IPSWorkflow;
import net.ibizsys.runtime.DynaInstModes;
import net.ibizsys.runtime.IDynaInstRuntime;
import net.ibizsys.runtime.ISystemRuntime;
import net.ibizsys.runtime.ModelException;
import net.ibizsys.runtime.codelist.ICodeListRuntime;
import net.ibizsys.runtime.dataentity.DEStorageModes;
import net.ibizsys.runtime.dataentity.DEVirtualModes;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeBase;
import net.ibizsys.runtime.dataentity.DataEntityRuntimeException;
import net.ibizsys.runtime.dataentity.action.CheckKeyStates;
import net.ibizsys.runtime.dataentity.action.DEActionLogicTypes;
import net.ibizsys.runtime.dataentity.action.DEActionModes;
import net.ibizsys.runtime.dataentity.action.DEActionParamModes;
import net.ibizsys.runtime.dataentity.action.DEActionTypes;
import net.ibizsys.runtime.dataentity.action.DEActions;
import net.ibizsys.runtime.dataentity.action.IDEActionLogicRuntime;
import net.ibizsys.runtime.dataentity.action.IDEActionPluginRuntime;
import net.ibizsys.runtime.dataentity.action.IDEActionRuntime;
import net.ibizsys.runtime.dataentity.action.IDEScriptLogicRuntime;
import net.ibizsys.runtime.dataentity.dataexport.IDEDataExportRuntime;
import net.ibizsys.runtime.dataentity.dataimport.IDEDataImportRuntime;
import net.ibizsys.runtime.dataentity.datasync.DEDataSyncEvents;
import net.ibizsys.runtime.dataentity.der.DERTypes;
import net.ibizsys.runtime.dataentity.ds.DEDataSetTypes;
import net.ibizsys.runtime.dataentity.ds.IDEDataSetPluginRuntime;
import net.ibizsys.runtime.dataentity.ds.IDEDataSetRuntime;
import net.ibizsys.runtime.dataentity.logic.IDELogicRuntime;
import net.ibizsys.runtime.dataentity.notify.IDENotifyRuntime;
import net.ibizsys.runtime.dataentity.service.DEMethodDTOFieldTypes;
import net.ibizsys.runtime.dataentity.service.DEMethodDTOTypes;
import net.ibizsys.runtime.dataentity.service.DEMethodInputTypes;
import net.ibizsys.runtime.dataentity.service.DEMethodReturnTypes;
import net.ibizsys.runtime.security.IUserContext;
import net.ibizsys.runtime.util.ActionSession;
import net.ibizsys.runtime.util.ActionSessionManager;
import net.ibizsys.runtime.util.Conditions;
import net.ibizsys.runtime.util.DBTypes;
import net.ibizsys.runtime.util.DataTypeUtils;
import net.ibizsys.runtime.util.EntityListUtils;
import net.ibizsys.runtime.util.Errors;
import net.ibizsys.runtime.util.IAction;
import net.ibizsys.runtime.util.IActionSessionLog;
import net.ibizsys.runtime.util.IEntity;
import net.ibizsys.runtime.util.IEntityBase;
import net.ibizsys.runtime.util.INamedAction;
import net.ibizsys.runtime.util.ISearchContextBase;
import net.ibizsys.runtime.util.ITransactionalUtil;
import net.ibizsys.runtime.util.JsonUtils;
import net.ibizsys.runtime.util.KeyValueUtils;
import net.ibizsys.runtime.util.LogCats;
import net.ibizsys.runtime.util.LogLevels;
import net.ibizsys.runtime.util.script.IScriptEntity;
import net.ibizsys.runtime.util.script.IScriptSearchContext;

/**
 * 默认实体运行时对象
 * 
 * @author lionlau
 *
 */
public class DataEntityRuntime extends DataEntityRuntimeBase implements IDataEntityRuntime {

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(DataEntityRuntime.class);

	private ISystemRuntimeContext iSystemRuntimeContext = null;
	private String strId = null;
	private String strName = null;
	private Object data = null;

	private Map<String, Object> methodMap = null;
	private Map<String, IDEMethodDTORuntime> deMethodDTORuntimeMap = new HashMap<String, IDEMethodDTORuntime>();
	private Map<String, IDEDataQueryCodeRuntime> deDataQueryCodeRuntimeMap = null;
	private Map<String, IPSDEFSearchMode> psDEFSearchModeMap = new HashMap<String, IPSDEFSearchMode>();
	private Map<String, IPSDEField> psDEFieldMap2 = new HashMap<String, IPSDEField>();

	private Map<String, IDERRuntime> derRuntimeMap = null;
	private Map<String, IDEWFRuntime> deWFRuntimeMap = null;
	private List<IPSDEField> quickSearchPSDEFieldList = null;
	private Map<String, IDEMapRuntime> deMapRuntimeMap = null;

	private Map<String, List<IDEActionLogicRuntime>> deActionLogicRuntimeListMap = null;

	private IDEMethodDTORuntime defaultDEMethodDTORuntime = null;
	private IDEFilterDTORuntime defaultDEFilterDTORuntime = null;
	private ISystemPersistentAdapter iSystemPersistentAdapter = null;
	private ISysDBSchemeRuntime iSysDBSchemeRuntime = null;
	private IPSDEDBConfig defaultPSDEDBConfig = null;
	private ISysBDSchemeRuntime iSysBDSchemeRuntime = null;
	private IDataEntityAccessManager iDataEntityAccessManager = null;
	private IDEService iDEService = null;
	private boolean bEnableDEService = false;
	private ISubSysServiceAPIRuntime iSubSysServiceAPIRuntime = null;
	private ISubSysServiceAPIDERuntime iSubSysServiceAPIDERuntime = null;
	private ISystemModuleUtilRuntime iSystemModuleUtilRuntime = null;
	private ISystemModuleRuntime iSystemModuleRuntime = null;

	private List<IDETestCaseRuntime> deTestCaseRuntimeList = null;

	private IDataEntityRuntimeContext iDataEntityRuntimeContext = new IDataEntityRuntimeContext() {

		@Override
		public IDataEntityRuntime getDataEntityRuntime() {
			return getSelf();
		}

		@Override
		public ISysDBSchemeRuntime getSysDBSchemeRuntime() {
			return getSelf().getSysDBSchemeRuntime();
		}

		@Override
		public Object executeActionReal(IPSDEAction iPSDEAction, Object[] args, Object actionData) throws Throwable {
			return getSelf().doExecuteActionReal(iPSDEAction.getName(), iPSDEAction, args, actionData);
		}

		@Override
		public Object fetchDataSetReal(IPSDEDataSet iPSDEDataSet, Object[] args, Object actionData) throws Throwable {
			return getSelf().doFetchDataSetReal(iPSDEDataSet.getName(), iPSDEDataSet, args, actionData);
		}

		@Override
		public Object executeActionReal(String strActionName, IPSDEAction iPSDEAction, Object[] args, Object actionData) throws Throwable {
			if (!StringUtils.hasLength(strActionName) && iPSDEAction != null) {
				strActionName = iPSDEAction.getName();
			}

			return getSelf().doExecuteActionReal(strActionName, iPSDEAction, args, actionData);
		}

		@Override
		public Object fetchDataSetReal(String strDataSetName, IPSDEDataSet iPSDEDataSet, Object[] args, Object actionData) throws Throwable {
			if (!StringUtils.hasLength(strDataSetName) && iPSDEDataSet != null) {
				strDataSetName = iPSDEDataSet.getName();
			}
			return getSelf().doFetchDataSetReal(strDataSetName, iPSDEDataSet, args, actionData);
		}

	};

	@Override
	public void init(ISystemRuntimeContext iSystemRuntimeContext, IPSDataEntity iPSDataEntity, Object data) throws Exception {
		this.iSystemRuntimeContext = iSystemRuntimeContext;
		this.strId = iPSDataEntity.getId();
		this.strName = iPSDataEntity.getName();
		this.data = data;
		this.bEnableDEService = iSystemRuntimeContext.getSystemRuntime().isEnableDEService(iPSDataEntity);
		// 实体为延迟加载，不调用 onInit();
	}

	@Override
	protected void onInit() throws Exception {

		if (this.getPSDataEntity().getPSSystemModule() != null) {
			this.iSystemModuleRuntime = this.getSystemRuntime().getSystemModuleRuntime(this.getPSDataEntity().getPSSystemModule().getId(), false);
			if (this.iSystemModuleRuntime instanceof ISystemModuleUtilRuntime) {
				this.iSystemModuleUtilRuntime = (ISystemModuleUtilRuntime) this.iSystemModuleRuntime;
			}
		}

		super.onInit();

		// 缓存搜索模式
		java.util.List<IPSDEField> psDEFieldList = this.getPSDataEntity().getAllPSDEFields();
		if (psDEFieldList != null) {
			for (IPSDEField iPSDEField : psDEFieldList) {
				java.util.List<IPSDEFSearchMode> psDEFSearchModeList = iPSDEField.getAllPSDEFSearchModes();
				if (psDEFSearchModeList != null) {
					for (IPSDEFSearchMode iPSDEFSearchMode : psDEFSearchModeList) {
						psDEFSearchModeMap.put(iPSDEFSearchMode.getLowerCaseName(), iPSDEFSearchMode);
					}
				}
				if (StringUtils.hasLength(iPSDEField.getCodeName())) {
					this.psDEFieldMap2.put(iPSDEField.getCodeName().toLowerCase(), iPSDEField);
				}
			}
		}

		java.util.List<IPSDERBase> psDERBases = this.getPSDataEntity().getMinorPSDERs();
		if (psDERBases != null) {
			for (IPSDERBase iPSDERBase : psDERBases) {
				IDERRuntime iDERRuntime = this.createDERRuntime(iPSDERBase);
				if (iDERRuntime == null) {
					continue;
				}
				try {
					iDERRuntime.init(this.getDataEntityRuntimeContext(), iPSDERBase);
				} catch (Exception ex) {
					throw new Exception(String.format("初始化实体关系[%1$s]运行时对象发生异常，%2$s", iPSDERBase.getName(), ex.getMessage()), ex);
				}
				if (this.derRuntimeMap == null) {
					this.derRuntimeMap = new HashMap<String, IDERRuntime>();
				}
				this.derRuntimeMap.put(iPSDERBase.getId(), iDERRuntime);
			}
		}

		java.util.List<IPSDEMap> psDEMapList = this.getPSDataEntity().getAllPSDEMaps();
		if (!ObjectUtils.isEmpty(psDEMapList)) {
			for (IPSDEMap iPSDEMap : psDEMapList) {
				IDEMapRuntime iDEMapRuntime = this.createDEMapRuntime(iPSDEMap);
				if (iDEMapRuntime == null) {
					continue;
				}
				try {
					iDEMapRuntime.init(this.getDataEntityRuntimeContext(), iPSDEMap);
				} catch (Exception ex) {
					throw new Exception(String.format("初始化实体映射[%1$s]运行时对象发生异常，%2$s", iPSDEMap.getName(), ex.getMessage()), ex);
				}
				if (this.deMapRuntimeMap == null) {
					this.deMapRuntimeMap = new LinkedHashMap<String, IDEMapRuntime>();
				}
				this.deMapRuntimeMap.put(iPSDEMap.getCodeName().toLowerCase(), iDEMapRuntime);
			}
		}

		prepareDEMethods();

		prepareDEWFs();

		prepareQuickSearchPSDEFields();

		IDataEntityAccessManager iDataEntityAccessManager = this.createDataEntityAccessManager();
		iDataEntityAccessManager.init(this.getDataEntityRuntimeContext(), this.getSystemRuntime().getSystemAccessManager());
		this.iDataEntityAccessManager = iDataEntityAccessManager;

		if (this.getStorageMode() != DEStorageModes.NONE && this.getStorageMode() != DEStorageModes.SERVICEAPI) {
			// 获取当前实体持久化对象
			if (this.getSystemModuleUtilRuntime() != null) {
				this.iSystemPersistentAdapter = this.getSystemModuleUtilRuntime().getSystemPersistentAdapter(this.getPSDataEntity());
			} else {
				this.iSystemPersistentAdapter = ((net.ibizsys.central.ISystemRuntimeContext) this.getSystemRuntimeContext()).getSystemPersistentAdapter(this.getPSDataEntity());
			}

			if (this.getStorageMode() == DEStorageModes.SQL) {
				if (this.getPSDataEntity().getPSSysDBScheme() != null) {
					this.iSysDBSchemeRuntime = this.getSystemRuntime().getSysDBSchemeRuntime(this.getPSDataEntity().getPSSysDBScheme().getId(), false);
				}
				if (this.getSysDBSchemeRuntime() != null) {
					String strDBType = this.getSysDBSchemeRuntime().getDBType();
					if (!StringUtils.hasLength(strDBType)) {
						strDBType = DBTypes.MYSQL5;
					}
					List<IPSDEDBConfig> psDEDBConfigList = this.getPSDataEntity().getAllPSDEDBConfigs();
					if (psDEDBConfigList != null) {
						for (IPSDEDBConfig iPSDEDBConfig : psDEDBConfigList) {
							if (strDBType.equals(iPSDEDBConfig.getDBType())) {
								this.defaultPSDEDBConfig = iPSDEDBConfig;
								break;
							}
						}
					}
					String strTableName = this.getTableName();
					if (StringUtils.hasLength(strTableName)) {
						ISysDBTableRuntime iSysDBTableRuntime = this.getSysDBSchemeRuntime().getSysDBTableRuntime(strTableName, true);
						if (iSysDBTableRuntime != null) {
							iSysDBTableRuntime.setDataEntityRuntime(this);
						}
					}
				}
			}
		} else if (this.getStorageMode() == DEStorageModes.SERVICEAPI) {
			this.iSubSysServiceAPIRuntime = this.getSystemRuntime().getSubSysServiceAPIRuntime(this.getPSDataEntity().getPSSubSysServiceAPIMust().getId(), false);
			this.iSubSysServiceAPIDERuntime = this.iSubSysServiceAPIRuntime.getSubSysServiceAPIDERuntime(this.getPSDataEntity().getPSSubSysServiceAPIDEMust().getId(), false);
		} else if (this.getStorageMode() == DEStorageModes.NONE) {
			if (this.isVirtual()) {
				if(this.getVirtualMode() == DEVirtualModes.MINHERIT) {
					if (getPSDERMultiInherits() != null && this.getPSDERMultiInherits().size() > 0) {
						IDataEntityRuntime majorDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(this.getPSDERMultiInherits().get(0).getMajorPSDataEntityMust().getId());
						this.iSystemPersistentAdapter = majorDataEntityRuntime.getSystemPersistentAdapter();
						this.iSysDBSchemeRuntime = majorDataEntityRuntime.getSysDBSchemeRuntime();
					}
				}
				else
					if(this.getVirtualMode() == DEVirtualModes.INDEXMAJOR) {
						if (this.getPSDataEntity().getMajorPSDERs() != null && this.getPSDataEntity().getMajorPSDERs().size() > 0) {
							for(IPSDERBase iPSDERBase : this.getPSDataEntity().getMajorPSDERs()) {
								if(DERTypes.DERINDEX.equals(iPSDERBase.getDERType())) {
									IDataEntityRuntime minorDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(iPSDERBase.getMinorPSDataEntityMust().getId());
									if(minorDataEntityRuntime.getSystemPersistentAdapter()!=null) {
										this.iSystemPersistentAdapter = minorDataEntityRuntime.getSystemPersistentAdapter();
										this.iSysDBSchemeRuntime = minorDataEntityRuntime.getSysDBSchemeRuntime();
										break;
									}
								}
							}
						}
					}
			}
		}

	}

	private DataEntityRuntime getSelf() {
		return this;
	}

	@Override
	protected IDataEntityRuntimeContext getDataEntityRuntimeContext() {
		return this.iDataEntityRuntimeContext;
	}

	@Override
	public IDEService getDEService() {
		if (!this.isEnableDEService() || this.iDEService != null) {
			return this.iDEService;
		}
		IDEService iDEService = this.getSystemRuntime().getDEService(this);
		if (iDEService instanceof IDEServiceInitable) {
			try {
				((IDEServiceInitable) iDEService).init(this.getDataEntityRuntimeContext());
			} catch (Exception ex) {
				log.debug(String.format("初始化实体服务对象发生异常，%1$s", ex.getMessage()), ex);
				throw new DataEntityRuntimeException(this, String.format("初始化实体服务对象发生异常，%1$s", ex.getMessage()), ex);
			}
		} else {
			iDEService.prepare();
		}

		this.iDEService = iDEService;
		return this.iDEService;
	}

	/**
	 * 是否启用运行时对象的服务重写模式
	 * 
	 * @return
	 */
	protected boolean isEnableRuntimeServiceMode() {
		return false;
	}

	/**
	 * 准备实体方法
	 * 
	 * @throws Exception
	 */
	protected void prepareDEMethods() throws Exception {

		if (this.methodMap != null) {
			return;
		}

		Map<String, Object> methodMap = new HashMap<String, Object>();

		// 准备实体方法
		java.util.List<IPSDEAction> psDEActionList = this.getPSDataEntity().getAllPSDEActions();
		if (psDEActionList != null) {
			for (IPSDEAction iPSDEAction : psDEActionList) {
				String strCodeName = iPSDEAction.getCodeName();
				if (!StringUtils.hasLength(strCodeName)) {
					throw new ModelException(iPSDEAction, String.format("实体行为[%1$s]没有指定代码标识", iPSDEAction.getName()));
				}
				String strCodeNameFormat = this.getSystemRuntime().getSystemRuntimeSetting().getDEActionCodeNameFormat();
				if (StringUtils.hasLength(strCodeNameFormat)) {
					strCodeName = String.format(strCodeNameFormat, strCodeName);
				}

				if (!StringUtils.hasLength(strCodeName)) {
					throw new ModelException(iPSDEAction, String.format("实体行为[%1$s]无法计算代码标识", iPSDEAction.getName()));
				}
				methodMap.put(strCodeName.toLowerCase(), iPSDEAction);
			}
		}

		// 准备实体数据集
		java.util.List<IPSDEDataSet> psDEDataSetList = this.getPSDataEntity().getAllPSDEDataSets();
		if (psDEDataSetList != null) {
			for (IPSDEDataSet iPSDEDataSet : psDEDataSetList) {
				String strCodeName = iPSDEDataSet.getCodeName();
				if (!StringUtils.hasLength(strCodeName)) {
					throw new ModelException(iPSDEDataSet, String.format("实体数据集[%1$s]没有指定代码标识", iPSDEDataSet.getName()));
				}
				String strCodeNameFormat = this.getSystemRuntime().getSystemRuntimeSetting().getDEDataSetCodeNameFormat();
				if (StringUtils.hasLength(strCodeNameFormat)) {
					strCodeName = String.format(strCodeNameFormat, strCodeName);
				}

				if (!StringUtils.hasLength(strCodeName)) {
					throw new ModelException(iPSDEDataSet, String.format("实体数据集[%1$s]无法计算代码标识", iPSDEDataSet.getName()));
				}
				methodMap.put(strCodeName.toLowerCase(), iPSDEDataSet);
			}
		}

		java.util.List<IPSDEDataQuery> psDEDataQueryList = this.getPSDataEntity().getAllPSDEDataQueries();
		if (psDEDataQueryList != null) {
			for (IPSDEDataQuery iPSDEDataQuery : psDEDataQueryList) {
				java.util.List<IPSDEDataQueryCode> psDEDataQueryCodeList = iPSDEDataQuery.getAllPSDEDataQueryCodes();
				if (psDEDataQueryCodeList != null) {
					for (IPSDEDataQueryCode iPSDEDataQueryCode : psDEDataQueryCodeList) {
						IDEDataQueryCodeRuntime iDEDataQueryCodeRuntime = this.createDEDataQueryCodeRuntime(iPSDEDataQueryCode);
						iDEDataQueryCodeRuntime.init(this.getDataEntityRuntimeContext(), iPSDEDataQuery, iPSDEDataQueryCode);
						String strTag = String.format("%1$s|%2$s", iPSDEDataQuery.getId(), iPSDEDataQueryCode.getDBType());
						if (this.deDataQueryCodeRuntimeMap == null) {
							this.deDataQueryCodeRuntimeMap = new HashMap<>();
						}
						this.deDataQueryCodeRuntimeMap.put(strTag, iDEDataQueryCodeRuntime);
					}
				}
			}
		}

		IDEMethodDTORuntime defaultDEMethodDTORuntime = null;
		IDEFilterDTORuntime defaultDEFilterDTORuntime = null;
		java.util.List<IPSDEMethodDTO> psDEMethodDTOList = this.getPSDataEntity().getAllPSDEMethodDTOs();
		if (psDEMethodDTOList != null) {
			for (IPSDEMethodDTO iPSDEMethodDTO : psDEMethodDTOList) {

				IDEMethodDTORuntime iDEMethodDTORuntime = this.createDEMethodDTORuntime(iPSDEMethodDTO);
				iDEMethodDTORuntime.init(this.getDataEntityRuntimeContext(), iPSDEMethodDTO);
				this.deMethodDTORuntimeMap.put(iDEMethodDTORuntime.getId(), iDEMethodDTORuntime);

				if (!iPSDEMethodDTO.isDefaultMode()) {
					continue;
				}
				// 根据类型判断
				if (DEMethodDTOTypes.DEFAULT.equals(iPSDEMethodDTO.getType())) {
					defaultDEMethodDTORuntime = iDEMethodDTORuntime;
					continue;
				}

				if (DEMethodDTOTypes.DEFILTER.equals(iPSDEMethodDTO.getType())) {
					if (!(iDEMethodDTORuntime instanceof IDEFilterDTORuntime)) {
						throw new ModelException(iPSDEMethodDTO, String.format("实体方法DTO[%1$s]类型不正确", iPSDEMethodDTO.getName()));
					}
					defaultDEFilterDTORuntime = (IDEFilterDTORuntime) iDEMethodDTORuntime;
					continue;
				}
			}
		}

		if (this.methodMap == null) {
			this.methodMap = methodMap;
			this.defaultDEMethodDTORuntime = defaultDEMethodDTORuntime;
			this.defaultDEFilterDTORuntime = defaultDEFilterDTORuntime;
		}

		this.onPrepareDEMethods();
	}

	protected void onPrepareDEMethods() throws Exception {

		Method[] methods = this.getClass().getDeclaredMethods();
		if (ObjectUtils.isEmpty(methods)) {
			return;
		}

		for (Method method : methods) {
			DEAction deAction = method.getAnnotation(DEAction.class);
			if (deAction != null) {
				String name = deAction.name();
				if (!StringUtils.hasLength(name)) {
					name = deAction.value();
				}

				if (!StringUtils.hasLength(name)) {
					throw new Exception(String.format("代码方法[%1$s]实体行为注解未指定行为标识", method.getName()));
				}

				IPSDEAction iPSDEAction = this.getPSDEAction(name);
				if (iPSDEAction == null) {
					throw new Exception(String.format("代码方法[%1$s]实体行为注解指定行为[%2$s]不存在", method.getName(), name));
				}

				this.registerDEActionPluginRuntime(iPSDEAction.getName(), new IAction() {
					@Override
					public Object execute(Object[] args) throws Throwable {
						if (!method.isAccessible()) {
							method.setAccessible(true);
						}
						return method.invoke(getSelf(), args);
					}
				});

				continue;
			}

			DEDataSet deDataSet = method.getAnnotation(DEDataSet.class);
			if (deDataSet != null) {
				String name = deDataSet.name();
				if (!StringUtils.hasLength(name)) {
					name = deDataSet.value();
				}

				if (!StringUtils.hasLength(name)) {
					throw new Exception(String.format("代码方法[%1$s]实体数据集注解未指定数据集标识", method.getName()));
				}

				IPSDEDataSet iPSDEDataSet = this.getPSDEDataSet(name);
				if (iPSDEDataSet == null) {
					throw new Exception(String.format("代码方法[%1$s]实体数据集注解指定数据集[%2$s]不存在", method.getName(), name));
				}

				this.registerDEDataSetPluginRuntime(iPSDEDataSet.getName(), new IAction() {
					@Override
					public Object execute(Object[] args) throws Throwable {
						if (!method.isAccessible()) {
							method.setAccessible(true);
						}
						return method.invoke(getSelf(), args);
					}
				});

				continue;
			}

		}
	}

	@Override
	public ISystemModuleUtilRuntime getSystemModuleUtilRuntime() {
		this.prepare();
		return this.iSystemModuleUtilRuntime;
	}

	@Override
	public ISystemModuleRuntime getSystemModuleRuntime() {
		this.prepare();
		return this.iSystemModuleRuntime;
	}

	@Override
	public IPSDEMethodDTO getDefaultPSDEMethodDTO() {
		this.prepare();
		if (this.defaultDEMethodDTORuntime != null) {
			return this.defaultDEMethodDTORuntime.getPSDEMethodDTO();
		}
		return null;
	}

	@Override
	public IDEMethodDTORuntime getDEMethodDTORuntime(IPSDEMethodDTO iPSDEMethodDTO, boolean bTryMode) {

		Assert.notNull(iPSDEMethodDTO, "传入实体方法DTO模型对象无效");

		this.prepare();
		IDEMethodDTORuntime iDEMethodDTORuntime = this.deMethodDTORuntimeMap.get(iPSDEMethodDTO.getId());
		if (iDEMethodDTORuntime != null || bTryMode) {
			return iDEMethodDTORuntime;
		}
		throw new DataEntityRuntimeException(this, String.format("无法获取指定实体方法DTO运行时对象[%1$s]", iPSDEMethodDTO.getId()));
	}

	/**
	 * 准备实体工作流
	 * 
	 * @throws Exception
	 */
	protected void prepareDEWFs() throws Exception {

		if (this.deWFRuntimeMap != null) {
			return;
		}

		Map<String, IDEWFRuntime> deWFRuntimeMap = new HashMap<String, IDEWFRuntime>();

		// 准备实体工作流
		java.util.List<IPSDEWF> psDEWFList = this.getPSDataEntity().getAllPSDEWFs();
		if (psDEWFList != null) {
			for (IPSDEWF iPSDEWF : psDEWFList) {
				IDEWFRuntime iDEWFRuntime = this.createDEWFRuntime(iPSDEWF);
				iDEWFRuntime.init(this.getDataEntityRuntimeContext(), iPSDEWF);
				deWFRuntimeMap.put(iPSDEWF.getId(), iDEWFRuntime);
				if (iPSDEWF.getPSWorkflow() != null) {
					deWFRuntimeMap.put(iPSDEWF.getPSWorkflow().getId(), iDEWFRuntime);
				}
			}
		}

		if (this.deWFRuntimeMap == null && deWFRuntimeMap.size() != 0) {
			this.deWFRuntimeMap = deWFRuntimeMap;
		}
	}

	/**
	 * 准备支持快速搜索的属性集合
	 * 
	 * @throws Exception
	 */
	protected void prepareQuickSearchPSDEFields() throws Exception {

		if (this.quickSearchPSDEFieldList != null) {
			return;
		}
		List<IPSDEField> quickSearchPSDEFieldList = new ArrayList<IPSDEField>();

		java.util.List<IPSDEField> psDEFieldList = this.getPSDataEntity().getAllPSDEFields();
		if (psDEFieldList != null) {
			for (IPSDEField iPSDEField : psDEFieldList) {
				if (iPSDEField.isEnableQuickSearch()) {
					quickSearchPSDEFieldList.add(iPSDEField);
				}
			}
		}

		if (this.quickSearchPSDEFieldList == null && quickSearchPSDEFieldList.size() != 0) {
			this.quickSearchPSDEFieldList = quickSearchPSDEFieldList;
		}
	}

	@Override
	public IPSDEDBConfig getDefaultPSDEDBConfig() {
		this.prepare();
		return this.defaultPSDEDBConfig;
	}

	@Override
	public String getTableName() {
		this.prepare();
		if (getDefaultPSDEDBConfig() != null) {
			return getDefaultPSDEDBConfig().getTableName();
		}
		try {
			return this.getPSDataEntity().getTableName();
		} catch (Exception ex) {
			throw new DataEntityRuntimeException(this, String.format("获取实体默认数据表名称发生异常，%1$s", ex.getMessage()), ex);
		}
	}

	@Override
	public IPSDEFilterDTO getDefaultPSDEFilterDTO() {
		this.prepare();
		if (this.defaultDEFilterDTORuntime != null) {
			return this.defaultDEFilterDTORuntime.getPSDEFilterDTO();
		}
		return null;
	}

	protected IDEMethodDTORuntime createDEMethodDTORuntime(IPSDEMethodDTO iPSDEMethodDTO) {
		// 根据对象类型进行建立
		if (DEMethodDTOTypes.DEFAULT.equals(iPSDEMethodDTO.getType())) {
			return createDEMethodDTORuntime();
		}

		if (DEMethodDTOTypes.DEACTIONINPUT.equals(iPSDEMethodDTO.getType())) {
			return createDEActionInputDTORuntime();
		}

		if (DEMethodDTOTypes.DEFILTER.equals(iPSDEMethodDTO.getType())) {
			return createDEFilterDTORuntime();
		}

		throw new DataEntityRuntimeException(this, String.format("无法识别的实体方法DTO类型[%1$s][%2$s]", iPSDEMethodDTO.getName(), iPSDEMethodDTO.getType()));
	}

	@Override
	public IDEMethodDTO getDEMethodDTO(IPSDEMethodDTO iPSDEMethodDTO, Object objData) throws Exception {

		return getDEMethodDTO(iPSDEMethodDTO, objData, true);
	}

	@Override
	public IDEMethodDTO getDEMethodDTO(IPSDEMethodDTO iPSDEMethodDTO, Object objData, boolean bDTOMode) throws Exception {
		this.prepare();
		Assert.notNull(iPSDEMethodDTO, "实体方法DTO模型对象无效");
		// 根据对象类型进行建立
		if (DEMethodDTOTypes.DEFAULT.equals(iPSDEMethodDTO.getType())) {
			IEntityDTO iEntityDTO = createEntityDTO(iPSDEMethodDTO);
			iEntityDTO.init(this.getDEMethodDTORuntime(iPSDEMethodDTO, false), objData, bDTOMode);
			return iEntityDTO;
		}

		if (DEMethodDTOTypes.DEACTIONINPUT.equals(iPSDEMethodDTO.getType())) {
			IEntityDTO iEntityDTO = createEntityDTO(iPSDEMethodDTO);
			iEntityDTO.init(this.getDEMethodDTORuntime(iPSDEMethodDTO, false), objData, bDTOMode);
			return iEntityDTO;
		}

		if (DEMethodDTOTypes.DEFILTER.equals(iPSDEMethodDTO.getType())) {
			ISearchContextDTO iSearchContextDTO = createSearchContextDTO(iPSDEMethodDTO);
			iSearchContextDTO.init(this.getDEMethodDTORuntime(iPSDEMethodDTO, false), objData, bDTOMode);
			return iSearchContextDTO;
		}

		throw new DataEntityRuntimeException(this, String.format("无法识别的实体方法DTO类型[%1$s][%2$s]", iPSDEMethodDTO.getName(), iPSDEMethodDTO.getType()));
	}

	protected IEntityDTO createEntityDTO(IPSDEMethodDTO iPSDEMethodDTO) {
		if (this.getDEService() != null) {
			IEntityDTO iEntityDTO = this.getDEService().createEntityDTO(iPSDEMethodDTO);
			if (iEntityDTO != null) {
				return iEntityDTO;
			}
		}
		return new EntityDTO();
	}

	protected List<IEntityDTO> createEntityDTOList(IPSDEMethodDTO iPSDEMethodDTO) {
		if (this.getDEService() != null) {
			List<IEntityDTO> entityDTOList = this.getDEService().createEntityDTOList(iPSDEMethodDTO);
			if (entityDTOList != null) {
				return entityDTOList;
			}
		}
		return new ArrayList<IEntityDTO>();
	}

	protected ISearchContextDTO createSearchContextDTO(IPSDEMethodDTO iPSDEMethodDTO) {
		if (this.getDEService() != null) {
			ISearchContextDTO iSearchContextDTO = this.getDEService().createSearchContextDTO(iPSDEMethodDTO);
			if (iSearchContextDTO != null) {
				return iSearchContextDTO;
			}
		}
		return new SearchContextDTO();
	}

	/**
	 * 建立实体方法DTO运行时对象
	 * 
	 * @return
	 */
	protected IDEMethodDTORuntime createDEMethodDTORuntime() {
		return new DEMethodDTORuntime();
	}

	/**
	 * 建立实体行为DTO运行时对象
	 * 
	 * @return
	 */
	protected IDEActionInputDTORuntime createDEActionInputDTORuntime() {
		return new DEActionInputDTORuntime();
	}

	/**
	 * 建立实体过滤器DTO运行时对象
	 * 
	 * @return
	 */
	protected IDEFilterDTORuntime createDEFilterDTORuntime() {
		return new DEFilterDTORuntime();
	}

	protected IDEDataQueryCodeRuntime createDEDataQueryCodeRuntime(IPSDEDataQueryCode iPSDEDataQueryCode) {
		return new DEDataQueryCodeRuntime();
	}

	/**
	 * 获取实体方法对象
	 * 
	 * @param strMethodName
	 * @return
	 * @throws Exception
	 */
	protected Object getMethod(String strMethodName) {
		return this.methodMap.get(strMethodName.toLowerCase());
	}

	@Override
	public String getId() {
		return this.strId;
	}

	@Override
	public String getName() {
		return this.strName;
	}

	@Override
	public IDataEntityAccessManager getDataEntityAccessManager() {
		this.prepare();
		return this.iDataEntityAccessManager;
	}

	protected IDataEntityAccessManager createDataEntityAccessManager() {
		return this.getSystemRuntime().getSystemAccessManager().createDataEntityAccessManager(this);
	}

	/**
	 * 获取系统模型运行时上下文对象
	 * 
	 * @return
	 */
	protected net.ibizsys.central.ISystemRuntimeContext getSystemRuntimeContext() {
		return this.iSystemRuntimeContext;
	}

	protected Object getData() {
		return this.data;
	}

	@Override
	public net.ibizsys.central.ISystemRuntime getSystemRuntime() {
		return this.getSystemRuntimeContext().getSystemRuntime();
	}

	@Override
	public Object invokeMethod(String strMethodName, Object objArg, Object objTag) throws Throwable {
		this.prepare();
		Object objMethod = this.getMethod(strMethodName);
		if (objMethod == null) {
			throw new Exception(String.format("无法获取指定实体方法[%1$s]", strMethodName));
		}
		if (objMethod instanceof IPSDEAction) {
			IPSDEAction iPSDEAction = (IPSDEAction) objMethod;
			// 获取输入参数
			Object[] args = this.getActionArgs(iPSDEAction, objArg);
			Object objRet = executeAction(iPSDEAction.getName(), iPSDEAction, args);

			return objRet;
		}

		if (objMethod instanceof IPSDEDataSet) {
			IPSDEDataSet iPSDEDataSet = (IPSDEDataSet) objMethod;
			// 获取输入参数
			Object[] args = this.getDataSetArgs(iPSDEDataSet, objArg);
			Object objRet = fetchDataSet(iPSDEDataSet.getName(), iPSDEDataSet, args);

			return objRet;
		}

		throw new DataEntityRuntimeException(this, String.format("无法识别的实体方法[%1$s][%2$s]", strMethodName, objMethod));
	}

	protected Object[] getActionArgs(IPSDEAction iPSDEAction, Object objArg) throws Exception {
		IPSDEActionInput iPSDEActionInput = iPSDEAction.getPSDEActionInput();
		if (iPSDEActionInput == null) {
			throw new ModelException(iPSDEAction, String.format("实体行为[%1$s]没有指定输入对象", iPSDEAction.getName()));
		}
		if (DEMethodInputTypes.KEYFIELD.equals(iPSDEActionInput.getType()) || DEMethodInputTypes.KEYFIELDS.equals(iPSDEActionInput.getType()) || DEMethodInputTypes.DTO.equals(iPSDEActionInput.getType()) || DEMethodInputTypes.DTOS.equals(iPSDEActionInput.getType())) {

			if (ObjectUtils.isEmpty(objArg)) {
				throw new Exception("没有指定输入参数");
			}

			if (DEMethodInputTypes.KEYFIELD.equals(iPSDEActionInput.getType())) {
				if (objArg instanceof String) {
					Object objValue = this.getSystemRuntime().convertValue(this.getKeyPSDEField().getStdDataType(), (String) objArg);
					return new Object[] { objValue };
				} else {
					return new Object[] { objArg };
				}
			}

			if (DEMethodInputTypes.KEYFIELDS.equals(iPSDEActionInput.getType())) {
				if (objArg instanceof String) {
					// 进行分隔
					String strValue = (String) objArg;
					String[] items = strValue.trim().split("[;]");
					List list = new ArrayList();
					for (int i = 0; i < items.length; i++) {
						Object objValue = this.getSystemRuntime().convertValue(this.getKeyPSDEField().getStdDataType(), items[i]);
						list.add(objValue);
					}
					return new Object[] { list };
				} else {
					if (objArg.getClass().isArray()) {
						return new Object[] { Arrays.asList((Object[]) objArg) };
					} else {
						return new Object[] { objArg };
					}
				}
			}
			if (DEMethodInputTypes.DTO.equals(iPSDEActionInput.getType())) {
				return new Object[] { this.getDEMethodDTO(iPSDEActionInput.getPSDEMethodDTOMust(), objArg) };
			}
		}

		throw new DataEntityRuntimeException(this, String.format("无法识别的实体行为输入类型[%1$s][%2$s]", iPSDEAction.getName(), iPSDEActionInput.getType()));
	}

	protected Object[] getDataSetArgs(IPSDEDataSet iPSDEDataSet, Object objArg) throws Exception {
		IPSDEDataSetInput iPSDEDataSetInput = iPSDEDataSet.getPSDEDataSetInput();
		if (iPSDEDataSetInput == null) {
			throw new ModelException(iPSDEDataSet, String.format("实体数据集[%1$s]没有指定输入对象", iPSDEDataSet.getName()));
		}
		if (DEMethodInputTypes.DTO.equals(iPSDEDataSetInput.getType())) {
			return new Object[] { this.getDEMethodDTO(iPSDEDataSetInput.getPSDEFilterDTOMust(), objArg) };
		}

		throw new DataEntityRuntimeException(this, String.format("无法识别的实体数据集输入类型[%1$s][%2$s]", iPSDEDataSet.getName(), iPSDEDataSetInput.getType()));
	}

	@Override
	protected boolean isEnableExecuteAction(String strActionName, IPSDEAction iPSDEAction) {
		return true;
	}

	@Override
	protected boolean isEnableFetchDataSet(String strDataSetName, IPSDEDataSet iPSDEDataSet) {
		return true;
	}

	@Override
	protected Object onExecuteActionReal(String strActionName, IPSDEAction iPSDEAction, Object[] args, Object actionData) throws Throwable {

		if (isEnableRuntimeServiceMode()) {
			if (DEActions.CREATE.equalsIgnoreCase(strActionName)) {
				if (args[0] instanceof IEntityDTO) {
					doCreateReal((IEntityDTO) args[0], args, actionData);
					return null;
				}
			} else if (DEActions.UPDATE.equalsIgnoreCase(strActionName)) {
				if (args[0] instanceof IEntityDTO) {
					doUpdateReal((IEntityDTO) args[0], args, actionData);
					return null;
				}
			} else if (DEActions.REMOVE.equalsIgnoreCase(strActionName)) {
				doRemoveReal(args[0], args, actionData);
				return null;
			} else if (DEActions.GET.equalsIgnoreCase(strActionName)) {
				return doGetReal(args[0], args, actionData);
			} else if (DEActions.GETDRAFT.equalsIgnoreCase(strActionName)) {
				if (args[0] instanceof IEntityDTO) {
					return doGetDraftReal((IEntityDTO) args[0], args, actionData);
				}
			}
		} else {
			IDEService iDEService = this.getDEService();
			if (iDEService != null) {
				return iDEService.executeActionReal(this.getDataEntityRuntimeContext(), strActionName, iPSDEAction, args, actionData);
			}
		}

		return this.doExecuteActionReal(strActionName, iPSDEAction, args, actionData);
	}

	protected void doCreateReal(IEntityDTO iEntityDTO, Object[] args, Object actionData) throws Throwable {
		this.doExecuteActionReal(DEActions.CREATE, null, args, actionData);
		return;
	}

	protected void doUpdateReal(IEntityDTO iEntityDTO, Object[] args, Object actionData) throws Throwable {
		this.doExecuteActionReal(DEActions.UPDATE, null, args, actionData);
		return;
	}

	protected void doRemoveReal(Object objKey, Object[] args, Object actionData) throws Throwable {
		this.doExecuteActionReal(DEActions.REMOVE, null, args, actionData);
		return;
	}

	protected IEntityDTO doGetReal(Object objKey, Object[] args, Object actionData) throws Throwable {
		Object objRet = this.doExecuteActionReal(DEActions.GET, null, args, actionData);
		if (objRet instanceof IEntityDTO) {
			return (IEntityDTO) objRet;
		}
		return null;
	}

	protected IEntityDTO doGetDraftReal(IEntityDTO iEntityDTO, Object[] args, Object actionData) throws Throwable {
		Object objRet = this.doExecuteActionReal(DEActions.GETDRAFT, null, args, actionData);
		if (objRet instanceof IEntityDTO) {
			return (IEntityDTO) objRet;
		}
		return null;
	}

	protected Object doExecuteActionReal(String strActionName, IPSDEAction iPSDEAction, Object[] args, Object actionData) throws Throwable {

		if (iPSDEAction == null) {
			iPSDEAction = this.getPSDEAction(strActionName);
		}

		IDEActionRuntime iDEActionRuntime = getDEActionRuntime(iPSDEAction);
		if (iDEActionRuntime != null) {
			return iDEActionRuntime.execute(args);
		}

		/**
		 * 进行工作流回调行为相关处理
		 */
		if (this.getDefaultPSDEWF() != null && strActionName.toLowerCase().indexOf("wf") == 0) {
			if (args[0] instanceof IEntityDTO) {
				IPSDEWF iPSDEWF = null;
				if (args.length >= 2 && (args[1] instanceof IPSDEWF)) {
					iPSDEWF = (IPSDEWF) args[1];
				}
				if (iPSDEWF == null) {
					iPSDEWF = this.getDefaultPSDEWF();
				}

				if (DEActions.WFSTART.equalsIgnoreCase(strActionName)) {
					this.onWFStart((IEntityDTO) args[0], iPSDEAction, iPSDEWF, ActionSessionManager.getCurrentSession().getDynaInstRuntime(), actionData);
				} else {
					this.onWFActionReal(strActionName, (IEntityDTO) args[0], iPSDEAction, this.getDefaultPSDEWF(), actionData);
				}
			}
			return null;
		}

		if (iPSDEAction == null) {
			// return super.onExecuteAction(strActionName, iPSDEAction, args,
			// actionData);
			return super.onExecuteActionReal(strActionName, iPSDEAction, args, actionData);
		}

		String strActionMode = iPSDEAction.getActionMode();

		if (args[0] instanceof IEntityDTO) {
			// 执行处理逻辑及脚本行为
			if (DEActionTypes.DELOGIC.equals(iPSDEAction.getActionType())) {
				IPSDELogicAction iPSDELogicAction = (IPSDELogicAction) iPSDEAction;
				return this.executeDELogic((IEntityDTO) args[0], iPSDEAction, iPSDELogicAction.getPSDELogic(), ActionSessionManager.getCurrentSession().getDynaInstRuntime(), actionData);
			} else if (DEActionTypes.SCRIPT.equals(iPSDEAction.getActionType())) {
				IPSDEScriptAction iPSDEScriptAction = (IPSDEScriptAction) iPSDEAction;
				return this.executeDEScriptLogic((IEntityDTO) args[0], iPSDEScriptAction, null, ActionSessionManager.getCurrentSession().getDynaInstRuntime(), actionData);
			}
		}

		if (this.getStorageMode() == DEStorageModes.SERVICEAPI) {
			IPSSubSysServiceAPIDEMethod iPSSubSysServiceAPIDEMethod = iPSDEAction.getPSSubSysServiceAPIDEMethod();
			if (iPSSubSysServiceAPIDEMethod != null) {
				Object objData = this.executeSubSysServiceAPIDEMethod(iPSSubSysServiceAPIDEMethod, iPSDEAction, args);
				if (DEActionModes.CREATE.equals(strActionMode) || DEActionModes.UPDATE.equals(strActionMode)) {
					if (args[0] instanceof IEntityDTO) {
						if (objData instanceof IEntityDTO) {
							((IEntityDTO) args[0]).reload(((IEntityDTO) objData).any(), true);
						} else {
							((IEntityDTO) args[0]).reload(objData, false);
						}
						return null;
					}
				}
				return objData;
			}
		}

		if (this.getSystemPersistentAdapter() != null) {

			if (DEActionModes.CREATE.equals(strActionMode)) {
				if (args[0] instanceof IEntityDTO) {
					Object objData = getSystemPersistentAdapter().create(this, iPSDEAction, (IEntityDTO) args[0], null, true, null, false);
					if (objData instanceof IEntityDTO) {
						((IEntityDTO) args[0]).reload(((IEntityDTO) objData).any(), true);
					} else {
						((IEntityDTO) args[0]).reload(objData, false);
					}
				} else {
					throw new Exception(String.format("不支持的新建数据对象[%1$s]", args[0]));
				}
				return null;
			}

			if (DEActionModes.UPDATE.equals(strActionMode)) {
				if (args[0] instanceof IEntityDTO) {
					Object objData = getSystemPersistentAdapter().update(this, iPSDEAction, (IEntityDTO) args[0], null, true, null, false);
					if (objData instanceof IEntityDTO) {
						((IEntityDTO) args[0]).reload(((IEntityDTO) objData).any(), true);
					} else {
						((IEntityDTO) args[0]).reload(objData, false);
					}
				} else {
					throw new Exception(String.format("不支持的更新数据对象[%1$s]", args[0]));
				}
				return null;
			}

			if (DEActionModes.DELETE.equals(strActionMode) || DEActionModes.REMOVE.equals(strActionMode)) {
				if (args[0] instanceof IEntityDTO) {
					IEntityDTO iEntityDTO = (IEntityDTO) args[0];
					Object objKey = iEntityDTO.get(this.getKeyPSDEField().getLowerCaseName());
					getSystemPersistentAdapter().remove(this, iPSDEAction, objKey, false);

				} else {
					getSystemPersistentAdapter().remove(this, iPSDEAction, args[0], false);
				}

				return null;
			}

			if (DEActionModes.READ.equals(strActionMode)) {

				// 进一步判断是否为通过主键查询
				if (DEActionTypes.SELECTBYKEY.equals(iPSDEAction.getActionType())) {
					ISearchContextDTO iSearchContextDTO = this.createSearchContext();
					SearchContextDTO.addSearchFieldCond(iSearchContextDTO, this.getKeyPSDEField().getLowerCaseName(), Conditions.EQ, args[0], null);
					if (iPSDEAction instanceof IPSDESelectByKeyAction) {
						IPSDESelectByKeyAction iPSDESelectByKeyAction = (IPSDESelectByKeyAction) iPSDEAction;
						if (iPSDESelectByKeyAction.getPSDEDataQuery() == null) {
							return this.selectOne(iSearchContextDTO, false);
						} else {
							List<IEntityDTO> list = this.selectDataQuery(iPSDESelectByKeyAction.getPSDEDataQuery(), iSearchContextDTO);
							if (list == null || list.size() == 0) {
								throw new DataEntityRuntimeException(this, String.format("无法获取指定数据[%1$s]", args[0]), Errors.INVALIDDATA);
							}
							return list.get(0);
						}
					} else
						return this.selectOne(iSearchContextDTO, false);
				} else {
					// 判断参数是否为对象
					if (args[0] instanceof IEntityDTO) {
						IEntityDTO iEntityDTO = (IEntityDTO) args[0];
						Object objKey = iEntityDTO.get(this.getKeyPSDEField().getLowerCaseName());
						Object objData = getSystemPersistentAdapter().get(this, iPSDEAction, objKey, null, false);
						if (objData == null) {
							return objData;
						}

						iEntityDTO.resetAll();
						if (objData instanceof IEntityDTO) {
							iEntityDTO.reload(objData, true);
						} else {
							iEntityDTO.reload(objData, false);
						}

						return iEntityDTO;
					} else {
						Object objData = getSystemPersistentAdapter().get(this, iPSDEAction, args[0], null, false);
						if (objData == null || (objData instanceof IEntityDTO)) {
							return objData;
						}

						IPSDEMethodDTO iPSDEMethodDTO = iPSDEAction.getPSDEActionReturnMust().getPSDEMethodDTO();
						if (iPSDEMethodDTO == null) {
							iPSDEMethodDTO = this.getDefaultPSDEMethodDTO();
						}
						IEntityDTO iEntityDTO = this.createEntityDTO(iPSDEMethodDTO);
						iEntityDTO.init(this.getDEMethodDTORuntime(iPSDEMethodDTO, false), objData, false);
						return iEntityDTO;
					}
				}
			}

			if (DEActionModes.GETDRAFT.equals(strActionMode)) {

				String strRetType = iPSDEAction.getPSDEActionReturnMust().getType();
				if (DEMethodReturnTypes.VOID.equals(strRetType)) {
					return null;
				}

				if (DEMethodReturnTypes.DTO.equals(strRetType)) {
					IPSDEMethodDTO iPSDEMethodDTO = iPSDEAction.getPSDEActionReturnMust().getPSDEMethodDTO();
					if (iPSDEMethodDTO == null) {
						iPSDEMethodDTO = this.getDefaultPSDEMethodDTO();
					}
					IEntityDTO iEntityDTO = this.createEntityDTO(iPSDEMethodDTO);
					iEntityDTO.init(this.getDEMethodDTORuntime(iPSDEMethodDTO, false), args[0], true);
					return iEntityDTO;
				}

				return null;
			}

			if (DEActionModes.CHECKKEY.equals(strActionMode)) {

				if (this.getUniTagPSDEField() != null) {
					Object objKey = null;
					if (args[0] instanceof IEntityDTO) {
						IEntityDTO iEntityDTO = (IEntityDTO) args[0];
						objKey = iEntityDTO.get(this.getUniTagPSDEField().getLowerCaseName());
						if (ObjectUtils.isEmpty(objKey)) {
							if (!this.fillEntityKeyValue(iEntityDTO)) {
								return CheckKeyStates.OK;
							}
							objKey = iEntityDTO.get(this.getUniTagPSDEField().getLowerCaseName());
						}
					} else {
						objKey = args[0];
					}
					return this.checkKeyState(objKey);
				} else {
					Object objKey = null;
					if (args[0] instanceof IEntityDTO) {
						IEntityDTO iEntityDTO = (IEntityDTO) args[0];
						objKey = iEntityDTO.get(this.getKeyPSDEField().getLowerCaseName());
						if (ObjectUtils.isEmpty(objKey)) {
							if (!this.fillEntityKeyValue(iEntityDTO)) {
								return CheckKeyStates.OK;
							}
							objKey = iEntityDTO.get(this.getKeyPSDEField().getLowerCaseName());
						}
					} else {
						objKey = args[0];
					}
					return this.checkKeyState(objKey);
				}

			}
		}

		return super.onExecuteActionReal(strActionName, iPSDEAction, args, actionData);
		// throw new DataEntityRuntimeException(this, String)
	}

	@Override
	protected boolean isEnableExecutePredefinedAction() {
		return false;
	}

	@Override
	protected Object onFetchDataSet(String strDataSetName, IPSDEDataSet iPSDEDataSet, Object[] args, Object actionData) throws Throwable {

		IDEMapRuntime iDEMapRuntime = this.getDEMapRuntime(strDataSetName, iPSDEDataSet);
		if (iDEMapRuntime != null) {
			log.debug(String.format("使用实体映射[%1$s]处理结果集[%2$s]", iDEMapRuntime.getName(), (iPSDEDataSet != null ? iPSDEDataSet.getName() : strDataSetName)));
			return iDEMapRuntime.fetchDataSet(strDataSetName, iPSDEDataSet, args, null);
		}

		return super.onFetchDataSet(strDataSetName, iPSDEDataSet, args, actionData);
	}

	@Override
	protected Object onFetchDataSetReal(String strDataSetName, IPSDEDataSet iPSDEDataSet, Object[] args, Object actionData) throws Throwable {
		IDEService iDEService = this.getDEService();
		if (iDEService != null) {
			return iDEService.fetchDataSetReal(this.getDataEntityRuntimeContext(), strDataSetName, iPSDEDataSet, args, actionData);
		}

		return this.doFetchDataSetReal(strDataSetName, iPSDEDataSet, args, actionData);
	}

	protected Object doFetchDataSetReal(String strDataSetName, IPSDEDataSet iPSDEDataSet, Object[] args, Object actionData) throws Throwable {

		if (iPSDEDataSet == null) {
			iPSDEDataSet = this.getPSDEDataSet(strDataSetName);
			if (iPSDEDataSet == null) {
				throw new DataEntityRuntimeException(this, String.format("无法获取实体数据集[%1$s]，无法获取对应的数据集模型", strDataSetName));
			}
		}

		IDEDataSetRuntime iDEDataSetRuntime = getDEDataSetRuntime(iPSDEDataSet);
		if (iDEDataSetRuntime != null) {
			return iDEDataSetRuntime.fetch(args);
		}

		if (this.getStorageMode() == DEStorageModes.SERVICEAPI) {
			IPSSubSysServiceAPIDEMethod iPSSubSysServiceAPIDEMethod = iPSDEDataSet.getPSSubSysServiceAPIDEMethod();
			if (iPSSubSysServiceAPIDEMethod != null) {
				return this.executeSubSysServiceAPIDEMethod(iPSSubSysServiceAPIDEMethod, iPSDEDataSet, args);
			}
		}

		if (this.getSystemPersistentAdapter() != null) {
			if (args != null && args.length > 0 && args[0] instanceof ISearchContext) {
				ISearchContext iSearchContext = (ISearchContext) args[0];
				Page page = this.getSystemPersistentAdapter().fetchDataSet(this, iPSDEDataSet, iSearchContext, null);
				page = getEntityDTOPage(page, iPSDEDataSet, iSearchContext.getPageable());
				this.fillEntityDTOPageNestedFields(page, iPSDEDataSet);
				return page;	
			}
		}

		return super.onFetchDataSetReal(strDataSetName, iPSDEDataSet, args, actionData);
	}

	public Page<IEntityDTO> getEntityDTOPage(Page page, IPSDEDataSet iPSDEDataSet, Pageable pagable) throws Throwable {
		if (page == null || page.getNumberOfElements() == 0) {
			return page;
		}
		// 判断是否需要进行DTO转化
		if (page.getContent().get(0) instanceof IEntityDTO) {
			return page;
		}

		IPSDEMethodDTO iPSDEMethodDTO = (iPSDEDataSet == null) ? getDefaultPSDEMethodDTO() : iPSDEDataSet.getPSDEDataSetReturnMust().getPSDEMethodDTOMust();
		IDEMethodDTORuntime iDEMethodDTORuntime = this.getDEMethodDTORuntime(iPSDEMethodDTO, false);

		List<IEntityDTO> entityDTOList = new ArrayList<IEntityDTO>();
		for (Object objItem : page.getContent()) {
			IEntityDTO iEntityDTO = this.createEntityDTO(iPSDEMethodDTO);
			iEntityDTO.init(iDEMethodDTORuntime, objItem, false);
			entityDTOList.add(iEntityDTO);
		}

		if (pagable == null) {
			return new PageImpl<IEntityDTO>(entityDTOList);
		} else {
			return new PageImpl<IEntityDTO>(entityDTOList, pagable, page.getTotalElements());
		}

	}

	public Page<IEntityDTO> getEntityDTOPage(Page page, IPSDEDataQuery iPSDEDataQuery, Pageable pagable) throws Throwable {
		if (page == null || page.getNumberOfElements() == 0) {
			return page;
		}
		// 判断是否需要进行DTO转化
		if (page.getContent().get(0) instanceof IEntityDTO) {
			return page;
		}

		IPSDEMethodDTO iPSDEMethodDTO = (iPSDEDataQuery == null) ? getDefaultPSDEMethodDTO() : iPSDEDataQuery.getPSDEDataQueryReturnMust().getPSDEMethodDTOMust();
		IDEMethodDTORuntime iDEMethodDTORuntime = this.getDEMethodDTORuntime(iPSDEMethodDTO, false);

		List<IEntityDTO> entityDTOList = new ArrayList<IEntityDTO>();
		for (Object objItem : page.getContent()) {
			IEntityDTO iEntityDTO = this.createEntityDTO(iPSDEMethodDTO);
			iEntityDTO.init(iDEMethodDTORuntime, objItem, false);
			entityDTOList.add(iEntityDTO);
		}

		if (pagable == null) {
			return new PageImpl<IEntityDTO>(entityDTOList);
		} else {
			return new PageImpl<IEntityDTO>(entityDTOList, pagable, page.getTotalElements());
		}

	}

	protected Object executeSubSysServiceAPIDEMethod(IPSSubSysServiceAPIDEMethod iPSSubSysServiceAPIDEMethod, IPSDEAction iPSDEAction, Object[] args) throws Throwable {
		return onExecuteSubSysServiceAPIDEMethod(iPSSubSysServiceAPIDEMethod, iPSDEAction, args);
	}

	protected Object onExecuteSubSysServiceAPIDEMethod(IPSSubSysServiceAPIDEMethod iPSSubSysServiceAPIDEMethod, IPSDEAction iPSDEAction, Object[] args) throws Throwable {
		ISubSysServiceAPIDERuntime iSubSysServiceAPIDERuntime = this.getSubSysServiceAPIDERuntime();
		if (iSubSysServiceAPIDERuntime == null) {
			throw new DataEntityRuntimeException(this, String.format("实体不存在外部服务接口实体运行时对象"));
		}

		return iSubSysServiceAPIDERuntime.invokeMethod(iPSSubSysServiceAPIDEMethod, this, iPSDEAction, args);
	}

	protected Object executeSubSysServiceAPIDEMethod(IPSSubSysServiceAPIDEMethod iPSSubSysServiceAPIDEMethod, IPSDEDataSet iPSDEDataSet, Object[] args) throws Throwable {
		return onExecuteSubSysServiceAPIDEMethod(iPSSubSysServiceAPIDEMethod, iPSDEDataSet, args);
	}

	protected Object onExecuteSubSysServiceAPIDEMethod(IPSSubSysServiceAPIDEMethod iPSSubSysServiceAPIDEMethod, IPSDEDataSet iPSDEDataSet, Object[] args) throws Throwable {
		ISubSysServiceAPIDERuntime iSubSysServiceAPIDERuntime = this.getSubSysServiceAPIDERuntime();
		if (iSubSysServiceAPIDERuntime == null) {
			throw new DataEntityRuntimeException(this, String.format("实体不存在外部服务接口实体运行时对象"));
		}

		return iSubSysServiceAPIDERuntime.invokeMethod(iPSSubSysServiceAPIDEMethod, this, iPSDEDataSet, args);
	}

	@Override
	public IEntityDTO createEntity() {
		IPSDEMethodDTO defaultPSDEMethodDTO = this.getDefaultPSDEMethodDTO();
		if (defaultPSDEMethodDTO == null) {
			throw new DataEntityRuntimeException(this, String.format("实体未定义默认方法DTO模型"));
		}
		try {
			IEntityDTO iEntityDTO = this.createEntityDTO(defaultPSDEMethodDTO);
			iEntityDTO.init(this.getDEMethodDTORuntime(defaultPSDEMethodDTO, false), null, false);
			return iEntityDTO;
		} catch (Exception e) {
			throw new DataEntityRuntimeException(this, String.format("建立实体默认DTO对象发生异常，%1$s", e.getMessage()), e);
		}
	}

	@Override
	public List<IEntityDTO> createEntityList() {
		IPSDEMethodDTO defaultPSDEMethodDTO = this.getDefaultPSDEMethodDTO();
		if (defaultPSDEMethodDTO == null) {
			throw new DataEntityRuntimeException(this, String.format("实体未定义默认方法DTO模型"));
		}
		try {
			List<IEntityDTO> list = this.createEntityDTOList(defaultPSDEMethodDTO);
			return list;
		} catch (Exception e) {
			throw new DataEntityRuntimeException(this, String.format("建立实体默认DTO对象列表发生异常，%1$s", e.getMessage()), e);
		}
	}

	// @Override
	// public Page<IEntityDTO> createEntityPage() {
	// return createEntityPage(null, Pageable.unpaged(), 0);
	// }
	//
	// @Override
	// public Page<IEntityDTO> createEntityPage(List<IEntityDTO> list, Pageable
	// pageable, int nTotal) {
	// IPSDEMethodDTO defaultPSDEMethodDTO = this.getDefaultPSDEMethodDTO();
	// if (defaultPSDEMethodDTO == null) {
	// throw new DataEntityRuntimeException(this,
	// String.format("实体未定义默认方法DTO模型"));
	// }
	// try {
	// Page<IEntityDTO> page = this.createEntityDTOPage(defaultPSDEMethodDTO);
	// return page;
	// } catch (Exception e) {
	// throw new DataEntityRuntimeException(this,
	// String.format("建立实体默认DTO对象分页结果对象发生异常，%1$s", e.getMessage()), e);
	// }
	// }

	@Override
	public IDEDataQueryCodeRuntime getDEDataQueryCodeRuntime(IPSDEDataQuery iPSDEDataQuery, String strDBType, boolean bTryMode) {
		this.prepare();

		String strTag = String.format("%1$s|%2$s", iPSDEDataQuery.getId(), strDBType);
		IDEDataQueryCodeRuntime iDEDataQueryCodeRuntime = null;
		if (this.deDataQueryCodeRuntimeMap != null) {
			iDEDataQueryCodeRuntime = this.deDataQueryCodeRuntimeMap.get(strTag);
		}
		if (iDEDataQueryCodeRuntime != null || bTryMode) {
			return iDEDataQueryCodeRuntime;
		}

		throw new DataEntityRuntimeException(this, String.format("无法获取指定数据查询[%1$s][%2$s]运行时对象", iPSDEDataQuery.getName(), strDBType));
	}

	/**
	 * 获取系统持久化设配器
	 */
	@Override
	public ISystemPersistentAdapter getSystemPersistentAdapter() {
		this.prepare();
		return this.iSystemPersistentAdapter;
	}

	@Override
	public ISysDBSchemeRuntime getSysDBSchemeRuntime() {
		this.prepare();
		return this.iSysDBSchemeRuntime;
	}

	@Override
	public ISubSysServiceAPIRuntime getSubSysServiceAPIRuntime() {
		this.prepare();
		return this.iSubSysServiceAPIRuntime;
	}

	@Override
	public ISubSysServiceAPIDERuntime getSubSysServiceAPIDERuntime() {
		this.prepare();
		return this.iSubSysServiceAPIDERuntime;
	}

	@Override
	public ISearchContextDTO createSearchContext(Map<String, Object> params) {
		IPSDEFilterDTO defaultPSDEFilterDTO = this.getDefaultPSDEFilterDTO();
		if (defaultPSDEFilterDTO == null) {
			throw new DataEntityRuntimeException(this, String.format("实体未定义默认过滤器DTO模型"));
		}
		try {
			ISearchContextDTO iSearchContextDTO = (ISearchContextDTO) this.getDEMethodDTO(defaultPSDEFilterDTO, params);
			return iSearchContextDTO;
		} catch (Exception e) {
			throw new DataEntityRuntimeException(this, String.format("建立实体过滤器对象发生异常，%1$s", e.getMessage()), e);
		}
	}

	@Override
	public ISearchContextDTO createSearchContext() {
		return createSearchContext(null);
	}

	@Override
	public IScriptSearchContext createScriptSearchContext(ISearchContextBase iSearchContextBase) {
		ISearchContextDTO iSearchContextDTO = null;
		if (iSearchContextBase != null) {
			iSearchContextDTO = getSearchContextDTO(iSearchContextBase);
		} else {
			iSearchContextDTO = createSearchContext();
		}
		return new ScriptSearchContext(this, iSearchContextDTO);
	}

	@Override
	public IScriptEntity createScriptEntity(IEntityBase iEntityBase) {
		return new ScriptEntity(this, iEntityBase);
	}

	// @Override
	// public IScriptEntityList createScriptEntityList(List<? extends
	// IEntityDTO> list) {
	// if(list == null) {
	// list = this.createEntityList();
	// }
	// return new ScriptEntityList(this, list);
	// }
	//
	// @Override
	// public IScriptEntityPage createScriptEntityPage(Page<? extends
	// IEntityDTO> page) {
	// if(page == null) {
	// page = new PageImpl<IEntityDTO>(createEntityList(), Pageable.unpaged(),
	// 0);
	// }
	// return new ScriptEntityPage(this, page);
	// }
	//

	@Override
	public IPSDEField getPSDEField(String strName, boolean bTryMode) {
		IPSDEField iPSDEField = super.getPSDEField(strName);
		if (iPSDEField != null || bTryMode) {
			return iPSDEField;
		}
		throw new DataEntityRuntimeException(this, String.format("无法获取指定属性[%1$s]模型对象", strName));
	}

	@Override
	public IPSDEFSearchMode getPSDEFSearchMode(String strName, boolean bTryMode) {
		this.prepare();
		IPSDEFSearchMode iPSDEFSearchMode = this.psDEFSearchModeMap.get(strName);
		if (iPSDEFSearchMode != null || bTryMode) {
			return iPSDEFSearchMode;
		}
		throw new DataEntityRuntimeException(this, String.format("无法获取指定属性搜索模式[%1$s]模型对象", strName));

	}

	@Override
	public int checkKeyState(Object objKey) {

		if (this.getSystemPersistentAdapter() == null) {
			// throw new DataEntityRuntimeException(this,
			// String.format("检查主键[%1$s]状态发生错误，未指定实体持久化对象", objKey));
			IEntityDTO iEntityDTO = this.get(objKey, true);
			if (iEntityDTO == null) {
				return CheckKeyStates.OK;
			}
			return CheckKeyStates.EXIST;
		}

		try {
			return this.getSystemPersistentAdapter().checkKeyState(this, null, objKey);
		} catch (Throwable ex) {
			throw new DataEntityRuntimeException(this, String.format("检查数据键值[%1$s]发生异常，%2$s", objKey, ex.getMessage()), ex);
		}
	}

	@Override
	public boolean containsForeignKey(IPSDEField iPSDEField, Object objKey, IPSDERBase iPSDERBase) {

		ISearchContextDTO iSearchContextDTO = this.createSearchContext();
		SearchContextDTO.addSearchFieldCond(iSearchContextDTO, iPSDEField.getName(), Conditions.EQ, objKey);
		// 设置页数
		this.setSearchPaging(iSearchContextDTO, ISearchContext.STARTPAGE, 1, Sort.unsorted());
		iSearchContextDTO.setCount(false);

		// if (this.getSystemPersistentAdapter() == null) {
		// throw new DataEntityRuntimeException(this,
		// String.format("检查是否引用指定数据[%1$s][%2$s]发生异常，未指定实体持久化对象"));
		// }

		try {
			List list = null;
			if (this.getSystemPersistentAdapter() == null) {
				if (this.getDefaultPSDEDataSet() != null) {
					list = this.selectDataSet(this.getDefaultPSDEDataSet(), iSearchContextDTO);
				} else
					throw new Exception("未指定默认数据集");
			} else {
				list = this.getSystemPersistentAdapter().query(this, this.getDefaultPSDEDataQuery(), iSearchContextDTO, null);
			}
			if (list == null || list.size() == 0) {
				return false;
			}
			return true;
		} catch (Throwable ex) {
			throw new DataEntityRuntimeException(this, String.format("检查是否引用指定数据[%1$s][%2$s]发生异常，%3$s", iPSDEField.getName(), objKey, ex.getMessage()), ex);
		}

	}

	@Override
	public void resetByForeignKey(IPSDEField iPSDEField, Object objKey, IPSDERBase iPSDERBase) {

		// if (this.getSystemPersistentAdapter() == null) {
		// throw new DataEntityRuntimeException(this,
		// String.format("重置指定引用[%1$s][%2$s]相关数据发生错误，未指定实体持久化对象",
		// iPSDEField.getName(), objKey));
		// }

		ISearchContextDTO iSearchContextDTO = this.createSearchContext();
		SearchContextDTO.addSearchFieldCond(iSearchContextDTO, iPSDEField.getName(), Conditions.EQ, objKey);
		iSearchContextDTO.all();
		iSearchContextDTO.setCount(false);
		try {

			List list = null;
			if (this.getSystemPersistentAdapter() == null) {
				if (this.getDefaultPSDEDataSet() != null) {
					list = this.selectDataSet(this.getDefaultPSDEDataSet(), iSearchContextDTO);
				} else
					throw new Exception("未指定默认数据集");
			} else {
				list = this.getSystemPersistentAdapter().query(this, this.getDefaultPSDEDataQuery(), iSearchContextDTO, null);
			}

			if (list == null || list.size() == 0) {
				return;
			}

			for (Object item : list) {
				Object key = null;
				if (item instanceof Map) {
					key = ((Map) item).get(this.getKeyPSDEField().getName());
				} else if (item instanceof net.ibizsys.central.util.IEntity) {
					key = ((net.ibizsys.central.util.IEntity) item).get(this.getKeyPSDEField().getName());
				} else {
					throw new Exception(String.format("无法识别的数据对象[%3$s]", item));
				}

				IEntity iEntity = this.createEntity();
				iEntity.set(this.getKeyPSDEField().getName(), key);
				iEntity.set(iPSDEField.getName(), null);
				this.update(iEntity);
			}

		} catch (Throwable ex) {
			throw new DataEntityRuntimeException(this, String.format("重置指定引用[%1$s][%2$s]相关数据发生异常，%3$s", iPSDEField.getName(), objKey, ex.getMessage()), ex);
		}

	}

	@Override
	public void removeByForeignKey(IPSDEField iPSDEField, Object objKey, IPSDERBase iPSDERBase) {

		// if (this.getSystemPersistentAdapter() == null) {
		// throw new DataEntityRuntimeException(this,
		// String.format("删除指定引用[%1$s][%2$s]相关数据发生错误，未指定实体持久化对象",
		// iPSDEField.getName(), objKey));
		// }

		ISearchContextDTO iSearchContextDTO = this.createSearchContext();
		SearchContextDTO.addSearchFieldCond(iSearchContextDTO, iPSDEField.getName(), Conditions.EQ, objKey);
		iSearchContextDTO.all();
		iSearchContextDTO.setCount(false);

		try {

			List list = null;
			if (this.getSystemPersistentAdapter() == null) {
				if (this.getDefaultPSDEDataSet() != null) {
					list = this.selectDataSet(this.getDefaultPSDEDataSet(), iSearchContextDTO);
				} else
					throw new Exception("未指定默认数据集");
			} else {
				list = this.getSystemPersistentAdapter().query(this, this.getDefaultPSDEDataQuery(), iSearchContextDTO, null);
				if (list == null || list.size() == 0) {
					return;
				}
			}

			for (Object item : list) {
				Object key = null;
				if (item instanceof Map) {
					key = ((Map) item).get(this.getKeyPSDEField().getName());
				} else if (item instanceof net.ibizsys.central.util.IEntity) {
					key = ((net.ibizsys.central.util.IEntity) item).get(this.getKeyPSDEField().getName());
				} else {
					throw new Exception(String.format("无法识别的数据对象[%3$s]", item));
				}

				this.remove(key);
			}

		} catch (Throwable ex) {
			throw new DataEntityRuntimeException(this, String.format("删除指定引用[%1$s][%2$s]相关数据发生异常，%3$s", iPSDEField.getName(), objKey, ex.getMessage()), ex);
		}
	}

	@Override
	public boolean existsData(ISearchContextBase iSearchContextBase) {
		ISearchContextDTO iSearchContextDTO = getSearchContextDTO(iSearchContextBase);
		// 设置页数
		this.setSearchPaging(iSearchContextDTO, ISearchContext.STARTPAGE, 1, Sort.unsorted());
		iSearchContextDTO.setCount(false);
		//
		// if (this.getSystemPersistentAdapter() == null) {
		// throw new DataEntityRuntimeException(this,
		// String.format("执行数据存在判断发生错误，未指定实体持久化对象"));
		// }
		//

		try {
			List list = null;
			if (this.getSystemPersistentAdapter() == null) {
				if (this.getDefaultPSDEDataSet() != null) {
					list = this.selectDataSet(this.getDefaultPSDEDataSet(), iSearchContextDTO);
				} else
					throw new Exception("未指定默认数据集");

			} else {
				list = this.getSystemPersistentAdapter().query(this, this.getDefaultPSDEDataQuery(), iSearchContextDTO, null);
			}
			if (list == null || list.size() == 0) {
				return false;
			}
			return true;
		} catch (Throwable ex) {
			throw new DataEntityRuntimeException(this, String.format("检查是否存在指定数据发生异常，%1$s", ex.getMessage()), ex);
		}
	}

	@Override
	public Page<? extends IEntityBase> searchDataSet(IPSDEDataSet iPSDEDataSet, ISearchContextBase iSearchContextBase) {
		ISearchContextDTO iSearchContextDTO = getSearchContextDTO(iSearchContextBase);

		try {
			Object ret = this.fetchDataSet(iPSDEDataSet.getName(), iPSDEDataSet, new Object[] { iSearchContextBase });
			if (ret == null) {
				throw new Exception(String.format("未返回结果对象"));
			}

			return (Page<? extends IEntityBase>) ret;

		} catch (Throwable ex) {
			throw new DataEntityRuntimeException(this, String.format("搜索结果集[%1$s]发生异常，%2$s", iPSDEDataSet.getName(), ex.getMessage()), ex);
		}
	}

	@Override
	public List<? extends IEntityBase> selectDataQuery(IPSDEDataQuery iPSDataQuery, ISearchContextBase iSearchContextBase) {
		Assert.notNull(iPSDataQuery, "传入数据查询模型对象无效");
		if (this.getSystemPersistentAdapter() == null) {
			throw new DataEntityRuntimeException(this, String.format("搜索数据查询[%1$s]发生错误，未指定实体持久化对象", iPSDataQuery.getName()));
		}

		ISearchContextDTO iSearchContextDTO = getSearchContextDTO(iSearchContextBase);
		try {
			List list = this.getSystemPersistentAdapter().query(this, iPSDataQuery, iSearchContextDTO, null);

			List<IEntityDTO> entityDTOList = new ArrayList<>();
			if (list != null) {
				IPSDEMethodDTO iPSDEMethodDTO = this.getDefaultPSDEMethodDTO();
				IDEMethodDTORuntime iDEMethodDTORuntime = this.getDEMethodDTORuntime(iPSDEMethodDTO, false);
				for (Object item : list) {
					if (item instanceof IEntityDTO) {
						entityDTOList.add((IEntityDTO) item);
					} else {
						IEntityDTO iEntityDTO = this.createEntityDTO(iPSDEMethodDTO);
						iEntityDTO.init(iDEMethodDTORuntime, item, false);
						entityDTOList.add(iEntityDTO);
					}
				}
			}

			return entityDTOList;

		} catch (Throwable ex) {
			throw new DataEntityRuntimeException(this, String.format("搜索数据查询[%1$s]发生异常，%2$s", iPSDataQuery.getName(), ex.getMessage()), ex);
		}
	}

	@Override
	public List<IEntityDTO> selectDataQuery(String strDataQueryName, ISearchContextDTO iSearchContextDTO) {
		IPSDEDataQuery iPSDEDataQuery = this.getPSDEDataQuery(strDataQueryName);
		if (iPSDEDataQuery == null) {
			throw new DataEntityRuntimeException(this, String.format("无法获取指定数据查询[%1$s]", strDataQueryName));
		}
		return selectDataQuery(iPSDEDataQuery, iSearchContextDTO);
	}

	@Override
	public List<IEntityDTO> selectDataQuery(IPSDEDataQuery iPSDataQuery, ISearchContextDTO iSearchContextDTO) {
		Assert.notNull(iPSDataQuery, "传入数据查询模型对象无效");
		if (this.getSystemPersistentAdapter() == null) {
			throw new DataEntityRuntimeException(this, String.format("搜索数据查询[%1$s]发生错误，未指定实体持久化对象", iPSDataQuery.getName()));
		}

		try {
			List list = this.getSystemPersistentAdapter().query(this, iPSDataQuery, iSearchContextDTO, null);

			List<IEntityDTO> entityDTOList = new ArrayList<>();
			if (list != null) {
				IPSDEMethodDTO iPSDEMethodDTO = this.getDefaultPSDEMethodDTO();
				IDEMethodDTORuntime iDEMethodDTORuntime = this.getDEMethodDTORuntime(iPSDEMethodDTO, false);
				for (Object item : list) {
					if (item instanceof IEntityDTO) {
						entityDTOList.add((IEntityDTO) item);
					} else {
						IEntityDTO iEntityDTO = this.createEntityDTO(iPSDEMethodDTO);
						iEntityDTO.init(iDEMethodDTORuntime, item, false);
						entityDTOList.add(iEntityDTO);
					}
				}
			}

			return entityDTOList;

		} catch (Throwable ex) {
			throw new DataEntityRuntimeException(this, String.format("搜索数据查询[%1$s]发生异常，%2$s", iPSDataQuery.getName(), ex.getMessage()), ex);
		}
	}

	@Override
	public Page<IEntityDTO> searchDataQuery(IPSDEDataQuery iPSDataQuery, ISearchContextDTO iSearchContextDTO) {
		Assert.notNull(iPSDataQuery, "传入数据查询模型对象无效");
		if (this.getSystemPersistentAdapter() == null) {
			throw new DataEntityRuntimeException(this, String.format("搜索数据查询[%1$s]发生错误，未指定实体持久化对象", iPSDataQuery.getName()));
		}

		try {
			Page page = this.getSystemPersistentAdapter().query2(this, iPSDataQuery, iSearchContextDTO, null);
			return getEntityDTOPage(page, iPSDataQuery, iSearchContextDTO.getPageable());

		} catch (Throwable ex) {
			throw new DataEntityRuntimeException(this, String.format("搜索数据查询[%1$s]发生异常，%2$s", iPSDataQuery.getName(), ex.getMessage()), ex);
		}
	}

	@Override
	public List<IEntityDTO> selectDataSet(String strDataSetName, ISearchContextDTO iSearchContextDTO) {
		IPSDEDataSet iPSDEDataSet = this.getPSDEDataSet(strDataSetName);
		if (iPSDEDataSet == null) {
			throw new DataEntityRuntimeException(this, String.format("无法获取指定数据集[%1$s]", strDataSetName));
		}
		return selectDataSet(iPSDEDataSet, iSearchContextDTO);
	}

	@Override
	public List<IEntityDTO> selectDataSet(IPSDEDataSet iPSDataSet, ISearchContextDTO iSearchContextDTO) {
		Assert.notNull(iPSDataSet, "传入数据集模型对象无效");
		Object objRet;
		try {
			iSearchContextDTO.setCount(false);
			objRet = this.fetchDataSet(iPSDataSet.getName(), iPSDataSet, new Object[] { iSearchContextDTO });
			if (objRet instanceof Page) {
				Page<IEntityDTO> page = getEntityDTOPage((Page) objRet, iPSDataSet, iSearchContextDTO.getPageable());
				return page.getContent();
			}
			throw new Exception("调用返回结果不正确");
		} catch (Throwable ex) {
			throw new DataEntityRuntimeException(this, String.format("查询结果集[%1$s]发生异常，%2$s", iPSDataSet.getName(), ex.getMessage()), ex);
		}
	}

	@Override
	public List<IEntityDTO> selectSimple(ISearchContextDTO iSearchContextDTO) {
		if (this.getSystemPersistentAdapter() == null) {
			if (this.getDefaultPSDEDataSet() != null) {
				return this.selectDataSet(this.getDefaultPSDEDataSet(), iSearchContextDTO);
			}
		}

		if (this.getSimplePSDEDataQuery() != null) {
			return this.selectDataQuery(this.getSimplePSDEDataQuery(), iSearchContextDTO);
		}

		if (this.getDefaultPSDEDataQuery() != null) {
			return this.selectDataQuery(this.getDefaultPSDEDataQuery(), iSearchContextDTO);
		}

		if (this.getViewPSDEDataQuery() != null) {
			return this.selectDataQuery(this.getViewPSDEDataQuery(), iSearchContextDTO);
		}

		throw new DataEntityRuntimeException(this, String.format("搜索简单数据查询发生异常，无法选择合适的数据查询"));
	}

	@Override
	public IEntityDTO selectOne(ISearchContextDTO iSearchContextDTO, boolean bTryMode) {
		try {
			return (IEntityDTO) selectOne(iSearchContextDTO);
		} catch (DataEntityRuntimeException ex) {
			if (bTryMode && ex.getErrorCode() == Errors.INVALIDDATA) {
				return null;
			}
			throw ex;
		}
	}

	@Override
	public IEntityBase selectOne(ISearchContextBase iSearchContextBase) {
		ISearchContextDTO iSearchContextDTO = getSearchContextDTO(iSearchContextBase);
		this.setSearchPaging(iSearchContextDTO, ISearchContext.STARTPAGE, 1);

		List<? extends IEntityBase> list = null;
		if (this.getSystemPersistentAdapter() == null) {
			if (this.getDefaultPSDEDataSet() != null) {
				list = this.selectDataSet(this.getDefaultPSDEDataSet(), getSearchContextDTO(iSearchContextBase));
			}
		} else {
			list = this.selectDataQuery(this.getViewPSDEDataQuery(), iSearchContextDTO);
		}

		if (list == null || list.size() == 0) {
			throw new DataEntityRuntimeException(this, String.format("无法获取指定条件数据"), Errors.INVALIDDATA);
		}
		return (IEntityDTO) list.get(0);
	}

	@Override
	public List<? extends IEntityBase> select(ISearchContextBase iSearchContextBase) {
		if (this.getSystemPersistentAdapter() == null) {
			if (this.getDefaultPSDEDataSet() != null) {
				return this.selectDataSet(this.getDefaultPSDEDataSet(), getSearchContextDTO(iSearchContextBase));
			}
		}
		return this.selectDataQuery(this.getViewPSDEDataQuery(), iSearchContextBase);
	}

	@Override
	public List<IEntityDTO> select(ISearchContextDTO iSearchContextDTO) {
		if (this.getSystemPersistentAdapter() == null) {
			if (this.getDefaultPSDEDataSet() != null) {
				return this.selectDataSet(this.getDefaultPSDEDataSet(), iSearchContextDTO);
			}
		}
		return this.selectDataQuery(this.getViewPSDEDataQuery(), iSearchContextDTO);
	}

	@Override
	public IEntityBase selectOne(String strCondition) {
		ISearchContextDTO iSearchContextDTO = this.createSearchContext();
		this.setSearchCustomCondition(iSearchContextDTO, strCondition);
		return selectOne(iSearchContextDTO);
	}

	@Override
	public List<? extends IEntityBase> select(String strCondition) {
		ISearchContextDTO iSearchContextDTO = this.createSearchContext();
		this.setSearchCustomCondition(iSearchContextDTO, strCondition);
		return select(iSearchContextDTO);
	}

	@Override
	public IEntityDTO getSimpleEntity(Object objKey) {

		ISearchContextDTO iSearchContextDTO = this.createSearchContext();
		SearchContextDTO.addSearchFieldCond(iSearchContextDTO, this.getKeyPSDEField().getLowerCaseName(), Conditions.EQ, objKey, null);
		this.setSearchPaging(iSearchContextDTO, ISearchContext.STARTPAGE, 1);

		List<? extends IEntityDTO> list = null;
		if (this.getSystemPersistentAdapter() == null) {
			if (this.getDefaultPSDEDataSet() != null) {
				list = this.selectDataSet(this.getDefaultPSDEDataSet(), iSearchContextDTO);
			}
		} else {
			list = this.selectDataQuery(this.getSimplePSDEDataQuery(), iSearchContextDTO);
		}

		if (list == null || list.size() == 0) {
			throw new DataEntityRuntimeException(this, String.format("无法获取指定数据[%1$s]", objKey), Errors.INVALIDDATA);
		}
		return list.get(0);
	}

	@Override
	protected void onWFAction(String strActionName, IEntityBase arg0, IPSDEAction iPSDEAction, IPSDEWF iPSDEWF, Object actionData) throws Throwable {
		// super.onWFAction(strActionName, arg0, iPSDEAction, iPSDEWF,
		// actionData);
	}

	protected void onWFActionReal(String strActionName, IEntityBase arg0, IPSDEAction iPSDEAction, IPSDEWF iPSDEWF, Object actionData) throws Throwable {
		super.onWFAction(strActionName, arg0, iPSDEAction, iPSDEWF, actionData);
	}

	@Override
	protected void onWFStart(Object arg0, IPSDEAction iPSDEAction, IPSDEWF iPSDEWF, IDynaInstRuntime iDynaInstRuntime, Object actionData) throws Throwable {
		this.getDEWFRuntime(iPSDEWF).start(arg0, iPSDEAction, iDynaInstRuntime, actionData);
	}

	@Override
	protected void onWFCancel(Object arg0, IPSDEAction iPSDEAction, IPSDEWF iPSDEWF, IDynaInstRuntime iDynaInstRuntime, Object actionData) throws Throwable {
		this.getDEWFRuntime(iPSDEWF).cancel(arg0, iPSDEAction, iDynaInstRuntime, actionData);
	}

	@Override
	protected void onWFError(IEntityBase arg0, IPSDEAction iPSDEAction, IPSDEWF iPSDEWF, Object actionData) throws Throwable {
		this.getDEWFRuntime(iPSDEWF).error(arg0, iPSDEAction, actionData);
	}

	@Override
	protected void onWFFinish(IEntityBase arg0, IPSDEAction iPSDEAction, IPSDEWF iPSDEWF, Object actionData) throws Throwable {
		this.getDEWFRuntime(iPSDEWF).finish(arg0, iPSDEAction, actionData);
	}

	@Override
	protected void onWFInit(IEntityBase arg0, IPSDEAction iPSDEAction, IPSDEWF iPSDEWF, Object actionData) throws Throwable {
		this.getDEWFRuntime(iPSDEWF).init(arg0, iPSDEAction, actionData);
	}

	@Override
	protected void onWFRegister(Object arg0, IPSDEAction iPSDEAction, IPSDEWF iPSDEWF, IDynaInstRuntime iDynaInstRuntime, Object actionData) throws Throwable {
		this.getDEWFRuntime(iPSDEWF).register(arg0, iPSDEAction, iDynaInstRuntime, actionData);
	}

	@Override
	protected void onWFUnregister(Object arg0, IPSDEAction iPSDEAction, IPSDEWF iPSDEWF, IDynaInstRuntime iDynaInstRuntime, Object actionData) throws Throwable {
		this.getDEWFRuntime(iPSDEWF).unregister(arg0, iPSDEAction, iDynaInstRuntime, actionData);
	}

	@Override
	protected void onWFUpdate(IEntityBase arg0, IPSDEAction iPSDEAction, IPSDEWF iPSDEWF, Object actionData) throws Throwable {
		this.getDEWFRuntime(iPSDEWF).update(arg0, iPSDEAction, actionData);
	}

	@Override
	protected void onWFRollback(IEntityBase arg0, IPSDEAction iPSDEAction, IPSDEWF iPSDEWF, Object actionData) throws Throwable {
		this.getDEWFRuntime(iPSDEWF).rollback(arg0, iPSDEAction, actionData);
	}

	@Override
	protected void onExecuteActionLogics(Object arg0, IPSDEAction iPSDEAction, String strAttachMode, IDynaInstRuntime iDynaInstRuntime, Object actionData) throws Throwable {
		// 此函数为Runtime提供的早期BPMN引擎介入入口，Central包不做任何处理
	}

	@Override
	public String getDynaInstId(Object objEntity) {
		ActionSession actionSession = ActionSessionManager.getCurrentSession();
		if (actionSession != null && actionSession.getUserContext() != null) {
			return actionSession.getUserContext().getDynainstid();
		}

		if (this.getUserContext() != null) {
			return this.getUserContext().getDynainstid();
		}

		return null;
	}

	@Override
	protected IUserContext getUserContext() {
		// return UserContext.getCurrent();
		return ActionSessionManager.getUserContext();
	}

	@Override
	public Object getFieldValue(IEntityBase objEntity, IPSDEField iPSDEField) {
		return getEntity(objEntity).get(iPSDEField.getLowerCaseName());
	}

	@Override
	public void setFieldValue(IEntityBase objEntity, IPSDEField iPSDEField, Object objValue) {
		getEntity(objEntity).set(iPSDEField.getLowerCaseName(), objValue);
	}

	@Override
	public boolean containsFieldValue(IEntityBase objEntity, IPSDEField iPSDEField) {
		return getEntity(objEntity).contains(iPSDEField.getLowerCaseName());
	}

	@Override
	public void resetFieldValue(IEntityBase objEntity, IPSDEField iPSDEField) {
		getEntity(objEntity).reset(iPSDEField.getLowerCaseName());
	}

	@Override
	public IEntityBase[] getNestedDERValue(IEntityBase iEntityBase, IPSDERBase iPSDERBase) {
		if (iEntityBase instanceof IEntityDTO) {
			IEntityDTO iEntityDTO = (IEntityDTO) iEntityBase;
			if (iEntityDTO.getDEMethodDTORuntime() != null) {
				IPSDEMethodDTOField iPSDEMethodDTOField = iEntityDTO.getDEMethodDTORuntime().getPSDEMethodDTOFieldByDER(iPSDERBase.getId(), true);
				if (iPSDEMethodDTOField != null) {
					Object data = iEntityDTO.get(iPSDEMethodDTOField.getLowerCaseName());
					if (data == null) {
						return null;
					}
					if (!(data instanceof List)) {
						throw new DataEntityRuntimeException(this, String.format("DTO属性[%1$s]值类型不正确", iPSDEMethodDTOField.getLowerCaseName()));
					}

					List list = (List) data;
					if (list.size() == 0) {
						return null;
					}

					IEntityBase[] arr = new IEntityBase[list.size()];
					for (int i = 0; i < list.size(); i++) {
						Object item = list.get(i);
						if (!(item instanceof IEntityBase)) {
							throw new DataEntityRuntimeException(this, String.format("DTO属性[%1$s]值类型不正确", iPSDEMethodDTOField.getLowerCaseName()));
						}
						arr[i] = (IEntityBase) list.get(i);
					}
					return arr;
				}
			}
		}
		return null;
	}

	@Override
	public void setNestedDERValue(IEntityBase iEntityBase, IPSDERBase iPSDERBase, IEntityBase[] value) {
		// TODO Auto-generated method stub
		// throw new DataEntityRuntimeException(this, "没有实现", Errors.NOTIMPL);
	}

	@Override
	public boolean containsNestedDERValue(IEntityBase iEntityBase, IPSDERBase iPSDERBase) {
		if (iEntityBase instanceof IEntityDTO) {
			IEntityDTO iEntityDTO = (IEntityDTO) iEntityBase;
			if (iEntityDTO.getDEMethodDTORuntime() != null) {
				IPSDEMethodDTOField iPSDEMethodDTOField = iEntityDTO.getDEMethodDTORuntime().getPSDEMethodDTOFieldByDER(iPSDERBase.getId(), true);
				if (iPSDEMethodDTOField != null) {
					return iEntityDTO.contains(iPSDEMethodDTOField.getLowerCaseName());
				}
			}
		}
		return false;
	}

	@Override
	public void resetNestedDERValue(IEntityBase iEntityBase, IPSDERBase iPSDERBase) {
		// TODO Auto-generated method stub
		throw new DataEntityRuntimeException(this, "没有实现", Errors.NOTIMPL);
	}

	@Override
	public void setSearchCondition(ISearchContextBase iSearchContextBase, IPSDEField iPSDEField, String strCondition, Object objValue) {
		ISearchContextDTO iSearchContextDTO = this.getSearchContextDTO(iSearchContextBase);
		SearchContextDTO.addSearchFieldCond(iSearchContextDTO, iPSDEField.getLowerCaseName(), strCondition, objValue, null);
	}

	@Override
	public void setSearchCondition(ISearchContextBase iSearchContextBase, IPSDEField iPSDEField, IPSDEFSearchMode iPSDEFSearchMode, Object objValue) {
		ISearchContextDTO iSearchContextDTO = this.getSearchContextDTO(iSearchContextBase);
		SearchContextDTO.addSearchFieldCond(iSearchContextDTO, iPSDEField.getLowerCaseName(), iPSDEFSearchMode.getValueOP(), objValue, null);
	}

	@Override
	public Object getSearchCondition(ISearchContextBase iSearchContextBase, IPSDEField iPSDEField, IPSDEFSearchMode iPSDEFSearchMode) {
		ISearchContextDTO iSearchContextDTO = this.getSearchContextDTO(iSearchContextBase);
		return iSearchContextDTO.get(iPSDEFSearchMode.getLowerCaseName());
	}

	@Override
	public Object getSearchCondition(ISearchContextBase iSearchContextBase, IPSDEField iPSDEField, String strCondition) {
		ISearchContextDTO iSearchContextDTO = this.getSearchContextDTO(iSearchContextBase);
		String strName = String.format("n_%1$s_%2$s", iPSDEField.getLowerCaseName(), strCondition).toLowerCase();
		return iSearchContextDTO.get(strName);
	}

	@Override
	public void setSearchCustomCondition(ISearchContextBase iSearchContextBase, String strCustomCondition) {
		ISearchContextDTO iSearchContextDTO = getSearchContextDTO(iSearchContextBase);
		SearchContextDTO.addSearchCustomCond(iSearchContextDTO, strCustomCondition);
	}

	@Override
	public void setSearchPaging(ISearchContextDTO iSearchContextDTO, int nPageIndex, int nPageSize) {
		iSearchContextDTO.setPageable(PageRequest.of(nPageIndex, nPageSize));
	}

	@Override
	public void setSearchPaging(ISearchContextBase iSearchContextBase, int nPageIndex, int nPageSize, Sort sort) {
		ISearchContextDTO iSearchContextDTO = getSearchContextDTO(iSearchContextBase);
		iSearchContextDTO.setPageable(PageRequest.of(nPageIndex, nPageSize));
		iSearchContextDTO.setPageSort(sort);
	}

	@Override
	public void setSearchPaging(ISearchContextDTO iSearchContextDTO, int nPageIndex, int nPageSize, IPSDEField sortPSDEField, String strSortDir) {
		Sort sort = Sort.unsorted();
		if (sortPSDEField != null) {
			List<Sort.Order> list = new ArrayList<Sort.Order>();
			if ("DESC".equalsIgnoreCase(strSortDir)) {
				list.add(Sort.Order.desc(sortPSDEField.getLowerCaseName()));
			} else {
				list.add(Sort.Order.asc(sortPSDEField.getLowerCaseName()));
			}
			sort = Sort.by(list);
		}
		this.setSearchPaging(iSearchContextDTO, nPageIndex, nPageSize, sort);
	}

	@Override
	public void setSearchDataContext(ISearchContextBase iSearchContextBase, String strParam, Object objValue) {

		IPSDEFSearchMode iPSDEFSearchMode = this.getPSDEFSearchMode(strParam, false);

		IPSDEField iPSDEField = iPSDEFSearchMode.getParentPSModelObject(IPSDEField.class, false);

		this.setSearchCondition(iSearchContextBase, iPSDEField, iPSDEFSearchMode, objValue);
	}

	@Override
	public Object getSearchDataContext(ISearchContextBase iSearchContextBase, String strParam) {
		ISearchContextDTO iSearchContextDTO = getSearchContextDTO(iSearchContextBase);
		return iSearchContextDTO.get(strParam);
	}

	@Override
	public void setSearchMode(ISearchContextBase iSearchContextBase, boolean bData, boolean bCount) {
		ISearchContextDTO iSearchContextDTO = getSearchContextDTO(iSearchContextBase);
		iSearchContextDTO.setCount(bCount);
		if (!bData) {
			throw new DataEntityRuntimeException(this, String.format("未支持无数据模式"), Errors.NOTIMPL);
		}
	}

	protected ISearchContextDTO getSearchContextDTO(ISearchContextBase iSearchContextBase) {
		if (!(iSearchContextBase instanceof ISearchContextDTO)) {
			throw new DataEntityRuntimeException(this, String.format("无法识别的搜索上下文对象[%1$s]", iSearchContextBase));
		}
		return (ISearchContextDTO) iSearchContextBase;
	}

	protected IEntityDTO getEntityDTO(IEntityBase iEntityBase) {
		if (!(iEntityBase instanceof IEntityDTO)) {
			throw new DataEntityRuntimeException(this, String.format("无法识别的数据对象[%1$s]", iEntityBase));
		}
		return (IEntityDTO) iEntityBase;
	}

	protected IEntity getEntity(IEntityBase iEntityBase) {
		if (!(iEntityBase instanceof IEntity)) {
			throw new DataEntityRuntimeException(this, String.format("无法识别的数据对象[%1$s]", iEntityBase));
		}
		return (IEntity) iEntityBase;
	}

	@Override
	protected String getDBType() {
		if (this.getSysDBSchemeRuntime() != null) {
			return this.getSysDBSchemeRuntime().getDBType();
		}
		return super.getDBType();
	}

	@Override
	public String getFieldQueryExp(String strFieldName) {
		if (this.getViewPSDEDataQuery() != null) {
			IDEDataQueryCodeRuntime iDEDataQueryCodeRuntime = this.getDEDataQueryCodeRuntime(this.getViewPSDEDataQuery(), getDBType(), true);
			if (iDEDataQueryCodeRuntime != null) {
				IPSDEDataQueryCodeExp iPSDEDataQueryCodeExp = iDEDataQueryCodeRuntime.getPSDEDataQueryCodeExp(strFieldName, true);
				if (iPSDEDataQueryCodeExp != null) {
					return iPSDEDataQueryCodeExp.getExpression();
				}
			}
		}
		return super.getFieldQueryExp(strFieldName);
	}

	@Override
	protected void inheritMajorDataEntityCreateOrUpdate(IEntityBase arg0, boolean bCreate, IPSDEAction iPSDEAction, IPSDataEntity iPSDataEntity, IDynaInstRuntime iDynaInstRuntime, Object actionData) throws Throwable {
		// 存在实体持久化对象忽略单项处理
		if (this.getSystemPersistentAdapter() != null) {
			return;
		}
		super.inheritMajorDataEntityCreateOrUpdate(arg0, bCreate, iPSDEAction, iPSDataEntity, iDynaInstRuntime, actionData);
	}

	// @Override
	// protected void inheritMajorDataEntityRemove(Object arg0, IPSDEAction
	// iPSDEAction, IPSDataEntity iPSDataEntity, IDynaInstRuntime
	// iDynaInstRuntime, Object actionData) throws Throwable {
	// // 存在实体持久化对象忽略单项处理
	// if (this.getSystemPersistentAdapter() != null) {
	// return;
	// }
	// super.inheritMajorDataEntityRemove(arg0, iPSDEAction, iPSDataEntity,
	// iDynaInstRuntime, actionData);
	// }
	//
	// @Override
	// public void sysUpdate(IEntityBase iEntityBase) throws Throwable {
	//
	// if (this.getSystemPersistentAdapter() == null) {
	// throw new DataEntityRuntimeException(this,
	// String.format("执行系统更新发生错误，未指定实体持久化对象"));
	// }
	//
	// IEntityDTO iEntityDTO = this.getEntityDTO(iEntityBase);
	//
	// try {
	// this.getSystemPersistentAdapter().update(this, null, iEntityDTO, null,
	// false, null, true);
	// } catch (Throwable ex) {
	// throw new DataEntityRuntimeException(this,
	// String.format("执行系统更新发生异常，%1$s", ex.getMessage()), ex);
	// }
	// }

	@Override
	public IDEWFRuntime getDEWFRuntime(IPSDEWF iPSDEWF) {
		this.prepare();
		IDEWFRuntime iDEWFRuntime = null;
		if (this.deWFRuntimeMap != null) {
			iDEWFRuntime = this.deWFRuntimeMap.get(iPSDEWF.getId());
		}
		if (iDEWFRuntime == null && iPSDEWF instanceof IPSWFDE) {
			if (iPSDEWF.getPSWorkflow() != null) {
				iDEWFRuntime = this.deWFRuntimeMap.get(iPSDEWF.getPSWorkflow().getId());
			} else if (iPSDEWF.getParentPSModelObject() instanceof IPSWorkflow) {
				iDEWFRuntime = this.deWFRuntimeMap.get(iPSDEWF.getParentPSModelObject().getId());
			}

		}
		if (iDEWFRuntime != null) {
			return iDEWFRuntime;
		}
		throw new DataEntityRuntimeException(this, String.format("无法获取指定实体工作流[%1$s]运行时对象", iPSDEWF.getId()));
	}

	@Override
	public IDEWFRuntime getDefaultDEWFRuntime() {
		this.prepare();
		IPSDEWF defaultPSDEWF = this.getDefaultPSDEWF();
		if (defaultPSDEWF == null) {
			throw new DataEntityRuntimeException(this, String.format("未定义默认实体工作流"));
		}
		return getDEWFRuntime(defaultPSDEWF);
	}

	/**
	 * 建立实体工作流运行时
	 * 
	 * @return
	 */
	protected IDEWFRuntime createDEWFRuntime(IPSDEWF iPSDEWF) {

		IDEWFRuntime iDEWFRuntime = this.getSystemRuntime().getRuntimeObject(IDEWFRuntime.class, null);
		if (iDEWFRuntime != null) {
			return iDEWFRuntime;
		}

		return new DEWFRuntime();
	}

	@Override
	public List<IPSDEField> getQuickSearchPSDEFields() {
		this.prepare();
		return this.quickSearchPSDEFieldList;
	}

	/**
	 * 填充实体行为参数
	 * 
	 * @param iPSDEAction
	 * @param arg0
	 * @param joinPoint
	 * @throws Exception
	 */
	@Override
	protected void fillActionParams(IEntityBase arg0, IPSDEAction iPSDEAction, IPSDataEntity iPSDataEntity, IDynaInstRuntime iDynaInstRuntime, Object actionData) throws Exception {
		List<IPSDEActionParam> psDEActionParams = iPSDEAction.getPSDEActionParams();
		//
		if (psDEActionParams != null) {
			// 判断参数模式
			int nParamMode = iPSDEAction.getParamMode();
			if (nParamMode == DEActionParamModes.ALL) {
				// 全部参数
				for (IPSDEActionParam iPSDEActionParam : psDEActionParams) {
					setActionParamValue(arg0, iPSDEActionParam, this.getPSDEField(iPSDEActionParam.getName()));
				}
				if (log.isDebugEnabled()) {
					log.debug(String.format("行为[%1$s]参数处理：%2$s", iPSDEAction.getName(), this.getSystemRuntime().serialize(arg0)));
				}
			} else if (nParamMode == DEActionParamModes.SOME) {

				IPSDEActionInputDTO iPSDEActionInputDTO = null;
				/**
				 * 判断输入对象类型
				 */
				if (iPSDEAction.getPSDEActionInput() != null && iPSDEAction.getPSDEActionInput().getPSDEMethodDTO() instanceof IPSDEActionInputDTO) {
					iPSDEActionInputDTO = (IPSDEActionInputDTO) iPSDEAction.getPSDEActionInput().getPSDEMethodDTO();
				}

				if (iPSDEActionInputDTO == null) {
					// 指定限定参数
					java.util.List<IPSDEField> psDEFields = iPSDataEntity.getAllPSDEFields();
					if (psDEFields != null) {
						for (IPSDEField iPSDEField : psDEFields) {
							boolean bReset = !iPSDEField.isKeyDEField(); // 主键保留
							for (IPSDEActionParam iPSDEActionParam : psDEActionParams) {
								if (iPSDEField.getName().equalsIgnoreCase(iPSDEActionParam.getName())) {
									setActionParamValue(arg0, iPSDEActionParam, iPSDEField);
									bReset = false;
								}
							}
							if (bReset) {
								this.resetFieldValue(arg0, iPSDEField);
							}
						}
					}
				} else {
					for (IPSDEActionParam iPSDEActionParam : psDEActionParams) {
						setActionParamValue(arg0, iPSDEActionParam);
					}
				}
				//
				if (log.isDebugEnabled()) {
					log.debug(String.format("行为[%1$s]参数处理：%2$s", iPSDEAction.getName(), this.getSystemRuntime().serialize(arg0)));
				}
			} else {
				log.warn(String.format("无法识别的实体行为参数模式[%1$s]", nParamMode));
			}
		}
	}

	@Override
	public IEntityDTO get(Object objKey, boolean bTryMode) {
		try {
			IEntityBase iEntityBase = super.get(objKey);
			return (IEntityDTO) iEntityBase;
		} catch (Throwable e) {
			if (e instanceof DataEntityRuntimeException) {
				if (bTryMode && ((DataEntityRuntimeException) e).getErrorCode() == Errors.INVALIDDATA) {
					return null;
				}
				throw (DataEntityRuntimeException) e;
			}
			throw new DataEntityRuntimeException(this, String.format("获取数据[%1$s]发生异常，%2$s", objKey, e.getMessage()), e);
		}
	}

	@Override
	public Object fetchDataSet(String strDataSetName, IPSDEDataSet iPSDEDataSet, Object[] args, boolean bIgnoreDEService) throws Throwable {

		prepare();

		if (iPSDEDataSet == null) {
			iPSDEDataSet = this.getPSDEDataSet(strDataSetName);
			if (iPSDEDataSet == null) {
				throw new DataEntityRuntimeException(this, String.format("无法获取实体数据集[%1$s]，无法获取对应的数据集模型", strDataSetName));
			}
		}

		if (args.length > 0 && args[0] instanceof ISearchContextDTO) {
			// 判断DTO对象是否有运行时
			ISearchContextDTO iSearchContextDTO = (ISearchContextDTO) args[0];
			if (iSearchContextDTO.getDEMethodDTORuntime() == null) {

				if (iPSDEDataSet.getPSDEDataSetInputMust().getPSDEFilterDTO() != null) {
					iSearchContextDTO.setDEMethodDTORuntime((IDEFilterDTORuntime) this.getDEMethodDTORuntime(iPSDEDataSet.getPSDEDataSetInputMust().getPSDEFilterDTO(), false));
				}
			}
		}

		if (!bIgnoreDEService && this.getDEService() != null) {
			return this.getDEService().fetchDataSet(strDataSetName, iPSDEDataSet, args);
		} else {
			getDEService();
		}
		return super.fetchDataSet(strDataSetName, iPSDEDataSet, args);
	}

	@Override
	public Object fetchDataSet(String strDataSetName, IPSDEDataSet iPSDEDataSet, Object[] args) throws Throwable {
		return fetchDataSet(strDataSetName, iPSDEDataSet, args, false);
	}

	@Override
	public Object executeAction(String strActionName, IPSDEAction iPSDEAction, Object[] args) throws Throwable {
		return executeAction(strActionName, iPSDEAction, args, false);
	}

	@Override
	public Object executeAction(String strActionName, IPSDEAction iPSDEAction, Object[] args, boolean bIgnoreDEService) throws Throwable {

		prepare();

		// 判断行为是否支持
		if (iPSDEAction == null) {
			iPSDEAction = this.getPSDEAction(strActionName);
		}

		if (args != null && args.length > 0 && iPSDEAction != null) {
			if (this.getSystemPersistentAdapter() != null && DEActions.SAVE.equalsIgnoreCase(iPSDEAction.getName()) && DEActionModes.UNKNOWN.equals(iPSDEAction.getActionMode()) && args[0] instanceof IEntityDTO) {
				// 判断数据是否存在
				IEntityDTO iEntityDTO = (IEntityDTO) args[0];
				if (iEntityDTO.getDEMethodDTORuntime() == null) {
					iEntityDTO.setDEMethodDTORuntime(this.getDEMethodDTORuntime(iPSDEAction.getPSDEActionInputMust().getPSDEMethodDTO(), false));
				}

				Object objKey = this.getFieldValue(iEntityDTO, this.getKeyPSDEField());
				if (ObjectUtils.isEmpty(objKey)) {
					if (!ObjectUtils.isEmpty(this.getUnionKeyValuePSDEFields())) {
						this.fillEntityKeyValue(iEntityDTO);
						objKey = this.getFieldValue(iEntityDTO, this.getKeyPSDEField());
					}
				}
				boolean bCreate = true;
				if (!ObjectUtils.isEmpty(objKey)) {
					if (this.checkKeyState(objKey) == CheckKeyStates.EXIST) {
						bCreate = false;
					}
				}
				if (bCreate) {
					return executeAction(DEActions.CREATE, null, new Object[] { iEntityDTO });
				} else {
					return executeAction(DEActions.UPDATE, null, new Object[] { iEntityDTO });
				}

			}

			if (iPSDEAction.getPSDEActionInputMust().getPSDEMethodDTO() != null) {
				// 判断参数DTO对象是否有运行时
				if (args[0] instanceof IEntityDTO) {
					IEntityDTO iEntityDTO = (IEntityDTO) args[0];
					if (iEntityDTO.getDEMethodDTORuntime() == null) {
						iEntityDTO.setDEMethodDTORuntime(this.getDEMethodDTORuntime(iPSDEAction.getPSDEActionInputMust().getPSDEMethodDTO(), false));
					}
				} else if (args[0] instanceof List) {
					List list = (List) args[0];
					for (Object item : list) {
						if (item instanceof IEntityDTO) {
							IEntityDTO iEntityDTO = (IEntityDTO) item;
							if (iEntityDTO.getDEMethodDTORuntime() == null) {
								iEntityDTO.setDEMethodDTORuntime(this.getDEMethodDTORuntime(iPSDEAction.getPSDEActionInputMust().getPSDEMethodDTO(), false));
							}
						}
					}
				}
			}

			if (args[0] instanceof List) {
				List list = (List) args[0];
				if (DEMethodInputTypes.DTOS.equals(iPSDEAction.getPSDEActionInputMust().getType()) || DEMethodInputTypes.KEYFIELDS.equals(iPSDEAction.getPSDEActionInputMust().getType())) {
					boolean bConvert = false;
					if (DEMethodInputTypes.KEYFIELDS.equals(iPSDEAction.getPSDEActionInputMust().getType())) {
						for (Object item : list) {
							if (item instanceof IEntityDTO) {
								bConvert = true;
								break;
							}
						}
						if (bConvert) {
							List keyList = new ArrayList<>();
							for (Object item : list) {
								IEntityDTO iEntityDTO = (IEntityDTO) item;
								Object objKey = this.getFieldValue(iEntityDTO, this.getKeyPSDEField());
								keyList.add(objKey);
							}
							args[0] = keyList;
						}
					}
					if (bConvert) {
						Object objRet = executeAction(strActionName, iPSDEAction, args, bIgnoreDEService);
						args[0] = list;
						return objRet;
					}
				}
			} else {
				if (DEMethodInputTypes.DTOS.equals(iPSDEAction.getPSDEActionInputMust().getType()) || DEMethodInputTypes.KEYFIELDS.equals(iPSDEAction.getPSDEActionInputMust().getType())) {
					// 需要列表
					Object arg0 = args[0];
					List list = new ArrayList<>();
					list.add(arg0);
					args[0] = list;

					Object objRet = executeAction(strActionName, iPSDEAction, args, bIgnoreDEService);

					args[0] = arg0;

					return objRet;
				} else if (DEMethodInputTypes.KEYFIELD.equals(iPSDEAction.getPSDEActionInputMust().getType()) && args[0] instanceof IEntityDTO) {
					Object arg0 = args[0];
					Object objKey = this.getFieldValue((IEntityDTO) arg0, this.getKeyPSDEField());

					args[0] = objKey;

					Object objRet = executeAction(strActionName, iPSDEAction, args, bIgnoreDEService);
					args[0] = arg0;
					if (objRet != null && objRet instanceof IEntityDTO) {
						// if(objRet != null && objRet instanceof IEntityDTO &&
						// iPSDEAction.getPSDEActionInputMust().isOutput()) {
						((IEntityDTO) arg0).reload(objRet, true);
						return arg0;
					}
					return objRet;
				}
			}
		}

		return this.executeActionReal(strActionName, iPSDEAction, args, bIgnoreDEService);
		
	}
	
	/**
	 * 实际执行操作
	 * @param strActionName
	 * @param iPSDEAction
	 * @param args
	 * @param bIgnoreDEService
	 * @return
	 * @throws Throwable
	 */
	protected Object executeActionReal(String strActionName, IPSDEAction iPSDEAction, Object[] args, boolean bIgnoreDEService) throws Throwable {
		
		boolean bOpenActionSession = (ActionSessionManager.getCurrentSession() == null);
		if (bOpenActionSession) {
			ActionSessionManager.openSession().setName(this.getName());
			ActionSessionManager.getCurrentSession().setUserContext(this.getUserContext());
		}
		
		if (iPSDEAction == null) {
			iPSDEAction = this.getPSDEAction(strActionName);
		}

		try {
			this.pushDataSource();
			// 备份会话的动态实例运行时
			IDynaInstRuntime lastDynaInstRuntime = ActionSessionManager.getCurrentSession().getDynaInstRuntime();
			IDynaInstRuntime lastChildDynaInstRuntime = ActionSessionManager.getCurrentSession().getChildDynaInstRuntime();
			String strLastSessionId = ActionSessionManager.getCurrentSession().getSessionId();

			ActionSessionManager.getCurrentSession().setSessionId(KeyValueUtils.genGuidEx());

			int nTransactionalPropagation = getTransactionalPropagation(strActionName, iPSDEAction);
			final IPSDEAction iPSDEAction2 = iPSDEAction;
			// 此代码必须独立调用，全局准备实体服务对象
			final IDEService iDEService = this.getDEService();
			Object objRet = null;
			if (!bIgnoreDEService && iDEService != null && iPSDEAction != null && args != null && args.length != 0) {
				ActionSessionManager.getCurrentSession().beginLog(this.getName(), strActionName + "@DEService");

				objRet = ActionSessionManager.getCurrentSession().execute(new IAction() {
					@Override
					public Object execute(Object[] args) throws Throwable {
						return iDEService.executeAction(strActionName, iPSDEAction2, args);
					}
				}, args, nTransactionalPropagation);

			} else {

				ActionSessionManager.getCurrentSession().beginLog(this.getName(), strActionName);

				if (bIgnoreDEService && iDEService != null) {
					objRet = onExecuteAction(strActionName, iPSDEAction2, args, null);
				} else {
					objRet = ActionSessionManager.getCurrentSession().execute(new IAction() {
						@Override
						public Object execute(Object[] args) throws Throwable {
							return onExecuteAction(strActionName, iPSDEAction2, args, null);
						}
					}, args, nTransactionalPropagation);
				}
			}

			// 恢复会话的动态实例运行时
			ActionSessionManager.getCurrentSession().setSessionId(strLastSessionId);
			ActionSessionManager.getCurrentSession().setDynaInstRuntime(lastDynaInstRuntime);
			ActionSessionManager.getCurrentSession().setChildDynaInstRuntime(lastChildDynaInstRuntime);

			IActionSessionLog iActionSessionLog = ActionSessionManager.getCurrentSession().endLog(null);

			if (bOpenActionSession) {
				if (iActionSessionLog != null) {
					if (iActionSessionLog.getTime() >= 200) {
						this.getSystemRuntime().logPO(ISystemRuntime.LOGLEVEL_WARN, LogCats.PO_DEACTION, iActionSessionLog.toString(true), this.getName(), strActionName, iActionSessionLog.getTime(), iActionSessionLog);
					}
				}
				ActionSessionManager.closeSession(true);

			}

			return objRet;

		} catch (Throwable ex) {

			ActionSessionManager.getCurrentSession().setDynaInstRuntime(null);
			ActionSessionManager.getCurrentSession().setChildDynaInstRuntime(null);

			if (bOpenActionSession) {
				IActionSessionLog iActionSessionLog = ActionSessionManager.getCurrentSession().endLog(null, true, ex);
				if (iActionSessionLog != null) {
					String strInfo = String.format("实体[%1$s]行为[%2$s]发生异常，%3$s\r\n%4$s", this.getName(), strActionName, ex.getMessage(), iActionSessionLog.toObjectNode().toString());
					this.getSystemRuntime().log(LogLevels.ERROR, LogCats.DEACTION, strInfo, ex);
				}

				ActionSessionManager.closeSession(false);
			}
			throw ex;
		} finally {
			this.pollDataSource();
		}

	}

	@Override
	public Object rawExecute(IAction iAction, Object[] args) throws Throwable {
		return this.rawExecute(iAction, args, ITransactionalUtil.PROPAGATION_REQUIRED);
	}

	@Override
	public Object rawExecute(IAction iAction, Object[] args, int nTransactionalPropagation) throws Throwable {

		prepare();

		boolean bOpenActionSession = (ActionSessionManager.getCurrentSession() == null);
		if (bOpenActionSession) {
			ActionSessionManager.openSession().setName(this.getName());
			ActionSessionManager.getCurrentSession().setUserContext(this.getUserContext());
		}

		String strActionName = "未知行为";
		if (iAction instanceof INamedAction) {
			strActionName = ((INamedAction) iAction).getName();
		}

		try {
			this.pushDataSource();
			// 备份会话的动态实例运行时
			IDynaInstRuntime lastDynaInstRuntime = ActionSessionManager.getCurrentSession().getDynaInstRuntime();
			IDynaInstRuntime lastChildDynaInstRuntime = ActionSessionManager.getCurrentSession().getChildDynaInstRuntime();
			String strLastSessionId = ActionSessionManager.getCurrentSession().getSessionId();

			ActionSessionManager.getCurrentSession().setSessionId(KeyValueUtils.genGuidEx());

			ActionSessionManager.getCurrentSession().beginLog(this.getName(), strActionName);

			Object objRet = ActionSessionManager.getCurrentSession().execute(iAction, args, nTransactionalPropagation);

			// Object objRet = this.onExecuteAction(strActionName, iPSDEAction,
			// args, null);

			// 恢复会话的动态实例运行时
			ActionSessionManager.getCurrentSession().setSessionId(strLastSessionId);
			ActionSessionManager.getCurrentSession().setDynaInstRuntime(lastDynaInstRuntime);
			ActionSessionManager.getCurrentSession().setChildDynaInstRuntime(lastChildDynaInstRuntime);

			IActionSessionLog iActionSessionLog = ActionSessionManager.getCurrentSession().endLog(null);

			if (bOpenActionSession) {
				if (iActionSessionLog != null) {
					if (iActionSessionLog.getTime() >= ActionSessionManager.getLogPOTime()) {
						this.getSystemRuntime().logPO(ISystemRuntime.LOGLEVEL_WARN, LogCats.PO_DEACTION, iActionSessionLog.toString(true), this.getName(), strActionName, iActionSessionLog.getTime(), iActionSessionLog);
					}
				}
				ActionSessionManager.closeSession(true);
			}

			return objRet;

		} catch (Throwable ex) {
			ActionSessionManager.getCurrentSession().setDynaInstRuntime(null);
			ActionSessionManager.getCurrentSession().setChildDynaInstRuntime(null);
			if (bOpenActionSession) {

				IActionSessionLog iActionSessionLog = ActionSessionManager.getCurrentSession().endLog(null, true, ex);
				if (iActionSessionLog != null) {
					String strInfo = String.format("实体[%1$s]行为[%2$s]发生异常，%3$s\r\n%4$s", this.getName(), strActionName, ex.getMessage(), iActionSessionLog.toObjectNode().toString());
					this.getSystemRuntime().log(LogLevels.ERROR, LogCats.DEACTION, strInfo, ex);
				}

				ActionSessionManager.closeSession(false);
			}
			throw ex;
		} finally {
			this.pollDataSource();
		}
	}

	@Override
	public void wfStart(IEntityBase iEntityBase, IPSDEWF iPSDEWF) throws Throwable {
		wfStart(iEntityBase, iPSDEWF, false);
	}

	@Override
	public void wfStart(IEntityBase iEntityBase, IPSDEWF iPSDEWF, boolean bIgnoreDEService) throws Throwable {
		if (!bIgnoreDEService && this.getDEService() != null) {
			this.getDEService().wfStart(iEntityBase, iPSDEWF);
			return;
		}
		super.wfStart(iEntityBase, iPSDEWF);
	}

	@Override
	public void checkNestedEntities(IEntityBase parentEntity, IEntityBase[] entities, IDynaInstRuntime iDynaInstRuntime) throws Throwable {

		net.ibizsys.runtime.dataentity.IDynaInstDataEntityRuntime iDynaInstDataEntityRuntime = null;
		if (iDynaInstRuntime != null) {
			iDynaInstDataEntityRuntime = iDynaInstRuntime.getDynaInstDataEntityRuntime(this.getId());
		}
		for (IEntityBase iEntityBase : entities) {
			this.checkEntityBeforeProceed(iEntityBase, DEActions.CREATE, null, (iDynaInstDataEntityRuntime == null) ? this.getPSDataEntity() : iDynaInstDataEntityRuntime.getPSDataEntity(), iDynaInstRuntime, entities);
		}

		super.checkNestedEntities(parentEntity, entities, iDynaInstRuntime);
	}

	@Override
	protected void translateEntityNestedDERsBeforeProceed(IEntityBase arg0, String strActionName, IPSDEAction iPSDEAction, IPSDataEntity iPSDataEntity, IDynaInstRuntime iDynaInstRuntime, Object actionData) throws Throwable {
		if (!(arg0 instanceof IEntityDTO)) {
			return;
		}
		IEntityDTO iEntityDTO = (IEntityDTO) arg0;
		if (iEntityDTO.getDEMethodDTORuntime() != null) {
			List<IPSDEMethodDTOField> psDEMethodDTOFieldList = iEntityDTO.getDEMethodDTORuntime().getPSDEMethodDTO().getPSDEMethodDTOFields();
			if (psDEMethodDTOFieldList != null) {
				for (IPSDEMethodDTOField iPSDEMethodDTOField : psDEMethodDTOFieldList) {
					if (DEMethodDTOFieldTypes.DTO.equals(iPSDEMethodDTOField.getType()) || DEMethodDTOFieldTypes.DTOS.equals(iPSDEMethodDTOField.getType())) {
						Object dtoData = iEntityDTO.get(iPSDEMethodDTOField.getLowerCaseName());
						if (dtoData != null) {
							IDataEntityRuntime refDataEntityRuntime = this.getSystemRuntimeContext().getSystemRuntime().getDataEntityRuntime(iPSDEMethodDTOField.getRefPSDataEntityMust().getId());
							if (DEMethodDTOFieldTypes.DTOS.equals(iPSDEMethodDTOField.getType())) {
								// 列表模式
								if (!(dtoData instanceof List)) {
									throw new DataEntityRuntimeException(this, iEntityDTO.getDEMethodDTORuntime(), String.format("属性[%1$s]传入数据类型不正确", iPSDEMethodDTOField.getName()));
								}
								IPSDERBase iPSDERBase = iPSDEMethodDTOField.getPSDERMust();

								IEntityBase[] minorEntities = this.getNestedDERValue(arg0, iPSDERBase);

								// 检查嵌套数据
								if (minorEntities != null && minorEntities.length > 0) {

									// 填充主键
									for (IEntityBase item : minorEntities) {
										Object objKey = refDataEntityRuntime.getFieldValue(item, refDataEntityRuntime.getKeyPSDEField());
										if (ObjectUtils.isEmpty(objKey)) {
											refDataEntityRuntime.fillEntityKeyValue(item);
										}
									}

									refDataEntityRuntime.checkNestedEntities(arg0, minorEntities, iDynaInstRuntime);
								}

								// //备份
								// String strParamKey =
								// String.format("ONE2MANYDATA_%1$s_%2$s",iPSDER1N.getName(),actionSession.getSessionId());
								// actionSession.setActionParam(strParamKey,
								// (minorEntities != null)? minorEntities:
								// ActionSession.EMPTYPARAM);

								// 执行数据映射处理
								if (iPSDERBase instanceof IPSDER1N) {
									IPSDER1N iPSDER1N = (IPSDER1N) iPSDERBase;
									if (iPSDER1N.getPSDER1NDEFieldMaps() != null) {
										for (IPSDER1NDEFieldMap iPSDER1NDEFieldMap : iPSDER1N.getPSDER1NDEFieldMaps()) {
											Object objCalcValue = EntityListUtils.calc(iPSDER1NDEFieldMap.getMapType(), minorEntities, iPSDER1NDEFieldMap.getMinorPSDEField(), refDataEntityRuntime);
											this.setFieldValue(arg0, iPSDER1NDEFieldMap.getMajorPSDEField(), objCalcValue);
										}
									}
								}
							} else {
								if (!(arg0 instanceof IEntityBase)) {
									throw new DataEntityRuntimeException(this, iEntityDTO.getDEMethodDTORuntime(), String.format("属性[%1$s]传入数据类型不正确", iPSDEMethodDTOField.getName()));
								}

								refDataEntityRuntime.checkNestedEntities(arg0, new IEntityBase[] { (IEntityBase) arg0 }, iDynaInstRuntime);
							}
						}
					}
				}
			}
		}
	}

	@Override
	protected void translateEntityNestedDERsAfterProceed(IEntityBase arg0, String strActionName, IPSDEAction iPSDEAction, IPSDataEntity iPSDataEntity, IDynaInstRuntime iDynaInstRuntime, Object actionData) throws Throwable {
		if (!(arg0 instanceof IEntityDTO)) {
			return;
		}
		IEntityDTO iEntityDTO = (IEntityDTO) arg0;
		if (iEntityDTO.getDEMethodDTORuntime() != null) {
			List<IPSDEMethodDTOField> psDEMethodDTOFieldList = iEntityDTO.getDEMethodDTORuntime().getPSDEMethodDTO().getPSDEMethodDTOFields();
			if (psDEMethodDTOFieldList != null) {
				for (IPSDEMethodDTOField iPSDEMethodDTOField : psDEMethodDTOFieldList) {
					if (DEMethodDTOFieldTypes.DTO.equals(iPSDEMethodDTOField.getType()) || DEMethodDTOFieldTypes.DTOS.equals(iPSDEMethodDTOField.getType())) {

						// 找到外键
						IPSDEField pickupPSDEField = null;
						IPSDERBase iPSDERBase = iPSDEMethodDTOField.getPSDERMust();
						IPSDEDataSet nestedPSDEDataSet = null;
						if (iPSDERBase instanceof IPSDER1N) {
							pickupPSDEField = ((IPSDER1N) iPSDERBase).getPSPickupDEFieldMust();
							nestedPSDEDataSet = ((IPSDER1N) iPSDERBase).getNestedPSDEDataSet();
						} else if (iPSDERBase instanceof IPSDERCustom) {
							pickupPSDEField = ((IPSDERCustom) iPSDERBase).getPickupPSDEField();
							nestedPSDEDataSet = ((IPSDERCustom) iPSDERBase).getNestedPSDEDataSet();
						}
						if (pickupPSDEField == null) {
							throw new DataEntityRuntimeException(this, iEntityDTO.getDEMethodDTORuntime(), String.format("属性[%1$s]没有定义DTO连接属性", iPSDEMethodDTOField.getName()));
						}

						// 查出原有数据
						IDataEntityRuntime refDataEntityRuntime = this.getSystemRuntimeContext().getSystemRuntime().getDataEntityRuntime(iPSDEMethodDTOField.getRefPSDataEntityMust().getId());
						if (refDataEntityRuntime.getStorageMode() == DEStorageModes.NONE) {
							continue;
						}

						Object objKeyValue = iEntityDTO.get(getKeyPSDEField().getLowerCaseName());

						ISearchContextDTO iSearchContextDTO = refDataEntityRuntime.createSearchContext();
						iSearchContextDTO.all().count(false);
						refDataEntityRuntime.setSearchCondition(iSearchContextDTO, pickupPSDEField, Conditions.EQ, objKeyValue);
						List<IEntityDTO> lastList = null;
						if (nestedPSDEDataSet != null) {
							lastList = refDataEntityRuntime.selectDataSet(nestedPSDEDataSet, iSearchContextDTO);
						} else {
							lastList = refDataEntityRuntime.select(iSearchContextDTO);
						}

						iEntityDTO.set(iPSDEMethodDTOField.getLowerCaseName(), lastList);

					}
				}
			}
		}
	}

	@Override
	protected boolean isEnableBPMNExecuteMode() {
		return false;
	}

	@Override
	protected boolean onExecuteActionLogic(IEntityBase arg0, IPSDEActionLogic iPSDEActionLogic, IPSDEAction iPSDEAction, String strAttachMode, IDynaInstRuntime iDynaInstRuntime, Object actionData) throws Throwable {

		if (!(arg0 instanceof IEntityDTO)) {
			throw new DataEntityRuntimeException(this, String.format("无法执行行为附加逻辑，传入参数[%1$s]类型不正确", arg0));
		}
		IEntityDTO iEntityDTO = (IEntityDTO) arg0;
		try {
			ActionSessionManager.getCurrentSession().beginLog(this.getName(), String.format("%1$s[%2$s]", strAttachMode, iPSDEActionLogic.getName()));

			boolean bRet = this.onExecuteActionLogicReal(iEntityDTO, iPSDEActionLogic, iPSDEAction, strAttachMode, iDynaInstRuntime, actionData);

			ActionSessionManager.getCurrentSession().endLog(null);
			return bRet;
		} catch (Throwable ex) {
			if (!iPSDEActionLogic.isIgnoreException()) {
				throw ex;
			} else {
				ActionSessionManager.getCurrentSession().endLog(String.format("忽略异常：%1$s", ex.getMessage()), true, ex);
				this.getSystemRuntime().log(LogLevels.ERROR, LogCats.DEACTION, String.format("实体[%1$s]行为[%2$s]附加逻辑[%3$s]发生异常，%4$s", this.getName(), iPSDEAction.getName(), iPSDEActionLogic.getName(), ex.getMessage()), ex);
				log.error(String.format("实体[%1$s]行为[%2$s]附加逻辑[%3$s]发生异常，%4$s", this.getName(), iPSDEAction.getName(), iPSDEActionLogic.getName(), ex.getMessage()), ex);
			}
		}

		return true;

	}

	protected boolean onExecuteActionLogicReal(IEntityDTO iEntityDTO, IPSDEActionLogic iPSDEActionLogic, IPSDEAction iPSDEAction, String strAttachMode, IDynaInstRuntime iDynaInstRuntime, Object actionData) throws Throwable {
		boolean bCloneParam = iPSDEActionLogic.isCloneParam();
		if (iPSDEActionLogic.getActionLogicType() == DEActionLogicTypes.EXTERNAL) {

			// 直接调用外部行为
			IDataEntityRuntime dstDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(iPSDEActionLogic.getDstPSDEMust().getId());
			IPSDEAction dstPSDEAction = iPSDEActionLogic.getDstPSDEActionMust();
			IPSDEMethodDTO dstPSDEMethodDTO = null;
			if (!DEMethodInputTypes.DTO.equals(dstPSDEAction.getPSDEActionInputMust().getType())) {
				throw new DataEntityRuntimeException(this, String.format("实体[%1$s]行为[%2$s]输入类型必须为[DTO]", dstDataEntityRuntime.getName(), dstPSDEAction.getName()));
			}
			dstPSDEMethodDTO = dstPSDEAction.getPSDEActionInput().getPSDEMethodDTOMust();
			if (!bCloneParam) {
				if (!this.getId().equals(iPSDEActionLogic.getDstPSDEMust().getId())) {
					bCloneParam = true;
				} else {
					// 判断行为使用的DTO是否一致
					if (iEntityDTO.getDEMethodDTORuntime() == null || iEntityDTO.getDEMethodDTORuntime().getPSDEMethodDTO() == null || !(iEntityDTO.getDEMethodDTORuntime().getPSDEMethodDTO().getId().equals(dstPSDEMethodDTO.getId()))) {
						bCloneParam = true;
					}
				}
			}
			IEntityDTO dstEntityDTO = null;
			if (bCloneParam) {
				dstEntityDTO = (IEntityDTO) dstDataEntityRuntime.getDEMethodDTO(dstPSDEMethodDTO, null);
				iEntityDTO.copyTo(dstEntityDTO);
			} else {
				dstEntityDTO = iEntityDTO;
			}

			dstDataEntityRuntime.executeAction(dstPSDEAction.getName(), dstPSDEAction, new Object[] { dstEntityDTO });
			return true;
		}

		if (iPSDEActionLogic.getActionLogicType() == DEActionLogicTypes.INTERNAL) {
			if (iPSDEActionLogic.getPSDELogic() != null && iPSDEActionLogic.getPSDELogic().isCustomCode()) {
				if (StringUtils.hasLength(iPSDEActionLogic.getPSDELogic().getScriptCode())) {
					IDEScriptLogicRuntime iDEScriptActionRuntime = this.getDEScriptLogicRuntime(IDEScriptLogicRuntime.LOGICMODE_DEACTIONLOGIC, iPSDEActionLogic.getPSDELogic().getScriptCode(), iDynaInstRuntime != null);
					if (iDEScriptActionRuntime == null) {
						iDEScriptActionRuntime = iDynaInstRuntime.getDynaInstDataEntityRuntime(this.getId()).getDEScriptLogicRuntime(IDEScriptLogicRuntime.LOGICMODE_DEACTIONLOGIC, iPSDEActionLogic.getPSDELogic().getScriptCode());
					}
					iDEScriptActionRuntime.execute(new Object[] { iEntityDTO });
				}
			} else {
				IDELogicRuntime iDELogicRuntime = null;
				if (iDynaInstRuntime == null) {
					iDELogicRuntime = this.getDELogicRuntime(iPSDEActionLogic.getPSDELogicMust());
				} else {
					iDELogicRuntime = iDynaInstRuntime.getDynaInstDataEntityRuntime(this.getId()).getDELogicRuntime(iPSDEActionLogic.getPSDELogicMust());
				}

				IEntityDTO dstEntityDTO = null;
				if (bCloneParam) {
					if (iEntityDTO.getDEMethodDTORuntime() != null && iEntityDTO.getDEMethodDTORuntime().getPSDEMethodDTO() != null) {
						dstEntityDTO = (IEntityDTO) this.getDEMethodDTO(iEntityDTO.getDEMethodDTORuntime().getPSDEMethodDTO(), null);
						iEntityDTO.copyTo(dstEntityDTO);
					} else {
						dstEntityDTO = this.createEntity();
						iEntityDTO.copyTo(dstEntityDTO);
					}
				} else {
					dstEntityDTO = iEntityDTO;
				}

				iDELogicRuntime.execute(new Object[] { dstEntityDTO });

			}
			return true;
		}

		if (iPSDEActionLogic.getActionLogicType() == DEActionLogicTypes.SCRIPT) {
			if (StringUtils.hasLength(iPSDEActionLogic.getScriptCode())) {
				IDEScriptLogicRuntime iDEScriptActionRuntime = this.getDEScriptLogicRuntime(IDEScriptLogicRuntime.LOGICMODE_DEACTIONLOGIC, iPSDEActionLogic.getScriptCode(), iDynaInstRuntime != null);
				if (iDEScriptActionRuntime == null) {
					iDEScriptActionRuntime = iDynaInstRuntime.getDynaInstDataEntityRuntime(this.getId()).getDEScriptLogicRuntime(IDEScriptLogicRuntime.LOGICMODE_DEACTIONLOGIC, iPSDEActionLogic.getScriptCode());
				}
				iDEScriptActionRuntime.execute(new Object[] { iEntityDTO });
			}
			return true;
		}

		if (iPSDEActionLogic.getActionLogicType() == DEActionLogicTypes.NOTIFY) {
			IPSDENotify iPSDENotify = iPSDEActionLogic.getPSDENotify();
			if (iPSDENotify != null) {
				IDynaInstDataEntityRuntime iDynaInstDataEntityRuntime = null;
				if (iDynaInstRuntime != null) {
					iDynaInstDataEntityRuntime = (IDynaInstDataEntityRuntime) iDynaInstRuntime.getDynaInstDataEntityRuntime(this.getId());
				}
				IDENotifyRuntime iDENotifyRuntime = (iDynaInstDataEntityRuntime != null) ? iDynaInstDataEntityRuntime.getDENotifyRuntime(iPSDENotify) : this.getDENotifyRuntime(iPSDENotify);
				iDENotifyRuntime.send(iEntityDTO);
			}
			return true;
		}

		return super.onExecuteActionLogic(iEntityDTO, iPSDEActionLogic, iPSDEAction, strAttachMode, iDynaInstRuntime, actionData);
	}

	@Override
	protected Object onExecuteDELogic(Object arg0, IPSDEAction iPSDEAction, IPSDELogic iPSDELogic, IDynaInstRuntime iDynaInstRuntime, Object actionData) throws Throwable {
		IDELogicRuntime iDELogicRuntime = null;
		if (iDynaInstRuntime == null) {
			iDELogicRuntime = this.getDELogicRuntime(iPSDELogic);
		} else {
			iDELogicRuntime = iDynaInstRuntime.getDynaInstDataEntityRuntime(this.getId()).getDELogicRuntime(iPSDELogic);
		}
		return iDELogicRuntime.execute(new Object[] { arg0 });
	}

	@Override
	public IDynaInstDataEntityRuntime getDynaInstDataEntityRuntime(IEntityBase iEntityBase, boolean bModuleInst) {
		if (this.getDynaInstMode() != DynaInstModes.DISABLE) {
			String strDynainstid = getDynaInstId(iEntityBase);
			if (StringUtils.hasLength(strDynainstid)) {
				IDynaInstRuntime iDynaInstRuntime = this.getSystemRuntime().getDynaInstRuntime(strDynainstid);
				if (bModuleInst && this.getDynaInstMode() == DynaInstModes.ENABLEINST) {
					// 计算对应的实例
					IUserContext iUserContext = null;
					if (ActionSessionManager.getCurrentSession() != null) {
						iUserContext = ActionSessionManager.getCurrentSession().getUserContext();
					}
					if (iUserContext == null) {
						iUserContext = this.getUserContext();
					}
					if (iUserContext != null) {
						Object objDataType = null;
						if (StringUtils.hasLength(this.getDynaInstTag()) && StringUtils.hasLength(iUserContext.getDynainsttag()) && StringUtils.hasLength(iUserContext.getDynainsttag2()) && this.getDynaInstTag().equals(iUserContext.getDynainsttag())) {
							try {
								objDataType = this.getSystemRuntime().convertValue(this.getDataTypePSDEField().getStdDataType(), iUserContext.getDynainsttag2());
							} catch (Exception ex) {
								throw new DataEntityRuntimeException(this, String.format("转化动态实例标记值2发生异常，%2$s", ex.getMessage()), ex);
							}
						}
						if (objDataType != null) {
							String strChildDynaInstId = iDynaInstRuntime.getChildDynaInstId(this.getDynaInstTag(), objDataType.toString());
							if (StringUtils.hasLength(strChildDynaInstId)) {
								iDynaInstRuntime = this.getSystemRuntime().getDynaInstRuntime(strChildDynaInstId);
							}
						}
					}

				}
				if (iDynaInstRuntime != null) {
					return (IDynaInstDataEntityRuntime) iDynaInstRuntime.getDynaInstDataEntityRuntime(this.getId());
				}
			}
		}
		return null;
	}

	@Override
	public boolean isEnableDEService() {
		return this.bEnableDEService;
	}

	@Override
	protected int onGetStorageMode() throws Exception {
		if (this.getSystemModuleUtilRuntime() != null) {
			return this.getSystemModuleUtilRuntime().getStorageMode(this.getPSDataEntity());
		}
		return this.getSystemRuntimeContext().getStorageMode(this.getPSDataEntity());
	}

	@Override
	protected Object onExecuteAction(String strActionName, IPSDEAction iPSDEAction, Object[] args, Object actionData) throws Throwable {
		// 判断输入是否为列表（LIST），入列表则循环处理
		if (args != null && args.length > 0 && args[0] instanceof List) {
			List retList = null;
			if (iPSDEAction != null && !DEMethodReturnTypes.VOID.equals(iPSDEAction.getPSDEActionReturnMust().getType())) {
				retList = new ArrayList();
			}
			List list = (List) args[0];
			for (Object item : list) {
				args[0] = item;
				Object objRet = this.onExecuteActionSingle(strActionName, iPSDEAction, args, actionData);
				if (retList != null) {
					retList.add(objRet);
				}
			}
			args[0] = list;
			return retList;
		}

		return onExecuteActionSingle(strActionName, iPSDEAction, args, actionData);
	}

	protected Object onExecuteActionSingle(String strActionName, IPSDEAction iPSDEAction, Object[] args, Object actionData) throws Throwable {

		IDEMapRuntime iDEMapRuntime = this.getDEMapRuntime(strActionName, iPSDEAction);
		if (iDEMapRuntime != null) {
			log.debug(String.format("使用实体映射[%1$s]处理行为[%2$s]", iDEMapRuntime.getName(), (iPSDEAction != null ? iPSDEAction.getName() : strActionName)));
			return iDEMapRuntime.executeAction(strActionName, iPSDEAction, args, null);
		}

		return super.onExecuteAction(strActionName, iPSDEAction, args, actionData);
	}

	@Override
	protected boolean isConvertDataSetSortFieldExp() {
		return false;
	}

	@Override
	public IDEDataSetRuntime createDEDataSetRuntime(IPSDEDataSet iPSDEDataSet) {

		IDEDataSetRuntime iDEDataSetRuntime = this.getSystemRuntime().getRuntimeObject(iPSDEDataSet.getPSSysSFPlugin(), IDEDataSetRuntime.class, true);
		if (iDEDataSetRuntime != null) {
			return iDEDataSetRuntime;
		}

		if (this.getSystemModuleUtilRuntime() != null) {
			iDEDataSetRuntime = this.getSystemModuleUtilRuntime().createDEDataSetRuntime(iPSDEDataSet);
			if (iDEDataSetRuntime != null) {
				return iDEDataSetRuntime;
			}
		}
		if (iPSDEDataSet.getPSCodeList() != null) {
			if (DEDataSetTypes.CODELIST.equals(iPSDEDataSet.getDataSetType()) || DEDataSetTypes.INDEXDE.equals(iPSDEDataSet.getDataSetType()) || DEDataSetTypes.MULTIFORM.equals(iPSDEDataSet.getDataSetType())) {
				return new DECodeListDataSetRuntime();
			}
		}

		if (iPSDEDataSet.getPSDELogic() != null) {
			if (DEDataSetTypes.DELOGIC.equals(iPSDEDataSet.getDataSetType())) {
				return new DELogicDataSetRuntime();
			}
		}

		return super.createDEDataSetRuntime(iPSDEDataSet);
	}

	@Override
	public IDEActionRuntime createDEActionRuntime(IPSDEAction iPSDEAction) {

		IDEActionRuntime iDEActionRuntime = this.getSystemRuntime().getRuntimeObject(iPSDEAction.getPSSysSFPlugin(), IDEActionRuntime.class, true);
		if (iDEActionRuntime != null) {
			return iDEActionRuntime;
		}

		if (this.getSystemModuleUtilRuntime() != null) {
			iDEActionRuntime = this.getSystemModuleUtilRuntime().createDEActionRuntime(iPSDEAction);
			if (iDEActionRuntime != null) {
				return iDEActionRuntime;
			}
		}

		return super.createDEActionRuntime(iPSDEAction);
	}

	@Override
	public IDELogicRuntime createDELogicRuntime(IPSDELogic iPSDELogic) {

		IDELogicRuntime iDELogicRuntime = this.getSystemRuntime().getRuntimeObject(iPSDELogic.getPSSysSFPlugin(), IDELogicRuntime.class, true);
		if (iDELogicRuntime != null) {
			return iDELogicRuntime;
		}

		if (this.getSystemModuleUtilRuntime() != null) {
			iDELogicRuntime = this.getSystemModuleUtilRuntime().createDELogicRuntime(iPSDELogic);
			if (iDELogicRuntime != null) {
				return iDELogicRuntime;
			}
		}
		return createDefaultDELogicRuntime();
	}

	protected IDELogicRuntime createDefaultDELogicRuntime() {
		return new DELogicRuntime();
	}

	@Override
	public IDEDataExportRuntime createDEDataExportRuntime(IPSDEDataExport iPSDEDataExport) {
		IDEDataExportRuntime iDEDataExportRuntime = this.getSystemRuntime().getRuntimeObject(iPSDEDataExport.getPSSysSFPlugin(), IDEDataExportRuntime.class, true);
		if (iDEDataExportRuntime != null) {
			return iDEDataExportRuntime;
		}

		if (this.getSystemModuleUtilRuntime() != null) {
			iDEDataExportRuntime = this.getSystemModuleUtilRuntime().createDEDataExportRuntime(iPSDEDataExport);
			if (iDEDataExportRuntime != null) {
				return iDEDataExportRuntime;
			}
		}

		iDEDataExportRuntime = this.getSystemRuntime().getRuntimeObject(IDEDataExportRuntime.class, null);
		if (iDEDataExportRuntime != null) {
			return iDEDataExportRuntime;
		}

		return createDefaultDEDataExportRuntime();
	}

	protected IDEDataExportRuntime createDefaultDEDataExportRuntime() {
		return new DEDataExportRuntime();
	}

	@Override
	public IDEDataImportRuntime createDEDataImportRuntime(IPSDEDataImport iPSDEDataImport) {
		IDEDataImportRuntime iDEDataImportRuntime = this.getSystemRuntime().getRuntimeObject(iPSDEDataImport.getPSSysSFPlugin(), IDEDataImportRuntime.class, true);
		if (iDEDataImportRuntime != null) {
			return iDEDataImportRuntime;
		}

		if (this.getSystemModuleUtilRuntime() != null) {
			iDEDataImportRuntime = this.getSystemModuleUtilRuntime().createDEDataImportRuntime(iPSDEDataImport);
			if (iDEDataImportRuntime != null) {
				return iDEDataImportRuntime;
			}
		}

		iDEDataImportRuntime = this.getSystemRuntime().getRuntimeObject(IDEDataImportRuntime.class, null);
		if (iDEDataImportRuntime != null) {
			return iDEDataImportRuntime;
		}

		return createDefaultDEDataImportRuntime();
	}

	protected IDEDataImportRuntime createDefaultDEDataImportRuntime() {
		return new DEDataImportRuntime();
	}

	public IDERRuntime createDERRuntime(IPSDERBase iPSDERBase) {

		IDERRuntime iDERRuntime = null;
		if (this.getSystemModuleUtilRuntime() != null) {
			iDERRuntime = this.getSystemModuleUtilRuntime().createDERRuntime(iPSDERBase);
			if (iDERRuntime != null) {
				return iDERRuntime;
			}
		}

		if (DERTypes.DERAGGDATA.equals(iPSDERBase.getDERType())) {
			return new DERAggDataRuntime();
		}

		return null;
	}

	@Override
	public IDERRuntime getDERRuntime(IPSDERBase iPSDERBase, boolean bTryMode) {
		this.prepare();
		Assert.notNull(iPSDERBase, "传入实体关系模型对象无效");
		IDERRuntime iDERRuntime = null;
		if (this.derRuntimeMap != null) {
			iDERRuntime = this.derRuntimeMap.get(iPSDERBase.getId());
		}
		if (iDERRuntime != null || bTryMode) {
			return iDERRuntime;
		}
		throw new DataEntityRuntimeException(this, String.format("无法获取实体关系[%1$s]运行时对象", iPSDERBase.getId()));
	}

	@Override
	public IDEMapRuntime getDEMapRuntime(String strCodeName, boolean bTryMode) {
		this.prepare();
		Assert.hasLength(strCodeName, "传入实体映射代码标识无效");

		IDEMapRuntime iDEMapRuntime = null;
		if (this.deMapRuntimeMap != null) {
			iDEMapRuntime = this.deMapRuntimeMap.get(strCodeName.toLowerCase());
		}
		if (iDEMapRuntime != null || bTryMode) {
			return iDEMapRuntime;
		}
		throw new DataEntityRuntimeException(this, String.format("无法获取实体映射[%1$s]运行时对象", strCodeName));
	}

	public IDEMapRuntime createDEMapRuntime(IPSDEMap iPSDEMap) {

		IDEMapRuntime iDEMapRuntime = this.getSystemRuntime().getRuntimeObject(iPSDEMap.getPSSysSFPlugin(), IDEMapRuntime.class, true);
		if (iDEMapRuntime != null) {
			return iDEMapRuntime;
		}

		iDEMapRuntime = this.getSystemRuntime().getRuntimeObject(IDEMapRuntime.class, null);
		if (iDEMapRuntime != null) {
			return iDEMapRuntime;
		}

		return createDefaultDEMapRuntime();
	}

	protected IDEMapRuntime createDefaultDEMapRuntime() {
		// return new DEMapRuntime();
		return this.getSystemRuntime().createDefaultDEMapRuntime();
	}

	/**
	 * 获取支持指定行为的映射对象
	 * 
	 * @param strActionName
	 * @param iPSDEAction
	 * @return
	 */
	public IDEMapRuntime getDEMapRuntime(String strActionName, IPSDEAction iPSDEAction) {
		this.prepare();
		if (ObjectUtils.isEmpty(this.deMapRuntimeMap)) {
			return null;
		}
		for (IDEMapRuntime iDEMapRuntime : this.deMapRuntimeMap.values()) {
			if (iDEMapRuntime.isEnableAction(strActionName, iPSDEAction)) {
				return iDEMapRuntime;
			}
		}
		return null;
	}

	/**
	 * 获取支持指定结果集的映射对象
	 * 
	 * @param strDataSetName
	 * @param iPSDEDataSet
	 * @return
	 */
	public IDEMapRuntime getDEMapRuntime(String strDataSetName, IPSDEDataSet iPSDEDataSet) {
		this.prepare();
		if (ObjectUtils.isEmpty(this.deMapRuntimeMap)) {
			return null;
		}
		for (IDEMapRuntime iDEMapRuntime : this.deMapRuntimeMap.values()) {
			if (iDEMapRuntime.isEnableDataSet(strDataSetName, iPSDEDataSet)) {
				return iDEMapRuntime;
			}
		}
		return null;
	}

	@Override
	public void rawCreate(List<? extends net.ibizsys.central.util.IEntityDTO> list, boolean bSysMode) throws Throwable {
		Assert.notEmpty(list, "传入数据列表无效");
		boolean bPrepareDTORuntime = false;
		for (IEntityDTO t : list) {
			if (t.getDEMethodDTORuntime() == null) {
				bPrepareDTORuntime = true;
				break;
			}
		}
		if (bPrepareDTORuntime) {
			IPSDEMethodDTO iPSDEMethodDTO = this.getDefaultPSDEMethodDTO();
			if (iPSDEMethodDTO != null) {
				IDEMethodDTORuntime iDEMethodDTORuntime = this.getDEMethodDTORuntime(iPSDEMethodDTO, false);
				for (IEntityDTO t : list) {
					if (t.getDEMethodDTORuntime() == null) {
						t.setDEMethodDTORuntime(iDEMethodDTORuntime);
					}
				}
			}
		}

		getSystemPersistentAdapterMust().create(this, null, list, null, false, null, bSysMode);
	}

	@Override
	public void rawUpdate(List<? extends net.ibizsys.central.util.IEntityDTO> list, boolean bSysMode) throws Throwable {
		Assert.notEmpty(list, "传入数据列表无效");

		boolean bPrepareDTORuntime = false;
		for (IEntityDTO t : list) {
			if (t.getDEMethodDTORuntime() == null) {
				bPrepareDTORuntime = true;
				break;
			}
		}
		if (bPrepareDTORuntime) {
			IPSDEMethodDTO iPSDEMethodDTO = this.getDefaultPSDEMethodDTO();
			if (iPSDEMethodDTO != null) {
				IDEMethodDTORuntime iDEMethodDTORuntime = this.getDEMethodDTORuntime(iPSDEMethodDTO, false);
				for (IEntityDTO t : list) {
					if (t.getDEMethodDTORuntime() == null) {
						t.setDEMethodDTORuntime(iDEMethodDTORuntime);
					}
				}
			}
		}

		getSystemPersistentAdapterMust().update(this, null, list, null, false, null, bSysMode);
	}

	@Override
	public void rawSave(List<? extends net.ibizsys.central.util.IEntityDTO> list, boolean bSysMode) throws Throwable {
		Assert.notEmpty(list, "传入数据列表无效");

		boolean bPrepareDTORuntime = false;
		for (IEntityDTO t : list) {
			if (t.getDEMethodDTORuntime() == null) {
				bPrepareDTORuntime = true;
				break;
			}
		}

		if (bPrepareDTORuntime) {
			IPSDEMethodDTO iPSDEMethodDTO = this.getDefaultPSDEMethodDTO();
			if (iPSDEMethodDTO != null) {
				IDEMethodDTORuntime iDEMethodDTORuntime = this.getDEMethodDTORuntime(iPSDEMethodDTO, false);
				for (IEntityDTO t : list) {
					if (t.getDEMethodDTORuntime() == null) {
						t.setDEMethodDTORuntime(iDEMethodDTORuntime);
					}
				}
			}
		}

		List<IEntityDTO> createList = new ArrayList<>();
		List<IEntityDTO> updateList = new ArrayList<>();
		for (IEntityDTO t : list) {
			Object objKey = this.getDataEntityRuntime().getFieldValue(t, this.getDataEntityRuntime().getKeyPSDEField());
			if (ObjectUtils.isEmpty(objKey)) {
				// 新建
				if (!this.getDataEntityRuntime().fillEntityKeyValue(t)) {
					createList.add(t);
					continue;
				}
				objKey = this.getDataEntityRuntime().getFieldValue(t, this.getDataEntityRuntime().getKeyPSDEField());
			}
			int nRet = this.checkKeyState(objKey);
			if (nRet == CheckKeyStates.DELETE) {
				throw new DataEntityRuntimeException(this, String.format("数据[%1$s]已经被删除", objKey), Errors.INVALIDDATAKEYS);
			}
			if (nRet == CheckKeyStates.OK) {
				createList.add(t);
			} else {
				updateList.add(t);
			}
		}
		if (!ObjectUtils.isEmpty(createList)) {
			this.rawCreate(createList, bSysMode);
		}
		if (!ObjectUtils.isEmpty(updateList)) {
			this.rawUpdate(updateList, bSysMode);
		}
	}

	@Override
	public void rawRemove(List<Object> list, boolean bSysMode) throws Throwable {
		Assert.notEmpty(list, "传入数据列表无效");
		getSystemPersistentAdapterMust().remove(this, null, list, bSysMode);
	}

	public ISystemPersistentAdapter getSystemPersistentAdapterMust() {
		ISystemPersistentAdapter iSystemPersistentAdapter = this.getSystemPersistentAdapter();
		if (iSystemPersistentAdapter == null) {
			throw new DataEntityRuntimeException(this.getDataEntityRuntime(), "系统持久化对象无效");
		}
		return iSystemPersistentAdapter;
	}

	@Override
	public ISysBDSchemeRuntime getSysBDSchemeRuntime() {
		if (this.getStorageMode() != DEStorageModes.NOSQL || this.iSysBDSchemeRuntime != null) {
			return this.iSysBDSchemeRuntime;
		}

		this.iSysBDSchemeRuntime = this.getSystemRuntime().getSysBDSchemeRuntime(this);
		if (this.iSysBDSchemeRuntime == null) {
			log.warn(String.format("实体[%1$s]配置大数据存储，但未获取对应的大数据库运行时对象", this.getName()));
		}

		return this.iSysBDSchemeRuntime;
	}

	@Override
	protected void translateSearchContextBeforeProceed(ISearchContextBase arg0, String strDataSetName, IPSDEDataSet iPSDEDataSet, IPSDataEntity iPSDataEntity, IDynaInstRuntime iDynaInstRuntime, Object actionData) throws Throwable {
		if (iPSDEDataSet.getActiveDataPSDELogic() != null) {
			// 进行查询上下文值逻辑转换
			IDELogicRuntime iDELogicRuntime = this.getDELogicRuntime(iPSDEDataSet.getActiveDataPSDELogic());
			iDELogicRuntime.execute(new Object[] { arg0 });
		}
		super.translateSearchContextBeforeProceed(arg0, strDataSetName, iPSDEDataSet, iPSDataEntity, iDynaInstRuntime, actionData);
	}

	@Override
	public Object serializeEntityList(List<? extends IEntityDTO> list) {
		Assert.notNull(list, "不能传入空对象");
		try {
			return JsonUtils.MAPPER.writeValueAsString(list);
		} catch (Exception ex) {
			throw new DataEntityRuntimeException(this, String.format("序列化数据对象列表发生异常，%1$s", ex.getMessage()), ex);
		}
	}

	@Override
	public List<IEntityDTO> deserializeEntityList(Object objData) {
		if (!(objData instanceof String)) {
			throw new DataEntityRuntimeException(this, String.format("反序列化数据对象列表发生异常，传入值类型不正确"));
		}

		Assert.hasLength((String) objData, "不能传入空数据");

		try {
			List list = JsonUtils.MAPPER.readValue((String) objData, List.class);
			if (list != null) {
				List<IEntityDTO> entityDTOList = new ArrayList<IEntityDTO>();
				for (Object map : list) {
					if (map instanceof Map) {
						IEntityDTO iEntityDTO = this.createEntity();
						iEntityDTO.reload(map, true);
						entityDTOList.add(iEntityDTO);
					} else {
						throw new Exception("成员类型不正确");
					}
				}
				return entityDTOList;
			}
		} catch (Exception ex) {
			throw new DataEntityRuntimeException(this, String.format("反序列化数据对象列表发生异常，%1$s", ex.getMessage()), ex);
		}
		return null;
	}

	@Override
	public Object serializeEntity(IEntityBase iEntityBase) {
		Assert.notNull(iEntityBase, "不能传入空对象");
		try {
			return JsonUtils.MAPPER.writeValueAsString(iEntityBase);
		} catch (Exception ex) {
			throw new DataEntityRuntimeException(this, String.format("序列化数据对象发生异常，%1$s", ex.getMessage()), ex);
		}
	}

	@Override
	public IEntityBase deserializeEntity(Object objData) {
		if (!(objData instanceof String)) {
			throw new DataEntityRuntimeException(this, String.format("反序列化数据对象发生异常，传入值类型不正确"));
		}

		Assert.hasLength((String) objData, "不能传入空数据");

		try {
			Map map = JsonUtils.MAPPER.readValue((String) objData, Map.class);
			if (map != null) {
				IEntityDTO iEntityDTO = this.createEntity();
				iEntityDTO.reload(map, true);
				return iEntityDTO;
			}
		} catch (Exception ex) {
			throw new DataEntityRuntimeException(this, String.format("反序列化数据对象列表发生异常，%1$s", ex.getMessage()), ex);
		}
		return null;
	}

	@Override
	public IEntityBase[] deserializeEntities(Object objData) {
		List<IEntityDTO> list = deserializeEntityList(objData);
		if (list == null || list.size() == 0) {
			return null;
		}

		return list.toArray(new IEntityBase[list.size()]);
	}

	@Override
	public Object serializeEntities(IEntityBase[] list) {
		Assert.notNull(list, "不能传入空对象");
		try {
			return JsonUtils.MAPPER.writeValueAsString(list);
		} catch (Exception ex) {
			throw new DataEntityRuntimeException(this, String.format("序列化数据对象列表发生异常，%1$s", ex.getMessage()), ex);
		}
	}

	@Override
	protected void onPushDataSource() {
		if (this.getSysDBSchemeRuntime() != null) {
			this.getSysDBSchemeRuntime().push();
		}
		super.onPushDataSource();
	}

	@Override
	protected void onPollDataSource() {

		super.onPollDataSource();

		if (this.getSysDBSchemeRuntime() != null) {
			this.getSysDBSchemeRuntime().poll();
		}
	}

	@Override
	public void getImportTemplate(String strImportTag, OutputStream outputStream, boolean bTestPriv, IDataEntityRuntime parentDataEntityRuntime, String strParentKey) throws Throwable {
		prepare();

		boolean bOpenActionSession = (ActionSessionManager.getCurrentSession() == null);
		if (bOpenActionSession) {
			ActionSessionManager.openSession().setName(this.getName());
			ActionSessionManager.getCurrentSession().setUserContext(this.getUserContext());
		}

		try {
			this.pushDataSource();
			// 备份会话的动态实例运行时
			IDynaInstRuntime lastDynaInstRuntime = ActionSessionManager.getCurrentSession().getDynaInstRuntime();
			IDynaInstRuntime lastChildDynaInstRuntime = ActionSessionManager.getCurrentSession().getChildDynaInstRuntime();

			String strLastSessionId = ActionSessionManager.getCurrentSession().getSessionId();

			ActionSessionManager.getCurrentSession().setSessionId(KeyValueUtils.genGuidEx());

			ActionSessionManager.getCurrentSession().beginLog(this.getName(), String.format("获取导入数据模板[%1$s]", strImportTag));

			this.onGetImportTemplate(strImportTag, outputStream, bTestPriv, parentDataEntityRuntime, strParentKey);

			// 恢复会话的动态实例运行时
			ActionSessionManager.getCurrentSession().setSessionId(strLastSessionId);
			ActionSessionManager.getCurrentSession().setDynaInstRuntime(lastDynaInstRuntime);
			ActionSessionManager.getCurrentSession().setChildDynaInstRuntime(lastChildDynaInstRuntime);

			IActionSessionLog iActionSessionLog = ActionSessionManager.getCurrentSession().endLog(null);

			if (bOpenActionSession) {
				if (iActionSessionLog != null) {
					if (iActionSessionLog.getTime() >= ActionSessionManager.getLogPOTime()) {
						this.getSystemRuntime().logPO(ISystemRuntime.LOGLEVEL_WARN, LogCats.PO_DEDATAIMPTEMPL, iActionSessionLog.toString(true), this.getName(), String.format("获取导入数据模板[%1$s]", strImportTag), iActionSessionLog.getTime(), iActionSessionLog);
					}
				}
				ActionSessionManager.closeSession(true);
			}

		} catch (Throwable ex) {
			ActionSessionManager.getCurrentSession().setDynaInstRuntime(null);
			ActionSessionManager.getCurrentSession().setChildDynaInstRuntime(null);
			if (bOpenActionSession) {

				IActionSessionLog iActionSessionLog = ActionSessionManager.getCurrentSession().endLog(null, true, ex);
				if (iActionSessionLog != null) {
					String strInfo = String.format("实体[%1$s]获取导入数据模板[%2$s]发生异常，%3$s\r\n%4$s", this.getName(), strImportTag, ex.getMessage(), iActionSessionLog.toObjectNode().toString());
					this.getSystemRuntime().log(LogLevels.ERROR, LogCats.DEDATAIMPTEMPL, strInfo, ex);
				}

				ActionSessionManager.closeSession(false);
			}
			throw ex;
		} finally {
			this.pollDataSource();
		}
	}

	protected void onGetImportTemplate(String strImportTag, OutputStream outputStream, boolean bTestPriv, IDataEntityRuntime parentDataEntityRuntime, String strParentKey) throws Throwable {
		/**
		 * 计算动态实例实体运行时
		 */
		IDynaInstDataEntityRuntime iDynaInstDataEntityRuntime = null;
		IDynaInstRuntime iDynaInstRuntime = null;
		if (this.getDynaInstMode() != DynaInstModes.DISABLE) {
			String strDynainstid = getDynaInstId(null);
			if (StringUtils.hasLength(strDynainstid)) {
				iDynaInstRuntime = this.getSystemRuntime().getDynaInstRuntime(strDynainstid);
				// 设置当前会话的动态实例运行时
				ActionSessionManager.getCurrentSession().setDynaInstRuntime(iDynaInstRuntime);
				if (iDynaInstRuntime != null) {
					iDynaInstDataEntityRuntime = (IDynaInstDataEntityRuntime) iDynaInstRuntime.getDynaInstDataEntityRuntime(this.getId());
				}
			}
		}
		IDEDataImportRuntime iDEDataImportRuntime = null;
		if (iDynaInstDataEntityRuntime != null) {
			iDEDataImportRuntime = iDynaInstDataEntityRuntime.getDEDataImportRuntime(strImportTag);
		} else {
			iDEDataImportRuntime = this.getDEDataImportRuntime(strImportTag);
		}

		((net.ibizsys.central.dataentity.dataimport.IDEDataImportRuntime) iDEDataImportRuntime).getImportTemplate(strImportTag, outputStream, bTestPriv, parentDataEntityRuntime, strParentKey);
	}

	@Override
	public List<IDETestCaseRuntime> getDETestCaseRuntimes() {
		prepare();

		try {
			if (!ObjectUtils.isEmpty(this.deTestCaseRuntimeList)) {
				return this.deTestCaseRuntimeList;
			}
			List<IPSSysTestCase> psSysTestCaseList = this.getPSDataEntity().getAllPSSysTestCases();
			if (!ObjectUtils.isEmpty(psSysTestCaseList)) {
				List<IDETestCaseRuntime> list = new ArrayList<IDETestCaseRuntime>();
				for (IPSSysTestCase iPSSysTestCase : psSysTestCaseList) {
					ISysTestCaseRuntime iSysTestCaseRuntime = this.getSystemRuntime().createSysTestCaseRuntime(iPSSysTestCase);
					if (!(iSysTestCaseRuntime instanceof IDETestCaseRuntime)) {
						throw new Exception(String.format("建立测试用例[%1$s]运行时对象不正确", iPSSysTestCase.getName()));
					}
					try {
						iSysTestCaseRuntime.init(this.getSystemRuntimeContext(), iPSSysTestCase);
					} catch (Exception ex) {
						throw new Exception(String.format("初始化测试用例[%1$s]运行时对象发生异常，%2$s", iPSSysTestCase.getName(), ex.getMessage()), ex);
					}
					list.add((IDETestCaseRuntime) iSysTestCaseRuntime);
				}
				if (this.deTestCaseRuntimeList == null) {
					this.deTestCaseRuntimeList = list;
				}
			}

			return this.deTestCaseRuntimeList;
		} catch (Throwable ex) {
			throw new DataEntityRuntimeException(this, String.format("获取实体测试用例运行时对象集合发生异常，%1$s", ex.getMessage()), ex);
		}
	}

	@Override
	public void fillEntityCodeListTexts(IEntity iEntity) {
		prepare();

		try {

			// 进一步填充代码表值
			java.util.List<IPSDEField> psDEFieldList = this.getPSDataEntity().getAllPSDEFields();
			if (!ObjectUtils.isEmpty(psDEFieldList)) {
				for (IPSDEField iPSDEField : psDEFieldList) {
					IPSCodeList iPSCodeList = iPSDEField.getPSCodeList();
					if (iPSCodeList == null) {
						continue;
					}

					if (!iEntity.contains(iPSDEField.getLowerCaseName())) {
						continue;
					}

					String strTextItemName = String.format("%1$stext", iPSDEField.getLowerCaseName());
					if (iEntity.contains(strTextItemName)) {
						continue;
					}

					ICodeListRuntime iCodeListRuntime = this.getSystemRuntime().getCodeListRuntime(iPSCodeList);

					Object objValue = iEntity.get(iPSDEField.getLowerCaseName());

					try {
						if (ObjectUtils.isEmpty(objValue)) {
							iEntity.set(strTextItemName, iCodeListRuntime.getEmptyText());
						} else {
							iEntity.set(strTextItemName, iCodeListRuntime.getText(objValue));
						}
					} catch (Throwable ex) {
						log.error(String.format("获取代码表[%1$s]值[%2$s]文本发生异常，%3$s", iPSCodeList.getId(), objValue, ex.getMessage()));
						iEntity.set(strTextItemName, ex.getMessage());
					}
				}
			}

		} catch (Throwable ex) {
			throw new DataEntityRuntimeException(this, String.format("获取实体数据对象代码表值文本发生异常，%1$s", ex.getMessage()), ex);
		}
	}

	@Override
	public void create(IEntityDTO iEntityDTO) throws Throwable {
		super.create(iEntityDTO);
	}

	@Override
	public void update(IEntityDTO iEntityDTO) throws Throwable {
		super.update(iEntityDTO);
	}

	@Override
	public void sysUpdate(IEntityDTO iEntityDTO) throws Throwable {
		if (this.getSystemPersistentAdapter() == null) {
			throw new DataEntityRuntimeException(this, String.format("执行系统更新发生错误，未指定实体持久化对象"));
		}

		// IEntityDTO iEntityDTO = this.getEntityDTO(iEntityBase);

		try {
			this.getSystemPersistentAdapter().update(this, null, iEntityDTO, null, false, null, true);
			this.syncEntityAfterProceed(DEDataSyncEvents.UPDATE, iEntityDTO, null, DEActions.SYSUPDATE, null, null, null, null);
		} catch (Throwable ex) {
			throw new DataEntityRuntimeException(this, String.format("执行系统更新发生异常，%1$s", ex.getMessage()), ex);
		}
	}

	@Override
	public IEntityDTO get(Object objKey) throws Throwable {
		return (IEntityDTO) super.get(objKey);
	}

	@Override
	public void removeInvalidUserInput(IPSDEAction iPSDEAction, IEntityDTO iEntityDTO) {
		prepare();
		try {
			onRemoveInvalidUserInput(iPSDEAction, iEntityDTO);
		} catch (Throwable ex) {
			throw new DataEntityRuntimeException(this, String.format("移除无效用户输入发生异常，%1$s", ex.getMessage()), ex);
		}
	}

	protected void onRemoveInvalidUserInput(IPSDEAction iPSDEAction, IEntityDTO iEntityDTO) throws Throwable {
		// 判断模式
		if (DEActions.CREATE.equalsIgnoreCase(iPSDEAction.getName()) || DEActionModes.CREATE.equals(iPSDEAction.getActionMode())) {

			java.util.List<IPSDEField> psDEFieldList = this.getPSDataEntity().getAllPSDEFields();
			if (!ObjectUtils.isEmpty(psDEFieldList)) {
				for (IPSDEField iPSDEField : psDEFieldList) {
					if (iPSDEField.isKeyDEField()) {
						continue;
					}

					if (!iPSDEField.isEnableUICreate()) {
						// 属性不支持界面建立
						iEntityDTO.reset(iPSDEField.getLowerCaseName());
					}
				}
			}
		} else if (DEActions.UPDATE.equalsIgnoreCase(iPSDEAction.getName()) || DEActionModes.UPDATE.equals(iPSDEAction.getActionMode())) {

			java.util.List<IPSDEField> psDEFieldList = this.getPSDataEntity().getAllPSDEFields();
			if (!ObjectUtils.isEmpty(psDEFieldList)) {
				for (IPSDEField iPSDEField : psDEFieldList) {
					if (iPSDEField.isKeyDEField()) {
						continue;
					}

					if (!iPSDEField.isEnableUIModify()) {
						// 属性不支持界面修改
						iEntityDTO.reset(iPSDEField.getLowerCaseName());
					}
				}
			}
		}
	}

	/**
	 * 是否启用继承逻辑处理
	 * 
	 * @return
	 */
	protected boolean isEnableInheritLogic() {
		if (this.isInheritMajor() || this.isInheritMinor()) {
			// 判断
			if (this.getStorageMode() == DEStorageModes.SERVICEAPI) {
				if (this.isInheritMinor() && this.getInheritDataEntityRuntime() != null) {
					// 判断主实体模式
					if (this.getInheritDataEntityRuntime().getStorageMode() == DEStorageModes.SERVICEAPI) {
						ISubSysServiceAPIRuntime subSysServiceAPIRuntime = ((IDataEntityRuntime) this.getInheritDataEntityRuntime()).getSubSysServiceAPIRuntime();
						ISubSysServiceAPIRuntime subSysServiceAPIRuntime2 = this.getSubSysServiceAPIRuntime();
						if (subSysServiceAPIRuntime != null && subSysServiceAPIRuntime2 != null) {
							return !subSysServiceAPIRuntime.getId().equals(subSysServiceAPIRuntime2.getId());
						}
					}
				}
			}

			return true;
		}
		return false;
	}

	@Override
	public ImportDataResult importData2(String strImportTag, IEntity baseEntity, InputStream inputStream, boolean bTestPriv, IDataEntityRuntime parentDataEntityRuntime, String strParentKey) throws Throwable {
		prepare();

		boolean bOpenActionSession = (ActionSessionManager.getCurrentSession() == null);
		if (bOpenActionSession) {
			ActionSessionManager.openSession().setName(this.getName());
			ActionSessionManager.getCurrentSession().setUserContext(this.getUserContext());
		}

		try {
			this.pushDataSource();
			// 备份会话的动态实例运行时
			IDynaInstRuntime lastDynaInstRuntime = ActionSessionManager.getCurrentSession().getDynaInstRuntime();
			IDynaInstRuntime lastChildDynaInstRuntime = ActionSessionManager.getCurrentSession().getChildDynaInstRuntime();

			String strLastSessionId = ActionSessionManager.getCurrentSession().getSessionId();

			ActionSessionManager.getCurrentSession().setSessionId(KeyValueUtils.genGuidEx());

			ActionSessionManager.getCurrentSession().beginLog(this.getName(), String.format("导入数据[%1$s]", strImportTag));

			ImportDataResult ret = this.onImportData2(strImportTag, baseEntity, inputStream, bTestPriv, parentDataEntityRuntime, strParentKey);

			// 恢复会话的动态实例运行时
			ActionSessionManager.getCurrentSession().setSessionId(strLastSessionId);
			ActionSessionManager.getCurrentSession().setDynaInstRuntime(lastDynaInstRuntime);
			ActionSessionManager.getCurrentSession().setChildDynaInstRuntime(lastChildDynaInstRuntime);

			IActionSessionLog iActionSessionLog = ActionSessionManager.getCurrentSession().endLog(null);

			if (bOpenActionSession) {
				if (iActionSessionLog != null) {
					if (iActionSessionLog.getTime() >= ActionSessionManager.getImportDataLogPOTime()) {
						this.getSystemRuntime().logPO(ISystemRuntime.LOGLEVEL_WARN, LogCats.PO_DEDATAIMP, iActionSessionLog.toString(true), this.getName(), String.format("导入数据[%1$s]", strImportTag), iActionSessionLog.getTime(), iActionSessionLog);
					}
				}
				ActionSessionManager.closeSession(true);
			}

			return ret;

		} catch (Throwable ex) {
			ActionSessionManager.getCurrentSession().setDynaInstRuntime(null);
			ActionSessionManager.getCurrentSession().setChildDynaInstRuntime(null);
			if (bOpenActionSession) {

				IActionSessionLog iActionSessionLog = ActionSessionManager.getCurrentSession().endLog(ex.getMessage(), true, ex);
				if (iActionSessionLog != null) {
					String strInfo = String.format("实体[%1$s]数据导入[%2$s]发生异常，%3$s\r\n%4$s", this.getName(), strImportTag, ex.getMessage(), iActionSessionLog.toObjectNode().toString());
					this.getSystemRuntime().log(LogLevels.ERROR, LogCats.DEDATAIMP, strInfo, ex);
				}

				ActionSessionManager.closeSession(false);
			}
			throw ex;
		} finally {
			this.pollDataSource();
		}
	}

	protected ImportDataResult onImportData2(String strImportTag, IEntity baseEntity, InputStream inputStream, boolean bTestPriv, IDataEntityRuntime parentDataEntityRuntime, String strParentKey) throws Throwable {

		IDEDataImportRuntime iDEDataImportRuntime = this.getDEDataImportRuntime(strImportTag);
		if (iDEDataImportRuntime instanceof IDEDataImportRuntime2) {
			return ((IDEDataImportRuntime2) iDEDataImportRuntime).importStream2(baseEntity, inputStream, bTestPriv, parentDataEntityRuntime, strParentKey);
		}

		throw new Exception(String.format("对象[%1$s]未支持增强导入数据", iDEDataImportRuntime));
	}

	// @Override
	// protected int getDataSyncEvent(String strActionName, IPSDEAction
	// iPSDEAction) {
	// if(this.getSystemPersistentAdapter() == null) {
	// return DEDataSyncEvents.NONE;
	// }
	// return super.getDataSyncEvent(strActionName, iPSDEAction);
	// }

	/**
	 * 注册实体行为插件运行时对象接口
	 * 
	 * @param strAction
	 * @param iAction
	 * @return
	 */
	protected IDEActionPluginRuntime registerDEActionPluginRuntime(String strAction, IAction iAction) {
		IDEActionPluginRuntime iDEActionPluginRuntime = new DEActionPluginRuntimeBase() {
			@Override
			protected Object onExecute(Object[] args) throws Throwable {
				return iAction.execute(args);
			}
		};

		this.registerDEActionPluginRuntime(strAction, iDEActionPluginRuntime);
		return iDEActionPluginRuntime;
	}

	/**
	 * 注册实体结果集插件运行时对象接口
	 * 
	 * @param strDataSet
	 * @param iDataSet
	 * @return
	 */
	protected IDEDataSetPluginRuntime registerDEDataSetPluginRuntime(String strDataSet, IAction iAction) {
		IDEDataSetPluginRuntime iDEDataSetPluginRuntime = new DEDataSetPluginRuntimeBase() {
			@Override
			protected Object onFetch(Object[] args) throws Throwable {
				return iAction.execute(args);
			}
		};

		this.registerDEDataSetPluginRuntime(strDataSet, iDEDataSetPluginRuntime);
		return iDEDataSetPluginRuntime;
	}

	@Override
	public IPSDEAction getPSDEActionByCodeName(String actionCodeName, boolean bTryMode) {
		prepare();
		Object method = this.getMethod(actionCodeName);
		if (method instanceof IPSDEAction) {
			return (IPSDEAction) method;
		}
		if (bTryMode) {
			return null;
		}
		throw new DataEntityRuntimeException(this, String.format("无法获取指定代码名称[%1$s]实体行为", actionCodeName));
	}

	@Override
	public IPSDEDataSet getPSDEDataSetByCodeName(String dataSetCodeName, boolean bTryMode) {
		prepare();
		Object method = this.getMethod(dataSetCodeName);
		if (method instanceof IPSDEDataSet) {
			return (IPSDEDataSet) method;
		}
		if (bTryMode) {
			return null;
		}
		throw new DataEntityRuntimeException(this, String.format("无法获取指定代码名称[%1$s]实体数据集", dataSetCodeName));
	}

	@Override
	public IPSDEField getPSDEFieldByCodeName(String fieldCodeName, boolean bTryMode) {
		prepare();
		IPSDEField iPSDEField = this.psDEFieldMap2.get(fieldCodeName.toLowerCase());
		if (bTryMode || iPSDEField != null) {
			return iPSDEField;
		}
		throw new DataEntityRuntimeException(this, String.format("无法获取指定代码名称[%1$s]实体属性", fieldCodeName));
	}

	@Override
	protected boolean checkFieldValueRangeCondition(Object objValue, IEntityBase arg0, IPSDEFVRValueRangeCondition iPSDEFVRValueRangeCondition, IPSDEField iPSDEField) throws Throwable {

		if (ObjectUtils.isEmpty(objValue)) {
			return true;
		}

		String strRuleInfo = iPSDEFVRValueRangeCondition.getRuleInfo();
		boolean bTryMode = !iPSDEFVRValueRangeCondition.isKeyCond();

		IDataEntityRuntime dsDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(iPSDEFVRValueRangeCondition.getMajorPSDataEntityMust().getId());

		ISearchContextDTO iSearchContextDTO = dsDataEntityRuntime.createSearchContext();
		iSearchContextDTO.count(false);
		iSearchContextDTO.limit(1);
		iSearchContextDTO.eq(dsDataEntityRuntime.getKeyPSDEField().getName(), objValue);
		if (iPSDEFVRValueRangeCondition.getExtMajorPSDEField() != null) {
			iSearchContextDTO.eq(iPSDEFVRValueRangeCondition.getExtMajorPSDEField().getName(), ((IEntityDTO) arg0).get(iPSDEFVRValueRangeCondition.getExtPSDEFieldMust().getName()));
		}

		Page page = (Page) dsDataEntityRuntime.fetchDataSet(iPSDEFVRValueRangeCondition.getMajorPSDEDataSetMust().getName(), iPSDEFVRValueRangeCondition.getMajorPSDEDataSetMust(), new Object[] { iSearchContextDTO });
		if (page != null && !ObjectUtils.isEmpty(page.getTotalElements())) {
			return true;
		}

		if (bTryMode) {
			return false;
		}

		throw createDEFVRConditionException(iPSDEFVRValueRangeCondition, strRuleInfo, MSG_CHECKFIELDDATASETRULE_INFO, iPSDEField);

	}

	@Override
	protected boolean checkFieldQueryCountCondition(Object objValue, IEntityBase arg0, IPSDEFVRQueryCountCondition iPSDEFVRQueryCountCondition, IPSDEField iPSDEField) throws Throwable {

		ISearchContextDTO iSearchContextDTO = this.createSearchContext();
		IEntityDTO iEntityDTO = (IEntityDTO) arg0;
		iEntityDTO.copyTo(iSearchContextDTO, false);

		Page<IEntityDTO> page = this.searchDataQuery(iPSDEFVRQueryCountCondition.getPSDEDataQueryMust(), iSearchContextDTO);
		int total = (int) ((page != null) ? page.getTotalElements() : 0);

		Integer nMinValue = iPSDEFVRQueryCountCondition.getMinValue();
		Integer nMaxValue = iPSDEFVRQueryCountCondition.getMaxValue();
		boolean bIncMinValue = iPSDEFVRQueryCountCondition.isIncludeMinValue();
		boolean bIncMaxValue = iPSDEFVRQueryCountCondition.isIncludeMaxValue();
		boolean bTryMode = !iPSDEFVRQueryCountCondition.isKeyCond();
		String strRuleInfo = iPSDEFVRQueryCountCondition.getRuleInfo();

		if (nMinValue != null) {
			if (bIncMinValue) {
				if (total < nMinValue) {
					if (bTryMode)
						return false;

					throw createDEFVRConditionException(iPSDEFVRQueryCountCondition, strRuleInfo, null, iPSDEField);
				}
			} else {
				if (total <= nMinValue) {
					if (bTryMode)
						return false;

					throw createDEFVRConditionException(iPSDEFVRQueryCountCondition, strRuleInfo, null, iPSDEField);
				}
			}
		}

		if (nMaxValue != null) {
			if (bIncMaxValue) {
				if (total > nMaxValue) {
					if (bTryMode)
						return false;

					throw createDEFVRConditionException(iPSDEFVRQueryCountCondition, strRuleInfo, null, iPSDEField);
				}
			} else {
				if (total >= nMaxValue) {
					if (bTryMode)
						return false;

					throw createDEFVRConditionException(iPSDEFVRQueryCountCondition, strRuleInfo, null, iPSDEField);
				}
			}
		}

		return true;

	}

	@Override
	protected boolean checkFieldValueRecursionCondition(Object objValue, IEntityBase arg0, IPSDEFVRValueRecursionCondition iPSDEFVRValueRecursionCondition, IPSDEField iPSDEField) throws Throwable {

		String strRuleInfo = iPSDEFVRValueRecursionCondition.getRuleInfo();
		boolean bTryMode = !iPSDEFVRValueRecursionCondition.isKeyCond();
		if (ObjectUtils.isEmpty(objValue)) {
			return true;
		}

		IEntityDTO iEntityDTO = (IEntityDTO) arg0;
		Object objKey = iEntityDTO.get(this.getKeyPSDEField().getName());
		if (ObjectUtils.isEmpty(objKey)) {
			return true;
		}

		if (DataTypeUtils.compare(this.getKeyPSDEField().getStdDataType(), objValue, objKey) == 0) {
			if (bTryMode) {
				return false;
			}
			throw createDEFVRConditionException(iPSDEFVRValueRecursionCondition, strRuleInfo, MSG_CHECKFIELDRECURSIONRULE_INFO, iPSDEField);
		}

		while (true) {
			IEntityDTO parentEntity = this.get(objValue);
			objValue = parentEntity.get(iPSDEField.getName());
			if (ObjectUtils.isEmpty(objValue)) {
				return true;
			}

			if (DataTypeUtils.compare(this.getKeyPSDEField().getStdDataType(), objValue, objKey) == 0) {
				if (bTryMode) {
					return false;
				}
				throw createDEFVRConditionException(iPSDEFVRValueRecursionCondition, strRuleInfo, MSG_CHECKFIELDRECURSIONRULE_INFO, iPSDEField);
			}
		}
	}

	@Override
	public synchronized void registerDEActionLogicRuntime(String strAction, IDEActionLogicRuntime iDEActionLogicRuntime) {
		
		Assert.hasLength(strAction, "未传入附加的行为标识");
		Assert.notNull(iDEActionLogicRuntime,  "未传入附加的行为逻辑运行时对象");
		
		if (this.deActionLogicRuntimeListMap == null) {
			this.deActionLogicRuntimeListMap = new ConcurrentHashMap<String, List<IDEActionLogicRuntime>>();
		}

		List<IDEActionLogicRuntime> list = this.deActionLogicRuntimeListMap.get(strAction);
		if (list == null) {
			list = new ArrayList<IDEActionLogicRuntime>();
			this.deActionLogicRuntimeListMap.put(strAction, list);
		}
		list.add(iDEActionLogicRuntime);

	}

	@Override
	public synchronized boolean unregisterDEActionLogicRuntime(String strAction, IDEActionLogicRuntime iDEActionLogicRuntime) {
		Assert.hasLength(strAction, "未传入附加的行为标识");
		Assert.notNull(iDEActionLogicRuntime,  "未传入附加的行为逻辑运行时对象");
		
		if (this.deActionLogicRuntimeListMap != null) {
			List<IDEActionLogicRuntime> list = this.deActionLogicRuntimeListMap.get(strAction);
			if(list!=null) {
				return list.remove(iDEActionLogicRuntime);
			}
		}
		
		return false;
	}

	
	protected List<IDEActionLogicRuntime> getDEActionLogicRuntimes(String strAction) {
		if (this.deActionLogicRuntimeListMap != null) {
			return this.deActionLogicRuntimeListMap.get(strAction);
		}
		return null;
	}
	
	
	@Override
	protected void executeActionLogics(IEntityBase arg0, IPSDEAction iPSDEAction, String strAttachMode, net.ibizsys.runtime.dataentity.IDynaInstDataEntityRuntime iDynaInstDataEntityRuntime, IDynaInstRuntime iDynaInstRuntime, Object actionData) throws Throwable {
		super.executeActionLogics(arg0, iPSDEAction, strAttachMode, iDynaInstDataEntityRuntime, iDynaInstRuntime, actionData);
		
		//获取附加逻辑
		List<IDEActionLogicRuntime> list = this.getDEActionLogicRuntimes(iPSDEAction.getName());
		if(ObjectUtils.isEmpty(list)) {
			return;
		}
		
		for(IDEActionLogicRuntime iDEActionLogicRuntime : list) {
			if(!strAttachMode.equalsIgnoreCase(iDEActionLogicRuntime.getAttachMode())) {
				continue;
			}
			
			iDEActionLogicRuntime.execute(arg0);
		}
	}
	
	@Override
	protected boolean isEnableActionLogic(IPSDEAction iPSDEAction, String strAttachMode) {
		if(super.isEnableActionLogic(iPSDEAction, strAttachMode)) {
			return true;
		}
		
		List<IDEActionLogicRuntime> list = this.getDEActionLogicRuntimes(iPSDEAction.getName());
		if(ObjectUtils.isEmpty(list)) {
			return false;
		}
		
		return true;
	}
	
	/**
	 * 填充EntityDTO分页对象嵌套属性
	 * @param page
	 * @param iPSDEDataSet
	 * @throws Throwable
	 */
	protected void fillEntityDTOPageNestedFields(Page page, IPSDEDataSet iPSDEDataSet) throws Throwable {
		if(iPSDEDataSet.getGroupMode() != DEDataSetGroupMode.NONE.value) {
			return;
		}
		if(iPSDEDataSet.getViewLevel() == DEDataQueryViewLevel.DEFGROUP.value && iPSDEDataSet.getPSDEFGroup() != null){
			this.fillEntityDTONestedFields(page.getContent(), iPSDEDataSet.getPSDEFGroup());
			return;
		}
		
		if(iPSDEDataSet.getViewLevel() == DEDataQueryViewLevel.ALL.value) {
			this.fillEntityDTONestedFields(page.getContent(), null);
			return;
		}
	}
	
	@Override
	public void fillEntityDTONestedFields(List<? extends IEntityDTO> list, IPSDEFGroup iPSDEFGroup) throws Throwable {
		
		if(ObjectUtils.isEmpty(list)) {
			return;
		}
		
		IEntityDTO firstEntityDTO = list.get(0);
		if (firstEntityDTO.getDEMethodDTORuntime() != null) {
			List<IPSDEMethodDTOField> psDEMethodDTOFieldList = firstEntityDTO.getDEMethodDTORuntime().getPSDEMethodDTO().getPSDEMethodDTOFields();
			if (psDEMethodDTOFieldList != null) {
				
				Map<String, IPSDEField> psDEFieldMap = null;
				if(iPSDEFGroup != null && !ObjectUtils.isEmpty(iPSDEFGroup.getPSDEFGroupDetails())) {
					psDEFieldMap = new HashMap<String, IPSDEField>();
					for(IPSDEFGroupDetail iPSDEFGroupDetail : iPSDEFGroup.getPSDEFGroupDetails()) {
						if(iPSDEFGroupDetail.getPSDEField() == null) {
							continue;
						}
						psDEFieldMap.put(iPSDEFGroupDetail.getPSDEField().getName(), iPSDEFGroupDetail.getPSDEField());
					}
				}
				
				for (IPSDEMethodDTOField iPSDEMethodDTOField : psDEMethodDTOFieldList) {
					
					if(psDEFieldMap != null) {
						if(iPSDEMethodDTOField.getPSDEField() == null) {
							continue;
						}
						if(!psDEFieldMap.containsKey(iPSDEMethodDTOField.getPSDEField().getName())) {
							continue;
						}
					}
					
					if (DEMethodDTOFieldTypes.DTO.equals(iPSDEMethodDTOField.getType()) || DEMethodDTOFieldTypes.DTOS.equals(iPSDEMethodDTOField.getType())) {

						// 找到外键
						IPSDEField pickupPSDEField = null;
						IPSDERBase iPSDERBase = iPSDEMethodDTOField.getPSDERMust();
						IPSDEDataSet nestedPSDEDataSet = null;
						if (iPSDERBase instanceof IPSDER1N) {
							pickupPSDEField = ((IPSDER1N) iPSDERBase).getPSPickupDEFieldMust();
							nestedPSDEDataSet = ((IPSDER1N) iPSDERBase).getNestedPSDEDataSet();
						} else if (iPSDERBase instanceof IPSDERCustom) {
							pickupPSDEField = ((IPSDERCustom) iPSDERBase).getPickupPSDEField();
							nestedPSDEDataSet = ((IPSDERCustom) iPSDERBase).getNestedPSDEDataSet();
						}
						if (pickupPSDEField == null) {
							throw new DataEntityRuntimeException(this, firstEntityDTO.getDEMethodDTORuntime(), String.format("属性[%1$s]没有定义DTO连接属性", iPSDEMethodDTOField.getName()));
						}

						// 查出原有数据
						IDataEntityRuntime refDataEntityRuntime = this.getSystemRuntimeContext().getSystemRuntime().getDataEntityRuntime(iPSDEMethodDTOField.getRefPSDataEntityMust().getId());
						if (refDataEntityRuntime.getStorageMode() == DEStorageModes.NONE) {
							continue;
						}
						
						Map<Object, IEntityDTO> entityDTOMap = new LinkedHashMap<Object, IEntityDTO>();
						for(IEntityDTO iEntityDTO : list) {
							Object objKeyValue = iEntityDTO.get(getKeyPSDEField().getLowerCaseName());
							if(ObjectUtils.isEmpty(objKeyValue)) {
								throw new DataEntityRuntimeException(this, String.format("填充数据对象嵌套数据发生异常，传入数据未指定主键"));
							}
							entityDTOMap.put(objKeyValue, iEntityDTO);
						}
						
						ISearchContextDTO iSearchContextDTO = refDataEntityRuntime.createSearchContext();
						iSearchContextDTO.all().count(false);
						if(entityDTOMap.size()==1) {
							refDataEntityRuntime.setSearchCondition(iSearchContextDTO, pickupPSDEField, Conditions.EQ, entityDTOMap.keySet().iterator().next());
						}
						else {
							refDataEntityRuntime.setSearchCondition(iSearchContextDTO, pickupPSDEField, Conditions.IN, entityDTOMap.keySet());
						}
						
						List<IEntityDTO> allList = null;
						if (nestedPSDEDataSet != null) {
							allList = refDataEntityRuntime.selectDataSet(nestedPSDEDataSet, iSearchContextDTO);
						} else {
							allList = refDataEntityRuntime.select(iSearchContextDTO);
						}
						
						if(!ObjectUtils.isEmpty(allList)) {
							Map<Object, List<IEntityDTO>> lastListMap = new HashMap<Object, List<IEntityDTO>>();
							for(IEntityDTO item : allList) {
								Object objKey = item.get(pickupPSDEField.getLowerCaseName());
								List<IEntityDTO> lastList = lastListMap.get(objKey);
								if(lastList == null) {
									lastList = new ArrayList<IEntityDTO>();
									lastListMap.put(objKey, lastList);
								}
								lastList.add(item);
							}
							
							for(java.util.Map.Entry<Object, List<IEntityDTO>> entry : lastListMap.entrySet()){
								IEntityDTO iEntityDTO = entityDTOMap.get(entry.getKey());
								if(iEntityDTO != null) {
									iEntityDTO.set(iPSDEMethodDTOField.getLowerCaseName(), entry.getValue());
								}
							}
						}
					}
				}
			}
		}
	}
}
