package net.ibizsys.central.ba;

import net.ibizsys.runtime.IModelRuntime;
import net.ibizsys.runtime.ISystemRuntimeBase;
import net.ibizsys.runtime.ISystemRuntimeException;
import net.ibizsys.runtime.util.Errors;

/**
 * 系统大数据体系运行时异常
 * @author lionlau
 *
 */
public class SysBDSchemeRuntimeException extends RuntimeException implements ISystemRuntimeException {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private ISysBDSchemeRuntime iSysBDSchemeRuntimeBase = null;
	private int nErrorCode = Errors.INTERNALERROR;
	
	public SysBDSchemeRuntimeException(ISysBDSchemeRuntime iSysBDSchemeRuntimeBase, String strInfo) {
		super(strInfo);
		this.iSysBDSchemeRuntimeBase = iSysBDSchemeRuntimeBase;
	}
	
	public SysBDSchemeRuntimeException(ISysBDSchemeRuntime iSysBDSchemeRuntimeBase, String strInfo, int nErrorCode) {
		super(strInfo);
		this.nErrorCode = nErrorCode;
		this.iSysBDSchemeRuntimeBase = iSysBDSchemeRuntimeBase;
	}
	
	public SysBDSchemeRuntimeException(ISysBDSchemeRuntime iSysBDSchemeRuntimeBase, String strInfo,Throwable throwable) {
		super(strInfo, throwable);
		this.iSysBDSchemeRuntimeBase = iSysBDSchemeRuntimeBase;
	}
	
	public SysBDSchemeRuntimeException(ISysBDSchemeRuntime iSysBDSchemeRuntimeBase, String strInfo, int nErrorCode, Throwable throwable) {
		super(strInfo, throwable);
		this.nErrorCode = nErrorCode;
		this.iSysBDSchemeRuntimeBase = iSysBDSchemeRuntimeBase;
	}
	
	
	/**
	 * 获取系统大数据体系对象
	 * @return
	 */
	public ISysBDSchemeRuntime getSysBDSchemeRuntime() {
		return this.iSysBDSchemeRuntimeBase;
	}
	
	
	
	/**
	 * 获取错误代码
	 * 
	 * @return the nErrorCode
	 */
	public int getErrorCode() {
		return nErrorCode;
	}

	@Override
	public ISystemRuntimeBase getSystemRuntime() {
		if(getSysBDSchemeRuntime()!=null) {
			return this.getSysBDSchemeRuntime().getSystemRuntime();
		}
		return null;
	}

	@Override
	public IModelRuntime getModelRuntime() {
		return this.getSysBDSchemeRuntime();
	}
	
}
