package net.ibizsys.ruleengine.delogic.core;


/**
 * 实体处理逻辑直接Sql调用节点
 * @author lionlau
 *
 */
public interface IDELogicRawSqlNode extends IDELogicNode{

	/**
	 * 获取DBSchema
	 * @return
	 */
	String getDBSchema();
	
	/**
	 * 获取Sql代码
	 * @return
	 */
	String getSql();
	
	/**
	 * 获取目标参数
	 * @return
	 */
	String getDstParam();
	
	
	/**
	 * 是否将执行结果填充至目标参数
	 * @return
	 */
	boolean isFillDstParam();
	
	
	/**
	 * 是否填充之前忽略重置目标参数
	 * @return
	 */
	boolean isIgnoreResetDstParam();
	
	
}
