package net.ibizsys.ruleengine.delogic.core;

public interface IDELogicNodeRouteSingleCond extends IDELogicNodeRouteCond{

	/**
	 * 等于操作
	 */
	public final static String COND_EQ = "EQ";

	/**
	 * 绝对等于（保留）
	 */
	public final static String COND_ABSEQ = "ABSEQ";

	/**
	 * 大于操作
	 */
	public final static String COND_GT = "GT";

	/**
	 * 大于等于操作
	 */
	public final static String COND_GTANDEQ = "GTANDEQ";

	/**
	 * 小于操作
	 */
	public final static String COND_LT = "LT";

	/**
	 * 小于等于操作
	 */
	public final static String COND_LTANDEQ = "LTANDEQ";

	/**
	 * 不等于操作
	 */
	public final static String COND_NOTEQ = "NOTEQ";

	/**
	 * 为空判断操作
	 */
	public final static String COND_ISNULL = "ISNULL";

	/**
	 * 不为空判断操作
	 */
	public final static String COND_ISNOTNULL = "ISNOTNULL";

	/**
	 * 文本包含
	 */
	public final static String COND_USERLIKE = "USERLIKE";

	/**
	 * 文本包含
	 */
	public final static String COND_LIKE = "LIKE";

	/**
	 * 文本左包含
	 */
	public final static String COND_LEFTLIKE = "LEFTLIKE";

	/**
	 * 文本右包含
	 */
	public final static String COND_RIGHTLIKE = "RIGHTLIKE";

	/**
	 * 空判断
	 */
	public final static String COND_TESTNULL = "TESTNULL";

	/**
	 * 值包含在给定的范围中
	 */
	public final static String COND_IN = "IN";
	
	
	/**
	 * 值不包含在给定的范围中
	 */
	public final static String COND_NOTIN = "NOTIN";
	
	
	/**
	 * 获取目标参数
	 */
	String getDstParam();
	
	/**
	 * 获取目标参数属性
	 * @param dstField
	 */
	String getDstField();
	
	
	
	String getCond();
	
	
	
	/**
	 * 获取源值类型
	 */
	String getSrcValueType();
	
	/**
	 * 获取源参数
	 */
	String getSrcParam();
	
	/**
	 * 获取源参数属性
	 */
	String getSrcField();
	
	
	/**
	 * 获取源值类型
	 */
	String getSrcValue();
}
