package net.ibizsys.ruleengine.delogic.core;


/**
 * 实体处理逻辑附加参数节点
 * @author lionlau
 *
 */
public interface IDELogicAppendParamNode extends IDELogicNode{

	/**
	 * 获取目标参数
	 * @return
	 */
	String getDstParam();
	
	
	/**
	 * 获取源参数
	 * @return
	 */
	String getSrcParam() ;
	
	
	/**
	 * 获取源属性名称
	 * 
	 * @return
	 */
	String getSrcField() ;
	
	
	/**
	 * 获取源列表起始位置
	 * @return
	 */
	int getSrcIndex();
	
	
	
	/**
	 * 获取源列表长度
	 * @return
	 */
	int getSrcSize();
	
	
	/**
	 * 获取目标列表起始位置
	 * @return
	 */
	int getDstIndex();
	
}
