/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.IPSSystemService;
import net.ibizsys.model.app.IPSApplication;
import net.ibizsys.model.app.view.IPSAppView;
import net.ibizsys.model.control.IPSControl;
import net.ibizsys.model.control.IPSControlContainer;
import net.ibizsys.model.control.IPSNavigateContext;
import net.ibizsys.model.control.IPSNavigateParam;
import net.ibizsys.model.control.IPSNavigateParamContainer;
import net.ibizsys.model.control.form.IPSDEForm;
import net.ibizsys.model.control.form.IPSDEFormDRUIPart;
import net.ibizsys.model.control.form.IPSDEFormDetail;
import net.ibizsys.model.control.form.IPSDEFormGroupBase;
import net.ibizsys.model.control.form.IPSDEFormMDCtrl;
import net.ibizsys.model.control.form.IPSDEFormPage;
import net.ibizsys.model.control.form.IPSDEFormTabPage;
import net.ibizsys.model.control.form.IPSDEFormTabPanel;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.util.transpiler.IPSModelTranspileContext;
import net.ibizsys.psmodel.core.util.DataTypeUtils;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.core.util.IPSModelService;
import net.ibizsys.psmodel.core.util.PSModelServiceBase;
import net.ibizsys.psmodel.core.util.PSModelServiceSession;
import net.ibizsys.psmodel.runtime.util.IPSModelRTService;
import net.ibizsys.psmodel.runtime.util.IPSModelRTServiceSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Sort;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class PSModelRTServiceBase<M extends IPSModel, F extends IPSModelFilter>
extends PSModelServiceBase<M, F>
implements IPSModelRTService<M> {
    private static final Log log = LogFactory.getLog(PSModelRTServiceBase.class);
    public static final String VIEWPARAM_NAVCONTEXT = "SRFNAVCTX.";
    public static final String VIEWPARAM_NAVPARAM = "SRFNAVPARAM.";
    public static final String DATASET_DEFAULT = "DEFAULT";
    public static final Random random = new Random();

    protected Random getRandom() {
        return random;
    }

    @Override
    public Object invoke(String pmodelName, String pkey, String methodName, String key, Object param) throws Exception {
        return this.doInvoke(pmodelName, pkey, methodName, key, param);
    }

    protected Object doInvoke(String pmodelName, String pkey, String methodName, String key, Object param) throws Exception {
        if (methodName.toUpperCase().indexOf("FETCH") == 0 && StringUtils.hasLength((String)pmodelName)) {
            IPSModelService parentPSModelService = this.getPSModelRTServiceSession().getPSModelService(pmodelName);
            LinkedHashMap<String, String> map = null;
            if (param != null) {
                map = param;
            } else {
                param = map = new LinkedHashMap<String, String>();
            }
            map.put("srfparentdename", parentPSModelService.getModelName(true));
            map.put("srfparentkey", pkey);
        }
        return this.invoke(methodName, key, param);
    }

    protected String getOriginModelName() {
        return null;
    }

    protected M doGet(String key, boolean tryMode) throws Exception {
        IPSModelObject iPSModelObject = this.getPSModelObject(key, tryMode);
        if (iPSModelObject != null) {
            IPSModel domain = this.createDomain();
            domain = this.getPSModelRTServiceSession().getPSModelListTranspiler(this.getPSModelObjectCls(), false).decompile((IPSModelTranspileContext)this.getPSModelRTServiceSession(), iPSModelObject, domain, true);
            this.fillDomain(domain, iPSModelObject, true);
            return (M)domain;
        }
        return null;
    }

    protected Page<M> doFetch(String strDataSetName, F f) throws Exception {
        List<M> domainList = this.getDomainList(strDataSetName, f);
        return this.createPage(domainList, f);
    }

    protected IPSSystemService getPSSystemService() throws Exception {
        return ((IPSModelRTServiceSession)PSModelServiceSession.getCurrent()).getPSSystemService();
    }

    protected IPSModelRTServiceSession getPSModelRTServiceSession() throws Exception {
        return (IPSModelRTServiceSession)PSModelServiceSession.getCurrent();
    }

    protected List<M> getDomainList(String strDataSetName, F f) throws Exception {
        List domainList = new ArrayList();
        List<IPSModelObject> psModelObjectList = this.getPSModelObjectList(f);
        if (psModelObjectList == null) {
            return domainList;
        }
        domainList = this.fillDomainList(domainList, psModelObjectList, strDataSetName, f);
        return this.filterDomainList(domainList, strDataSetName, f);
    }

    protected List<M> doGetDomainList(String strDataSetName, F f) throws Exception {
        ArrayList domainList = new ArrayList();
        List<IPSModelObject> psModelObjectList = this.getPSModelObjectList(f);
        if (psModelObjectList == null) {
            return domainList;
        }
        return this.fillDomainList(domainList, psModelObjectList, strDataSetName, f);
    }

    protected List<M> fillDomainList(List<M> domainList, List<? extends IPSModelObject> psModelObjectList, String strDataSetName, F f) throws Exception {
        this.getPSModelRTServiceSession().getPSModelListTranspiler(this.getPSModelObjectCls(), false).decompile((IPSModelTranspileContext)this.getPSModelRTServiceSession(), psModelObjectList, domainList, false);
        for (int i = 0; i < domainList.size(); ++i) {
            this.fillDomain((IPSModel)domainList.get(i), psModelObjectList.get(i), false);
        }
        return domainList;
    }

    protected List<M> filterDomainList(List<M> domainList, String strDataSetName, F f) throws Exception {
        if (ObjectUtils.isEmpty(domainList)) {
            return domainList;
        }
        HashMap<String, Object> conds = f.any();
        Map<String, Object> dataSetConds = this.getDataSetConds(strDataSetName, f);
        if (!ObjectUtils.isEmpty(dataSetConds)) {
            if (conds == null) {
                conds = new HashMap<String, Object>();
            }
            conds.putAll(dataSetConds);
        }
        if (ObjectUtils.isEmpty((Object)conds)) {
            return domainList;
        }
        Object query = f.get("query");
        String strQuery = null;
        if (!ObjectUtils.isEmpty((Object)query)) {
            strQuery = query.toString().toUpperCase();
        }
        LinkedHashMap<String, Map<String, Object>> condMap = new LinkedHashMap<String, Map<String, Object>>();
        for (Map.Entry entry : conds.entrySet()) {
            int nPos;
            Object value;
            String strCondition = (String)entry.getKey();
            if (!StringUtils.hasLength((String)strCondition) || ObjectUtils.isEmpty(value = entry.getValue()) || (strCondition = strCondition.toLowerCase()).indexOf("n_") != 0 || (nPos = (strCondition = strCondition.substring(2)).lastIndexOf("_")) == -1) continue;
            String strField = strCondition.substring(0, nPos);
            String strOp = strCondition.substring(nPos + 1);
            if (ObjectUtils.isEmpty((Object)strField) || ObjectUtils.isEmpty((Object)strOp) || strField.equals("dynainstmode")) continue;
            LinkedHashMap map = (LinkedHashMap)condMap.get(strField);
            if (map == null) {
                map = new LinkedHashMap();
                condMap.put(strField, map);
            }
            map.put(strOp.toUpperCase(), value);
        }
        if (ObjectUtils.isEmpty(condMap) && ObjectUtils.isEmpty((Object)strQuery)) {
            return domainList;
        }
        ArrayList<IPSModel> domainList2 = new ArrayList<IPSModel>();
        for (IPSModel item : domainList) {
            if (strQuery != null && (!StringUtils.hasLength((String)item.getName()) || item.getName().toUpperCase().indexOf(strQuery) == -1) || !this.testDomain(item, condMap)) continue;
            domainList2.add(item);
        }
        return domainList2;
    }

    protected Map<String, Object> getDataSetConds(String strDataSetName, F f) {
        return null;
    }

    protected boolean testDomain(M domain, Map<String, Map<String, Object>> condMap) throws Exception {
        for (Map.Entry<String, Map<String, Object>> entry : condMap.entrySet()) {
            String strField = entry.getKey();
            Object value = domain.get(strField);
            if (!(strField.indexOf("psdeid") != -1 ? !this.testDomainField2(value, entry.getValue()) : !this.testDomainField(value, entry.getValue()))) continue;
            return false;
        }
        return true;
    }

    protected boolean testDomainField(Object value, Map<String, Object> condMap) throws Exception {
        for (Map.Entry<String, Object> entry : condMap.entrySet()) {
            if (ObjectUtils.isEmpty((Object)value) && !"NOTEQ".equals(entry.getKey())) {
                return false;
            }
            if (this.testDomainField(value, entry.getKey(), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    protected boolean testDomainField2(Object value, Map<String, Object> condMap) throws Exception {
        if (value.toString().indexOf("@") != -1) {
            String value2 = value.toString().split("[@]")[1];
            for (Map.Entry<String, Object> entry : condMap.entrySet()) {
                Object value3 = entry.getValue();
                if (!(value3.toString().indexOf("@") != -1 ? !this.testDomainField(value, entry.getKey(), value3) : !this.testDomainField(value2, entry.getKey(), value3))) continue;
                return false;
            }
            return true;
        }
        for (Map.Entry<String, Object> entry : condMap.entrySet()) {
            Object value3 = entry.getValue();
            if (value3.toString().indexOf("@") != -1) {
                String value2 = value3.toString().split("[@]")[1];
                if (this.testDomainField(value, entry.getKey(), value2)) continue;
                return false;
            }
            if (this.testDomainField(value, entry.getKey(), value3)) continue;
            return false;
        }
        return true;
    }

    protected boolean testDomainField(Object value, String strCondition, Object condValue) throws Exception {
        if ("EQ".equals(strCondition) || "ABSEQ".equals(strCondition)) {
            if (value instanceof String) {
                return ((String)value).equalsIgnoreCase(condValue.toString());
            }
            int nDataType = DataTypeUtils.getObjectDataType((Object)value);
            return DataTypeUtils.compare((int)nDataType, (Object)value, (Object)condValue) == 0L;
        }
        if ("GT".equals(strCondition)) {
            int nDataType = DataTypeUtils.getObjectDataType((Object)value);
            return DataTypeUtils.compare((int)nDataType, (Object)value, (Object)condValue) > 0L;
        }
        if ("GTANDEQ".equals(strCondition)) {
            int nDataType = DataTypeUtils.getObjectDataType((Object)value);
            return DataTypeUtils.compare((int)nDataType, (Object)value, (Object)condValue) >= 0L;
        }
        if ("LT".equals(strCondition)) {
            int nDataType = DataTypeUtils.getObjectDataType((Object)value);
            return DataTypeUtils.compare((int)nDataType, (Object)value, (Object)condValue) < 0L;
        }
        if ("LTANDEQ".equals(strCondition)) {
            int nDataType = DataTypeUtils.getObjectDataType((Object)value);
            return DataTypeUtils.compare((int)nDataType, (Object)value, (Object)condValue) <= 0L;
        }
        if ("NOTEQ".equals(strCondition)) {
            if (value instanceof String) {
                return !((String)value).equalsIgnoreCase(condValue.toString());
            }
            int nDataType = DataTypeUtils.getObjectDataType((Object)value);
            return DataTypeUtils.compare((int)nDataType, (Object)value, (Object)condValue) != 0L;
        }
        if ("LIKE".equals(strCondition)) {
            return value.toString().toUpperCase().indexOf(condValue.toString().toUpperCase()) != -1;
        }
        log.warn((Object)String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u6761\u4ef6\u64cd\u4f5c[%1$s]", strCondition));
        return false;
    }

    protected Page<M> createPage(List<M> domainList, F f) throws Exception {
        Sort sort = f.getPageSort();
        if (sort != null && !sort.isUnsorted()) {
            Sort.Order order = null;
            Iterator orders = sort.iterator();
            if (orders.hasNext()) {
                order = (Sort.Order)orders.next();
            }
            if (order != null) {
                final Sort.Order order2 = order;
                Collections.sort(domainList, new Comparator<M>(){

                    @Override
                    public int compare(M o1, M o2) {
                        Object objValue = o1.get(order2.getProperty().toLowerCase());
                        Object objValueCompare = o2.get(order2.getProperty().toLowerCase());
                        if (order2.isDescending()) {
                            Object temp = objValueCompare;
                            objValueCompare = objValue;
                            objValue = temp;
                        }
                        if (objValue == null || objValueCompare == null) {
                            if (objValue == null && objValueCompare == null) {
                                return 0;
                            }
                            if (objValue == null) {
                                return 1;
                            }
                            return -1;
                        }
                        int nDataType = DataTypeUtils.getObjectDataType((Object)objValue);
                        return (int)DataTypeUtils.compare((int)nDataType, (Object)objValue, (Object)objValueCompare);
                    }
                });
            }
        }
        if (f.getPageable() != null && !f.getPageable().isUnpaged()) {
            if (f.getPageable().getPageNumber() == 0 && f.getPageable().getPageSize() >= domainList.size()) {
                return new PageImpl(domainList, f.getPageable(), (long)domainList.size());
            }
            ArrayList<M> domainList2 = new ArrayList<M>();
            int nStartPos = f.getPageable().getPageSize() * f.getPageable().getPageNumber();
            int nEndPos = f.getPageable().getPageSize() * (f.getPageable().getPageNumber() + 1);
            if (nStartPos >= domainList.size()) {
                return new PageImpl(domainList2, f.getPageable(), (long)domainList.size());
            }
            if (nEndPos > domainList.size()) {
                nEndPos = domainList.size();
            }
            for (int i = nStartPos; i < nEndPos; ++i) {
                domainList2.add(domainList.get(i));
            }
            return new PageImpl(domainList2, f.getPageable(), (long)domainList.size());
        }
        return new PageImpl(domainList);
    }

    @Override
    public void fillDomain(M domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        this.doFillDomain(domain, iPSModelObject, bFullMode);
    }

    protected void doFillDomain(M domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        domain.set("dynamodelflag", (Object)0);
    }

    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        throw new Exception("\u6ca1\u6709\u5b9e\u73b0");
    }

    protected List<? extends IPSModelObject> getPSModelObjectList(F f) throws Exception {
        throw new Exception("\u6ca1\u6709\u5b9e\u73b0");
    }

    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        throw new Exception("\u6ca1\u6709\u5b9e\u73b0");
    }

    @Override
    public <T> T getPSModelObject(String key, Class<T> cls, boolean tryMode) throws Exception {
        IPSModelObject iPSModelObject = this.getPSModelObject(key, tryMode);
        if (iPSModelObject != null) {
            return (T)iPSModelObject;
        }
        return null;
    }

    protected <T extends IPSModelObject> T getPSModelObject(Class<T> cls, List<T> list, String strTag, boolean bTryMode) throws Exception {
        if (cls.equals(IPSDataEntity.class) && strTag.indexOf("@") != -1) {
            strTag = strTag.split("[@]")[1];
        }
        if (list != null) {
            for (IPSModelObject item : list) {
                String strFullTag = this.getPSModelRTServiceSession().getPSModelUniqueTag(item);
                if (!StringUtils.hasLength((String)strFullTag) || !strFullTag.equalsIgnoreCase(strTag)) continue;
                return (T)item;
            }
        }
        if (bTryMode) {
            return null;
        }
        throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u6a21\u578b\u5bf9\u8c61[%1$s]", strTag));
    }

    public static String getParentId(String strId) {
        String[] items = strId.split("[.]");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < items.length - 1; ++i) {
            if (i != 0) {
                sb.append(".");
            }
            sb.append(items[i]);
        }
        return sb.toString();
    }

    public static String getParentId(IPSModelFilter iPSModelFilter, String strParentName) {
        Object strPKey;
        if (StringUtils.hasLength((String)strParentName)) {
            Object strPName = iPSModelFilter.get("srfparentdename");
            if (ObjectUtils.isEmpty((Object)strPName)) {
                return null;
            }
            if (!strParentName.equalsIgnoreCase(strPName.toString())) {
                return null;
            }
        }
        if ((strPKey = iPSModelFilter.get("srfparentkey")) != null) {
            return strPKey.toString();
        }
        return null;
    }

    protected <T extends IPSControl> void fillPSControlList(Class<T> cls, List<T> list) throws Exception {
        block5: {
            block4: {
                IPSApplication currentPSApplication = this.getPSModelRTServiceSession().getPSApplication();
                if (currentPSApplication == null) break block4;
                List psAppViews = currentPSApplication.getAllPSAppViews();
                if (ObjectUtils.isEmpty((Object)psAppViews)) break block5;
                for (IPSAppView iPSAppView : psAppViews) {
                    PSModelRTServiceBase.fillPSControlList(cls, iPSAppView, list);
                }
                break block5;
            }
            List psApplications = this.getPSSystemService().getPSSystem().getAllPSApps();
            if (!ObjectUtils.isEmpty((Object)psApplications)) {
                for (IPSApplication iPSApplication : psApplications) {
                    List psAppViews = iPSApplication.getAllPSAppViews();
                    if (ObjectUtils.isEmpty((Object)psAppViews)) continue;
                    for (IPSAppView iPSAppView : psAppViews) {
                        PSModelRTServiceBase.fillPSControlList(cls, iPSAppView, list);
                    }
                }
            }
        }
    }

    public static void fillPSDEFormDRUIParts(IPSDEForm iPSDEForm, List<IPSDEFormDRUIPart> psDEFormDRUIPartList) throws Exception {
        if (!ObjectUtils.isEmpty((Object)iPSDEForm.getPSDEFormPages())) {
            for (IPSDEFormPage iPSDEFormPage : iPSDEForm.getPSDEFormPages()) {
                PSModelRTServiceBase.fillPSDEFormDRUIParts((IPSDEFormDetail)iPSDEFormPage, psDEFormDRUIPartList);
            }
        }
    }

    public static void fillPSDEFormDRUIParts(IPSDEFormDetail iPSDEFormDetail, List<IPSDEFormDRUIPart> psDEFormDRUIPartList) throws Exception {
        if (iPSDEFormDetail instanceof IPSDEFormDRUIPart) {
            psDEFormDRUIPartList.add((IPSDEFormDRUIPart)iPSDEFormDetail);
            return;
        }
        if (iPSDEFormDetail instanceof IPSDEFormTabPanel) {
            IPSDEFormTabPanel iPSDEFormTabPanel = (IPSDEFormTabPanel)iPSDEFormDetail;
            if (iPSDEFormTabPanel.getPSDEFormTabPages() != null) {
                for (IPSDEFormTabPage item : iPSDEFormTabPanel.getPSDEFormTabPages()) {
                    PSModelRTServiceBase.fillPSDEFormDRUIParts((IPSDEFormDetail)item, psDEFormDRUIPartList);
                }
            }
            return;
        }
        if (iPSDEFormDetail instanceof IPSDEFormGroupBase) {
            IPSDEFormGroupBase iPSDEFormGroupBase = (IPSDEFormGroupBase)iPSDEFormDetail;
            if (iPSDEFormGroupBase.getPSDEFormDetails() != null) {
                for (IPSDEFormDetail item : iPSDEFormGroupBase.getPSDEFormDetails()) {
                    PSModelRTServiceBase.fillPSDEFormDRUIParts(item, psDEFormDRUIPartList);
                }
            }
            return;
        }
    }

    public static <T extends IPSControl> void fillPSControlList(Class<T> cls, IPSAppView iPSAppView, List<T> list) {
        if (iPSAppView.getPSViewLayoutPanel() != null) {
            PSModelRTServiceBase.fillPSControlList(cls, (IPSControl)iPSAppView.getPSViewLayoutPanel(), list);
        }
        PSModelRTServiceBase.fillPSControlList(cls, (IPSControlContainer)iPSAppView, list);
    }

    public static <T extends IPSControl> void fillPSControlList(Class<T> cls, IPSControlContainer iPSControlContainer, List<T> list) {
        List psControls = iPSControlContainer.getPSControls();
        if (psControls == null) {
            return;
        }
        for (IPSControl item : psControls) {
            PSModelRTServiceBase.fillPSControlList(cls, item, list);
        }
    }

    public static <T extends IPSControl> void fillPSControlList(Class<T> cls, IPSControl iPSControl, List<T> list) {
        if (cls.isAssignableFrom(iPSControl.getClass())) {
            list.add(iPSControl);
        }
        if (iPSControl instanceof IPSDEForm) {
            PSModelRTServiceBase.fillPSControlList(cls, (IPSDEForm)iPSControl, list);
        }
        if (iPSControl instanceof IPSControlContainer) {
            PSModelRTServiceBase.fillPSControlList(cls, (IPSControlContainer)iPSControl, list);
        }
    }

    public static <T extends IPSControl> void fillPSControlList(Class<T> cls, IPSDEForm iPSDEForm, List<T> list) {
        if (!ObjectUtils.isEmpty((Object)iPSDEForm.getPSDEFormPages())) {
            for (IPSDEFormPage iPSDEFormPage : iPSDEForm.getPSDEFormPages()) {
                PSModelRTServiceBase.fillPSControlList(cls, (IPSDEFormDetail)iPSDEFormPage, list);
            }
        }
    }

    public static <T extends IPSControl> void fillPSControlList(Class<T> cls, IPSDEFormDetail iPSDEFormDetail, List<T> list) {
        if (iPSDEFormDetail instanceof IPSDEFormMDCtrl) {
            IPSDEFormMDCtrl iPSDEFormMDCtrl = (IPSDEFormMDCtrl)iPSDEFormDetail;
            if (iPSDEFormMDCtrl.getContentPSControl() != null) {
                PSModelRTServiceBase.fillPSControlList(cls, iPSDEFormMDCtrl.getContentPSControl(), list);
            }
            return;
        }
        if (iPSDEFormDetail instanceof IPSDEFormTabPanel) {
            IPSDEFormTabPanel iPSDEFormTabPanel = (IPSDEFormTabPanel)iPSDEFormDetail;
            if (iPSDEFormTabPanel.getPSDEFormTabPages() != null) {
                for (IPSDEFormTabPage item : iPSDEFormTabPanel.getPSDEFormTabPages()) {
                    PSModelRTServiceBase.fillPSControlList(cls, (IPSDEFormDetail)item, list);
                }
            }
            return;
        }
        if (iPSDEFormDetail instanceof IPSDEFormGroupBase) {
            IPSDEFormGroupBase iPSDEFormGroupBase = (IPSDEFormGroupBase)iPSDEFormDetail;
            if (iPSDEFormGroupBase.getPSDEFormDetails() != null) {
                for (IPSDEFormDetail item : iPSDEFormGroupBase.getPSDEFormDetails()) {
                    PSModelRTServiceBase.fillPSControlList(cls, item, list);
                }
            }
            return;
        }
    }

    public static String getPSNavigateParams(IPSNavigateParamContainer iPSNavigateParamContainer) throws Exception {
        StringBuilder sb = new StringBuilder();
        boolean bFirst = true;
        if (!ObjectUtils.isEmpty((Object)iPSNavigateParamContainer.getPSNavigateParams())) {
            for (IPSNavigateParam iPSNavigateParam : iPSNavigateParamContainer.getPSNavigateParams()) {
                if (bFirst) {
                    bFirst = false;
                } else {
                    sb.append("\r\n");
                }
                if (iPSNavigateParam.isRawValue()) {
                    sb.append(String.format("%1$s%2$s=%3$s", VIEWPARAM_NAVPARAM, iPSNavigateParam.getKey(), iPSNavigateParam.getValue()));
                    continue;
                }
                sb.append(String.format("%1$s%2$s=%%%3$s%%", VIEWPARAM_NAVPARAM, iPSNavigateParam.getKey(), iPSNavigateParam.getValue()));
            }
        }
        if (!ObjectUtils.isEmpty((Object)iPSNavigateParamContainer.getPSNavigateContexts())) {
            for (IPSNavigateContext iPSNavigateContext : iPSNavigateParamContainer.getPSNavigateContexts()) {
                if (bFirst) {
                    bFirst = false;
                } else {
                    sb.append("\r\n");
                }
                if (iPSNavigateContext.isRawValue()) {
                    sb.append(String.format("%1$s%2$s=%3$s", VIEWPARAM_NAVCONTEXT, iPSNavigateContext.getKey(), iPSNavigateContext.getValue()));
                    continue;
                }
                sb.append(String.format("%1$s%2$s=%%%3$s%%", VIEWPARAM_NAVCONTEXT, iPSNavigateContext.getKey(), iPSNavigateContext.getValue()));
            }
        }
        if (bFirst) {
            return null;
        }
        return sb.toString();
    }
}

