/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.ArrayList;
import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.wf.IPSWFDE;
import net.ibizsys.model.wf.IPSWorkflow;
import net.ibizsys.psmodel.core.domain.PSWFDE;
import net.ibizsys.psmodel.core.domain.PSWorkflow;
import net.ibizsys.psmodel.core.filter.PSWFDEFilter;
import net.ibizsys.psmodel.core.service.IPSWFDEService;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class PSWFDERTService
extends PSModelRTServiceBase<PSWFDE, PSWFDEFilter>
implements IPSWFDEService {
    private static final Log log = LogFactory.getLog(PSWFDERTService.class);

    public PSWFDE createDomain() {
        return new PSWFDE();
    }

    public PSWFDEFilter createFilter() {
        return new PSWFDEFilter();
    }

    public PSWFDE getDomain(Object params) {
        if (params instanceof PSWFDE) {
            return (PSWFDE)params;
        }
        return (PSWFDE)PSWFDERTService.getMapper().convertValue(params, PSWFDE.class);
    }

    public PSWFDEFilter getFilter(Object params) {
        if (params instanceof PSWFDEFilter) {
            return (PSWFDEFilter)params;
        }
        return (PSWFDEFilter)PSWFDERTService.getMapper().convertValue(params, PSWFDEFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSWFDE";
        }
        return "PSWFDES";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSWFDE.class;
    }

    @Override
    protected List<? extends IPSWFDE> getPSModelObjectList(PSWFDEFilter f) throws Exception {
        Object objPSWFId = f.getFieldCond("pswfid", "EQ");
        if (!ObjectUtils.isEmpty((Object)objPSWFId)) {
            return this.getPSModelObject(IPSWorkflow.class, this.getPSSystemService().getPSSystem().getAllPSWorkflows(), (String)objPSWFId, false).getPSWFDEs();
        }
        ArrayList psWFDEList = new ArrayList();
        if (!ObjectUtils.isEmpty((Object)this.getPSSystemService().getPSSystem().getAllPSWorkflows())) {
            for (IPSWorkflow iPSWorkflow : this.getPSSystemService().getPSSystem().getAllPSWorkflows()) {
                if (ObjectUtils.isEmpty((Object)iPSWorkflow.getPSWFDEs())) continue;
                psWFDEList.addAll(iPSWorkflow.getPSWFDEs());
            }
        }
        return psWFDEList;
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSWFDE.class, this.getPSModelObject(IPSWorkflow.class, this.getPSSystemService().getPSSystem().getAllPSWorkflows(), PSWFDERTService.getParentId(key), false).getPSWFDEs(), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSWFDE domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        PSWorkflow parentPSModel = (PSWorkflow)this.getPSModelRTServiceSession().getCachePSModel("PSWORKFLOW", PSWFDERTService.getParentId(domain.getId()));
        domain.setPSWFId(parentPSModel.getId());
        domain.setPSWFName(parentPSModel.getName());
        domain.setWFCodeName(parentPSModel.getCodeName());
        domain.setWFCatCode(parentPSModel.getWFCatCode());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

