/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.ArrayList;
import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.priv.IPSDEUserRole;
import net.ibizsys.psmodel.core.domain.PSDEUserRole;
import net.ibizsys.psmodel.core.filter.PSDEUserRoleFilter;
import net.ibizsys.psmodel.core.service.IPSDEUserRoleService;
import net.ibizsys.psmodel.core.util.IPSModel;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class PSDEUserRoleRTService
extends PSModelRTServiceBase<PSDEUserRole, PSDEUserRoleFilter>
implements IPSDEUserRoleService {
    private static final Log log = LogFactory.getLog(PSDEUserRoleRTService.class);

    public PSDEUserRole createDomain() {
        return new PSDEUserRole();
    }

    public PSDEUserRoleFilter createFilter() {
        return new PSDEUserRoleFilter();
    }

    public PSDEUserRole getDomain(Object params) {
        if (params instanceof PSDEUserRole) {
            return (PSDEUserRole)params;
        }
        return (PSDEUserRole)PSDEUserRoleRTService.getMapper().convertValue(params, PSDEUserRole.class);
    }

    public PSDEUserRoleFilter getFilter(Object params) {
        if (params instanceof PSDEUserRoleFilter) {
            return (PSDEUserRoleFilter)params;
        }
        return (PSDEUserRoleFilter)PSDEUserRoleRTService.getMapper().convertValue(params, PSDEUserRoleFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSDEUSERROLE";
        }
        return "PSDEUSERROLES";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSDEUserRole.class;
    }

    @Override
    protected List<? extends IPSDEUserRole> getPSModelObjectList(PSDEUserRoleFilter f) throws Exception {
        Object objPSDEId = f.getFieldCond("psdeid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSDEId)) {
            objPSDEId = PSDEUserRoleRTService.getParentId((IPSModelFilter)f, "PSDATAENTITY");
        }
        if (ObjectUtils.isEmpty((Object)objPSDEId)) {
            if (this.getPSSystemService().getPSSystem().getAllPSDataEntities() == null) {
                return null;
            }
            ArrayList allPSDEUserRoleList = new ArrayList();
            for (IPSDataEntity iPSDataEntity : this.getPSSystemService().getPSSystem().getAllPSDataEntities()) {
                if (iPSDataEntity.getAllPSDEUserRoles() == null) continue;
                allPSDEUserRoleList.addAll(iPSDataEntity.getAllPSDEUserRoles());
            }
            return allPSDEUserRoleList;
        }
        return this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), (String)objPSDEId, false).getAllPSDEUserRoles();
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSDEUserRole.class, this.getPSModelObject(IPSDataEntity.class, this.getPSSystemService().getPSSystem().getAllPSDataEntities(), PSDEUserRoleRTService.getParentId(key), false).getAllPSDEUserRoles(), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSDEUserRole domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        IPSModel parentPSModel = this.getPSModelRTServiceSession().getCachePSModel("PSDATAENTITY", PSDEUserRoleRTService.getParentId(domain.getId()));
        domain.setPSDEId(parentPSModel.getId());
        domain.setPSDEName(parentPSModel.getName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

