/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.psmodel.runtime.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.app.IPSApplication;
import net.ibizsys.model.app.dataentity.IPSAppDEUIAction;
import net.ibizsys.model.app.dataentity.IPSAppDataEntity;
import net.ibizsys.model.dataentity.uiaction.IPSDEUIAction;
import net.ibizsys.psmodel.core.domain.PSDEUIAction;
import net.ibizsys.psmodel.core.domain.PSDataEntity;
import net.ibizsys.psmodel.core.filter.PSDEUIActionFilter;
import net.ibizsys.psmodel.core.service.IPSDEUIActionService;
import net.ibizsys.psmodel.core.util.IPSModelFilter;
import net.ibizsys.psmodel.runtime.util.PSModelRTServiceBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public class PSDEUIActionRTService
extends PSModelRTServiceBase<PSDEUIAction, PSDEUIActionFilter>
implements IPSDEUIActionService {
    private static final Log log = LogFactory.getLog(PSDEUIActionRTService.class);

    public PSDEUIAction createDomain() {
        return new PSDEUIAction();
    }

    public PSDEUIActionFilter createFilter() {
        return new PSDEUIActionFilter();
    }

    public PSDEUIAction getDomain(Object params) {
        if (params instanceof PSDEUIAction) {
            return (PSDEUIAction)params;
        }
        return (PSDEUIAction)PSDEUIActionRTService.getMapper().convertValue(params, PSDEUIAction.class);
    }

    public PSDEUIActionFilter getFilter(Object params) {
        if (params instanceof PSDEUIActionFilter) {
            return (PSDEUIActionFilter)params;
        }
        return (PSDEUIActionFilter)PSDEUIActionRTService.getMapper().convertValue(params, PSDEUIActionFilter.class);
    }

    public String getModelName(boolean single) {
        if (single) {
            return "PSDEUIACTION";
        }
        return "PSDEUIACTIONS";
    }

    @Override
    protected Class<? extends IPSModelObject> getPSModelObjectCls() throws Exception {
        return IPSDEUIAction.class;
    }

    @Override
    protected List<IPSDEUIAction> getPSModelObjectList(PSDEUIActionFilter f) throws Exception {
        Object objPSDEId = f.getFieldCond("psdeid", "EQ");
        if (ObjectUtils.isEmpty((Object)objPSDEId)) {
            objPSDEId = PSDEUIActionRTService.getParentId((IPSModelFilter)f, "PSDATAENTITY");
        }
        String strPSDEId = null;
        if (objPSDEId != null) {
            strPSDEId = (String)objPSDEId;
        }
        HashMap<String, IPSAppDEUIAction> psDEUIActionMap = new HashMap<String, IPSAppDEUIAction>();
        ArrayList<IPSDEUIAction> psAppDEUIActionList = new ArrayList<IPSDEUIAction>();
        if (!ObjectUtils.isEmpty((Object)this.getPSSystemService().getPSSystem().getAllPSApps())) {
            for (IPSApplication iPSApplication : this.getPSSystemService().getPSSystem().getAllPSApps()) {
                if (ObjectUtils.isEmpty((Object)iPSApplication.getAllPSAppDataEntities())) continue;
                for (IPSAppDataEntity iPSAppDataEntity : iPSApplication.getAllPSAppDataEntities()) {
                    if (ObjectUtils.isEmpty((Object)iPSAppDataEntity.getAllPSAppDEUIActions())) continue;
                    for (IPSAppDEUIAction iPSAppDEUIAction : iPSAppDataEntity.getAllPSAppDEUIActions()) {
                        if (iPSAppDEUIAction.getPSAppDataEntity() == null || iPSAppDEUIAction.getPSAppDataEntity().getPSDataEntity() == null) continue;
                        String strId = this.getPSModelRTServiceSession().getPSModelUniqueTag((IPSModelObject)iPSAppDEUIAction.getPSAppDataEntity().getPSDataEntity());
                        if (strPSDEId != null && !strPSDEId.equals(strId)) continue;
                        psDEUIActionMap.put(this.getPSModelRTServiceSession().getPSModelUniqueTag((IPSModelObject)iPSAppDEUIAction), iPSAppDEUIAction);
                    }
                }
            }
        }
        psAppDEUIActionList.clear();
        psAppDEUIActionList.addAll(psDEUIActionMap.values());
        return psAppDEUIActionList;
    }

    @Override
    protected IPSModelObject getPSModelObject(String key, boolean tryMode) throws Exception {
        return this.getPSModelObject(IPSDEUIAction.class, this.getPSModelObjectList(new PSDEUIActionFilter()), key, tryMode);
    }

    @Override
    protected void doFillDomain(PSDEUIAction domain, IPSModelObject iPSModelObject, boolean bFullMode) throws Exception {
        PSDataEntity parentPSModel = (PSDataEntity)this.getPSModelRTServiceSession().getCachePSModel("PSDATAENTITY", PSDEUIActionRTService.getParentId(domain.getId()));
        domain.setPSDEId(parentPSModel.getId());
        domain.setPSDEName(parentPSModel.getName());
        super.doFillDomain(domain, iPSModelObject, bFullMode);
    }
}

